/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.jcb.core.wizardpages;

import com.sap.ide.jcb.core.SAPJavaConnectivityBuilderCorePlugin;
import com.sap.ide.jcb.core.TextPool;
import com.sap.ide.jcb.core.service.IR3Service;
import com.sap.ide.jcb.core.service.LogicalSystem;
import com.sap.ide.jcb.core.service.SAPLogonHelper;
import com.sap.ide.jcb.core.service.connection.ConnectionFailedException;
import com.sap.ide.jcb.core.service.connection.IConnectionManager;
import com.sap.ide.jcb.core.util.LogHandler;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.ISimplePane;
import com.tssap.util.ui.pane.ITabbedPane;
import com.tssap.util.ui.pane.PaneFactory;
import java.lang.reflect.InvocationTargetException;
import java.util.AbstractList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IMemento;

public class SAPLogonPage
extends WizardPage {
    private static final String SAP_CONNECTION_TAG = "SAPConnection";
    private static final TextPool mTPool = TextPool.getInstance();
    private MessageServerPane mMessageServerPane = null;
    private UserLogonPane mUserLogonPane = null;
    private IMemento mMemento;
    private boolean mCreated = false;
    private IR3Service mR3Service;
    private IConnectionManager mConnectionManager;
    private static final String PAGE_NAME;
    private static final String PAGE_TITLE;
    private static final String PAGE_DESCRIPTION;
    private ConnectionFailedException mConnectionFailedException;

    public SAPLogonPage() {
        super(PAGE_NAME);
        this.setTitle(PAGE_TITLE);
        this.setDescription(PAGE_DESCRIPTION);
    }

    public void createControl(Composite parent) {
        ISimplePane mLogonPane = PaneFactory.createSimplePane((Composite)parent);
        Composite root = mLogonPane.getComposite();
        this.setControl((Control)root);
        IGridLayoutPane thePane = PaneFactory.createGridLayoutPane((Composite)root, (int)1);
        this.mMessageServerPane = new MessageServerPane(thePane);
        this.mUserLogonPane = new UserLogonPane(thePane);
        this.mMessageServerPane.show();
        this.mUserLogonPane.show();
        this.mCreated = true;
        if (this.mMemento != null) {
            this.init(this.mMemento);
        }
        this.handlePageCompletion();
    }

    private void handlePageCompletion() {
        this.setPageComplete(this.mMessageServerPane.isComplete() && this.mUserLogonPane.isComplete());
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }

    public void saveFields() {
        this.mMessageServerPane.saveFields();
        this.mUserLogonPane.saveFields();
    }

    public void init(IMemento memento) {
        if (!this.mCreated) {
            this.mMemento = memento;
            return;
        }
        if (memento == null) {
            return;
        }
        IMemento sapConnectionMemento = memento.getChild(SAP_CONNECTION_TAG);
        if (sapConnectionMemento == null) {
            return;
        }
        this.mMessageServerPane.init(sapConnectionMemento);
        this.mUserLogonPane.init(sapConnectionMemento);
    }

    public void saveState(IMemento memento) {
        IMemento sapConnectionMemento = memento.getChild(SAP_CONNECTION_TAG);
        if (sapConnectionMemento == null) {
            sapConnectionMemento = memento.createChild(SAP_CONNECTION_TAG);
        }
        this.mMessageServerPane.saveState(sapConnectionMemento);
        this.mUserLogonPane.saveState(sapConnectionMemento);
    }

    private IDialogSettings getDialogSection(String section, boolean create) {
        IDialogSettings theDialogSettings = null;
        IDialogSettings theSectionSettings = null;
        theDialogSettings = this.getDialogSettings();
        if (theDialogSettings == null) {
            theDialogSettings = SAPJavaConnectivityBuilderCorePlugin.getDefault().getDialogSettings();
        }
        if (theDialogSettings == null) {
            return null;
        }
        theSectionSettings = theDialogSettings.getSection(section);
        if (create && theSectionSettings == null) {
            theSectionSettings = theDialogSettings.addNewSection(section);
        }
        return theSectionSettings;
    }

    public String getConnectionType() {
        return this.mMessageServerPane.getConnectionType();
    }

    private void setPasswordEnabling(boolean enable) {
        if (this.mUserLogonPane != null) {
            this.mUserLogonPane.enablePassword(enable);
        }
    }

    private void setLoginNameasUser() {
        if (this.mUserLogonPane != null) {
            String userName = "";
            try {
                userName = System.getProperty("user.name");
            }
            catch (Exception e) {
                LogHandler.logException(e);
            }
            this.mUserLogonPane.setLogonName(userName);
        }
    }

    public void dispose() {
        super.dispose();
        if (this.mConnectionManager != null) {
            this.mConnectionManager.disconnect();
        }
    }

    public void setR3Service(IR3Service r3Service) {
        this.mR3Service = r3Service;
        if (this.mR3Service != null) {
            this.mConnectionManager = this.mR3Service.getConnectionManager();
        }
    }

    public void connectToServer() throws ConnectionFailedException {
        this.mConnectionFailedException = null;
        IRunnableWithProgress op = this.getRunnable();
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException e) {
            LogHandler.logException(e);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof ConnectionFailedException) {
                this.mConnectionFailedException = (ConnectionFailedException)e.getTargetException();
            }
            LogHandler.logException(e);
        }
        if (this.mConnectionFailedException != null) {
            throw this.mConnectionFailedException;
        }
    }

    private IRunnableWithProgress getRunnable() {
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                monitor.beginTask("Connecting to R/3 System", 3);
                monitor.worked(1);
                SAPLogonPage.this.getControl().getDisplay().asyncExec(new Runnable(this){
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        SAPLogonPage.access$1400(3.access$1300(this.this$1));
                    }
                });
                monitor.done();
            }

            static /* synthetic */ SAPLogonPage access$1300(3 x0) {
                return x0.SAPLogonPage.this;
            }
        };
        return op;
    }

    private void internalConnectToServer() {
        try {
            if (this.mMessageServerPane.getConnectionType().equalsIgnoreCase("LoadBalancingServer")) {
                this.mConnectionManager.connectToLoadBalancingServer(this.mUserLogonPane.getClient(), this.mUserLogonPane.getLogonName(), this.mUserLogonPane.getPassword(), this.mUserLogonPane.getLanguage(), this.mMessageServerPane.getMessageServer(), this.mMessageServerPane.getSystemName(), this.mMessageServerPane.getGroup());
            } else if (this.mMessageServerPane.getConnectionType().equalsIgnoreCase("LoadBalancingServerSnc")) {
                this.mConnectionManager.connectToLoadBalancingSncServer(this.mUserLogonPane.getClient(), this.mUserLogonPane.getLogonName(), this.mUserLogonPane.getLanguage(), this.mMessageServerPane.getMessageServer(), this.mMessageServerPane.getSystemName(), this.mMessageServerPane.getGroup(), this.mMessageServerPane.getPartner(), this.mMessageServerPane.getSecurityLevel());
            } else if (this.mMessageServerPane.getConnectionType().equalsIgnoreCase("SingleServer")) {
                this.mConnectionManager.connectToSingleServer(this.mUserLogonPane.getClient(), this.mUserLogonPane.getLogonName(), this.mUserLogonPane.getPassword(), this.mUserLogonPane.getLanguage(), this.mMessageServerPane.getHostName(), this.mMessageServerPane.getSystemNumber());
            }
        }
        catch (ConnectionFailedException e) {
            this.mConnectionFailedException = e;
            LogHandler.logException(e);
        }
    }

    public IWizardPage getNextPage() {
        try {
            this.connectToServer();
        }
        catch (ConnectionFailedException e) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Login Failed", (String)e.getMessage());
            LogHandler.logException(e);
            return this;
        }
        return super.getNextPage();
    }

    public void performFinish() throws ConnectionFailedException {
        this.saveFields();
        this.connectToServer();
    }

    public IConnectionManager getConnectionManager() {
        return this.mConnectionManager;
    }

    public void setConnectionManager(IConnectionManager connectionManager) {
        this.mConnectionManager = connectionManager;
    }

    static /* synthetic */ void access$1400(SAPLogonPage x0) {
        x0.internalConnectToServer();
    }

    static {
        PAGE_TITLE = PAGE_NAME = mTPool.getText(2001);
        PAGE_DESCRIPTION = mTPool.getText(2002);
    }

    class UserLogonPane {
        private static final String USER_LOGON_TAG = "UserLogon";
        private static final String USER_LOGON_CLIENT_ATTRIBUTE = "client";
        private static final String USER_LOGON_USER_ATTRIBUTE = "user";
        private static final String USER_LOGON_LANGUAGE_ATTRIBUTE = "language";
        private IGridLayoutPane mPane = null;
        private Text mClient = null;
        private Text mLogonName = null;
        private Text mPassword = null;
        private Text mLanguage = null;
        private static final String USER_LOGON_SECTION = "User Logon Section";
        private static final String CLIENT = "Client";
        private static final String LOGON_NAME = "Logon Name";
        private static final String PASSWORD = "Password";
        private static final String LANGUAGE = "Language";
        private boolean initialPasswordState = true;
        private String mInitialLogonName = null;

        public UserLogonPane(IGridLayoutPane thePane) {
            this.mPane = thePane;
        }

        public void enablePassword(boolean enable) {
            if (this.mPassword != null) {
                this.mPassword.setEnabled(enable);
                if (!enable) {
                    this.mPassword.setText("");
                }
            } else {
                this.initialPasswordState = enable;
            }
        }

        public void show() {
            IGridLayoutPane theUserLoginPane = this.mPane.addGridLayoutPane(1, this.mPane.createGridLayoutData(4, 4, true, false, 1, 1));
            this.createUserLoginPaneLayout(theUserLoginPane);
            this.addEventHandlers();
            if (this.mInitialLogonName != null) {
                this.setLogonName(this.mInitialLogonName);
            }
        }

        private void addEventHandlers() {
            this.mClient.addModifyListener((ModifyListener)new TextModifyListener());
            this.mLogonName.addModifyListener((ModifyListener)new TextModifyListener());
            this.mPassword.addModifyListener((ModifyListener)new TextModifyListener());
            this.mLanguage.addModifyListener((ModifyListener)new TextModifyListener());
        }

        private void createUserLoginPaneLayout(IGridLayoutPane theUserLoginHostPane) {
            IGridLayoutPane theUserLoginPane = theUserLoginHostPane.addGridLayoutPane(mTPool.getText(2501), 5, true, theUserLoginHostPane.createGridLayoutData(4, 4, true, true, 1, 1));
            theUserLoginPane.addTextLabel("", theUserLoginPane.createGridLayoutData(4, 4, false, false, 5, 1));
            theUserLoginPane.addTextLabel("", theUserLoginPane.createGridLayoutData(4, 4, false, false, 1, 1));
            theUserLoginPane.addTextLabel(mTPool.getText(2502), theUserLoginPane.createGridLayoutData(1, 2, true, false, 1, 1));
            this.mClient = theUserLoginPane.addTextField("", false, theUserLoginPane.createGridLayoutData(4, 2, true, false, 1, 1));
            theUserLoginPane.addTextLabel("", theUserLoginPane.createGridLayoutData(4, 4, false, false, 2, 1));
            this.mClient.setTextLimit(3);
            theUserLoginPane.addTextLabel("", theUserLoginPane.createGridLayoutData(4, 4, false, false, 1, 1));
            theUserLoginPane.addTextLabel(mTPool.getText(2503), theUserLoginPane.createGridLayoutData(1, 2, true, false, 1, 1));
            this.mLogonName = theUserLoginPane.addTextField("", false, theUserLoginPane.createGridLayoutData(4, 2, true, false, 2, 1));
            theUserLoginPane.addTextLabel("", theUserLoginPane.createGridLayoutData(4, 4, false, false, 1, 1));
            this.mLogonName.setTextLimit(12);
            theUserLoginPane.addTextLabel("", theUserLoginPane.createGridLayoutData(4, 4, false, false, 1, 1));
            theUserLoginPane.addTextLabel(mTPool.getText(2504), theUserLoginPane.createGridLayoutData(1, 2, true, false, 1, 1));
            this.mPassword = theUserLoginPane.addTextField("", false, theUserLoginPane.createGridLayoutData(4, 2, true, false, 2, 1));
            theUserLoginPane.addTextLabel("", theUserLoginPane.createGridLayoutData(4, 4, false, false, 1, 1));
            this.mPassword.setTextLimit(12);
            this.mPassword.setEchoChar('*');
            theUserLoginPane.addTextLabel("", theUserLoginPane.createGridLayoutData(4, 4, false, false, 1, 1));
            theUserLoginPane.addTextLabel(mTPool.getText(2505), theUserLoginPane.createGridLayoutData(1, 2, true, false, 1, 1));
            this.mLanguage = theUserLoginPane.addTextField("", false, theUserLoginPane.createGridLayoutData(4, 2, true, false, 1, 1));
            theUserLoginPane.addTextLabel("", theUserLoginPane.createGridLayoutData(4, 4, false, false, 2, 1));
            this.mLanguage.setTextLimit(3);
            theUserLoginPane.addTextLabel("", theUserLoginPane.createGridLayoutData(4, 4, false, false, 5, 1));
            this.initializeFields();
            this.mPassword.setEnabled(this.initialPasswordState);
        }

        public boolean isComplete() {
            boolean complete;
            boolean bl = complete = this.mClient.getText().length() > 0 && this.mLogonName.getText().length() > 0 && this.mLanguage.getText().length() > 0;
            if (SAPLogonPage.this.getConnectionType() != null && (SAPLogonPage.this.getConnectionType().equalsIgnoreCase("SingleServer") || SAPLogonPage.this.getConnectionType().equalsIgnoreCase("LoadBalancingServer"))) {
                complete = complete && this.mPassword.getText().length() > 0;
            }
            return complete;
        }

        public void init(IMemento memento) {
            IMemento userLogonMemento = memento.getChild(USER_LOGON_TAG);
            if (userLogonMemento == null) {
                return;
            }
            String client = userLogonMemento.getString(USER_LOGON_CLIENT_ATTRIBUTE);
            String user = userLogonMemento.getString(USER_LOGON_USER_ATTRIBUTE);
            String language = userLogonMemento.getString(USER_LOGON_LANGUAGE_ATTRIBUTE);
            if (client != null) {
                this.mClient.setText(client);
            }
            if (user != null) {
                this.mLogonName.setText(user);
            }
            if (language != null) {
                this.mLanguage.setText(language);
            }
        }

        public void saveState(IMemento memento) {
            IMemento userLogonMemento = memento.getChild(USER_LOGON_TAG);
            if (userLogonMemento == null) {
                userLogonMemento = memento.createChild(USER_LOGON_TAG);
            }
            userLogonMemento.putString(USER_LOGON_CLIENT_ATTRIBUTE, this.mClient.getText());
            userLogonMemento.putString(USER_LOGON_USER_ATTRIBUTE, this.mLogonName.getText());
            userLogonMemento.putString(USER_LOGON_LANGUAGE_ATTRIBUTE, this.mLanguage.getText());
        }

        private void initializeFields() {
            IDialogSettings theDialogSettings = SAPLogonPage.this.getDialogSection(USER_LOGON_SECTION, false);
            try {
                if (theDialogSettings != null) {
                    if (theDialogSettings.get(CLIENT) != null) {
                        this.mClient.setText(theDialogSettings.get(CLIENT));
                    }
                    if (theDialogSettings.get(LOGON_NAME) != null) {
                        this.mLogonName.setText(theDialogSettings.get(LOGON_NAME));
                    }
                    if (theDialogSettings.get(LANGUAGE) != null) {
                        this.mLanguage.setText(theDialogSettings.get(LANGUAGE));
                    }
                }
            }
            catch (RuntimeException e) {
                LogHandler.logException(e);
            }
        }

        private void saveFields() {
            IDialogSettings theDialogSettings = SAPLogonPage.this.getDialogSection(USER_LOGON_SECTION, true);
            if (theDialogSettings != null) {
                theDialogSettings.put(CLIENT, this.mClient.getText());
                theDialogSettings.put(LOGON_NAME, this.mLogonName.getText());
                theDialogSettings.put(LANGUAGE, this.mLanguage.getText());
            }
        }

        public String getClient() {
            return this.mClient.getText();
        }

        public String getLanguage() {
            return this.mLanguage.getText();
        }

        public String getLogonName() {
            return this.mLogonName.getText();
        }

        public String getPassword() {
            return this.mPassword.getText();
        }

        public void setClient(String client) {
            this.mClient.setText(client);
        }

        public void setLanguage(String language) {
            this.mLanguage.setText(language);
        }

        public void setLogonName(String logonName) {
            if (this.mLogonName == null) {
                this.mInitialLogonName = logonName;
            } else {
                this.mLogonName.setText(logonName);
            }
        }

        public void setPassword(String password) {
            this.mPassword.setText(password);
        }
    }

    class MessageServerPane {
        private static final String SERVER_TAG = "Server";
        private static final String SERVER_TYPE_ATTRIBUTE = "type";
        private static final String LOAD_BALANCING_SERVER_TAG = "LoadBalancingServer";
        private static final String LOAD_BALANCING_SERVER_SYSTEM_ATTRIBUTE = "system";
        private static final String LOAD_BALANCING_SERVER_MESSAGE_SERVER_ATTRIBUTE = "messageserver";
        private static final String LOAD_BALANCING_SERVER_SYSTEM_NAME_ATTRIBUTE = "systemname";
        private static final String LOAD_BALANCING_SERVER_GROUP_ATTRIBUTE = "group";
        private static final String SINGLE_SERVER_TAG = "SingleServer";
        private static final String SINGLE_SERVER_HOST_NAME_ATTRIBUTE = "hostname";
        private static final String SINGLE_SERVER_SYSTEM_NUMBER_ATTRIBUTE = "systemnumber";
        private static final String LOAD_BALANCING_SNC_SERVER_TAG = "LoadBalancingServerSnc";
        private static final String LOAD_BALANCING_SNC_SERVER_SYSTEM_ATTRIBUTE = "system";
        private static final String LOAD_BALANCING_SNC_SERVER_MESSAGE_SERVER_ATTRIBUTE = "messageserver";
        private static final String LOAD_BALANCING_SNC_SERVER_SYSTEM_NAME_ATTRIBUTE = "systemname";
        private static final String LOAD_BALANCING_SNC_SERVER_GROUP_ATTRIBUTE = "group";
        private static final String LOAD_BALANCING_SNC_SERVER_PARTNER_ATTRIBUTE = "partner";
        private static final String LOAD_BALANCING_SNC_SERVER_SECURITY_LEVEL_ATTRIBUTE = "securitylevel";
        private static final String USER_LOGON_TAG = "UserLogon";
        private static final String USER_LOGON_CLIENT_ATTRIBUTE = "client";
        private static final String USER_LOGON_USER_ATTRIBUTE = "user";
        private static final String USER_LOGON_LANGUAGE_ATTRIBUTE = "language";
        private Combo mSystems = null;
        private Text mMessageServer = null;
        private Text mSystemName = null;
        private Text mGroup = null;
        private Hashtable mLogicalSystems = new Hashtable();
        private Text mHostName = null;
        private Text mSystemNumber = null;
        private String mPartner;
        private String mSecurityLevel;
        private SAPLogonHelper mLoader = null;
        private IGridLayoutPane mPane = null;
        private TabFolder mTabFolder = null;
        private static final String MESSAGE_SERVER_SECTION = "Message Server Section";
        private static final String LOAD_BALANCING_PANE_SELECTED = "Load Balancing Pane";
        private static final int SINGLE_SERVER_PANE = 0;
        private static final int LOAD_BALANCING_SERVER_PANE = 1;
        private static final String SYSTEM = "System";
        private static final String MESSAGE_SERVER = "Message Server";
        private static final String SYSTEM_NAME = "System Name";
        private static final String GROUP = "Group";
        private static final String HOST_NAME = "Host Name";
        private static final String SYSTEM_NUMBER = "System Number";
        private static final String PARTNER = "Partner";
        private static final String SECURITY_LEVEL = "SecurityLevel";

        public MessageServerPane(IGridLayoutPane thePane) {
            this.mPane = thePane;
        }

        public void show() {
            IGridLayoutPane theMessageServerPane = this.mPane.addGridLayoutPane(1, this.mPane.createGridLayoutData(4, 4, false, false, 1, 1));
            ITabbedPane theHostPane = theMessageServerPane.addTabbedPane(theMessageServerPane.createGridLayoutData(4, 4, true, true, 1, 1));
            if (theHostPane.getComposite() instanceof TabFolder) {
                this.mTabFolder = (TabFolder)theHostPane.getComposite();
                this.mTabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                    private final /* synthetic */ MessageServerPane this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void widgetSelected(SelectionEvent e) {
                        MessageServerPane.access$300(this.this$1);
                    }
                });
            }
            IGridLayoutPane theSingleServerPane = theHostPane.addGridLayoutPaneAsTab(mTPool.getText(2302), 5, true);
            IGridLayoutPane theLoadBalancingPane = theHostPane.addGridLayoutPaneAsTab(mTPool.getText(2301), 5, true);
            this.createSingleServerPane(theSingleServerPane);
            this.createLoadBalancingPane(theLoadBalancingPane);
            this.fillUpLoadBalancingPaneSystems();
            this.initializeFields();
            this.addEventHandlers();
            this.firePaneSelection();
        }

        private void firePaneSelection() {
            if (this.mTabFolder == null) {
                return;
            }
            if (this.mTabFolder.getSelectionIndex() == 0) {
                this.singleServerPaneSelected();
            } else if (this.mTabFolder.getSelectionIndex() == 1) {
                this.fireLBSelection();
            }
        }

        private void fireLBSelection() {
            LogicalSystem logicalSystem = this.getLogicalSystem();
            if (logicalSystem == null || logicalSystem.getOrigin().equals("MS_SEL_GROUPS") || logicalSystem.getOrigin().equals("MS_SEL_SERVER")) {
                this.loadBalancingServerSelected();
            } else if (logicalSystem.getOrigin().equalsIgnoreCase("MS_SEL_GROUPS_SNC")) {
                this.singleSignOnServerSelected();
            }
        }

        private void singleSignOnServerSelected() {
            SAPLogonPage.this.setLoginNameasUser();
            SAPLogonPage.this.setPasswordEnabling(false);
        }

        private void loadBalancingServerSelected() {
            SAPLogonPage.this.setPasswordEnabling(true);
        }

        private void singleServerPaneSelected() {
            SAPLogonPage.this.setPasswordEnabling(true);
        }

        private void addEventHandlers() {
            this.mMessageServer.addModifyListener((ModifyListener)new TextModifyListener());
            this.mSystemName.addModifyListener((ModifyListener)new TextModifyListener());
            this.mGroup.addModifyListener((ModifyListener)new TextModifyListener());
            this.mHostName.addModifyListener((ModifyListener)new TextModifyListener());
            this.mSystemNumber.addModifyListener((ModifyListener)new TextModifyListener());
            this.mSystems.addSelectionListener(new SelectionListener(this){
                private final /* synthetic */ MessageServerPane this$1;
                {
                    this.this$1 = this$1;
                }

                public void widgetSelected(SelectionEvent e) {
                    if (MessageServerPane.access$700(this.this$1).getSelectionIndex() == -1) {
                        MessageServerPane.access$800(this.this$1, null);
                    } else {
                        LogicalSystem TheSystem = (LogicalSystem)MessageServerPane.access$900(this.this$1).get(MessageServerPane.access$700(this.this$1).getText());
                        MessageServerPane.access$800(this.this$1, TheSystem);
                    }
                    MessageServerPane.access$1000(this.this$1);
                    SAPLogonPage.access$200(MessageServerPane.access$1100(this.this$1));
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
        }

        public void init(IMemento memento) {
            IMemento serverMemento = memento.getChild(SERVER_TAG);
            if (serverMemento == null) {
                return;
            }
            String serverType = serverMemento.getString(SERVER_TYPE_ATTRIBUTE);
            if (serverType.equalsIgnoreCase(LOAD_BALANCING_SERVER_TAG)) {
                IMemento loadBalancingServerMemento = serverMemento.getChild(LOAD_BALANCING_SERVER_TAG);
                if (loadBalancingServerMemento == null) {
                    return;
                }
                this.selectPane(true);
                String system = loadBalancingServerMemento.getString("system");
                String messageServer = loadBalancingServerMemento.getString("messageserver");
                String systemName = loadBalancingServerMemento.getString("systemname");
                String group = loadBalancingServerMemento.getString("group");
                if (system != null) {
                    this.mSystems.setText(system);
                }
                if (messageServer != null) {
                    this.mMessageServer.setText(messageServer);
                }
                if (systemName != null) {
                    this.mSystemName.setText(systemName);
                }
                if (group != null) {
                    this.mGroup.setText(group);
                }
            } else if (serverType.equalsIgnoreCase(LOAD_BALANCING_SNC_SERVER_TAG)) {
                IMemento loadBalancingSncServerMemento = serverMemento.getChild(LOAD_BALANCING_SNC_SERVER_TAG);
                if (loadBalancingSncServerMemento == null) {
                    return;
                }
                this.selectPane(true);
                String system = loadBalancingSncServerMemento.getString("system");
                String messageServer = loadBalancingSncServerMemento.getString("messageserver");
                String systemName = loadBalancingSncServerMemento.getString("systemname");
                String group = loadBalancingSncServerMemento.getString("group");
                this.mPartner = loadBalancingSncServerMemento.getString(LOAD_BALANCING_SNC_SERVER_PARTNER_ATTRIBUTE);
                this.mSecurityLevel = loadBalancingSncServerMemento.getString(LOAD_BALANCING_SNC_SERVER_SECURITY_LEVEL_ATTRIBUTE);
                if (system != null) {
                    this.mSystems.setText(system);
                }
                if (messageServer != null) {
                    this.mMessageServer.setText(messageServer);
                }
                if (systemName != null) {
                    this.mSystemName.setText(systemName);
                }
                if (group != null) {
                    this.mGroup.setText(group);
                }
            } else if (serverType.equalsIgnoreCase(SINGLE_SERVER_TAG)) {
                IMemento singleServerMemento = serverMemento.getChild(SINGLE_SERVER_TAG);
                if (singleServerMemento == null) {
                    return;
                }
                this.selectPane(false);
                String hostName = singleServerMemento.getString(SINGLE_SERVER_HOST_NAME_ATTRIBUTE);
                String systemNumber = singleServerMemento.getString(SINGLE_SERVER_SYSTEM_NUMBER_ATTRIBUTE);
                if (hostName != null) {
                    this.mHostName.setText(hostName);
                }
                if (systemNumber != null) {
                    this.mSystemNumber.setText(systemNumber);
                }
            }
            this.firePaneSelection();
        }

        public void saveState(IMemento memento) {
            IMemento serverMemento = memento.getChild(SERVER_TAG);
            if (serverMemento == null) {
                serverMemento = memento.createChild(SERVER_TAG);
            }
            if (this.isLoadBalancingPaneSelected()) {
                LogicalSystem theLogicalSystem = this.getLogicalSystem();
                if (theLogicalSystem == null) {
                    return;
                }
                if (theLogicalSystem.getOrigin().equalsIgnoreCase("MS_SEL_GROUPS")) {
                    serverMemento.putString(SERVER_TYPE_ATTRIBUTE, LOAD_BALANCING_SERVER_TAG);
                    IMemento loadBalancingServerMemento = serverMemento.getChild(LOAD_BALANCING_SERVER_TAG);
                    if (loadBalancingServerMemento == null) {
                        loadBalancingServerMemento = serverMemento.createChild(LOAD_BALANCING_SERVER_TAG);
                    }
                    loadBalancingServerMemento.putString("system", this.mSystems.getText());
                    loadBalancingServerMemento.putString("messageserver", this.mMessageServer.getText());
                    loadBalancingServerMemento.putString("systemname", this.mSystemName.getText());
                    loadBalancingServerMemento.putString("group", this.mGroup.getText());
                }
                if (theLogicalSystem.getOrigin().equalsIgnoreCase("MS_SEL_GROUPS_SNC")) {
                    serverMemento.putString(SERVER_TYPE_ATTRIBUTE, LOAD_BALANCING_SNC_SERVER_TAG);
                    IMemento loadBalancingSncServerMemento = serverMemento.getChild(LOAD_BALANCING_SNC_SERVER_TAG);
                    if (loadBalancingSncServerMemento == null) {
                        loadBalancingSncServerMemento = serverMemento.createChild(LOAD_BALANCING_SNC_SERVER_TAG);
                    }
                    loadBalancingSncServerMemento.putString("system", this.mSystems.getText());
                    loadBalancingSncServerMemento.putString("messageserver", this.mMessageServer.getText());
                    loadBalancingSncServerMemento.putString("systemname", this.mSystemName.getText());
                    loadBalancingSncServerMemento.putString("group", this.mGroup.getText());
                    loadBalancingSncServerMemento.putString(LOAD_BALANCING_SNC_SERVER_PARTNER_ATTRIBUTE, this.mPartner);
                    loadBalancingSncServerMemento.putString(LOAD_BALANCING_SNC_SERVER_SECURITY_LEVEL_ATTRIBUTE, this.mSecurityLevel);
                }
            } else {
                serverMemento.putString(SERVER_TYPE_ATTRIBUTE, SINGLE_SERVER_TAG);
                IMemento singleServerMemento = serverMemento.getChild(SINGLE_SERVER_TAG);
                if (singleServerMemento == null) {
                    singleServerMemento = serverMemento.createChild(SINGLE_SERVER_TAG);
                }
                singleServerMemento.putString(SINGLE_SERVER_HOST_NAME_ATTRIBUTE, this.mHostName.getText());
                singleServerMemento.putString(SINGLE_SERVER_SYSTEM_NUMBER_ATTRIBUTE, this.mSystemNumber.getText());
            }
        }

        private void initializeFields() {
            IDialogSettings theDialogSettings = SAPLogonPage.this.getDialogSection(MESSAGE_SERVER_SECTION, false);
            this.selectPane(true);
            try {
                if (theDialogSettings != null) {
                    if (theDialogSettings.get(LOAD_BALANCING_PANE_SELECTED) != null) {
                        this.selectPane(theDialogSettings.getBoolean(LOAD_BALANCING_PANE_SELECTED));
                    }
                    if (theDialogSettings.get(SYSTEM) != null) {
                        this.mSystems.setText(theDialogSettings.get(SYSTEM));
                    }
                    if (theDialogSettings.get(MESSAGE_SERVER) != null) {
                        this.mMessageServer.setText(theDialogSettings.get(MESSAGE_SERVER));
                    }
                    if (theDialogSettings.get(SYSTEM_NAME) != null) {
                        this.mSystemName.setText(theDialogSettings.get(SYSTEM_NAME));
                    }
                    if (theDialogSettings.get(GROUP) != null) {
                        this.mGroup.setText(theDialogSettings.get(GROUP));
                    }
                    if (theDialogSettings.get(HOST_NAME) != null) {
                        this.mHostName.setText(theDialogSettings.get(HOST_NAME));
                    }
                    if (theDialogSettings.get(SYSTEM_NUMBER) != null) {
                        this.mSystemNumber.setText(theDialogSettings.get(SYSTEM_NUMBER));
                    }
                    if (theDialogSettings.get(PARTNER) != null) {
                        this.mPartner = theDialogSettings.get(PARTNER);
                    }
                    if (theDialogSettings.get(SECURITY_LEVEL) != null) {
                        this.mSecurityLevel = theDialogSettings.get(SECURITY_LEVEL);
                    }
                }
            }
            catch (Exception e) {
                LogHandler.logException(e);
            }
        }

        private void saveFields() {
            IDialogSettings theDialogSettings = SAPLogonPage.this.getDialogSection(MESSAGE_SERVER_SECTION, true);
            if (theDialogSettings == null) {
                return;
            }
            theDialogSettings.put(LOAD_BALANCING_PANE_SELECTED, this.isLoadBalancingPaneSelected());
            theDialogSettings.put(SYSTEM, this.mSystems.getText());
            theDialogSettings.put(MESSAGE_SERVER, this.mMessageServer.getText());
            theDialogSettings.put(SYSTEM_NAME, this.mSystemName.getText());
            theDialogSettings.put(GROUP, this.mGroup.getText());
            theDialogSettings.put(HOST_NAME, this.mHostName.getText());
            theDialogSettings.put(SYSTEM_NUMBER, this.mSystemNumber.getText());
            theDialogSettings.put(PARTNER, this.mPartner);
            theDialogSettings.put(SECURITY_LEVEL, this.mSecurityLevel);
        }

        private void selectPane(boolean selectLoadBalancingPane) {
            if (this.mTabFolder != null) {
                this.mTabFolder.setSelection(new TabItem[]{this.mTabFolder.getItem(selectLoadBalancingPane ? 1 : 0)});
            }
            this.firePaneSelection();
        }

        private boolean isLoadBalancingPaneSelected() {
            if (this.mTabFolder != null) {
                return this.mTabFolder.getSelectionIndex() == 1;
            }
            return false;
        }

        private void createSingleServerPane(IGridLayoutPane theSingleServerPane) {
            theSingleServerPane.addTextLabel("", theSingleServerPane.createGridLayoutData(4, 4, false, false, 5, 1));
            theSingleServerPane.addTextLabel("", theSingleServerPane.createGridLayoutData(4, 4, false, false, 1, 1));
            theSingleServerPane.addTextLabel(mTPool.getText(2350), theSingleServerPane.createGridLayoutData(1, 2, true, false, 1, 1));
            this.mHostName = theSingleServerPane.addTextField("", false, theSingleServerPane.createGridLayoutData(4, 2, true, false, 2, 1));
            theSingleServerPane.addTextLabel("", theSingleServerPane.createGridLayoutData(4, 4, false, false, 1, 1));
            theSingleServerPane.addTextLabel("", theSingleServerPane.createGridLayoutData(4, 4, false, false, 1, 1));
            theSingleServerPane.addTextLabel(mTPool.getText(2351), theSingleServerPane.createGridLayoutData(1, 2, true, false, 1, 1));
            this.mSystemNumber = theSingleServerPane.addTextField("", false, theSingleServerPane.createGridLayoutData(4, 2, true, false, 1, 1));
            theSingleServerPane.addTextLabel("", theSingleServerPane.createGridLayoutData(4, 4, false, false, 2, 1));
            theSingleServerPane.addTextLabel("", theSingleServerPane.createGridLayoutData(4, 4, false, false, 5, 1));
        }

        private void createLoadBalancingPane(IGridLayoutPane theMessageServerPane) {
            theMessageServerPane.addTextLabel("", theMessageServerPane.createGridLayoutData(4, 4, true, true, 5, 1));
            theMessageServerPane.addTextLabel("", theMessageServerPane.createGridLayoutData(4, 4, false, false, 1, 1));
            theMessageServerPane.addTextLabel(mTPool.getText(2303), theMessageServerPane.createGridLayoutData(1, 2, true, false, 1, 1));
            this.mSystems = theMessageServerPane.addComboBox(new String[0], "", true, theMessageServerPane.createGridLayoutData(4, 2, true, false, 2, 1));
            theMessageServerPane.addTextLabel("", theMessageServerPane.createGridLayoutData(4, 4, false, false, 1, 1));
            theMessageServerPane.addTextLabel("", theMessageServerPane.createGridLayoutData(4, 4, false, false, 1, 1));
            theMessageServerPane.addTextLabel(mTPool.getText(2304), theMessageServerPane.createGridLayoutData(1, 2, true, false, 1, 1));
            this.mMessageServer = theMessageServerPane.addTextField("", false, theMessageServerPane.createGridLayoutData(4, 2, true, false, 2, 1));
            theMessageServerPane.addTextLabel("", theMessageServerPane.createGridLayoutData(4, 4, false, false, 1, 1));
            theMessageServerPane.addTextLabel("", theMessageServerPane.createGridLayoutData(4, 4, false, false, 1, 1));
            theMessageServerPane.addTextLabel(mTPool.getText(2305), theMessageServerPane.createGridLayoutData(1, 2, true, false, 1, 1));
            this.mSystemName = theMessageServerPane.addTextField("", false, theMessageServerPane.createGridLayoutData(4, 2, true, false, 1, 1));
            theMessageServerPane.addTextLabel("", theMessageServerPane.createGridLayoutData(4, 4, false, false, 2, 1));
            this.mSystemName.setTextLimit(3);
            theMessageServerPane.addTextLabel("", theMessageServerPane.createGridLayoutData(4, 4, false, false, 1, 1));
            theMessageServerPane.addTextLabel(mTPool.getText(2306), theMessageServerPane.createGridLayoutData(1, 2, true, false, 1, 1));
            this.mGroup = theMessageServerPane.addTextField("", false, theMessageServerPane.createGridLayoutData(4, 2, true, false, 2, 1));
            theMessageServerPane.addTextLabel("", theMessageServerPane.createGridLayoutData(4, 4, false, false, 1, 1));
            this.mGroup.setTextLimit(12);
            theMessageServerPane.addTextLabel("", theMessageServerPane.createGridLayoutData(4, 4, true, true, 5, 1));
        }

        private void fillUpLoadBalancingPaneSystems() {
            this.mLoader = new SAPLogonHelper();
            if (this.mLoader.comboboxUsable()) {
                Vector v = this.mLoader.getComboboxItems();
                Iterator i = ((AbstractList)v).iterator();
                while (i.hasNext()) {
                    LogicalSystem TheSystem = (LogicalSystem)i.next();
                    this.mLogicalSystems.put(TheSystem.getLogicalName(), TheSystem);
                    if (!TheSystem.getOrigin().equals("MS_SEL_GROUPS") && !TheSystem.getOrigin().equals("MS_SEL_GROUPS_SNC")) continue;
                    this.mSystems.add(TheSystem.getLogicalName());
                }
            }
        }

        private void setLogicalSystem(LogicalSystem theSystem) {
            if (theSystem == null) {
                this.mMessageServer.setText("");
                this.mSystemName.setText("");
                this.mGroup.setText("");
            } else if (theSystem.getOrigin().equals("MS_SEL_SERVER")) {
                this.mMessageServer.setText("");
                this.mSystemName.setText("");
                this.mGroup.setText("");
            } else if (theSystem.getOrigin().equals("MS_SEL_GROUPS")) {
                this.mMessageServer.setText(theSystem.getMessageServer());
                this.mSystemName.setText(theSystem.getNameForBorder());
                this.mGroup.setText(theSystem.getServer());
            } else if (theSystem.getOrigin().equals("MS_SEL_GROUPS_SNC")) {
                this.mMessageServer.setText(theSystem.getMessageServer());
                this.mSystemName.setText(theSystem.getNameForBorder());
                this.mGroup.setText(theSystem.getServer());
                this.mPartner = theSystem.getPartnerName();
                this.mSecurityLevel = theSystem.getSecurityLevel();
            }
        }

        public LogicalSystem getLogicalSystem() {
            if (this.mSystems == null) {
                return null;
            }
            if (this.mSystems.getSelectionIndex() == -1) {
                return null;
            }
            return (LogicalSystem)this.mLogicalSystems.get(this.mSystems.getText());
        }

        public String getConnectionType() {
            if (this.isLoadBalancingPaneSelected()) {
                LogicalSystem theLogicalSystem = this.getLogicalSystem();
                if (theLogicalSystem == null) {
                    return null;
                }
                if (theLogicalSystem.getOrigin().equalsIgnoreCase("MS_SEL_GROUPS")) {
                    return LOAD_BALANCING_SERVER_TAG;
                }
                if (theLogicalSystem.getOrigin().equalsIgnoreCase("MS_SEL_GROUPS_SNC")) {
                    return LOAD_BALANCING_SNC_SERVER_TAG;
                }
                return null;
            }
            return SINGLE_SERVER_TAG;
        }

        public boolean isComplete() {
            return true;
        }

        public String getGroup() {
            return this.mGroup.getText();
        }

        public String getHostName() {
            return this.mHostName.getText();
        }

        public boolean isLoadBalancingConnection() {
            return this.isLoadBalancingPaneSelected();
        }

        public String getMessageServer() {
            return this.mMessageServer.getText();
        }

        public String getSystem() {
            return this.mSystems.getText();
        }

        public String getSystemName() {
            return this.mSystemName.getText();
        }

        public String getSystemNumber() {
            return this.mSystemNumber.getText();
        }

        public void setGroup(String group) {
            this.mGroup.setText(group);
        }

        public void setHostName(String hostName) {
            this.mHostName.setText(hostName);
        }

        public void setLoadBalancingConnection(boolean loadBalancingConnection) {
            this.selectPane(loadBalancingConnection);
        }

        public void setMessageServer(String messageServer) {
            this.mMessageServer.setText(messageServer);
        }

        public void setSystem(String system) {
            this.mSystems.setText(system);
        }

        public void setSystemName(String systemName) {
            this.mSystemName.setText(systemName);
        }

        public void setSystemNumber(String systemNumber) {
            this.mSystemNumber.setText(systemNumber);
        }

        public String getPartner() {
            return this.mPartner;
        }

        public String getSecurityLevel() {
            return this.mSecurityLevel;
        }

        public void setPartner(String partner) {
            this.mPartner = partner;
        }

        public void setSecurityLevel(String securityLevel) {
            this.mSecurityLevel = securityLevel;
        }

        static /* synthetic */ void access$300(MessageServerPane x0) {
            x0.firePaneSelection();
        }

        static /* synthetic */ Combo access$700(MessageServerPane x0) {
            return x0.mSystems;
        }

        static /* synthetic */ void access$800(MessageServerPane x0, LogicalSystem x1) {
            x0.setLogicalSystem(x1);
        }

        static /* synthetic */ Hashtable access$900(MessageServerPane x0) {
            return x0.mLogicalSystems;
        }

        static /* synthetic */ void access$1000(MessageServerPane x0) {
            x0.fireLBSelection();
        }

        static /* synthetic */ SAPLogonPage access$1100(MessageServerPane x0) {
            return x0.SAPLogonPage.this;
        }
    }

    class TextModifyListener
    implements ModifyListener {
        TextModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            SAPLogonPage.this.handlePageCompletion();
        }
    }
}

