/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.jcb.core.wizardpages;

import com.sap.ide.jcb.core.SAPJavaConnectivityBuilderCorePlugin;
import com.sap.ide.jcb.core.TextPool;
import com.sap.ide.jcb.core.panels.internal.search.RFCFlatListPanel;
import com.sap.ide.jcb.core.panels.internal.tree.RFCAKHTreePanel;
import com.sap.ide.jcb.core.panels.internal.workingset.WorkingSetPane;
import com.sap.ide.jcb.core.service.IR3Service;
import com.sap.ide.jcb.core.service.workingset.IWorkingSetObject;
import com.sap.ide.jcb.core.service.workingset.RFCModuleAddedEvent;
import com.sap.ide.jcb.core.service.workingset.RFCModuleAddedListener;
import com.sap.ide.jcb.core.service.workingset.RFCModuleRemovedEvent;
import com.sap.ide.jcb.core.service.workingset.RFCModuleRemovedListener;
import com.sap.ide.jcb.core.util.LogHandler;
import com.tssap.util.ui.image.ISapImage;
import com.tssap.util.ui.image.SapIdeUtilImages;
import com.tssap.util.ui.image.SapImage;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.ISashPane;
import com.tssap.util.ui.pane.ISimplePane;
import com.tssap.util.ui.pane.IToolBarPane;
import com.tssap.util.ui.pane.PaneFactory;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IMemento;

public class RFCSelectionPage
extends WizardPage {
    private static final String RFCS_TAG = "RFCS";
    private static final String RFC_TAG = "RFC";
    private static final String RFC_NAME_ATTRIBUTE = "name";
    private static final String RFC_DESCRIPTION_ATTRIBUTE = "description";
    private static final TextPool mTPool = TextPool.getInstance();
    private static final String PAGE_NAME;
    private static final String PAGE_TITLE;
    private static final String PAGE_DESCRIPTION;
    private ToolItem mRefreshButton;
    private ToolItem mWorkingSetButton = null;
    private ToolItem mResultSetButton = null;
    private Combo mInterfacesFilter = null;
    private RFCFlatListPanel mRFCFlatListPanel = null;
    private RFCAKHTreePanel mRFCAKHTreePanel = null;
    private WorkingSetPane mWorkingSetPanel = null;
    private IR3Service mR3Service = null;
    private boolean mTreeShownOnce = false;
    private boolean mListShownOnce = false;
    private boolean mWorkSetShownOnce = false;
    private boolean mListDisplay = false;
    private boolean mWorkSetDisplay = false;
    private Image mAKHTreeImage = SapIdeUtilImages.getSapImage((ISapImage)SapImage.ICON_DISPLAY_TREE);
    private Image mFlatListImage = SapIdeUtilImages.getSapImage((ISapImage)SapImage.ICON_GRID);
    private Image mWorkingSetShowImage = SAPJavaConnectivityBuilderCorePlugin.createImage("resources\\icons\\s_b_boye.gif");
    private Image mWorkingSetHideImage = SAPJavaConnectivityBuilderCorePlugin.createImage("resources\\icons\\s_b_bono.gif");
    private IGridLayoutPane mListPane = null;
    private IGridLayoutPane mTreePane = null;
    private IGridLayoutPane mWorkingSetPane = null;
    private Composite mResultSetHost = null;
    private Composite mWorkingSetHost;
    private StackLayout mResultSetLayout;
    private Composite innerComposite;
    private SashForm mSash;
    private boolean mCanShowAKH;
    private boolean mCanFilterReleased = true;
    private RFCModuleAddedListener mRFCModuleAddedListener = null;
    private RFCModuleRemovedListener mRFCModuleRemovedListener = null;
    private IMemento mMemento;
    private boolean mCreated = false;
    private String[][] mHasToBeDisplayed = null;

    public RFCSelectionPage() {
        super(PAGE_NAME);
        this.setTitle(PAGE_TITLE);
        this.setDescription(PAGE_DESCRIPTION);
        this.mRFCModuleAddedListener = new RFCModuleAddedListener(){

            public void rfcModuleAdded(RFCModuleAddedEvent rfcModuleAddedEvent) {
                RFCSelectionPage.this.handlePageCompletion();
                RFCSelectionPage.super.getContainer().updateButtons();
            }
        };
        this.mRFCModuleRemovedListener = new RFCModuleRemovedListener(){

            public void rfcModuleRemoved(RFCModuleRemovedEvent rfcModuleRemovedEvent) {
                RFCSelectionPage.this.handlePageCompletion();
                RFCSelectionPage.super.getContainer().updateButtons();
            }

            public void removedAll() {
                RFCSelectionPage.this.handlePageCompletion();
            }
        };
    }

    public void createControl(Composite parent) {
        ISimplePane RFCPane = PaneFactory.createSimplePane((Composite)parent);
        Composite root = RFCPane.getComposite();
        IGridLayoutPane thePane = PaneFactory.createGridLayoutPane((Composite)root, (int)1);
        this.setControl((Control)root);
        this.createToolbarPane(thePane);
        IGridLayoutPane theNextPane = thePane.addGridLayoutPane(1, thePane.createGridLayoutData(4, 4, true, true, 1, 1));
        this.createResultSetPane(theNextPane);
        this.addEventHandlers();
        this.mCreated = true;
        if (this.mMemento != null) {
            this.init(this.mMemento);
        }
        this.handlePageCompletion();
    }

    private void createResultSetPane(IGridLayoutPane theNextPane) {
        ISashPane innerSashPane = theNextPane.addVerticalSashPane(theNextPane.createGridLayoutData(4, 4, true, true, 1, 1));
        this.mSash = (SashForm)innerSashPane.getComposite();
        this.innerComposite = innerSashPane.addSimplePane().getComposite();
        this.mResultSetHost = new Composite(this.innerComposite, 0);
        this.mResultSetHost.setLayoutData((Object)new GridData(1808));
        this.mResultSetLayout = new StackLayout();
        this.mResultSetHost.setLayout((Layout)this.mResultSetLayout);
        this.mTreePane = PaneFactory.createGridLayoutPane((Composite)this.mResultSetHost, (int)1);
        this.mRFCAKHTreePanel = new RFCAKHTreePanel(this.mTreePane);
        this.mListPane = PaneFactory.createGridLayoutPane((Composite)this.mResultSetHost, (int)1);
        this.mRFCFlatListPanel = new RFCFlatListPanel(this.mListPane, this.getContainer());
        this.mWorkingSetHost = innerSashPane.addSimplePane().getComposite();
        this.mWorkingSetPane = PaneFactory.createGridLayoutPane((Composite)this.mWorkingSetHost, (int)1);
        this.mWorkingSetPanel = new WorkingSetPane(this.mWorkingSetPane);
        this.mRFCFlatListPanel.createLayout();
        this.mRFCAKHTreePanel.createLayout();
        this.mWorkingSetPanel.createLayout();
        if (this.mR3Service != null) {
            this.setCanFilterReleased(this.mR3Service.getRFCManager().isReleasedStateQuerySupported());
            this.setCanShowAKH(this.mR3Service.getRFCManager().isAKHSupported());
            this.mRFCFlatListPanel.setRFCManager(this.mR3Service.getRFCManager());
            this.mRFCFlatListPanel.setWorkingSet(this.mR3Service.getWorkingSet());
            this.mRFCAKHTreePanel.setRFCManager(this.mR3Service.getRFCManager());
            this.mRFCAKHTreePanel.setWorkingSet(this.mR3Service.getWorkingSet());
            this.mWorkingSetPanel.setWorkingSet(this.mR3Service.getWorkingSet());
        }
        innerSashPane.setWeights(new int[]{1, 1});
        this.handlePageCompletion();
    }

    private void addEventHandlers() {
        this.mRefreshButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (RFCSelectionPage.this.mListDisplay) {
                    RFCSelectionPage.this.mRFCFlatListPanel.refresh();
                } else {
                    RFCSelectionPage.this.mRFCAKHTreePanel.refresh();
                }
            }
        });
        this.mInterfacesFilter.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (RFCSelectionPage.this.mInterfacesFilter.getText().equalsIgnoreCase(mTPool.getText(2758))) {
                    RFCSelectionPage.this.showAllInterfaces();
                } else if (RFCSelectionPage.this.mInterfacesFilter.getText().equalsIgnoreCase(mTPool.getText(2759))) {
                    RFCSelectionPage.this.showReleasedInterfaces();
                }
            }
        });
        this.mResultSetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RFCSelectionPage.this.mListDisplay = !RFCSelectionPage.this.mListDisplay;
                RFCSelectionPage.this.updateResultSetPanel();
            }
        });
        this.mWorkingSetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RFCSelectionPage.this.mWorkSetDisplay = !RFCSelectionPage.this.mWorkSetDisplay;
                RFCSelectionPage.this.updateWorksetPanel();
            }
        });
    }

    private void showReleasedInterfaces() {
        if (this.mCanFilterReleased) {
            this.mRFCFlatListPanel.showReleasedInterfaces();
            this.mRFCAKHTreePanel.showReleasedInterfaces();
        }
    }

    private void showAllInterfaces() {
        this.mRFCFlatListPanel.showAllInterfaces();
        this.mRFCAKHTreePanel.showAllInterfaces();
    }

    private void updateWorksetPanel() {
        if (this.mWorkSetDisplay) {
            this.mSash.setMaximizedControl(null);
            if (!this.mWorkSetShownOnce) {
                this.mWorkingSetPanel.show();
                this.mWorkSetShownOnce = true;
            }
        } else {
            this.mSash.setMaximizedControl((Control)this.innerComposite);
            this.mResultSetHost.layout();
        }
        this.updateWorkSetIcon();
    }

    private void updateWorkSetIcon() {
        if (this.mWorkSetDisplay) {
            this.mWorkingSetButton.setImage(this.mWorkingSetHideImage);
            this.mWorkingSetButton.setToolTipText(mTPool.getText(2755));
        } else {
            this.mWorkingSetButton.setImage(this.mWorkingSetShowImage);
            this.mWorkingSetButton.setToolTipText(mTPool.getText(2754));
        }
    }

    private void updateResultSetIcon() {
        if (this.mListDisplay) {
            this.mResultSetButton.setImage(this.mAKHTreeImage);
            this.mResultSetButton.setToolTipText(mTPool.getText(2756));
        } else {
            this.mResultSetButton.setImage(this.mFlatListImage);
            this.mResultSetButton.setToolTipText(mTPool.getText(2757));
        }
    }

    private void createToolbarPane(IGridLayoutPane theHostPane) {
        IGridLayoutPane thePane = theHostPane.addGridLayoutPane(2, true, theHostPane.createGridLayoutData(4, 4, true, false, 1, 1));
        IToolBarPane theToolBarPane = thePane.addHorizontalToolBar(thePane.createGridLayoutData(4, 4, true, true, 1, 1));
        this.mRefreshButton = theToolBarPane.addToolBarButton(SapIdeUtilImages.getSapImage((ISapImage)SapImage.ICON_REFRESH), mTPool.getText(2751));
        this.mWorkingSetButton = theToolBarPane.addToolBarButton(this.mWorkingSetShowImage, mTPool.getText(2754));
        this.mResultSetButton = theToolBarPane.addToolBarButton(this.mAKHTreeImage, mTPool.getText(2756));
        IGridLayoutPane theComboPane = thePane.addGridLayoutPane(1, thePane.createGridLayoutData(3, 4, false, true, 1, 1));
        this.mInterfacesFilter = theComboPane.addComboBox(new String[]{mTPool.getText(2758), mTPool.getText(2759)}, mTPool.getText(2758), true, theComboPane.createGridLayoutData(3, 1, false, true, 1, 1));
    }

    private void handlePageCompletion() {
        if (this.mR3Service != null && this.mR3Service.getWorkingSet() != null) {
            this.setPageComplete(this.mR3Service.getWorkingSet().getSize() > 0);
        } else {
            this.setPageComplete(false);
        }
    }

    public void saveFields() {
    }

    public IR3Service getR3Service() {
        return this.mR3Service;
    }

    public void setR3Service(IR3Service r3Service) {
        this.removeWorkingSetListeners();
        this.mR3Service = r3Service;
        this.handlePageCompletion();
        this.addWorkingSetListeners();
        if (r3Service != null) {
            this.setCanFilterReleased(r3Service.getRFCManager().isReleasedStateQuerySupported());
            this.setCanShowAKH(r3Service.getRFCManager().isAKHSupported());
            if (this.mRFCFlatListPanel != null) {
                this.mRFCFlatListPanel.setRFCManager(r3Service.getRFCManager());
                this.mRFCFlatListPanel.setWorkingSet(r3Service.getWorkingSet());
            }
            if (this.mRFCAKHTreePanel != null) {
                this.mRFCAKHTreePanel.setRFCManager(r3Service.getRFCManager());
                this.mRFCAKHTreePanel.setWorkingSet(r3Service.getWorkingSet());
            }
            if (this.mWorkingSetPanel != null) {
                this.mWorkingSetPanel.setWorkingSet(r3Service.getWorkingSet());
            }
        }
    }

    private void addWorkingSetListeners() {
        if (this.mR3Service != null && this.mR3Service.getWorkingSet() != null) {
            this.mR3Service.getWorkingSet().addRFCModuleAddedEventListener(this.mRFCModuleAddedListener);
            this.mR3Service.getWorkingSet().addRFCModuleRemovedEventListener(this.mRFCModuleRemovedListener);
        }
    }

    private void removeWorkingSetListeners() {
        if (this.mR3Service != null && this.mR3Service.getWorkingSet() != null) {
            this.mR3Service.getWorkingSet().removeRFCModuleAddedEventListener(this.mRFCModuleAddedListener);
            this.mR3Service.getWorkingSet().removeRFCModuleRemovedEventListener(this.mRFCModuleRemovedListener);
        }
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.mListDisplay = true;
            this.setCanFilterReleased(this.mR3Service.getRFCManager().isReleasedStateQuerySupported());
            this.setCanShowAKH(this.mR3Service.getRFCManager().isAKHSupported());
            this.updateResultSetPanel();
            this.updateWorksetPanel();
            this.updateToolbar();
        }
        super.setVisible(visible);
    }

    private void updateResultSetPanel() {
        if (this.mListDisplay) {
            this.showList();
        } else {
            this.showTree();
        }
        this.updateResultSetIcon();
    }

    private void showTree() {
        if (!this.mTreeShownOnce) {
            this.internalShowTree();
            this.mTreeShownOnce = true;
        }
        this.mResultSetLayout.topControl = this.mTreePane.getComposite();
        this.mResultSetHost.layout();
    }

    private void internalShowTree() {
        IRunnableWithProgress op = this.getShowTreeRunnable();
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException e) {
            LogHandler.logException(e);
        }
        catch (InvocationTargetException e) {
            LogHandler.logException(e);
        }
    }

    private IRunnableWithProgress getShowTreeRunnable() {
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                monitor.beginTask("Reading Application Component Hierarchy", 3);
                monitor.worked(1);
                RFCSelectionPage.this.getControl().getDisplay().syncExec(new Runnable(this){
                    private final /* synthetic */ 7 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        RFCSelectionPage.access$500(7.access$1300(this.this$1)).show();
                    }
                });
                monitor.done();
            }

            static /* synthetic */ RFCSelectionPage access$1300(7 x0) {
                return x0.RFCSelectionPage.this;
            }
        };
        return op;
    }

    private void showList() {
        if (!this.mListShownOnce) {
            this.mRFCFlatListPanel.show();
            this.mListShownOnce = true;
        }
        this.mResultSetLayout.topControl = this.mListPane.getComposite();
        this.mResultSetHost.layout();
    }

    public void dispose() {
        super.dispose();
        if (this.mWorkingSetShowImage != null) {
            this.mWorkingSetShowImage.dispose();
            this.mWorkingSetShowImage = null;
        }
        if (this.mWorkingSetHideImage != null) {
            this.mWorkingSetHideImage.dispose();
            this.mWorkingSetHideImage = null;
        }
        this.removeWorkingSetListeners();
        this.mRFCFlatListPanel.dispose();
        this.mRFCAKHTreePanel.dispose();
        this.mWorkingSetPanel.dispose();
        if (this.mR3Service != null) {
            this.mR3Service.getWorkingSet().removeAll();
            this.mR3Service = null;
        }
    }

    public boolean isCanFilterReleased() {
        return this.mCanFilterReleased;
    }

    public boolean isCanShowAKH() {
        return this.mCanShowAKH;
    }

    public void setCanFilterReleased(boolean canFilterReleased) {
        this.mCanFilterReleased = canFilterReleased;
        this.updateToolbar();
    }

    public void setCanShowAKH(boolean canShowAKH) {
        this.mCanShowAKH = canShowAKH;
        this.updateToolbar();
    }

    public void updateToolbar() {
        if (this.mResultSetButton != null) {
            this.mResultSetButton.setEnabled(this.mCanShowAKH);
        }
        if (this.mInterfacesFilter != null) {
            this.mInterfacesFilter.setEnabled(this.mCanFilterReleased);
        }
    }

    public void init(IMemento memento) {
        if (!this.mCreated) {
            this.mMemento = memento;
            return;
        }
        if (this.mR3Service == null) {
            return;
        }
        this.mR3Service.getWorkingSet().removeAll();
        IMemento rfcsMemento = memento.getChild(RFCS_TAG);
        if (rfcsMemento == null) {
            return;
        }
        IMemento[] rfcMemento = rfcsMemento.getChildren(RFC_TAG);
        int i = 0;
        while (i < rfcMemento.length) {
            String workingSetName = rfcMemento[i].getString(RFC_NAME_ATTRIBUTE);
            String description = rfcMemento[i].getString(RFC_DESCRIPTION_ATTRIBUTE);
            if (workingSetName != null) {
                this.mR3Service.getWorkingSet().addWorkingSetObject(workingSetName, description);
            }
            ++i;
        }
    }

    public void saveState(IMemento memento) {
        IMemento rfcsMemento = memento.getChild(RFCS_TAG);
        if (rfcsMemento == null) {
            rfcsMemento = memento.createChild(RFCS_TAG);
        }
        Iterator iter = this.mR3Service.getWorkingSet().getIterator();
        while (iter.hasNext()) {
            IWorkingSetObject workingSetObject = (IWorkingSetObject)iter.next();
            if (workingSetObject == null) continue;
            IMemento rfcMemento = rfcsMemento.createChild(RFC_TAG);
            rfcMemento.putString(RFC_NAME_ATTRIBUTE, workingSetObject.getName());
            rfcMemento.putString(RFC_DESCRIPTION_ATTRIBUTE, workingSetObject.getDescription());
        }
    }

    public void performFinish() {
        this.saveFields();
    }

    public void setHasToBeDisplayedRfms(String[][] rfms) {
        this.mHasToBeDisplayed = rfms;
        int i = 0;
        while (i < rfms.length) {
            this.mR3Service.getWorkingSet().addWorkingSetObject(rfms[i][0], rfms[i][1]);
            ++i;
        }
        this.mWorkSetDisplay = true;
        this.updateWorksetPanel();
        this.mR3Service.getWorkingSet().setHasToBeThereRFCs(rfms);
    }

    static {
        PAGE_TITLE = PAGE_NAME = mTPool.getText(2701);
        PAGE_DESCRIPTION = mTPool.getText(2702);
    }
}

