/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.jcb.core.wizardpages;

import com.sap.ide.jcb.core.TextPool;
import com.sap.ide.jcb.core.service.connection.ConnectionEvent;
import com.sap.ide.jcb.core.service.connection.ConnectionListener;
import com.sap.ide.jcb.core.service.connection.IConnectionManager;
import com.sap.ide.jcb.core.util.LogHandler;
import com.sap.ide.jcb.core.wizardpages.CoolSelectionPage;
import com.sap.mw.jco.JCO;
import com.sap.tc.col.cds.ConnectionData;
import com.sap.tc.col.cds.ConnectionDataAppServer;
import com.sap.tc.col.cds.ConnectionDataMsgServer;
import com.sap.tc.col.cds.ConnectionDataMsgServerSnc;
import com.sap.tc.col.cds.ConnectionDataServiceFactory;
import com.sap.tc.col.cds.IConnectionDataService;
import com.sap.tc.col.client.generic.api.IServiceFacade;
import com.sap.tc.col.client.generic.api.ServiceFacadeFactory;
import com.sap.tc.col.client.metadata.api.IAspectDescriptor;
import com.sap.tc.col.client.metadata.api.IQueryDescriptor;
import com.sap.tc.col.client.metadata.api.IServiceModuleDescriptor;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.ISashPane;
import com.tssap.util.ui.pane.ISimplePane;
import com.tssap.util.ui.pane.PaneFactory;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class CoolSelectionPage
extends WizardPage {
    private static final TextPool mTPool = TextPool.getInstance();
    private static final String PAGE_NAME;
    private static final String PAGE_TITLE;
    private static final String PAGE_DESCRIPTION;
    private static final String PAGE_NO_QUERY_ASPECT_PANE_DESCRIPTION;
    private org.eclipse.swt.widgets.List mServiceModuleList;
    private QueryAspectPane mQueryAspectPane;
    private SelectionListener mServiceModuleSelectionListener;
    private IConnectionManager mConnectionManager;
    private ConnectionListener mConnectionListener;
    private IServiceFacade mServiceFacade;
    private IServiceModuleDescriptor mServiceModuleDescriptor;
    private boolean mUpdateOnDisplay = true;
    private boolean mHideQueryAspectPane = false;
    private boolean mUpdateHideQueryAspectPane = false;
    private SashForm mSash;
    private Composite mServiceModuleListComposite;
    private boolean mUpdateSelectableOnDisplay = false;
    private boolean mAllowQueryAspectSelection = false;

    public CoolSelectionPage() {
        this(false);
    }

    public CoolSelectionPage(boolean EnableQueryAspectSelection) {
        super(PAGE_NAME);
        this.setTitle(PAGE_TITLE);
        this.setDescription(PAGE_DESCRIPTION);
        this.mConnectionListener = new ConnectionListener(){

            public void connected(ConnectionEvent event) {
                CoolSelectionPage.this.setServiceManager(event.getClient());
            }

            public void disconnected(ConnectionEvent event) {
                CoolSelectionPage.this.setServiceManager(null);
            }
        };
        this.mServiceModuleSelectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = CoolSelectionPage.this.mServiceModuleList.getSelectionIndex();
                if (index >= 0 && !CoolSelectionPage.this.mHideQueryAspectPane) {
                    CoolSelectionPage.this.mQueryAspectPane.setRootServiceModuleDescriptor(CoolSelectionPage.this.mServiceModuleList.getItem(index));
                }
            }
        };
        this.setHideQueryAspectPane(false);
        this.mAllowQueryAspectSelection = EnableQueryAspectSelection;
    }

    public boolean isPageComplete() {
        return this.mQueryAspectPane.getRootServiceModuleDescriptor() != null;
    }

    public void createControl(Composite parent) {
        ISimplePane TheSimplePane = PaneFactory.createSimplePane((Composite)parent);
        Composite root = TheSimplePane.getComposite();
        this.setControl((Control)root);
        IGridLayoutPane HostPane = PaneFactory.createGridLayoutPaneWithTitle((Composite)root, (String)mTPool.getText(3010), (int)1);
        ISashPane hostSashPane = HostPane.addHorizontalSashPane(HostPane.createGridLayoutData(4, 4, true, true, 1, 1));
        this.mSash = (SashForm)hostSashPane.getComposite();
        this.mServiceModuleListComposite = this.createServiceModulePane(hostSashPane);
        this.createQueryAspectPane(hostSashPane);
        hostSashPane.setWeights(new int[]{3, 5});
        if (this.mUpdateOnDisplay) {
            this.refresh();
        }
        if (this.mUpdateHideQueryAspectPane) {
            this.setHideQueryAspectPane(this.mHideQueryAspectPane);
        }
    }

    private void setServiceManager(JCO.Client JcoClient) {
        if (JcoClient == null || !JcoClient.isAlive()) {
            this.mServiceFacade = null;
            if (this.mQueryAspectPane != null) {
                this.mQueryAspectPane.setRootServiceModuleDescriptor(null);
            }
        } else {
            Properties connectionProperties = JcoClient.getProperties();
            ConnectionData connectionData = this.getConnectionData(JcoClient);
            this.mServiceFacade = connectionData != null ? ServiceFacadeFactory.createServiceFacade((ConnectionData)connectionData) : null;
        }
        this.refresh();
    }

    private ConnectionData getConnectionData(JCO.Client JcoClient) {
        IConnectionManager connectionManager = this.getConnectionManager();
        String connectionType = connectionManager.getConnectionType();
        if (connectionManager == null || JcoClient == null || connectionType == null) {
            return null;
        }
        IConnectionDataService myCDS = ConnectionDataServiceFactory.getConnectionDataService();
        Properties connectionProperties = JcoClient.getProperties();
        if (connectionType.equalsIgnoreCase("SingleServer")) {
            ConnectionDataAppServer myConnData = (ConnectionDataAppServer)myCDS.getConnectionData("JCO", "0");
            myConnData.setAppServer(connectionProperties.getProperty("jco.client.ashost"));
            myConnData.setSystemNumber(connectionProperties.getProperty("jco.client.sysnr"));
            myConnData.setClient(connectionProperties.getProperty("jco.client.client"));
            myConnData.setUser(connectionProperties.getProperty("jco.client.user"));
            myConnData.setPassword(connectionProperties.getProperty("jco.client.passwd"));
            myConnData.setLanguage(connectionProperties.getProperty("jco.client.lang"));
            return myConnData;
        }
        if (connectionType.equalsIgnoreCase("LoadBalancingServer")) {
            ConnectionDataMsgServer myConnData = (ConnectionDataMsgServer)myCDS.getConnectionData("JCO", "1");
            myConnData.setSystemName(connectionProperties.getProperty("jco.client.r3name"));
            myConnData.setMsgServer(connectionProperties.getProperty("jco.client.mshost"));
            myConnData.setLogonGroup(connectionProperties.getProperty("jco.client.group"));
            myConnData.setClient(connectionProperties.getProperty("jco.client.client"));
            myConnData.setUser(connectionProperties.getProperty("jco.client.user"));
            myConnData.setPassword(connectionProperties.getProperty("jco.client.passwd"));
            myConnData.setLanguage(connectionProperties.getProperty("jco.client.lang"));
            return myConnData;
        }
        if (connectionType.equalsIgnoreCase("LoadBalancingServerSnc")) {
            ConnectionDataMsgServerSnc myConnData = (ConnectionDataMsgServerSnc)myCDS.getConnectionData("JCO", "5");
            myConnData.setSystemName(connectionProperties.getProperty("jco.client.r3name"));
            myConnData.setMsgServer(connectionProperties.getProperty("jco.client.mshost"));
            myConnData.setLogonGroup(connectionProperties.getProperty("jco.client.group"));
            myConnData.setClient(connectionProperties.getProperty("jco.client.client"));
            myConnData.setLanguage(connectionProperties.getProperty("jco.client.lang"));
            myConnData.setSncPartnerName(connectionProperties.getProperty("jco.client.snc_partnername"));
            return myConnData;
        }
        return null;
    }

    private void refresh() {
        if (this.mServiceFacade != null) {
            if (this.mServiceModuleList != null) {
                try {
                    this.mServiceModuleList.setItems(this.mServiceFacade.getServiceModuleNames());
                }
                catch (Exception e) {
                    LogHandler.logException(e);
                    MessageDialog.openError((Shell)this.getShell(), (String)mTPool.getText(3051), (String)e.getMessage());
                }
                this.mServiceModuleList.deselectAll();
                this.mUpdateOnDisplay = false;
            } else {
                this.mUpdateOnDisplay = true;
            }
        } else if (this.mServiceModuleList != null) {
            this.mServiceModuleList.removeAll();
            this.mUpdateOnDisplay = false;
        } else {
            this.mUpdateOnDisplay = true;
        }
    }

    private void createQueryAspectPane(ISashPane hostSashPane) {
        IGridLayoutPane TheQueryAspectPane = hostSashPane.addGridLayoutPane(1);
        this.mQueryAspectPane = new QueryAspectPane(TheQueryAspectPane, this.mAllowQueryAspectSelection);
    }

    private Composite createServiceModulePane(ISashPane hostSashPane) {
        IGridLayoutPane ServiceModulePane = hostSashPane.addGridLayoutPane(1);
        this.mServiceModuleList = ServiceModulePane.addList(new String[0], false, ServiceModulePane.createGridLayoutData(4, 4, true, true, 1, 1));
        this.mServiceModuleList.addSelectionListener(this.mServiceModuleSelectionListener);
        return ServiceModulePane.getComposite();
    }

    public IConnectionManager getConnectionManager() {
        return this.mConnectionManager;
    }

    public void setConnectionManager(IConnectionManager connectionManager) {
        this.removeConnectionListeners();
        this.mConnectionManager = connectionManager;
        this.addConnectionListeners();
    }

    private void addConnectionListeners() {
        if (this.mConnectionManager != null) {
            this.mConnectionManager.addConnectionListener(this.mConnectionListener);
        }
    }

    private void removeConnectionListeners() {
        if (this.mConnectionManager != null) {
            this.mConnectionManager.removeConnectionListener(this.mConnectionListener);
        }
    }

    public IServiceModuleDescriptor getServiceModuleDescriptor() {
        if (this.mHideQueryAspectPane) {
            return this.mServiceFacade.getServiceModuleDescriptor(this.mServiceModuleList.getItem(this.mServiceModuleList.getSelectionIndex()));
        }
        return this.mQueryAspectPane.getRootServiceModuleDescriptor();
    }

    public void setServiceModuleDescriptor(IServiceModuleDescriptor serviceModuleDescriptor) {
        this.mQueryAspectPane.setRootServiceModuleDescriptor(serviceModuleDescriptor.getName());
    }

    public IAspectDescriptor[] getSelectedAspects() {
        if (this.mHideQueryAspectPane) {
            IServiceModuleDescriptor theServiceModuleDescriptor = this.getServiceModuleDescriptor();
            if (theServiceModuleDescriptor == null) {
                return null;
            }
            return theServiceModuleDescriptor.getAspectDescriptors();
        }
        return this.mQueryAspectPane.getSelectedAspects();
    }

    public IQueryDescriptor[] getSelectedQueries() {
        if (this.mHideQueryAspectPane) {
            IServiceModuleDescriptor theServiceModuleDescriptor = this.getServiceModuleDescriptor();
            if (theServiceModuleDescriptor == null) {
                return null;
            }
            return theServiceModuleDescriptor.getQueryDescriptors();
        }
        return this.mQueryAspectPane.getSelectedQueries();
    }

    public void dispose() {
        super.dispose();
        this.setServiceManager(null);
        this.setConnectionManager(null);
    }

    public boolean canFlipToNextPage() {
        return true;
    }

    public boolean isHideQueryAspectPane() {
        return this.mHideQueryAspectPane;
    }

    public void setHideQueryAspectPane(boolean hideQueryAspectPane) {
        this.mHideQueryAspectPane = hideQueryAspectPane;
        if (this.mSash != null) {
            if (this.mHideQueryAspectPane) {
                this.mSash.setMaximizedControl((Control)this.mServiceModuleListComposite);
                this.setDescription(PAGE_NO_QUERY_ASPECT_PANE_DESCRIPTION);
            } else {
                this.mSash.setMaximizedControl(null);
                if (this.mAllowQueryAspectSelection) {
                    this.setDescription(PAGE_DESCRIPTION);
                } else {
                    this.setDescription(PAGE_NO_QUERY_ASPECT_PANE_DESCRIPTION);
                }
            }
            this.mUpdateHideQueryAspectPane = false;
        } else {
            this.mUpdateHideQueryAspectPane = true;
        }
    }

    static /* synthetic */ IServiceFacade access$1400(CoolSelectionPage x0) {
        return x0.mServiceFacade;
    }

    static {
        PAGE_TITLE = PAGE_NAME = mTPool.getText(3001);
        PAGE_DESCRIPTION = mTPool.getText(3002);
        PAGE_NO_QUERY_ASPECT_PANE_DESCRIPTION = mTPool.getText(3003);
    }

    class QueryAspectPane {
        private IServiceModuleDescriptor mRootServiceModuleDescriptor;
        private String mRootServiceModuleDescriptorName;
        private boolean mProcessSelection = true;
        private boolean mSelectable = true;
        private TableViewer mQueryTableViewer = null;
        private Table mQueryTable = null;
        private String[] mQueryCheckBoxTableColumnHeaders = new String[]{"", CoolSelectionPage.access$400().getText(3021), CoolSelectionPage.access$400().getText(3022), CoolSelectionPage.access$400().getText(3023)};
        private ColumnLayoutData[] mQueryCheckBoxTableColumnLayouts = new ColumnLayoutData[]{new ColumnPixelData(19, false), new ColumnWeightData(70), new ColumnWeightData(60), new ColumnWeightData(30)};
        private String[] mQueryTableColumnHeaders = new String[]{CoolSelectionPage.access$400().getText(3021), CoolSelectionPage.access$400().getText(3022), CoolSelectionPage.access$400().getText(3023)};
        private ColumnLayoutData[] mQueryTableColumnLayouts = new ColumnLayoutData[]{new ColumnWeightData(50), new ColumnWeightData(30), new ColumnWeightData(30)};
        private TableViewer mAspectTableViewer = null;
        private Table mAspectTable = null;
        private String[] mAspectTableColumnHeaders = new String[]{CoolSelectionPage.access$400().getText(3031), CoolSelectionPage.access$400().getText(3032)};
        private ColumnLayoutData[] mAspectTableColumnLayouts = new ColumnLayoutData[]{new ColumnWeightData(60), new ColumnWeightData(40)};
        private String[] mAspectCheckBoxTableColumnHeaders = new String[]{"", CoolSelectionPage.access$400().getText(3031), CoolSelectionPage.access$400().getText(3032)};
        private ColumnLayoutData[] mAspectCheckBoxTableColumnLayouts = new ColumnLayoutData[]{new ColumnPixelData(19, false), new ColumnWeightData(70), new ColumnWeightData(30)};
        private int mQueryNameColumn = 1;
        private int mQueryAspectColumn = 2;
        private int mQueryDescriptionColumn = 3;
        private int mAspectNameColumn = 1;
        private int mAspectDescriptionColumn = 2;

        public QueryAspectPane(IGridLayoutPane GridPane, boolean Selectable) {
            ISashPane QAPane = GridPane.addVerticalSashPane(GridPane.createGridLayoutData(4, 4, true, true, 1, 1));
            this.mSelectable = Selectable;
            this.createAspectPane(QAPane);
            this.createQueryPane(QAPane);
            if (!Selectable) {
                --this.mQueryNameColumn;
                --this.mQueryAspectColumn;
                --this.mQueryDescriptionColumn;
                --this.mAspectNameColumn;
                --this.mAspectDescriptionColumn;
            }
        }

        public QueryAspectPane(IGridLayoutPane GridPane) {
            this(GridPane, false);
        }

        private void createQueryPane(ISashPane QAPane) {
            IGridLayoutPane QueryPane = QAPane.addGridLayoutPane(mTPool.getText(3020), 1);
            this.mQueryTableViewer = this.mSelectable ? QueryPane.addCheckboxTableViewer(true) : QueryPane.addTableViewer(true);
            this.mQueryTable = this.mQueryTableViewer.getTable();
            TableLayout layout = new TableLayout();
            this.mQueryTable.setLayout((Layout)layout);
            this.mQueryTable.setHeaderVisible(true);
            String[] ColumnHeaders = this.mSelectable ? this.mQueryCheckBoxTableColumnHeaders : this.mQueryTableColumnHeaders;
            ColumnLayoutData[] TheColumnLayoutData = this.mSelectable ? this.mQueryCheckBoxTableColumnLayouts : this.mQueryTableColumnLayouts;
            int i = 0;
            while (i < ColumnHeaders.length) {
                layout.addColumnData(TheColumnLayoutData[i]);
                TableColumn tc = new TableColumn(this.mQueryTable, 0, i);
                tc.setResizable(TheColumnLayoutData[i].resizable);
                tc.setText(ColumnHeaders[i]);
                ++i;
            }
            this.mQueryTable.setLinesVisible(true);
            this.mQueryTableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(this){
                private Object[] EMPTY_ARRAY;
                private final /* synthetic */ QueryAspectPane this$1;
                {
                    this.this$1 = this$1;
                    this.EMPTY_ARRAY = new Object[0];
                }

                public Object[] getElements(Object inputElement) {
                    if (inputElement == null) {
                        return this.EMPTY_ARRAY;
                    }
                    if (inputElement instanceof IServiceModuleDescriptor) {
                        IServiceModuleDescriptor TheDescriptor = (IServiceModuleDescriptor)inputElement;
                        IQueryDescriptor[] TheQueryDescriptors = TheDescriptor.getQueryDescriptors();
                        Object[] TheElements = new Object[TheQueryDescriptors.length];
                        System.arraycopy(TheQueryDescriptors, 0, TheElements, 0, TheQueryDescriptors.length);
                        return TheElements;
                    }
                    return this.EMPTY_ARRAY;
                }

                public void dispose() {
                }

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }
            });
            this.mQueryTableViewer.setLabelProvider((IBaseLabelProvider)new QALabelProvider());
            if (this.mSelectable) {
                ((CheckboxTableViewer)this.mQueryTableViewer).addCheckStateListener(new ICheckStateListener(this){
                    private final /* synthetic */ QueryAspectPane this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void checkStateChanged(CheckStateChangedEvent event) {
                        if (!QueryAspectPane.access$500(this.this$1)) {
                            return;
                        }
                        if (event.getElement() instanceof IQueryDescriptor && event.getChecked()) {
                            IQueryDescriptor TheQueryDescriptor = (IQueryDescriptor)event.getElement();
                            IAspectDescriptor TheResultDescriptor = TheQueryDescriptor.getResultAspectDescriptor();
                            ((CheckboxTableViewer)QueryAspectPane.access$600(this.this$1)).setChecked((Object)TheResultDescriptor, true);
                        }
                    }
                });
            }
        }

        private void createAspectPane(ISashPane QAPane) {
            IGridLayoutPane AspectPane = QAPane.addGridLayoutPane(mTPool.getText(3030), 1);
            this.mAspectTableViewer = this.mSelectable ? AspectPane.addCheckboxTableViewer(true) : AspectPane.addTableViewer(true);
            this.mAspectTable = this.mAspectTableViewer.getTable();
            TableLayout layout = new TableLayout();
            this.mAspectTable.setLayout((Layout)layout);
            this.mAspectTable.setHeaderVisible(true);
            String[] ColumnHeaders = this.mSelectable ? this.mAspectCheckBoxTableColumnHeaders : this.mAspectTableColumnHeaders;
            ColumnLayoutData[] TheColumnLayoutData = this.mSelectable ? this.mAspectCheckBoxTableColumnLayouts : this.mAspectTableColumnLayouts;
            int i = 0;
            while (i < ColumnHeaders.length) {
                layout.addColumnData(TheColumnLayoutData[i]);
                TableColumn tc = new TableColumn(this.mAspectTable, 0, i);
                tc.setResizable(TheColumnLayoutData[i].resizable);
                tc.setText(ColumnHeaders[i]);
                ++i;
            }
            this.mAspectTable.setLinesVisible(true);
            this.mAspectTableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(this){
                private Object[] EMPTY_ARRAY;
                private final /* synthetic */ QueryAspectPane this$1;
                {
                    this.this$1 = this$1;
                    this.EMPTY_ARRAY = new Object[0];
                }

                public Object[] getElements(Object inputElement) {
                    if (inputElement == null) {
                        return this.EMPTY_ARRAY;
                    }
                    if (inputElement instanceof IServiceModuleDescriptor) {
                        IServiceModuleDescriptor TheDescriptor = (IServiceModuleDescriptor)inputElement;
                        IAspectDescriptor[] TheAspectDescriptors = TheDescriptor.getAspectDescriptors();
                        Object[] TheElements = new Object[TheAspectDescriptors.length];
                        System.arraycopy(TheAspectDescriptors, 0, TheElements, 0, TheAspectDescriptors.length);
                        return TheElements;
                    }
                    return this.EMPTY_ARRAY;
                }

                public void dispose() {
                }

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }
            });
            this.mAspectTableViewer.setLabelProvider((IBaseLabelProvider)new QALabelProvider());
            if (this.mSelectable) {
                ((CheckboxTableViewer)this.mAspectTableViewer).addCheckStateListener(new ICheckStateListener(this){
                    private final /* synthetic */ QueryAspectPane this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void checkStateChanged(CheckStateChangedEvent event) {
                        if (!QueryAspectPane.access$500(this.this$1)) {
                            return;
                        }
                        if (event.getElement() instanceof IAspectDescriptor && !event.getChecked()) {
                            IAspectDescriptor TheAspectDescriptor = (IAspectDescriptor)event.getElement();
                            IQueryDescriptor[] TheQueryDescriptors = QueryAspectPane.access$700(this.this$1).getQueryDescriptors();
                            ArrayList<IQueryDescriptor> QueryDescriptorsToUncheck = new ArrayList<IQueryDescriptor>();
                            int i = 0;
                            while (i < TheQueryDescriptors.length) {
                                if (TheQueryDescriptors[i].getResultAspectDescriptor().equals(TheAspectDescriptor) && ((CheckboxTableViewer)QueryAspectPane.access$800(this.this$1)).getChecked((Object)TheQueryDescriptors[i])) {
                                    QueryDescriptorsToUncheck.add(TheQueryDescriptors[i]);
                                }
                                ++i;
                            }
                            if (QueryDescriptorsToUncheck.size() > 0) {
                                String lineDelimiter = System.getProperty("line.separator", "\n");
                                if (MessageDialog.openQuestion((Shell)QueryAspectPane.access$900(this.this$1).getControl().getShell(), (String)"Confirm Deselection", (String)("The Aspect " + TheAspectDescriptor.getName() + " is being used in the following Queries : " + QueryAspectPane.access$1000(this.this$1, QueryDescriptorsToUncheck) + lineDelimiter + " Proceeding with the operation will deselect them.  Do you want to proceed with the operation?"))) {
                                    int i2 = 0;
                                    while (i2 < TheQueryDescriptors.length) {
                                        ((CheckboxTableViewer)QueryAspectPane.access$800(this.this$1)).setChecked((Object)TheQueryDescriptors[i2], false);
                                        ++i2;
                                    }
                                } else {
                                    ((CheckboxTableViewer)QueryAspectPane.access$600(this.this$1)).setChecked(event.getElement(), true);
                                }
                            }
                        }
                    }
                });
            }
        }

        private String getQueryNameString(List QueryDescriptorsToUncheck) {
            String QueryNameString = "";
            Iterator iter = QueryDescriptorsToUncheck.iterator();
            while (iter.hasNext()) {
                IQueryDescriptor TheQueryDescriptor = (IQueryDescriptor)iter.next();
                QueryNameString = QueryNameString.length() == 0 ? QueryNameString + TheQueryDescriptor.getName() : QueryNameString + " , " + TheQueryDescriptor.getName();
            }
            return QueryNameString;
        }

        public IServiceModuleDescriptor getRootServiceModuleDescriptor() {
            return this.mRootServiceModuleDescriptor;
        }

        public void setRootServiceModuleDescriptor(String rootServiceModuleDescriptor) {
            this.mRootServiceModuleDescriptorName = rootServiceModuleDescriptor;
            if (this.mRootServiceModuleDescriptorName == null) {
                this.ClearAll();
                return;
            }
            IRunnableWithProgress op = this.getRunnable();
            try {
                CoolSelectionPage.super.getContainer().run(true, false, op);
                CoolSelectionPage.this.setPageComplete(true);
            }
            catch (InterruptedException e) {
                LogHandler.logException(e);
            }
            catch (InvocationTargetException e) {
                LogHandler.logException(e);
            }
        }

        private IRunnableWithProgress getRunnable() {
            IRunnableWithProgress op = new IRunnableWithProgress(this){
                private final /* synthetic */ QueryAspectPane this$1;
                {
                    this.this$1 = this$1;
                }

                public void run(IProgressMonitor monitor) {
                    monitor.beginTask("Retrieving the Descriptors", 3);
                    monitor.worked(1);
                    QueryAspectPane.access$900(this.this$1).getControl().getDisplay().asyncExec(new Runnable(this){
                        private final /* synthetic */ 7 this$2;
                        {
                            this.this$2 = this$2;
                        }

                        /*
                         * Enabled aggressive block sorting
                         * Enabled unnecessary exception pruning
                         * Enabled aggressive exception aggregation
                         */
                        public void run() {
                            try {
                                block8: {
                                    try {
                                        if (QueryAspectPane.access$1300(7.access$1200(this.this$2)) == null) {
                                            QueryAspectPane.access$702(7.access$1200(this.this$2), null);
                                        } else {
                                            QueryAspectPane.access$702(7.access$1200(this.this$2), CoolSelectionPage.access$1400(QueryAspectPane.access$900(7.access$1200(this.this$2))).getServiceModuleDescriptor(QueryAspectPane.access$1300(7.access$1200(this.this$2))));
                                        }
                                        if (QueryAspectPane.access$600(7.access$1200(this.this$2)) != null) {
                                            QueryAspectPane.access$600(7.access$1200(this.this$2)).setInput((Object)QueryAspectPane.access$700(7.access$1200(this.this$2)));
                                        }
                                        if (QueryAspectPane.access$800(7.access$1200(this.this$2)) != null) {
                                            QueryAspectPane.access$800(7.access$1200(this.this$2)).setInput((Object)QueryAspectPane.access$700(7.access$1200(this.this$2)));
                                        }
                                        QueryAspectPane.access$502(7.access$1200(this.this$2), false);
                                        if (!CoolSelectionPage.access$1500(QueryAspectPane.access$900(7.access$1200(this.this$2)))) break block8;
                                        ((CheckboxTableViewer)QueryAspectPane.access$800(7.access$1200(this.this$2))).setAllChecked(true);
                                        ((CheckboxTableViewer)QueryAspectPane.access$600(7.access$1200(this.this$2))).setAllChecked(true);
                                    }
                                    catch (RuntimeException e) {
                                        LogHandler.logException(e);
                                        Object var3_2 = null;
                                        QueryAspectPane.access$502(7.access$1200(this.this$2), true);
                                        return;
                                    }
                                }
                                Object var3_1 = null;
                                QueryAspectPane.access$502(7.access$1200(this.this$2), true);
                                return;
                            }
                            catch (Throwable throwable) {
                                Object var3_3 = null;
                                QueryAspectPane.access$502(7.access$1200(this.this$2), true);
                                throw throwable;
                            }
                        }
                    });
                    monitor.done();
                }

                static /* synthetic */ QueryAspectPane access$1200(7 x0) {
                    return x0.this$1;
                }
            };
            return op;
        }

        private void ClearAll() {
            this.mRootServiceModuleDescriptorName = null;
            this.mRootServiceModuleDescriptor = null;
            if (this.mAspectTableViewer != null) {
                this.mAspectTableViewer.setInput(null);
            }
            if (this.mQueryTableViewer != null) {
                this.mQueryTableViewer.setInput(null);
            }
        }

        public IAspectDescriptor[] getSelectedAspects() {
            Object[] SelectedObjects = CoolSelectionPage.this.mAllowQueryAspectSelection ? ((CheckboxTableViewer)this.mAspectTableViewer).getCheckedElements() : new Object[]{};
            IAspectDescriptor[] SelectedAspectDescriptors = new IAspectDescriptor[SelectedObjects.length];
            System.arraycopy(SelectedObjects, 0, SelectedAspectDescriptors, 0, SelectedObjects.length);
            return SelectedAspectDescriptors;
        }

        public IQueryDescriptor[] getSelectedQueries() {
            Object[] SelectedObjects = CoolSelectionPage.this.mAllowQueryAspectSelection ? ((CheckboxTableViewer)this.mQueryTableViewer).getCheckedElements() : new Object[]{};
            IQueryDescriptor[] SelectedQueryDescriptors = new IQueryDescriptor[SelectedObjects.length];
            System.arraycopy(SelectedObjects, 0, SelectedQueryDescriptors, 0, SelectedObjects.length);
            return SelectedQueryDescriptors;
        }

        private void _internalSetSelectable(boolean selectable) {
            if (selectable) {
                TableColumn checkboxTableColumn = this.mAspectTable.getColumn(0);
                checkboxTableColumn.setResizable(true);
                checkboxTableColumn.setWidth(19);
                checkboxTableColumn = this.mQueryTable.getColumn(0);
                checkboxTableColumn.setResizable(true);
                checkboxTableColumn.setWidth(19);
            } else {
                TableColumn checkboxTableColumn = this.mAspectTable.getColumn(0);
                checkboxTableColumn.setResizable(false);
                checkboxTableColumn.setWidth(0);
                checkboxTableColumn = this.mQueryTable.getColumn(0);
                checkboxTableColumn.setResizable(false);
                checkboxTableColumn.setWidth(0);
            }
        }

        static /* synthetic */ boolean access$500(QueryAspectPane x0) {
            return x0.mProcessSelection;
        }

        static /* synthetic */ TableViewer access$600(QueryAspectPane x0) {
            return x0.mAspectTableViewer;
        }

        static /* synthetic */ IServiceModuleDescriptor access$700(QueryAspectPane x0) {
            return x0.mRootServiceModuleDescriptor;
        }

        static /* synthetic */ TableViewer access$800(QueryAspectPane x0) {
            return x0.mQueryTableViewer;
        }

        static /* synthetic */ CoolSelectionPage access$900(QueryAspectPane x0) {
            return x0.CoolSelectionPage.this;
        }

        static /* synthetic */ String access$1000(QueryAspectPane x0, List x1) {
            return x0.getQueryNameString(x1);
        }

        static /* synthetic */ String access$1300(QueryAspectPane x0) {
            return x0.mRootServiceModuleDescriptorName;
        }

        static /* synthetic */ IServiceModuleDescriptor access$702(QueryAspectPane x0, IServiceModuleDescriptor x1) {
            x0.mRootServiceModuleDescriptor = x1;
            return x0.mRootServiceModuleDescriptor;
        }

        static /* synthetic */ boolean access$502(QueryAspectPane x0, boolean x1) {
            x0.mProcessSelection = x1;
            return x0.mProcessSelection;
        }

        public class QALabelProvider
        extends LabelProvider
        implements ITableLabelProvider {
            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                String columnText = "";
                if (element instanceof IQueryDescriptor) {
                    IQueryDescriptor TheQueryDescriptor = (IQueryDescriptor)element;
                    if (columnIndex == QueryAspectPane.this.mQueryNameColumn) {
                        columnText = TheQueryDescriptor.getName();
                    } else if (columnIndex == QueryAspectPane.this.mQueryAspectColumn) {
                        IAspectDescriptor TheAspectDescriptor = TheQueryDescriptor.getResultAspectDescriptor();
                        columnText = TheAspectDescriptor != null ? TheAspectDescriptor.getName() : "";
                    } else if (columnIndex == QueryAspectPane.this.mQueryDescriptionColumn) {
                        columnText = TheQueryDescriptor.getDescription();
                    }
                } else if (element instanceof IAspectDescriptor) {
                    IAspectDescriptor TheAspectDescriptor = (IAspectDescriptor)element;
                    if (columnIndex == QueryAspectPane.this.mAspectNameColumn) {
                        columnText = TheAspectDescriptor.getName();
                    } else if (columnIndex == QueryAspectPane.this.mAspectDescriptionColumn) {
                        columnText = TheAspectDescriptor.getDescription();
                    }
                }
                return columnText;
            }
        }
    }
}

