/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.jcb.core.util;

import com.sap.ide.jcb.core.SAPJavaConnectivityBuilderCorePlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.util.Assert;

public class Status
implements IStatus {
    private String fStatusMessage;
    private int fSeverity;
    private String fPluginId;
    private Throwable fException;
    private String fOKMessage;

    public Status() {
        this(0, null);
    }

    public Status(int severity, String message) {
        this(SAPJavaConnectivityBuilderCorePlugin.getDefault().getDescriptor().getUniqueIdentifier(), severity, message);
    }

    public Status(String pluginId, int severity, String message) {
        this(pluginId, severity, message, null);
    }

    public Status(String pluginId, int severity, String message, Throwable exception) {
        this.fPluginId = pluginId;
        this.fStatusMessage = message;
        this.fSeverity = severity;
        this.fException = exception;
        if (this.fSeverity == 0) {
            this.fOKMessage = this.fStatusMessage;
        }
    }

    public void log() {
        SAPJavaConnectivityBuilderCorePlugin.getDefault().getLog().log((IStatus)this);
    }

    public boolean isOK() {
        return this.fSeverity == 0;
    }

    public boolean isWarning() {
        return this.fSeverity == 2;
    }

    public boolean isInfo() {
        return this.fSeverity == 1;
    }

    public boolean isError() {
        return this.fSeverity == 4;
    }

    public String getMessage() {
        if (this.isOK()) {
            return this.fOKMessage;
        }
        return this.fStatusMessage;
    }

    public void setError(String errorMessage) {
        Assert.isNotNull((Object)errorMessage);
        this.fStatusMessage = errorMessage;
        this.fSeverity = 4;
    }

    public void setWarning(String warningMessage) {
        Assert.isNotNull((Object)warningMessage);
        this.fStatusMessage = warningMessage;
        this.fSeverity = 2;
    }

    public void setInfo(String infoMessage) {
        Assert.isNotNull((Object)infoMessage);
        this.fStatusMessage = infoMessage;
        this.fSeverity = 1;
    }

    public void setOK() {
        this.fStatusMessage = null;
        this.fSeverity = 0;
    }

    public boolean matches(int severityMask) {
        return (this.fSeverity & severityMask) != 0;
    }

    public boolean isMultiStatus() {
        return false;
    }

    public int getSeverity() {
        return this.fSeverity;
    }

    public String getPlugin() {
        return this.fPluginId;
    }

    public Throwable getException() {
        return this.fException;
    }

    public int getCode() {
        return this.fSeverity;
    }

    public IStatus[] getChildren() {
        return new IStatus[0];
    }
}

