/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.jcb.core.service.workingset.internal;

import com.sap.ide.jcb.core.service.workingset.IWorkingSet;
import com.sap.ide.jcb.core.service.workingset.IWorkingSetObject;
import com.sap.ide.jcb.core.service.workingset.RFCInHasToBeThereWorkingSetRemoved;
import com.sap.ide.jcb.core.service.workingset.RFCModuleAddedEvent;
import com.sap.ide.jcb.core.service.workingset.RFCModuleAddedListener;
import com.sap.ide.jcb.core.service.workingset.RFCModuleRemovedEvent;
import com.sap.ide.jcb.core.service.workingset.RFCModuleRemovedListener;
import com.sap.ide.jcb.core.service.workingset.internal.WorkingSetObject;
import com.sap.ide.jcb.core.util.LogHandler;
import com.sap.mdi.AKHNode;
import com.sap.mdi.Rfm;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

public class WorkingSet
implements IWorkingSet {
    Map mWorkingSet = new Hashtable();
    ArrayList mRFCModuleAddedEventListeners = new ArrayList();
    ArrayList mRFCModuleRemovedEventListeners = new ArrayList();
    private String[][] mHasToBeThereRFCs = null;

    public void addRFCModule(Rfm rfcModule) {
        IWorkingSetObject workingSetObject = (IWorkingSetObject)this.mWorkingSet.get(rfcModule.getName());
        if (workingSetObject != null) {
            workingSetObject.setRFCModule(rfcModule);
        } else {
            this.addWorkingSetObject(new WorkingSetObject(rfcModule));
        }
    }

    protected void fireRFCModuleAdded(IWorkingSetObject workingSetObject) {
        if (workingSetObject == null) {
            return;
        }
        RFCModuleAddedEvent theEvent = new RFCModuleAddedEvent(this, workingSetObject);
        Iterator iter = ((AbstractList)this.mRFCModuleAddedEventListeners).iterator();
        while (iter.hasNext()) {
            RFCModuleAddedListener listener = (RFCModuleAddedListener)iter.next();
            if (listener == null) continue;
            listener.rfcModuleAdded(theEvent);
        }
    }

    public void removeRFCModule(Rfm rfcModule) throws RFCInHasToBeThereWorkingSetRemoved {
        try {
            this.removeWorkingSetObject(rfcModule.getName());
        }
        catch (RFCInHasToBeThereWorkingSetRemoved exception) {
            LogHandler.logException(exception);
            throw exception;
        }
    }

    protected void fireRFCModuleRemoved(IWorkingSetObject workingSetObject) {
        if (workingSetObject == null) {
            return;
        }
        RFCModuleRemovedEvent theEvent = new RFCModuleRemovedEvent(this, workingSetObject);
        Iterator iter = ((AbstractList)this.mRFCModuleRemovedEventListeners).iterator();
        while (iter.hasNext()) {
            RFCModuleRemovedListener listener = (RFCModuleRemovedListener)iter.next();
            if (listener == null) continue;
            listener.rfcModuleRemoved(theEvent);
        }
    }

    protected void fireRemovedAll() {
        Iterator iter = ((AbstractList)this.mRFCModuleRemovedEventListeners).iterator();
        while (iter.hasNext()) {
            RFCModuleRemovedListener listener = (RFCModuleRemovedListener)iter.next();
            if (listener == null) continue;
            listener.removedAll();
        }
    }

    public void addRFCModules(AKHNode applicationComponent) {
        throw new UnsupportedOperationException();
    }

    public void removeRFCModules(AKHNode applicationComponent) {
        throw new UnsupportedOperationException();
    }

    public void addRFCModuleAddedEventListener(RFCModuleAddedListener rfcModuleAddedListener) {
        this.mRFCModuleAddedEventListeners.add(rfcModuleAddedListener);
    }

    public void addRFCModuleRemovedEventListener(RFCModuleRemovedListener rfcModuleRemovedListener) {
        this.mRFCModuleRemovedEventListeners.add(rfcModuleRemovedListener);
    }

    public void removeRFCModuleAddedEventListener(RFCModuleAddedListener rfcModuleAddedListener) {
        ((AbstractCollection)this.mRFCModuleAddedEventListeners).remove(rfcModuleAddedListener);
    }

    public void removeRFCModuleRemovedEventListener(RFCModuleRemovedListener rfcModuleRemovedListener) {
        ((AbstractCollection)this.mRFCModuleRemovedEventListeners).remove(rfcModuleRemovedListener);
    }

    public Iterator getIterator() {
        return this.mWorkingSet.values().iterator();
    }

    public int getSize() {
        return this.mWorkingSet.size();
    }

    public Object[] toArray() {
        return this.mWorkingSet.values().toArray();
    }

    public void addWorkingSetObject(IWorkingSetObject workingSetObject) {
        if (null == this.mWorkingSet.get(workingSetObject.getName())) {
            this.mWorkingSet.put(workingSetObject.getName(), workingSetObject);
            this.fireRFCModuleAdded(workingSetObject);
        }
    }

    public void addWorkingSetObject(String name, String description) {
        this.addWorkingSetObject(new WorkingSetObject(name, description));
    }

    public void removeWorkingSetObject(IWorkingSetObject workingSetObject) throws RFCInHasToBeThereWorkingSetRemoved {
        try {
            this.removeWorkingSetObject(workingSetObject.getName());
        }
        catch (RFCInHasToBeThereWorkingSetRemoved exception) {
            LogHandler.logException(exception);
            throw exception;
        }
    }

    public void removeWorkingSetObject(String name) throws RFCInHasToBeThereWorkingSetRemoved {
        IWorkingSetObject workingSetObject = (IWorkingSetObject)this.mWorkingSet.remove(name);
        this.fireRFCModuleRemoved(workingSetObject);
        if (this.isRFCHasToBeThere(name)) {
            throw new RFCInHasToBeThereWorkingSetRemoved(this, name);
        }
    }

    public void removeAll() {
        Hashtable tmpWorkingSet = new Hashtable(this.mWorkingSet);
        int i = 0;
        while (i < tmpWorkingSet.size()) {
            Iterator iterator = tmpWorkingSet.values().iterator();
            while (iterator.hasNext()) {
                String name = ((WorkingSetObject)iterator.next()).getName();
                try {
                    this.removeWorkingSetObject(name);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            ++i;
        }
        this.fireRemovedAll();
    }

    public void setHasToBeThereRFCs(String[][] hasToBeThereRFCs) {
        this.mHasToBeThereRFCs = hasToBeThereRFCs;
    }

    public boolean isRFCHasToBeThere(String rfcName) {
        if (null == this.mHasToBeThereRFCs) {
            return false;
        }
        int i = 0;
        while (i < this.mHasToBeThereRFCs.length) {
            if (rfcName.equals(this.mHasToBeThereRFCs[i][0])) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

