/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.jcb.core.service.rfcaccess.internal;

import com.sap.ide.jcb.core.service.connection.ConnectionEvent;
import com.sap.ide.jcb.core.service.connection.ConnectionListener;
import com.sap.ide.jcb.core.service.connection.IConnectionManager;
import com.sap.ide.jcb.core.service.rfcaccess.IRFCManager;
import com.sap.ide.jcb.core.service.rfcaccess.R3DataAccessException;
import com.sap.ide.jcb.core.util.StopWatch;
import com.sap.mdi.AKHNode;
import com.sap.mdi.MetaDataAccessException;
import com.sap.mdi.ObjectFactory;
import com.sap.mdi.Rfm;
import com.sap.mdi.Rfms;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;

public class RFCManager
implements IRFCManager {
    private Rfm[] mRfms;
    private Hashtable mComponents = null;
    StopWatch mStopWatch = new StopWatch();
    private final Rfm[] EMPTY_RFM_ARRAY = new Rfm[0];
    private final String AKH = "AKH";
    private final String RELEASED = "RFM_RELEASED";
    private IConnectionManager mConnectionManager = null;
    private ObjectFactory mObjectFactory = null;

    public RFCManager(IConnectionManager connectionManager) {
        this.mConnectionManager = connectionManager;
        connectionManager.addConnectionListener(new ConnectionListener(){

            public void connected(ConnectionEvent event) {
                RFCManager.this.mObjectFactory = event.getObjectFactory();
            }

            public void disconnected(ConnectionEvent event) {
                RFCManager.this.reset();
            }
        });
    }

    public AKHNode[] getAKHChilden(AKHNode akhNode) throws R3DataAccessException {
        AKHNode[] theAKHChildren = new AKHNode[akhNode.getChildrenCount()];
        int i = 0;
        Iterator iter = akhNode.getChildren().getSequentialIterator();
        while (iter.hasNext()) {
            theAKHChildren[i] = (AKHNode)iter.next();
            ++i;
        }
        return theAKHChildren;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AKHNode getAKHRoot() throws R3DataAccessException {
        AKHNode aKHNode;
        try {
            try {
                if (this.mObjectFactory == null) {
                    AKHNode aKHNode2 = null;
                    Object var4_3 = null;
                    this.mStopWatch.stopAndWrite();
                    return aKHNode2;
                }
                this.mStopWatch.start("Get AKH Root");
                aKHNode = this.mObjectFactory.getAKHRoot();
            }
            catch (MetaDataAccessException e) {
                throw new R3DataAccessException(e);
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.mStopWatch.stopAndWrite();
            throw throwable;
        }
        Object var4_4 = null;
        this.mStopWatch.stopAndWrite();
        return aKHNode;
    }

    public Rfm[] getAllRFCModules() throws R3DataAccessException {
        return this.getAllRFCModules(false);
    }

    public Rfm[] getAllRFCModules(boolean refresh) throws R3DataAccessException {
        if (!refresh && this.mRfms != null) {
            return this.mRfms;
        }
        try {
            if (this.mObjectFactory == null) {
                return null;
            }
            this.mStopWatch.start("Empty Search");
            Rfms theRFCModules = this.mObjectFactory.getRfms().search("*", "*");
            this.mStopWatch.stopAndWrite();
            this.mRfms = this.getRfmArray(theRFCModules);
            return this.mRfms;
        }
        catch (MetaDataAccessException e) {
            throw new R3DataAccessException(e);
        }
    }

    public Rfm[] getRFCModules(String functionName, String functionGroup) throws R3DataAccessException {
        if (functionName.trim().length() == 0 && functionGroup.trim().length() == 0) {
            return this.getAllRFCModules();
        }
        try {
            if (this.mObjectFactory == null) {
                return null;
            }
            this.mStopWatch.start("Search " + functionName + " " + functionGroup);
            Rfms theRFCModules = this.mObjectFactory.getRfms().search(functionName, functionGroup);
            this.mStopWatch.stopAndWrite();
            return this.getRfmArray(theRFCModules);
        }
        catch (MetaDataAccessException e) {
            throw new R3DataAccessException(e);
        }
    }

    public Object[] getRFCsforAKH(AKHNode akhNode) throws R3DataAccessException {
        return this.getRfmArrayforComponent(akhNode.getId());
    }

    public Object[] getUnattachedRFCs() throws R3DataAccessException {
        return this.getRfmArrayforComponent("");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AKHNode getAKHNode(String componentId) throws R3DataAccessException {
        AKHNode aKHNode;
        try {
            try {
                if (this.mObjectFactory == null) {
                    AKHNode aKHNode2 = null;
                    Object var5_4 = null;
                    this.mStopWatch.stopAndWrite();
                    return aKHNode2;
                }
                this.mStopWatch.start("getAKHNode for " + componentId);
                aKHNode = this.getNode(this.mObjectFactory.getAKHRoot(), componentId);
            }
            catch (MetaDataAccessException e) {
                throw new R3DataAccessException(e);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.mStopWatch.stopAndWrite();
            throw throwable;
        }
        Object var5_5 = null;
        this.mStopWatch.stopAndWrite();
        return aKHNode;
    }

    public boolean isAKHSupported() {
        if (this.mObjectFactory == null) {
            return false;
        }
        return this.mObjectFactory.isSupported("AKH");
    }

    public boolean isReleasedStateQuerySupported() {
        if (this.mObjectFactory == null) {
            return false;
        }
        return this.mObjectFactory.isSupported("RFM_RELEASED");
    }

    private Object[] getRfmArrayforComponent(String componentId) throws R3DataAccessException {
        ArrayList TheComponentList;
        if (this.mComponents == null) {
            this.initializeComponentMap();
        }
        if ((TheComponentList = (ArrayList)this.mComponents.get(componentId)) == null) {
            return this.EMPTY_RFM_ARRAY;
        }
        return TheComponentList.toArray();
    }

    private Rfm[] getRfmArray(Rfms theRFCModules) {
        this.mStopWatch.start("Get Rfm Array");
        Iterator iterator = theRFCModules.getIterator();
        int size = theRFCModules.getSize();
        Rfm[] theRfms = new Rfm[size];
        int i = 0;
        while (iterator.hasNext()) {
            theRfms[i++] = (Rfm)iterator.next();
        }
        this.mStopWatch.stopAndWrite();
        return theRfms;
    }

    private void initializeComponentMap() throws R3DataAccessException {
        try {
            try {
                this.mComponents = new Hashtable();
                Rfm[] allRFCModules = this.getAllRFCModules();
                this.mStopWatch.start("Initialize Component");
                int i = 0;
                while (i < allRFCModules.length) {
                    Rfm TheRFCModule = allRFCModules[i];
                    ArrayList<Rfm> TheComponentList = (ArrayList<Rfm>)this.mComponents.get(TheRFCModule.getComponentId());
                    if (TheComponentList == null) {
                        TheComponentList = new ArrayList<Rfm>();
                        this.mComponents.put(TheRFCModule.getComponentId(), TheComponentList);
                    }
                    TheComponentList.add(TheRFCModule);
                    ++i;
                }
            }
            catch (MetaDataAccessException e) {
                throw new R3DataAccessException(e);
            }
            Object var6_6 = null;
            this.mStopWatch.stopAndWrite();
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.mStopWatch.stopAndWrite();
            throw throwable;
        }
    }

    private void reset() {
        this.mObjectFactory = null;
        this.mRfms = null;
        this.mComponents = null;
    }

    private AKHNode getNode(AKHNode theNode, String componentId) {
        if (theNode.getId().equalsIgnoreCase(componentId)) {
            return theNode;
        }
        Iterator iter = theNode.getChildren().getIterator();
        while (iter.hasNext()) {
            AKHNode element = this.getNode((AKHNode)iter.next(), componentId);
            if (element == null) continue;
            return element;
        }
        return null;
    }

    public Rfm getRfcModule(String functionName) {
        Rfm[] rfcModules;
        try {
            rfcModules = this.getAllRFCModules();
        }
        catch (R3DataAccessException e) {
            return null;
        }
        int i = 0;
        while (i < rfcModules.length) {
            if (rfcModules[i].getName().equalsIgnoreCase(functionName)) {
                return rfcModules[i];
            }
            ++i;
        }
        return null;
    }
}

