/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.jcb.core.service.generation.internal;

import com.sap.aii.proxy.generation.api.JavaSource;
import com.sap.ide.jcb.core.service.generation.GenerationException;
import com.sap.ide.jcb.core.service.generation.IGenerationData;
import com.sap.ide.jcb.core.service.generation.ISourceGenerationData;
import com.sap.ide.jcb.core.service.generation.internal.GenerationManager;
import com.sap.ide.jcb.core.util.Status;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;

public class SourceGenerationManager
extends GenerationManager {
    List mDuplicateFiles = new ArrayList();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IResource internalGenerate(JavaSource[] sources, IProgressMonitor progressMonitor) throws GenerationException {
        ISourceGenerationData sourceGenerationData;
        block17: {
            IResource iResource;
            block15: {
                try {
                    try {
                        block16: {
                            IGenerationData generationData = this.getGenerationData();
                            if (generationData instanceof ISourceGenerationData) {
                                ICompilationUnit mainClass;
                                sourceGenerationData = (ISourceGenerationData)generationData;
                                IPackageFragmentRoot packageFragmentRoot = sourceGenerationData.getPackageFragmentRoot();
                                if (packageFragmentRoot == null) {
                                    iResource = null;
                                    Object var17_10 = null;
                                    break block15;
                                }
                                progressMonitor.beginTask("Generating Classes", 2 * sources.length);
                                if (this.checkDuplicates(sources, sourceGenerationData, packageFragmentRoot)) {
                                    throw new GenerationException(new IllegalStateException(this.getCheckoutErrorMessage(this.getReadOnlyFiles())));
                                }
                                int i = 0;
                                while (true) {
                                    ICompilationUnit javaClass;
                                    String className;
                                    if (i >= sources.length) {
                                        IPackageFragment mainPackageFragment = packageFragmentRoot.getPackageFragment(generationData.getPackageName());
                                        if (mainPackageFragment != null && (mainClass = mainPackageFragment.getCompilationUnit(generationData.getClassName() + "_PortType.java")) != null) {
                                            break;
                                        }
                                        break block16;
                                    }
                                    JavaSource javaSource = sources[i];
                                    int classIndex = javaSource.getJavaName().lastIndexOf(46);
                                    String packageName = "";
                                    if (classIndex != -1) {
                                        className = javaSource.getJavaName().substring(classIndex + 1);
                                        packageName = javaSource.getJavaName().substring(0, classIndex);
                                    } else {
                                        className = javaSource.getJavaName();
                                    }
                                    int ticks = 2;
                                    IPackageFragment packageFragment = packageFragmentRoot.getPackageFragment(packageName);
                                    if (!packageFragment.exists()) {
                                        packageFragment = packageFragmentRoot.createPackageFragment(packageName, true, (IProgressMonitor)new SubProgressMonitor(progressMonitor, --ticks));
                                    }
                                    if ((javaClass = packageFragment.getCompilationUnit(className + ".java")).exists()) {
                                        IBuffer buf = javaClass.getBuffer();
                                        buf.setContents(javaSource.getContent());
                                        buf.save((IProgressMonitor)new SubProgressMonitor(progressMonitor, ticks), true);
                                        buf.close();
                                        javaClass.makeConsistent(null);
                                    } else {
                                        javaClass = packageFragment.createCompilationUnit(className + ".java", javaSource.getContent(), true, (IProgressMonitor)new SubProgressMonitor(progressMonitor, ticks));
                                    }
                                    ++i;
                                }
                                IResource iResource2 = mainClass.getCorrespondingResource();
                                Object var17_11 = null;
                                progressMonitor.done();
                                return iResource2;
                            }
                        }
                        sourceGenerationData = null;
                        break block17;
                    }
                    catch (JavaModelException e) {
                        Status status = new Status(4, e.getMessage());
                        status.log();
                        IResource iResource3 = null;
                        Object var17_13 = null;
                        progressMonitor.done();
                        return iResource3;
                    }
                }
                catch (Throwable throwable) {
                    Object var17_14 = null;
                    progressMonitor.done();
                    throw throwable;
                }
            }
            progressMonitor.done();
            return iResource;
        }
        Object var17_12 = null;
        progressMonitor.done();
        return sourceGenerationData;
    }

    private String getCheckoutErrorMessage(List list) {
        String ErrorMessage = "";
        if (list == null || list.size() == 0) {
            return ErrorMessage;
        }
        String lineDelimiter = System.getProperty("line.separator", "\n");
        ErrorMessage = "The following files are currently read-only.  Check out the files and start the Wizard again " + lineDelimiter;
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            IResource SourceFile = (IResource)iter.next();
            ErrorMessage = ErrorMessage + SourceFile.getFullPath().toOSString() + lineDelimiter;
        }
        return ErrorMessage;
    }

    private boolean checkDuplicates(JavaSource[] sources, ISourceGenerationData sourceGenerationData, IPackageFragmentRoot packageFragmentRoot) throws JavaModelException {
        boolean Overwrite = sourceGenerationData.canOverwriteWithoutWarning();
        this.mDuplicateFiles.clear();
        IResource ProjectFile = packageFragmentRoot.getJavaProject().getResource();
        if (ProjectFile.isReadOnly()) {
            this.mDuplicateFiles.add(ProjectFile);
        }
        int i = 0;
        while (i < sources.length) {
            IResource file;
            ICompilationUnit javaClass;
            String className;
            JavaSource javaSource = sources[i];
            int classIndex = javaSource.getJavaName().lastIndexOf(46);
            String packageName = "";
            if (classIndex != -1) {
                className = javaSource.getJavaName().substring(classIndex + 1);
                packageName = javaSource.getJavaName().substring(0, classIndex);
            } else {
                className = javaSource.getJavaName();
            }
            int ticks = 2;
            IPackageFragment packageFragment = packageFragmentRoot.getPackageFragment(packageName);
            if (packageFragment.exists() && (javaClass = packageFragment.getCompilationUnit(className + ".java")).exists() && (file = javaClass.getCorrespondingResource()).isReadOnly()) {
                this.mDuplicateFiles.add(file);
            }
            ++i;
        }
        return this.mDuplicateFiles.size() > 0;
    }

    public List getReadOnlyFiles() {
        return this.mDuplicateFiles;
    }
}

