/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.jcb.core.service.generation.internal;

import com.sap.aii.proxy.generation.api.JavaSource;
import com.sap.ide.jcb.core.service.generation.GenerationException;
import com.sap.ide.jcb.core.service.generation.IGenerationData;
import com.sap.ide.jcb.core.service.generation.IJarGenerationData;
import com.sap.ide.jcb.core.service.generation.internal.GenerationManager;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;

public class JarGenerationManager
extends GenerationManager {
    private static final String FILE_NAME = "geninfo.xml";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IResource internalGenerate(JavaSource[] sources, IProgressMonitor progressMonitor) throws GenerationException {
        IGenerationData generationData = this.getGenerationData();
        if (!(generationData instanceof IJarGenerationData)) return null;
        IJarGenerationData jarGenerationData = (IJarGenerationData)generationData;
        try {
            try {
                progressMonitor.beginTask("Creating JAR File:", 1);
                this.addToJar(jarGenerationData.getJarFileName(), sources, (XMLMemento)super.getMemento());
            }
            catch (IOException e) {
                throw new GenerationException(e);
            }
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            progressMonitor.done();
            throw throwable;
        }
        progressMonitor.done();
        return null;
    }

    public IMemento getMemento() {
        IGenerationData generationData = this.getGenerationData();
        if (generationData == null) {
            return null;
        }
        if (generationData instanceof IJarGenerationData) {
            IJarGenerationData jarGenerationData = (IJarGenerationData)generationData;
            this.setMemento(this.getMemento(this.getGenInfoReader(jarGenerationData.getJarFileName())));
            return super.getMemento();
        }
        return null;
    }

    public Reader getGenInfoReader(String fileName) {
        try {
            JarFile jarFile = new JarFile(fileName, true);
            JarEntry jarEntry = jarFile.getJarEntry(FILE_NAME);
            if (jarEntry == null) {
                return null;
            }
            InputStream inputStream = jarFile.getInputStream(new ZipEntry(FILE_NAME));
            InputStreamReader fileInputStreamReader = new InputStreamReader(inputStream);
            char[] genInfoBytes = new char[(int)jarEntry.getSize()];
            int jinputStreamCharRead = fileInputStreamReader.read(genInfoBytes);
            StringReader inputStreamReader = new StringReader(new String(genInfoBytes));
            jarFile.close();
            return inputStreamReader;
        }
        catch (IOException e) {
            return null;
        }
    }

    protected boolean addToJar(String fileName, JavaSource[] javaSources, XMLMemento memento) throws IOException {
        if (fileName == null) {
            throw new IllegalArgumentException();
        }
        if (javaSources == null) {
            return true;
        }
        File fileForJar = new File(fileName);
        if (!fileForJar.exists()) {
            fileForJar.createNewFile();
        }
        FileOutputStream fileOutputStreamforJar = new FileOutputStream(fileForJar);
        JarOutputStream jarOutputStream = new JarOutputStream((OutputStream)fileOutputStreamforJar, new Manifest());
        int i = 0;
        while (i < javaSources.length) {
            JavaSource javaSource = javaSources[i];
            String jarEntryName = javaSource.getJavaName().replace('.', '\\') + ".java";
            jarOutputStream.putNextEntry(new ZipEntry(jarEntryName));
            jarOutputStream.write(javaSource.getBytes());
            ++i;
        }
        if (memento != null) {
            jarOutputStream.putNextEntry(new ZipEntry(FILE_NAME));
            OutputStreamWriter jarOutputStreamWriter = new OutputStreamWriter(jarOutputStream);
            memento.save((Writer)jarOutputStreamWriter);
            jarOutputStream.close();
            fileOutputStreamforJar.close();
        }
        return true;
    }
}

