/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.jcb.core.service.generation.internal;

import com.sap.aii.proxy.generation.api.JavaSource;
import com.sap.aii.proxy.generation.api.ProxyGenerator;
import com.sap.aii.proxy.generation.api.ProxyGeneratorFactory;
import com.sap.aii.upload.tool.RFC2WSDLTool;
import com.sap.aii.util.misc.api.AIIProperties;
import com.sap.aii.util.prop.api.PropertySource;
import com.sap.aii.util.prop.api.PropertySourceFactory;
import com.sap.aii.util.prop.impl.BasicPropertySource;
import com.sap.aii.util.xml.api.XML;
import com.sap.aii.util.xml.api.XMLServices;
import com.sap.aii.util.xml.xdom.XDocument;
import com.sap.ide.jcb.core.service.connection.IConnectionManager;
import com.sap.ide.jcb.core.service.generation.GenerationException;
import com.sap.ide.jcb.core.service.generation.IGenerationData;
import com.sap.ide.jcb.core.service.generation.IGenerationManager;
import com.sap.ide.jcb.core.service.workingset.IWorkingSet;
import com.sap.ide.jcb.core.service.workingset.IWorkingSetObject;
import com.sap.ide.jcb.core.util.LogHandler;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;

public abstract class GenerationManager
implements IGenerationManager {
    IGenerationData mGenerationData;
    IMemento mMemento;
    IConnectionManager mConnectionManager;
    IWorkingSet mWorkingSet;
    IResource mGeneratedResource = null;
    private static final String ROOT_MEMENTO_XML = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><GenerationInformation></GenerationInformation>";

    public IConnectionManager getConnectionManager() {
        return this.mConnectionManager;
    }

    public IWorkingSet getWorkingSet() {
        return this.mWorkingSet;
    }

    public void setConnectionManager(IConnectionManager connectionManager) {
        this.mConnectionManager = connectionManager;
    }

    public void setWorkingSet(IWorkingSet workingSet) {
        this.mWorkingSet = workingSet;
    }

    public IGenerationData getGenerationData() {
        return this.mGenerationData;
    }

    public void setGenerationData(IGenerationData generationData) {
        this.mGenerationData = generationData;
    }

    public IResource generate(IProgressMonitor progressMonitor) throws GenerationException {
        try {
            try {
                this.mGeneratedResource = null;
                if (progressMonitor == null) {
                    progressMonitor = new NullProgressMonitor();
                }
                progressMonitor.beginTask("Generation:", 5);
                JavaSource[] sources = this.generateClass((IProgressMonitor)new SubProgressMonitor(progressMonitor, 4));
                System.out.println("SAP Enterprise Connector : Starting Internal Generation");
                this.mGeneratedResource = this.internalGenerate(sources, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                System.out.println("SAP Enterprise Connector : Finished Internal Generation");
                progressMonitor.done();
                IResource iResource = this.mGeneratedResource;
                Object var5_5 = null;
                this.setMemento(null);
                System.out.println("SAP Enterprise Connector : Exiting Generator");
                return iResource;
            }
            catch (GenerationException e) {
                LogHandler.logException(e);
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.setMemento(null);
            System.out.println("SAP Enterprise Connector : Exiting Generator");
            throw throwable;
        }
    }

    protected abstract IResource internalGenerate(JavaSource[] var1, IProgressMonitor var2) throws GenerationException;

    public IMemento getMemento() {
        return this.mMemento;
    }

    public void setMemento(IMemento memento) {
        this.mMemento = memento;
    }

    protected IMemento getMemento(Reader reader) {
        try {
            if (reader == null) {
                return this.createMemento();
            }
            return XMLMemento.createReadRoot((Reader)reader);
        }
        catch (WorkbenchException e) {
            LogHandler.logException(e);
            return null;
        }
    }

    public IMemento createMemento() {
        try {
            XMLMemento memento = XMLMemento.createReadRoot((Reader)new StringReader(ROOT_MEMENTO_XML));
            this.setMemento((IMemento)memento);
            return memento;
        }
        catch (WorkbenchException e) {
            LogHandler.logException(e);
            return null;
        }
    }

    protected JavaSource[] generateClass(IProgressMonitor progressMonitor) throws GenerationException {
        try {
            RFC2WSDLTool rfc2WsdlTool = new RFC2WSDLTool();
            progressMonitor.beginTask("Generating Proxies", 8);
            progressMonitor.worked(1);
            progressMonitor.subTask("Generating WSDL");
            IConnectionManager connectionManager = this.getConnectionManager();
            String[] rfcs = new String[this.getWorkingSet().getSize()];
            Object[] workingSetArray = this.getWorkingSet().toArray();
            int i = 0;
            while (i < workingSetArray.length) {
                rfcs[i] = ((IWorkingSetObject)workingSetArray[i]).getName();
                ++i;
            }
            System.out.println("SAP Enterprise Connector : Generating WSDL");
            XML wsdl = rfc2WsdlTool.getWSDLforRFCs(connectionManager.getJCOClient(), rfcs, this.getGenerationData().getClassName());
            progressMonitor.worked(4);
            System.out.println("SAP Enterprise Connector : Finished WSDL Generation");
            ProxyGenerator proxyGenerator = ProxyGeneratorFactory.getRfcGenerator((String)this.getGenerationData().getPackageName(), (boolean)this.getGenerationData().isJavaBean());
            XDocument xdoc = XMLServices.getXDOM((XML)wsdl);
            progressMonitor.worked(1);
            progressMonitor.subTask("Generating Proxy Classes");
            proxyGenerator.generateProxy(xdoc);
            System.out.println("SAP Enterprise Connector : Finished proxy generation");
            JavaSource[] sources = proxyGenerator.getSources();
            progressMonitor.done();
            return sources;
        }
        catch (Throwable e) {
            LogHandler.logException(e);
            throw new GenerationException(e);
        }
    }

    public IRunnableWithProgress getRunnable() {
        return new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    GenerationManager.this.generate(monitor);
                }
                catch (GenerationException e) {
                    LogHandler.logException(e);
                    throw new InvocationTargetException(e);
                }
            }
        };
    }

    public IResource getGeneratedResource() {
        return this.mGeneratedResource;
    }

    static {
        if (System.getProperty("log.initialConfiguration") == null) {
            System.setProperty("log.initialConfiguration", "NONE");
        }
        Properties prop = new Properties();
        PropertySourceFactory.setPropertySource((PropertySource)new BasicPropertySource(prop, ""));
        AIIProperties aip = AIIProperties.getInstance();
        aip.setProperty("com.sap.aii.util.xml.parserFactory", "com.sap.engine.lib.jaxp.SAXParserFactoryImpl");
        aip.setProperty("com.sap.aii.util.xml.transformerFactory", "com.sap.engine.lib.jaxp.TransformerFactoryImpl");
    }
}

