/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.jcb.core.service.connection.internal;

import com.sap.ide.jcb.core.service.connection.ConnectionEvent;
import com.sap.ide.jcb.core.service.connection.ConnectionFailedException;
import com.sap.ide.jcb.core.service.connection.ConnectionListener;
import com.sap.ide.jcb.core.service.connection.IConnectionManager;
import com.sap.ide.jcb.core.util.StopWatch;
import com.sap.mw.jco.JCO;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;

public class LiteConnectionManager
implements IConnectionManager {
    private JCO.Client mJCOClient = null;
    private boolean mConnected = false;
    private ArrayList mConnectionListeners = new ArrayList();
    private StopWatch mStopWatch = new StopWatch();
    private String mOldConnectionType = "";
    private Properties mConnectionProperties = new Properties();

    public String getConnectionType() {
        if (!this.isConnected()) {
            return null;
        }
        if (this.mOldConnectionType.equalsIgnoreCase("LoadBalancingServer")) {
            return "LoadBalancingServer";
        }
        if (this.mOldConnectionType.equalsIgnoreCase("SingleServer")) {
            return "SingleServer";
        }
        return null;
    }

    public void connectToLoadBalancingServer(String client, String logonName, String password, String language, String messageServer, String systemName, String group) throws ConnectionFailedException {
        Properties connectionProperties;
        if (this.mConnected && this.mOldConnectionType.equalsIgnoreCase("LoadBalancingServer") && client.equalsIgnoreCase((connectionProperties = this.mJCOClient.getProperties()).getProperty("jco.client.client")) && logonName.equalsIgnoreCase(connectionProperties.getProperty("jco.client.user")) && password.equalsIgnoreCase(connectionProperties.getProperty("jco.client.passwd")) && language.equalsIgnoreCase(connectionProperties.getProperty("jco.client.lang")) && messageServer.equalsIgnoreCase(connectionProperties.getProperty("jco.client.mshost")) && systemName.equalsIgnoreCase(connectionProperties.getProperty("jco.client.r3name")) && group.equalsIgnoreCase(connectionProperties.getProperty("jco.client.group"))) {
            return;
        }
        this.disconnect();
        this.mStopWatch.start("Load Balancing Connection");
        this.mConnectionProperties = new Properties();
        this.addLogonProperties(client, logonName, password, language, this.mConnectionProperties);
        ((Hashtable)this.mConnectionProperties).put("jco.client.mshost", messageServer);
        ((Hashtable)this.mConnectionProperties).put("jco.client.r3name", systemName);
        ((Hashtable)this.mConnectionProperties).put("jco.client.group", group);
        this.mOldConnectionType = "LoadBalancingServer";
        this.connect();
        this.mStopWatch.stopAndWrite();
    }

    private void addLogonProperties(String client, String logonName, String password, String language, Properties connectionProperties) {
        ((Hashtable)connectionProperties).put("jco.client.client", client);
        ((Hashtable)connectionProperties).put("jco.client.user", logonName);
        if (password != null) {
            ((Hashtable)connectionProperties).put("jco.client.passwd", password);
        }
        ((Hashtable)connectionProperties).put("jco.client.lang", language);
    }

    public void connectToSingleServer(String client, String logonName, String password, String language, String hostName, String systemNumber) throws ConnectionFailedException {
        Properties connectionProperties;
        if (this.mConnected && this.mOldConnectionType.equalsIgnoreCase("SingleServer") && client.equalsIgnoreCase((connectionProperties = this.mJCOClient.getProperties()).getProperty("jco.client.client")) && logonName.equalsIgnoreCase(connectionProperties.getProperty("jco.client.user")) && password.equalsIgnoreCase(connectionProperties.getProperty("jco.client.passwd")) && language.equalsIgnoreCase(connectionProperties.getProperty("jco.client.lang")) && hostName.equalsIgnoreCase(connectionProperties.getProperty("jco.client.ashost")) && systemNumber.equalsIgnoreCase(connectionProperties.getProperty("jco.client.sysnr"))) {
            return;
        }
        this.disconnect();
        this.mStopWatch.start("Single Server Connection");
        this.mConnectionProperties = new Properties();
        this.addLogonProperties(client, logonName, password, language, this.mConnectionProperties);
        ((Hashtable)this.mConnectionProperties).put("jco.client.ashost", hostName);
        ((Hashtable)this.mConnectionProperties).put("jco.client.sysnr", systemNumber);
        this.mOldConnectionType = "SingleServer";
        this.connect();
        this.mStopWatch.stopAndWrite();
    }

    private void connect() throws ConnectionFailedException {
        try {
            this.mJCOClient = JCO.createClient((Properties)this.mConnectionProperties);
            this.mJCOClient.connect();
        }
        catch (JCO.Exception e) {
            throw new ConnectionFailedException(e);
        }
        this.mConnected = true;
        this.fireConnectedEvent();
    }

    public void connectUsingSingleSignOn() throws ConnectionFailedException {
        throw new UnsupportedOperationException();
    }

    public void connectUsingX509() throws ConnectionFailedException {
        throw new UnsupportedOperationException();
    }

    public void connectToLoadBalancingSncServer(String client, String logonName, String language, String messageServer, String systemName, String group, String partner, String securityLevel) throws ConnectionFailedException {
        Properties connectionProperties;
        if (this.mConnected && this.mOldConnectionType.equalsIgnoreCase("LoadBalancingServerSnc") && client.equalsIgnoreCase((connectionProperties = this.mJCOClient.getProperties()).getProperty("jco.client.client")) && logonName.equalsIgnoreCase(connectionProperties.getProperty("jco.client.user")) && language.equalsIgnoreCase(connectionProperties.getProperty("jco.client.lang")) && messageServer.equalsIgnoreCase(connectionProperties.getProperty("jco.client.mshost")) && systemName.equalsIgnoreCase(connectionProperties.getProperty("jco.client.r3name")) && group.equalsIgnoreCase(connectionProperties.getProperty("jco.client.group")) && partner.equalsIgnoreCase(connectionProperties.getProperty("jco.client.snc_partnername")) && securityLevel.equalsIgnoreCase(connectionProperties.getProperty("jco.client.snc_qop"))) {
            return;
        }
        this.disconnect();
        this.mStopWatch.start("Load Balancing SNC Connection");
        this.mConnectionProperties = new Properties();
        this.addLogonProperties(client, logonName, null, language, this.mConnectionProperties);
        ((Hashtable)this.mConnectionProperties).put("jco.client.mshost", messageServer);
        ((Hashtable)this.mConnectionProperties).put("jco.client.r3name", systemName);
        ((Hashtable)this.mConnectionProperties).put("jco.client.group", group);
        ((Hashtable)this.mConnectionProperties).put("jco.client.snc_partnername", partner);
        ((Hashtable)this.mConnectionProperties).put("jco.client.snc_qop", securityLevel);
        ((Hashtable)this.mConnectionProperties).put("jco.client.snc_mode", "1");
        this.mOldConnectionType = "LoadBalancingServerSnc";
        this.connect();
        this.mStopWatch.stopAndWrite();
    }

    public void disconnect() {
        if (this.mJCOClient != null) {
            this.fireDisconnectedEvent();
            this.mJCOClient.disconnect();
            this.mOldConnectionType = "";
            this.mJCOClient = null;
            this.mConnected = false;
        }
    }

    public void reconnect() throws ConnectionFailedException {
        throw new UnsupportedOperationException();
    }

    public boolean isConnected() {
        return this.mConnected;
    }

    public void addConnectionListener(ConnectionListener connectionListener) {
        this.mConnectionListeners.add(connectionListener);
    }

    public void removeConnectionListener(ConnectionListener connectionListener) {
        ((AbstractCollection)this.mConnectionListeners).remove(connectionListener);
    }

    protected void fireConnectedEvent() {
        ConnectionEvent theEvent = new ConnectionEvent(this, this.mJCOClient, null);
        Iterator iter = ((AbstractList)this.mConnectionListeners).iterator();
        while (iter.hasNext()) {
            ConnectionListener listener = (ConnectionListener)iter.next();
            if (listener == null) continue;
            listener.connected(theEvent);
        }
    }

    protected void fireDisconnectedEvent() {
        ConnectionEvent theEvent = new ConnectionEvent(this, this.mJCOClient, null);
        Iterator iter = ((AbstractList)this.mConnectionListeners).iterator();
        while (iter.hasNext()) {
            ConnectionListener listener = (ConnectionListener)iter.next();
            if (listener == null) continue;
            listener.disconnected(theEvent);
        }
    }

    public JCO.Client getJCOClient() {
        return this.mJCOClient;
    }
}

