/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.jcb.core.panels.internal.workingset;

import com.sap.ide.jcb.core.TextPool;
import com.sap.ide.jcb.core.panels.internal.search.RFCFlatListSorter;
import com.sap.ide.jcb.core.panels.internal.workingset.WorkingSetContentProvider;
import com.sap.ide.jcb.core.panels.internal.workingset.WorkingSetLabelProvider;
import com.sap.ide.jcb.core.service.workingset.IWorkingSet;
import com.sap.ide.jcb.core.service.workingset.IWorkingSetObject;
import com.sap.ide.jcb.core.service.workingset.RFCInHasToBeThereWorkingSetRemoved;
import com.sap.ide.jcb.core.service.workingset.RFCModuleAddedEvent;
import com.sap.ide.jcb.core.service.workingset.RFCModuleAddedListener;
import com.sap.ide.jcb.core.service.workingset.RFCModuleRemovedEvent;
import com.sap.ide.jcb.core.service.workingset.RFCModuleRemovedListener;
import com.tssap.util.ui.pane.IGridLayoutPane;
import java.util.Iterator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;

public class WorkingSetPane {
    private IGridLayoutPane mHostPane = null;
    private IGridLayoutPane mPane = null;
    private TableViewer mWorkingSetTable = null;
    private Table mTable = null;
    private IWorkingSet mWorkingSet = null;
    private static final TextPool mTPool = TextPool.getInstance();
    private RFCModuleAddedListener mRFCModuleAddedListener = null;
    private RFCModuleRemovedListener mRFCModuleRemovedListener = null;
    private boolean mCalledFromHere = false;
    private String[] columnHeaders = new String[]{"", mTPool.getText(2851), mTPool.getText(2853)};
    private ColumnLayoutData[] columnLayouts = new ColumnLayoutData[]{new ColumnPixelData(19, false), new ColumnWeightData(40), new ColumnWeightData(50)};

    public WorkingSetPane(IGridLayoutPane thePane) {
        this.mHostPane = thePane;
        this.mRFCModuleAddedListener = new RFCModuleAddedListener(){

            public void rfcModuleAdded(RFCModuleAddedEvent rfcModuleAddedEvent) {
                if (!WorkingSetPane.this.mCalledFromHere) {
                    WorkingSetPane.this.mWorkingSetTable.add((Object)rfcModuleAddedEvent.getWorkingSetObject());
                }
            }
        };
        this.mRFCModuleRemovedListener = new RFCModuleRemovedListener(){

            public void rfcModuleRemoved(RFCModuleRemovedEvent rfcModuleRemovedEvent) {
                if (!WorkingSetPane.this.mCalledFromHere) {
                    WorkingSetPane.this.mWorkingSetTable.remove((Object)rfcModuleRemovedEvent.getWorkingSetObject());
                }
            }

            public void removedAll() {
                WorkingSetPane.this.mWorkingSetTable.refresh();
            }
        };
    }

    public void createLayout() {
        this.mPane = this.mHostPane.addGridLayoutPane("Working Set", 1, this.mHostPane.createGridLayoutData(4, 4, true, true, 1, 1));
        this.mWorkingSetTable = this.mPane.addTableViewer(true, this.mPane.createGridLayoutData(4, 4, true, true, 1, 1));
        this.mTable = this.mWorkingSetTable.getTable();
        this.createColumns();
        this.mTable.setToolTipText(mTPool.getText(2900));
        this.mTable.setLinesVisible(true);
        this.mWorkingSetTable.setLabelProvider((IBaseLabelProvider)new WorkingSetLabelProvider());
        this.mWorkingSetTable.setContentProvider((IContentProvider)new WorkingSetContentProvider());
        this.mWorkingSetTable.setCellEditors(null);
        this.mWorkingSetTable.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\u007f') {
                    IStructuredSelection theSelection = (IStructuredSelection)WorkingSetPane.this.mWorkingSetTable.getSelection();
                    Iterator iter = theSelection.iterator();
                    while (iter.hasNext()) {
                        try {
                            WorkingSetPane.this.mWorkingSet.removeWorkingSetObject((IWorkingSetObject)iter.next());
                        }
                        catch (RFCInHasToBeThereWorkingSetRemoved exception) {
                            MessageDialog.openWarning((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Reimport", (String)(exception.getRFCName() + " is imported in the model.  Removing it may leave the model incompatible"));
                        }
                    }
                }
            }
        });
    }

    private void createColumns() {
        SelectionAdapter headerListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int column = WorkingSetPane.this.mTable.indexOf((TableColumn)e.widget);
                RFCFlatListSorter oldSorter = (RFCFlatListSorter)WorkingSetPane.this.mWorkingSetTable.getSorter();
                if (oldSorter != null && column == oldSorter.getColumnNumber()) {
                    oldSorter.setReversed(!oldSorter.isReversed());
                    WorkingSetPane.this.mWorkingSetTable.refresh();
                } else {
                    WorkingSetPane.this.mWorkingSetTable.setSorter((ViewerSorter)new RFCFlatListSorter(column));
                }
            }
        };
        TableLayout layout = new TableLayout();
        this.mTable.setLayout((Layout)layout);
        this.mTable.setHeaderVisible(true);
        int i = 0;
        while (i < this.columnHeaders.length) {
            layout.addColumnData(this.columnLayouts[i]);
            TableColumn tc = new TableColumn(this.mTable, 0, i);
            tc.setResizable(this.columnLayouts[i].resizable);
            tc.setText(this.columnHeaders[i]);
            tc.addSelectionListener((SelectionListener)headerListener);
            ++i;
        }
        this.mTable.setLinesVisible(false);
    }

    public void show() {
        this.mWorkingSetTable.setInput((Object)this.mWorkingSet);
    }

    public void setVisible(boolean visible) {
        this.mPane.getComposite().setVisible(visible);
    }

    public void refresh() {
    }

    public void setWorkingSet(IWorkingSet workingSet) {
        this.detachListeners();
        this.mWorkingSet = workingSet;
        this.attachListeners();
    }

    private void attachListeners() {
        if (this.mWorkingSet != null) {
            this.mWorkingSet.addRFCModuleAddedEventListener(this.mRFCModuleAddedListener);
            this.mWorkingSet.addRFCModuleRemovedEventListener(this.mRFCModuleRemovedListener);
        }
    }

    private void detachListeners() {
        if (this.mWorkingSet != null) {
            this.mWorkingSet.removeRFCModuleAddedEventListener(this.mRFCModuleAddedListener);
            this.mWorkingSet.removeRFCModuleRemovedEventListener(this.mRFCModuleRemovedListener);
        }
    }

    public Control getControl() {
        return this.mPane.getComposite();
    }

    public void dispose() {
        this.detachListeners();
    }
}

