/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.jcb.core.panels.internal.tree;

import com.sap.ide.jcb.core.TextPool;
import com.sap.ide.jcb.core.panels.CheckboxExplorerPane;
import com.sap.ide.jcb.core.panels.internal.search.RFCFlatListFilter;
import com.sap.ide.jcb.core.panels.internal.tree.OtherNode;
import com.sap.ide.jcb.core.panels.internal.tree.RFCAKHLabelProvider;
import com.sap.ide.jcb.core.panels.internal.tree.RFCAKHListContentProvider;
import com.sap.ide.jcb.core.panels.internal.tree.RFCAKHTreeContentProvider;
import com.sap.ide.jcb.core.panels.internal.tree.RFCAKHTreeSorter;
import com.sap.ide.jcb.core.service.rfcaccess.IRFCManager;
import com.sap.ide.jcb.core.service.rfcaccess.R3DataAccessException;
import com.sap.ide.jcb.core.service.workingset.IWorkingSet;
import com.sap.ide.jcb.core.service.workingset.IWorkingSetObject;
import com.sap.ide.jcb.core.service.workingset.RFCInHasToBeThereWorkingSetRemoved;
import com.sap.ide.jcb.core.service.workingset.RFCModuleAddedEvent;
import com.sap.ide.jcb.core.service.workingset.RFCModuleAddedListener;
import com.sap.ide.jcb.core.service.workingset.RFCModuleRemovedEvent;
import com.sap.ide.jcb.core.service.workingset.RFCModuleRemovedListener;
import com.sap.ide.jcb.core.util.LogHandler;
import com.sap.mdi.AKHNode;
import com.sap.mdi.ObjectFactory;
import com.sap.mdi.Rfm;
import com.tssap.util.ui.pane.IGridLayoutPane;
import java.util.Iterator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class RFCAKHTreePanel {
    private IGridLayoutPane mHostPane = null;
    private IGridLayoutPane mPane = null;
    private ObjectFactory mObjectFactory = null;
    private IWorkingSet mWorkingSet = null;
    private IRFCManager mRFCManager = null;
    private CheckboxExplorerPane mRFCTreeList = null;
    private static final TextPool mTPool = TextPool.getInstance();
    private boolean mFirstTime = true;
    private RFCModuleAddedListener mRFCModuleAddedListener = null;
    private RFCModuleRemovedListener mRFCModuleRemovedListener = null;
    private boolean mCalledFromHere = false;
    private boolean mShowAllInterfaces = true;

    public RFCAKHTreePanel(IGridLayoutPane thePane) {
        this.mHostPane = thePane;
    }

    public void createLayout() {
        this.mPane = this.mHostPane.addGridLayoutPane("", 1, this.mHostPane.createGridLayoutData(4, 4, true, true, 1, 1));
        this.mRFCModuleAddedListener = new RFCModuleAddedListener(){

            public void rfcModuleAdded(RFCModuleAddedEvent rfcModuleAddedEvent) {
                if (!RFCAKHTreePanel.this.mCalledFromHere && RFCAKHTreePanel.this.mRFCTreeList != null) {
                    RFCAKHTreePanel.this.setChecked(rfcModuleAddedEvent.getWorkingSetObject(), true);
                }
            }
        };
        this.mRFCModuleRemovedListener = new RFCModuleRemovedListener(){

            public void rfcModuleRemoved(RFCModuleRemovedEvent rfcModuleRemovedEvent) {
                if (!RFCAKHTreePanel.this.mCalledFromHere && RFCAKHTreePanel.this.mRFCTreeList != null) {
                    RFCAKHTreePanel.this.setChecked(rfcModuleRemovedEvent.getWorkingSetObject(), false);
                }
            }

            public void removedAll() {
                if (RFCAKHTreePanel.this.mRFCTreeList != null) {
                    RFCAKHTreePanel.this.mRFCTreeList.setAllSelections(false);
                }
            }
        };
    }

    public void show() {
        this.mRFCTreeList = new CheckboxExplorerPane(this.mPane, (Object)this.mRFCManager, (ITreeContentProvider)new RFCAKHTreeContentProvider(this.mRFCManager), (ILabelProvider)new RFCAKHLabelProvider(), (IStructuredContentProvider)new RFCAKHListContentProvider(this.mRFCManager), (ILabelProvider)new RFCAKHLabelProvider(), 0, -1, -1);
        this.mRFCTreeList.setTreeSorter(new RFCAKHTreeSorter());
        this.displayAKHTree();
        this.mRFCTreeList.aboutToOpen();
        this.mRFCTreeList.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (RFCAKHTreePanel.this.mWorkingSet == null) {
                    return;
                }
                if (event.getCheckable().equals(RFCAKHTreePanel.this.mRFCTreeList.getListViewer())) {
                    RFCAKHTreePanel.this.mCalledFromHere = true;
                    if (event.getChecked()) {
                        RFCAKHTreePanel.this.mWorkingSet.addRFCModule((Rfm)event.getElement());
                    } else {
                        try {
                            RFCAKHTreePanel.this.mWorkingSet.removeRFCModule((Rfm)event.getElement());
                        }
                        catch (RFCInHasToBeThereWorkingSetRemoved exception) {
                            MessageDialog.openWarning((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Reimport", (String)(exception.getRFCName() + " is imported in the model.  Removing it may leave the model incompatible"));
                            LogHandler.logException(exception);
                        }
                    }
                    RFCAKHTreePanel.this.mCalledFromHere = false;
                } else if (event.getCheckable().equals(RFCAKHTreePanel.this.mRFCTreeList.getTreeViewer())) {
                    RFCAKHTreePanel.this.mCalledFromHere = true;
                    RFCAKHTreePanel.this.modifyWorkingSet(event.getElement(), event.getChecked());
                    RFCAKHTreePanel.this.mCalledFromHere = false;
                }
            }
        });
        this.mPane.getComposite().layout();
        this.mRFCTreeList.getTreeViewer().expandToLevel(2);
        this.updateFilter();
    }

    private void modifyWorkingSet(Object object, boolean b) {
        try {
            Object[] theRFCModules;
            if (object instanceof AKHNode) {
                AKHNode akhNode = (AKHNode)object;
                theRFCModules = this.mRFCManager.getRFCsforAKH(akhNode);
                Iterator iter = akhNode.getChildren().getIterator();
                while (iter.hasNext()) {
                    this.modifyWorkingSet(iter.next(), b);
                }
                if (akhNode.getParent() == null) {
                    this.modifyWorkingSet(new OtherNode(), b);
                }
            } else if (object instanceof OtherNode) {
                theRFCModules = this.mRFCManager.getUnattachedRFCs();
            } else {
                return;
            }
            int i = 0;
            while (i < theRFCModules.length) {
                if (b) {
                    this.mWorkingSet.addRFCModule((Rfm)theRFCModules[i]);
                } else {
                    try {
                        this.mWorkingSet.removeRFCModule((Rfm)theRFCModules[i]);
                    }
                    catch (RFCInHasToBeThereWorkingSetRemoved exception) {
                        MessageDialog.openWarning((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Reimport", (String)(exception.getRFCName() + " is imported in the model.  Removing it may leave the model incompatible"));
                    }
                }
                ++i;
            }
        }
        catch (R3DataAccessException e) {
            LogHandler.logException(e);
        }
    }

    public Control getControl() {
        return this.mPane.getComposite();
    }

    private void displayAKHTree() {
        if (this.mRFCManager == null) {
            return;
        }
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            public void run() {
                try {
                    RFCAKHTreePanel.this.mRFCTreeList.setRoot(RFCAKHTreePanel.this.mRFCManager);
                    RFCAKHTreePanel.this.setInitialCheckedElements();
                }
                catch (Exception e) {
                    LogHandler.logException(e);
                }
            }
        });
    }

    private void setInitialCheckedElements() {
        if (this.mWorkingSet != null) {
            Iterator iter = this.mWorkingSet.getIterator();
            while (iter.hasNext()) {
                this.setInitialChecked((IWorkingSetObject)iter.next());
            }
        }
    }

    public void setVisible(boolean visible) {
        this.mPane.getComposite().setVisible(visible);
    }

    public void refresh() {
        this.displayAKHTree();
    }

    public IRFCManager getRFCManager() {
        return this.mRFCManager;
    }

    public void setRFCManager(IRFCManager rFCManager) {
        this.mRFCManager = rFCManager;
    }

    public IWorkingSet getWorkingSet() {
        return this.mWorkingSet;
    }

    public void setWorkingSet(IWorkingSet workingSet) {
        if (this.mWorkingSet != null) {
            this.mWorkingSet.removeRFCModuleAddedEventListener(this.mRFCModuleAddedListener);
            this.mWorkingSet.removeRFCModuleRemovedEventListener(this.mRFCModuleRemovedListener);
        }
        this.mWorkingSet = workingSet;
        if (this.mWorkingSet != null) {
            this.mWorkingSet.addRFCModuleAddedEventListener(this.mRFCModuleAddedListener);
            this.mWorkingSet.addRFCModuleRemovedEventListener(this.mRFCModuleRemovedListener);
        }
    }

    public void showReleasedInterfaces() {
        if (this.mRFCManager == null) {
            return;
        }
        this.mShowAllInterfaces = false;
        this.updateFilter();
    }

    public void showAllInterfaces() {
        if (this.mRFCManager == null) {
            return;
        }
        this.mShowAllInterfaces = true;
        this.updateFilter();
    }

    private void updateFilter() {
        if (this.mRFCTreeList == null) {
            return;
        }
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            public void run() {
                if (RFCAKHTreePanel.this.mShowAllInterfaces) {
                    ViewerFilter[] theFilters = RFCAKHTreePanel.this.mRFCTreeList.getListViewer().getFilters();
                    if (theFilters == null) {
                        return;
                    }
                    int i = 0;
                    while (i < theFilters.length) {
                        ViewerFilter viewerFilter = theFilters[i];
                        RFCAKHTreePanel.this.mRFCTreeList.getListViewer().removeFilter(viewerFilter);
                        ++i;
                    }
                } else {
                    ViewerFilter[] theFilters = RFCAKHTreePanel.this.mRFCTreeList.getListViewer().getFilters();
                    if (theFilters == null || theFilters.length == 0) {
                        RFCAKHTreePanel.this.mRFCTreeList.getListViewer().addFilter((ViewerFilter)new RFCFlatListFilter());
                    }
                }
            }
        });
    }

    private void setInitialChecked(IWorkingSetObject workingSetObject) {
        if (workingSetObject.getRFCModule() != null) {
            this.mRFCTreeList.setListItemChecked(workingSetObject.getRFCModule(), true);
        } else {
            Rfm rfcModule = this.mRFCManager.getRfcModule(workingSetObject.getName());
            if (rfcModule != null) {
                workingSetObject.setRFCModule(rfcModule);
                this.mRFCTreeList.setListItemChecked(workingSetObject.getRFCModule(), true);
            }
        }
    }

    private void setChecked(IWorkingSetObject workingSetObject, boolean check) {
        if (workingSetObject.getRFCModule() != null) {
            this.mRFCTreeList.setListItemChecked(workingSetObject.getRFCModule(), check);
        } else {
            Rfm rfcModule = this.mRFCManager.getRfcModule(workingSetObject.getName());
            if (rfcModule != null) {
                workingSetObject.setRFCModule(rfcModule);
                this.mRFCTreeList.setListItemChecked(workingSetObject.getRFCModule(), check);
            }
        }
    }

    public void dispose() {
        if (this.mWorkingSet != null) {
            this.mWorkingSet.removeRFCModuleAddedEventListener(this.mRFCModuleAddedListener);
            this.mWorkingSet.removeRFCModuleRemovedEventListener(this.mRFCModuleRemovedListener);
        }
    }
}

