/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.jcb.core.panels.internal.tree;

import com.sap.ide.jcb.core.panels.internal.tree.OtherNode;
import com.sap.ide.jcb.core.service.rfcaccess.IRFCManager;
import com.sap.ide.jcb.core.service.rfcaccess.R3DataAccessException;
import com.sap.ide.jcb.core.util.LogHandler;
import com.sap.mdi.AKHNode;
import com.sap.mdi.MetaDataAccessException;
import com.sap.mdi.Rfm;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class RFCAKHTreeContentProvider
implements ITreeContentProvider {
    IRFCManager mRFCManager = null;
    OtherNode mOthersNode = new OtherNode();

    public RFCAKHTreeContentProvider(IRFCManager rfcManager) {
        this.mRFCManager = rfcManager;
    }

    public Object[] getChildren(Object parentElement) {
        Object[] TheChildrenNodes = new Object[]{};
        try {
            if (parentElement instanceof AKHNode) {
                AKHNode TheNode = (AKHNode)parentElement;
                AKHNode[] theAKHNodes = this.mRFCManager.getAKHChilden(TheNode);
                boolean isRootNode = TheNode.getParent() == null;
                int size = theAKHNodes.length;
                if (isRootNode) {
                    ++size;
                }
                TheChildrenNodes = new Object[size];
                System.arraycopy(theAKHNodes, 0, TheChildrenNodes, 0, theAKHNodes.length);
                if (isRootNode) {
                    TheChildrenNodes[size - 1] = this.mOthersNode;
                }
                return TheChildrenNodes;
            }
        }
        catch (R3DataAccessException e) {
            LogHandler.logException(e);
            MessageDialog.openError(null, (String)e.toString(), (String)e.getMessage());
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        try {
            if (element instanceof AKHNode) {
                AKHNode TheNode = (AKHNode)element;
                return TheNode.getParent();
            }
            if (element instanceof Rfm) {
                Rfm TheRFCModule = (Rfm)element;
                if (TheRFCModule.getComponentId().length() == 0) {
                    return this.mOthersNode;
                }
                return this.mRFCManager.getAKHNode(TheRFCModule.getComponentId());
            }
            if (element instanceof OtherNode) {
                return this.mRFCManager.getAKHRoot();
            }
        }
        catch (MetaDataAccessException e) {
            LogHandler.logException(e);
            return null;
        }
        catch (R3DataAccessException e) {
            e.printStackTrace();
            return null;
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof AKHNode) {
            AKHNode TheNode = (AKHNode)element;
            return TheNode.getChildrenCount() > 0;
        }
        return false;
    }

    public Object[] getElements(Object inputElement) {
        try {
            if (inputElement instanceof IRFCManager) {
                AKHNode theRoot = ((IRFCManager)inputElement).getAKHRoot();
                Object[] TheRootNodes = new Object[]{theRoot};
                return TheRootNodes;
            }
            if (inputElement instanceof AKHNode) {
                return this.getChildren(inputElement);
            }
        }
        catch (R3DataAccessException e) {
            MessageDialog.openError(null, (String)e.toString(), (String)e.getMessage());
            LogHandler.logException(e);
            return null;
        }
        return new Object[0];
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

