/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.jcb.core.panels.internal.tree;

import com.sap.ide.jcb.core.SAPJavaConnectivityBuilderCorePlugin;
import com.sap.ide.jcb.core.panels.internal.tree.OtherNode;
import com.sap.ide.jcb.core.util.LogHandler;
import com.sap.mdi.AKHNode;
import com.sap.mdi.MetaDataAccessException;
import com.sap.mdi.Rfm;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class RFCAKHLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    Image mComponentImage = null;
    Image mRFCModuleImage = null;
    private Image mReleasedImage = null;
    private Image mUnreleasedImage = null;

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        String columnText = "";
        if (element instanceof AKHNode) {
            AKHNode TheNode = (AKHNode)element;
            switch (columnIndex) {
                case 0: {
                    columnText = TheNode.isLeaf() ? TheNode.getFullName() : TheNode.getDescription();
                    break;
                }
                case 1: {
                    columnText = TheNode.isLeaf() ? TheNode.getDescription() : "";
                }
            }
        } else if (element instanceof Rfm) {
            Rfm theRFCModule = (Rfm)element;
            switch (columnIndex) {
                case 0: {
                    columnText = theRFCModule.getName();
                    break;
                }
                case 1: {
                    try {
                        columnText = theRFCModule.getDescription();
                        break;
                    }
                    catch (MetaDataAccessException e) {
                        LogHandler.logException(e);
                    }
                }
            }
        }
        return columnText;
    }

    public Image getImage(Object element) {
        if (element instanceof AKHNode) {
            return this.getComponentImage();
        }
        if (element instanceof Rfm) {
            return this.getRfmImage((Rfm)element);
        }
        if (element instanceof OtherNode) {
            return this.getComponentImage();
        }
        return super.getImage(element);
    }

    public String getText(Object element) {
        String columnText = "Blank";
        if (element instanceof AKHNode) {
            AKHNode TheNode = (AKHNode)element;
            return TheNode.getDescription();
        }
        if (element instanceof Rfm) {
            Rfm TheNode = (Rfm)element;
            return TheNode.getName();
        }
        if (element instanceof OtherNode) {
            return "Others";
        }
        return super.getText(element);
    }

    public void dispose() {
    }

    public Image getComponentImage() {
        if (this.mComponentImage == null) {
            this.mComponentImage = SAPJavaConnectivityBuilderCorePlugin.createImage("resources\\icons\\akh.gif");
        }
        return this.mComponentImage;
    }

    private Image getRfmImage(Rfm RFCModule) {
        try {
            if (RFCModule.getReleased() == 2) {
                return this.getReleasedImage();
            }
            return this.getUnreleasedImage();
        }
        catch (MetaDataAccessException e) {
            LogHandler.logException(e);
            return null;
        }
    }

    public Image getReleasedImage() {
        if (this.mReleasedImage == null) {
            this.mReleasedImage = SAPJavaConnectivityBuilderCorePlugin.createImage("resources\\icons\\released.gif");
        }
        return this.mReleasedImage;
    }

    public Image getUnreleasedImage() {
        if (this.mUnreleasedImage == null) {
            this.mUnreleasedImage = SAPJavaConnectivityBuilderCorePlugin.createImage("resources\\icons\\unreleased.gif");
        }
        return this.mUnreleasedImage;
    }
}

