/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.jcb.core.panels.internal.search;

import com.sap.ide.jcb.core.TextPool;
import com.sap.ide.jcb.core.panels.internal.search.RFCFlatListContentProvider;
import com.sap.ide.jcb.core.panels.internal.search.RFCFlatListFilter;
import com.sap.ide.jcb.core.panels.internal.search.RFCFlatListLabelProvider;
import com.sap.ide.jcb.core.panels.internal.search.RFCFlatListSorter;
import com.sap.ide.jcb.core.service.rfcaccess.IRFCManager;
import com.sap.ide.jcb.core.service.rfcaccess.R3DataAccessException;
import com.sap.ide.jcb.core.service.workingset.IWorkingSet;
import com.sap.ide.jcb.core.service.workingset.IWorkingSetObject;
import com.sap.ide.jcb.core.service.workingset.RFCInHasToBeThereWorkingSetRemoved;
import com.sap.ide.jcb.core.service.workingset.RFCModuleAddedEvent;
import com.sap.ide.jcb.core.service.workingset.RFCModuleAddedListener;
import com.sap.ide.jcb.core.service.workingset.RFCModuleRemovedEvent;
import com.sap.ide.jcb.core.service.workingset.RFCModuleRemovedListener;
import com.sap.ide.jcb.core.util.LogHandler;
import com.sap.mdi.Rfm;
import com.tssap.util.ui.pane.IGridLayoutPane;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class RFCFlatListPanel {
    private IGridLayoutPane mHostPane = null;
    private IGridLayoutPane mPane = null;
    private IWorkingSet mWorkingSet = null;
    private IRFCManager mRFCManager = null;
    private Text mFunctionName = null;
    private Text mFunctionGroup = null;
    private Button mSearch = null;
    private boolean mCalledFromHere = false;
    private boolean mShowAllInterfaces = true;
    private CheckboxTableViewer mRFCTable = null;
    private Table mTable = null;
    private String[] columnHeaders = new String[]{"", mTPool.getText(2851), mTPool.getText(2853), mTPool.getText(2852)};
    private ColumnLayoutData[] columnLayouts = new ColumnLayoutData[]{new ColumnPixelData(40, false), new ColumnWeightData(30), new ColumnWeightData(50), new ColumnWeightData(20)};
    private static final TextPool mTPool = TextPool.getInstance();
    private RFCModuleAddedListener mRFCModuleAddedListener = null;
    private RFCModuleRemovedListener mRFCModuleRemovedListener = null;
    private IWizardContainer mWizardContainer = null;

    public RFCFlatListPanel(IGridLayoutPane thePane) {
        this(thePane, null);
    }

    public RFCFlatListPanel(IGridLayoutPane thePane, IWizardContainer WizardContainer) {
        this.mHostPane = thePane;
        this.mWizardContainer = WizardContainer;
    }

    public void createLayout() {
        this.mPane = this.mHostPane.addGridLayoutPane("", 1, this.mHostPane.createGridLayoutData(4, 4, true, true, 1, 1));
        this.createSearchPane(this.mPane);
        this.createSearchResultPane(this.mPane);
        this.mRFCModuleAddedListener = new RFCModuleAddedListener(){

            public void rfcModuleAdded(RFCModuleAddedEvent rfcModuleAddedEvent) {
                if (!RFCFlatListPanel.this.mCalledFromHere) {
                    RFCFlatListPanel.this.setChecked(rfcModuleAddedEvent.getWorkingSetObject(), true);
                }
            }
        };
        this.mRFCModuleRemovedListener = new RFCModuleRemovedListener(){

            public void rfcModuleRemoved(RFCModuleRemovedEvent rfcModuleRemovedEvent) {
                if (!RFCFlatListPanel.this.mCalledFromHere) {
                    RFCFlatListPanel.this.setChecked(rfcModuleRemovedEvent.getWorkingSetObject(), false);
                }
            }

            public void removedAll() {
                RFCFlatListPanel.this.mRFCTable.setAllChecked(false);
            }
        };
    }

    private void setChecked(IWorkingSetObject workingSetObject, boolean check) {
        if (workingSetObject == null) {
            return;
        }
        if (workingSetObject.getRFCModule() != null) {
            this.mRFCTable.setChecked((Object)workingSetObject.getRFCModule(), check);
        } else {
            TableItem[] children = this.mRFCTable.getTable().getItems();
            int i = 0;
            while (i < children.length) {
                TableItem item = children[i];
                Rfm rfcModule = (Rfm)item.getData();
                if (rfcModule != null && rfcModule.getName().equalsIgnoreCase(workingSetObject.getName())) {
                    workingSetObject.setRFCModule(rfcModule);
                    item.setChecked(check);
                }
                ++i;
            }
        }
    }

    public void show() {
        this.setVisible(true);
        this.updateFilter();
    }

    public void setVisible(boolean visible) {
        this.mPane.getComposite().setVisible(visible);
    }

    private void createSearchPane(IGridLayoutPane thePane) {
        this.createSearchLayout(thePane);
        this.addEventHandlers();
    }

    private void createSearchLayout(IGridLayoutPane thePane) {
        IGridLayoutPane glp = thePane.addGridLayoutPane(7, true);
        glp.addTextLabel(mTPool.getText(2801), glp.createGridLayoutData(1, 2, true, false, 1, 1));
        this.mFunctionName = glp.addTextField("", false, glp.createGridLayoutData(4, 2, true, false, 2, 1));
        glp.addTextLabel(mTPool.getText(2802), glp.createGridLayoutData(1, 2, true, false, 1, 1));
        this.mFunctionGroup = glp.addTextField("", false, glp.createGridLayoutData(4, 2, true, false, 2, 1));
        this.mSearch = glp.addPushButton(mTPool.getText(2803));
    }

    private void addEventHandlers() {
        this.mFunctionName.addListener(-1, new Listener(){

            public void handleEvent(Event event) {
                RFCFlatListPanel.this.doSearch();
            }
        });
        this.mFunctionGroup.addListener(-1, new Listener(){

            public void handleEvent(Event event) {
                RFCFlatListPanel.this.doSearch();
            }
        });
        this.mSearch.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                RFCFlatListPanel.this.doSearch();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    private void doSearch() {
        if (this.mRFCManager == null) {
            return;
        }
        if (this.mWizardContainer != null) {
            IRunnableWithProgress op = this.getSearchRunnable();
            try {
                this.mWizardContainer.run(true, false, op);
            }
            catch (InterruptedException e) {
                LogHandler.logException(e);
            }
            catch (InvocationTargetException e) {
                LogHandler.logException(e);
            }
        } else {
            BusyIndicator.showWhile(null, (Runnable)new Runnable(){

                public void run() {
                    RFCFlatListPanel.this.internalDoSearch();
                }
            });
        }
    }

    private IRunnableWithProgress getSearchRunnable() {
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                monitor.beginTask("Searching for function modules", 3);
                monitor.worked(1);
                RFCFlatListPanel.this.getControl().getDisplay().syncExec(new Runnable(this){
                    private final /* synthetic */ 7 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        RFCFlatListPanel.access$400(7.access$500(this.this$1));
                    }
                });
                monitor.done();
            }

            static /* synthetic */ RFCFlatListPanel access$500(7 x0) {
                return x0.RFCFlatListPanel.this;
            }
        };
        return op;
    }

    private void internalDoSearch() {
        try {
            this.mRFCTable.setInput((Object)this.mRFCManager.getRFCModules(this.mFunctionName.getText(), this.mFunctionGroup.getText()));
            this.updateCheckedElements();
        }
        catch (R3DataAccessException e) {
            MessageDialog.openInformation(null, (String)"R3 access Failed", (String)e.getMessage());
            LogHandler.logException(e);
        }
    }

    private void updateCheckedElements() {
        if (this.mWorkingSet != null) {
            Iterator iter = this.mWorkingSet.getIterator();
            while (iter.hasNext()) {
                this.setChecked((IWorkingSetObject)iter.next(), true);
            }
        }
    }

    private void createSearchResultPane(IGridLayoutPane theHostPane) {
        IGridLayoutPane thePane = theHostPane.addGridLayoutPane(1, true, theHostPane.createGridLayoutData(4, 4, true, true, 7, 1));
        this.mRFCTable = thePane.addCheckboxTableViewer(true, thePane.createGridLayoutData(4, 4, true, true, 1, 1));
        this.mTable = this.mRFCTable.getTable();
        this.createSearchResultColumns();
        this.mRFCTable.setContentProvider((IContentProvider)new RFCFlatListContentProvider());
        this.mRFCTable.setLabelProvider((IBaseLabelProvider)new RFCFlatListLabelProvider());
        this.mRFCTable.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (RFCFlatListPanel.this.mWorkingSet == null) {
                    return;
                }
                RFCFlatListPanel.this.mCalledFromHere = true;
                if (event.getChecked()) {
                    RFCFlatListPanel.this.mWorkingSet.addRFCModule((Rfm)event.getElement());
                } else {
                    try {
                        RFCFlatListPanel.this.mWorkingSet.removeRFCModule((Rfm)event.getElement());
                    }
                    catch (RFCInHasToBeThereWorkingSetRemoved exception) {
                        MessageDialog.openWarning((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Reimport", (String)(exception.getRFCName() + " is imported in the model.  Removing it may leave the model incompatible"));
                        LogHandler.logException(exception);
                    }
                }
                RFCFlatListPanel.this.mCalledFromHere = false;
            }
        });
    }

    private void createSearchResultColumns() {
        SelectionAdapter headerListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int column = RFCFlatListPanel.this.mTable.indexOf((TableColumn)e.widget);
                RFCFlatListSorter oldSorter = (RFCFlatListSorter)RFCFlatListPanel.this.mRFCTable.getSorter();
                if (oldSorter != null && column == oldSorter.getColumnNumber()) {
                    oldSorter.setReversed(!oldSorter.isReversed());
                    RFCFlatListPanel.this.mRFCTable.refresh();
                } else {
                    RFCFlatListPanel.this.mRFCTable.setSorter((ViewerSorter)new RFCFlatListSorter(column));
                }
            }
        };
        TableLayout layout = new TableLayout();
        this.mTable.setLayout((Layout)layout);
        this.mTable.setHeaderVisible(true);
        int i = 0;
        while (i < this.columnHeaders.length) {
            layout.addColumnData(this.columnLayouts[i]);
            TableColumn tc = new TableColumn(this.mTable, 0, i);
            tc.setResizable(this.columnLayouts[i].resizable);
            tc.setText(this.columnHeaders[i]);
            tc.addSelectionListener((SelectionListener)headerListener);
            ++i;
        }
        this.mTable.setLinesVisible(false);
    }

    public void refresh() {
        this.doSearch();
    }

    public void showAllInterfaces() {
        if (this.mRFCManager == null) {
            return;
        }
        this.mShowAllInterfaces = true;
        this.updateFilter();
    }

    public void showReleasedInterfaces() {
        if (this.mRFCManager == null) {
            return;
        }
        this.mShowAllInterfaces = false;
        this.updateFilter();
    }

    private void updateFilter() {
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            public void run() {
                if (RFCFlatListPanel.this.mShowAllInterfaces) {
                    ViewerFilter[] theFilters = RFCFlatListPanel.this.mRFCTable.getFilters();
                    if (theFilters == null) {
                        return;
                    }
                    int i = 0;
                    while (i < theFilters.length) {
                        ViewerFilter viewerFilter = theFilters[i];
                        RFCFlatListPanel.this.mRFCTable.removeFilter(viewerFilter);
                        ++i;
                    }
                } else {
                    ViewerFilter[] theFilters = RFCFlatListPanel.this.mRFCTable.getFilters();
                    if (theFilters == null || theFilters.length == 0) {
                        RFCFlatListPanel.this.mRFCTable.addFilter((ViewerFilter)new RFCFlatListFilter());
                    }
                }
                RFCFlatListPanel.this.updateCheckedElements();
            }
        });
    }

    public Control getControl() {
        return this.mPane.getComposite();
    }

    public IRFCManager getRFCManager() {
        return this.mRFCManager;
    }

    public void setRFCManager(IRFCManager rFCManager) {
        this.mRFCManager = rFCManager;
    }

    public IWorkingSet getWorkingSet() {
        return this.mWorkingSet;
    }

    public void setWorkingSet(IWorkingSet workingSet) {
        if (this.mWorkingSet != null) {
            this.mWorkingSet.removeRFCModuleAddedEventListener(this.mRFCModuleAddedListener);
            this.mWorkingSet.removeRFCModuleRemovedEventListener(this.mRFCModuleRemovedListener);
        }
        this.mWorkingSet = workingSet;
        if (this.mWorkingSet != null) {
            this.mWorkingSet.addRFCModuleAddedEventListener(this.mRFCModuleAddedListener);
            this.mWorkingSet.addRFCModuleRemovedEventListener(this.mRFCModuleRemovedListener);
        }
    }

    public void dispose() {
        if (this.mWorkingSet != null) {
            this.mWorkingSet.removeRFCModuleAddedEventListener(this.mRFCModuleAddedListener);
            this.mWorkingSet.removeRFCModuleRemovedEventListener(this.mRFCModuleRemovedListener);
        }
    }
}

