/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.jcb.core.panels.internal.search;

import com.sap.ide.jcb.core.SAPJavaConnectivityBuilderCorePlugin;
import com.sap.ide.jcb.core.util.LogHandler;
import com.sap.mdi.MetaDataAccessException;
import com.sap.mdi.Rfm;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class RFCFlatListLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private Image mReleasedImage = null;
    private Image mUnreleasedImage = null;

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0 && element instanceof Rfm) {
            return this.getRfmImage((Rfm)element);
        }
        return super.getImage(element);
    }

    public String getColumnText(Object element, int columnIndex) {
        String columnText = "";
        if (element instanceof Rfm) {
            try {
                Rfm TheRFCModule = (Rfm)element;
                switch (columnIndex) {
                    case 1: {
                        columnText = TheRFCModule.getName();
                        break;
                    }
                    case 2: {
                        columnText = TheRFCModule.getDescription();
                        break;
                    }
                    case 3: {
                        columnText = TheRFCModule.getGroupName();
                        break;
                    }
                }
            }
            catch (MetaDataAccessException e) {
                LogHandler.logException(e);
            }
        }
        return columnText;
    }

    private Image getRfmImage(Rfm RFCModule) {
        try {
            if (RFCModule.getReleased() == 2) {
                return this.getReleasedImage();
            }
            return this.getUnreleasedImage();
        }
        catch (MetaDataAccessException e) {
            LogHandler.logException(e);
            return null;
        }
    }

    public Image getReleasedImage() {
        if (this.mReleasedImage == null) {
            this.mReleasedImage = SAPJavaConnectivityBuilderCorePlugin.createImage("resources\\icons\\released.gif");
        }
        return this.mReleasedImage;
    }

    public Image getUnreleasedImage() {
        if (this.mUnreleasedImage == null) {
            this.mUnreleasedImage = SAPJavaConnectivityBuilderCorePlugin.createImage("resources\\icons\\unreleased.gif");
        }
        return this.mUnreleasedImage;
    }
}

