/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.namealloc.api;

import java.io.Serializable;
import javax.naming.CompoundName;

public class AllocationState
implements Serializable {
    private final int UNRESERVED = 0;
    private final int PRERESERVED = 1;
    private final int FINRESERVED = 2;
    private String nameCategory = null;
    private String flatName = null;
    private String cimName = null;
    private CompoundName compoundName = null;
    private boolean flatSyntax = true;
    private String userId = null;
    private String caption = null;
    private String description = null;
    private boolean protectedGrowth = false;
    private String usageComment = null;
    private boolean ignoreCase = false;
    private String context = null;
    private String workspaceLocation = null;
    private String workspaceID = null;
    private String shortName = null;
    private int allocationState = 0;
    private String reservationKey = null;
    private String contextKey = null;
    private boolean contextIsOpen = false;

    public String getNameCategory() {
        return this.nameCategory;
    }

    public String getFlatName() {
        return this.flatName;
    }

    public String getCimName() {
        return this.cimName;
    }

    public boolean isOnNameServer() {
        return this.cimName != null;
    }

    public CompoundName getCompoundName() {
        return this.compoundName;
    }

    public boolean isFlatName() {
        return this.flatSyntax;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getCaption() {
        return this.caption;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isGrowingProtected() {
        return this.protectedGrowth;
    }

    public String getContext() {
        return this.context;
    }

    public boolean isReserved() {
        return this.allocationState != 0;
    }

    public boolean isReservedPreliminary() {
        return this.allocationState == 1;
    }

    public boolean isReservedFinally() {
        return this.allocationState == 2;
    }

    public boolean isReservedForMe(String aReservationKey, String aContextKey) {
        if (aReservationKey != null) {
            return aReservationKey.equals(this.reservationKey);
        }
        if (aContextKey != null) {
            return aContextKey.equals(this.contextKey);
        }
        return false;
    }

    public String getReservationKey() {
        return this.reservationKey;
    }

    public String getContextKey() {
        return this.contextKey;
    }

    public boolean isContextOpen() {
        return this.contextIsOpen;
    }

    public String getUsageComment() {
        return this.usageComment;
    }

    public boolean isCaseSensitive() {
        return !this.ignoreCase;
    }

    public String getWorkspaceLocation() {
        return this.workspaceLocation;
    }

    public String getWorkspaceID() {
        return this.workspaceID;
    }

    public String getShortName() {
        return this.shortName;
    }

    public void setNameCategory(String category) {
        this.nameCategory = category;
    }

    public void setFlatName(String name) {
        this.flatName = name;
    }

    public void setCimName(String nameKey) {
        this.cimName = nameKey;
    }

    public void setCompoundName(CompoundName name) {
        this.compoundName = name;
    }

    public void setUserId(String user) {
        this.userId = user;
    }

    public void setCaption(String title) {
        this.caption = title;
    }

    public void setDescription(String desc) {
        this.description = desc;
    }

    public void setProtectedGrowth(boolean flag) {
        this.protectedGrowth = flag;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public void setUnreserved() {
        this.allocationState = 0;
    }

    public void setReservedPreliminary() {
        this.allocationState = 1;
    }

    public void setReservedFinally() {
        this.allocationState = 2;
    }

    public void setCompoundSyntax() {
        this.flatSyntax = false;
    }

    public void setReservationKey(String reservationKey) {
        this.reservationKey = reservationKey;
    }

    public void setContextKey(String contextKey) {
        this.contextKey = contextKey;
    }

    public void setContextIsOpen(boolean flag) {
        this.contextIsOpen = flag;
    }

    public void setUsageComment(String comment) {
        this.usageComment = comment;
    }

    public void setIgnoreCase(boolean flag) {
        this.ignoreCase = flag;
    }

    public void setWorkspaceLocation(String wsLocation) {
        this.workspaceLocation = wsLocation;
    }

    public void setWorkspaceID(String wsID) {
        this.workspaceID = wsID;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }
}

