/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.namealloc;

import com.sap.lcr.api.cim.CIMClassname;
import com.sap.lcr.api.cim.CIMFactory;
import com.sap.lcr.api.cim.CIMInstance;
import com.sap.lcr.api.cim.CIMInstancename;
import com.sap.lcr.api.cim.CIMKeyValue;
import com.sap.lcr.api.cim.CIMKeybindingList;
import com.sap.lcr.api.cim.CIMProperty;
import com.sap.lcr.api.cim.CIMPropertyArray;
import com.sap.lcr.api.cim.CIMPropertyReference;
import com.sap.lcr.api.cim.CIMUtil;
import com.sap.lcr.api.cim.CIMValue;
import com.sap.lcr.api.cim.CIMValueArray;
import com.sap.lcr.api.cim.CIMValueNamedInstance;
import com.sap.lcr.api.cim.CIMValueObjectWithPath;
import com.sap.lcr.api.cim.CIMValueReference;
import com.sap.lcr.api.cim.ICIMItem;
import com.sap.lcr.api.cim.ICIMObjectContainer;
import com.sap.lcr.api.cim.ItemConstructionExcp;
import com.sap.lcr.api.cimclient.CIMClient;
import com.sap.lcr.api.cimclient.CIMClientException;
import com.sap.lcr.api.cimclient.CIMTraceUtil;
import com.sap.lcr.api.cimclient.LcrException;
import com.sap.lcr.api.log.Logger;
import com.sap.lcr.namealloc.NameAllocationConstants;
import com.sap.lcr.namealloc.NameAllocator;
import com.sap.lcr.namealloc.NameCharacteristic;
import com.sap.lcr.namealloc.NamespacePrefix;
import com.sap.lcr.namealloc.api.AllocationState;
import com.sap.lcr.namealloc.api.CommunicationFailureException;
import com.sap.lcr.namealloc.api.ForeignContextException;
import com.sap.lcr.namealloc.api.IExtendedSyntaxCheck;
import com.sap.lcr.namealloc.api.NameNotFoundException;
import com.sap.lcr.namealloc.api.NameSyntaxViolation;
import com.sap.lcr.namealloc.api.NotOwnerException;
import com.sap.lcr.namealloc.api.ReservedBeforeException;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.Properties;
import java.util.Random;
import javax.naming.CompoundName;
import javax.naming.InvalidNameException;

public class NameServerUtil
implements NameAllocationConstants {
    private static final Logger myLogger = Logger.getLogger((String)(class$com$sap$lcr$namealloc$NameServerUtil == null ? (class$com$sap$lcr$namealloc$NameServerUtil = NameServerUtil.class$("com.sap.lcr.namealloc.NameServerUtil")) : class$com$sap$lcr$namealloc$NameServerUtil).getName());
    private static final Random myRandom = new Random();
    private static Properties namePropertiesDefault = new Properties();
    private NameAllocator myNameAllocator;
    private CIMClient myCIMClient;
    static /* synthetic */ Class class$com$sap$lcr$namealloc$NameServerUtil;

    NameServerUtil(NameAllocator aNameAllocator) {
        this.myNameAllocator = aNameAllocator;
        this.myCIMClient = this.myNameAllocator.getMyCIMClient();
    }

    public String createNameInCIMKey(String source, NameCharacteristic namcha) {
        if (source != null && namcha != null && namcha.getMyIgnoreCase()) {
            return source.toUpperCase();
        }
        return source;
    }

    CIMInstancename createNameInstanceName(NameCharacteristic namcha, String category, String name) {
        String nameInCIMKey = this.createNameInCIMKey(name, namcha);
        String[] keyNames = new String[]{"CreationClassName", "Name"};
        String[] keyValues = new String[]{category, nameInCIMKey};
        return CIMFactory.instancename((String)category, (CIMKeybindingList)CIMFactory.keybindingList((String[])keyNames, (String[])keyValues));
    }

    public static CompoundName createCompoundNameWithCharacteristic(String source, NameCharacteristic namcha) throws NameSyntaxViolation {
        CompoundName result;
        if (source == null || source.length() == 0) {
            throw new NameSyntaxViolation("Unable to convert empty source into a compound name");
        }
        Properties nameSyntax = new Properties(namePropertiesDefault);
        if (namcha != null) {
            if (namcha.getMyCompoundFlag()) {
                NameServerUtil.createCompoundNameProperties(namcha, nameSyntax);
            } else if (namcha.getMyIgnoreCase()) {
                nameSyntax.setProperty("jndi.syntax.ignorecase", "true");
            }
        }
        try {
            result = new CompoundName(source, nameSyntax);
        }
        catch (InvalidNameException ine) {
            if (CIMTraceUtil.traceLevel >= 3) {
                myLogger.debug("Compound name syntax violation for name " + source, (Throwable)ine);
            }
            throw new NameSyntaxViolation(ine);
        }
        return result;
    }

    static void createCompoundNameProperties(NameCharacteristic namcha, Properties nameSyntax) throws NameSyntaxViolation {
        if (namcha == null || nameSyntax == null) {
            return;
        }
        nameSyntax.setProperty("jndi.syntax.direction", "left_to_right");
        if (namcha.getMySeparator() == null) {
            throw new NameSyntaxViolation("Illegal name characteristic for category " + namcha.getMyNameCategory() + " (missing separator)");
        }
        nameSyntax.setProperty("jndi.syntax.separator", namcha.getMySeparator());
        if (namcha.getMyEscape() != null) {
            nameSyntax.setProperty("jndi.syntax.escape", namcha.getMyEscape());
        }
        if (namcha.getMyIgnoreCase()) {
            nameSyntax.setProperty("jndi.syntax.ignorecase", "true");
        }
    }

    public CompoundName createCompoundNameFromString(String source, NameCharacteristic namcha) throws NameSyntaxViolation {
        return NameServerUtil.createCompoundNameWithCharacteristic(source, namcha);
    }

    CompoundName createCompoundNameFromCIMPA(CIMPropertyArray nameCompPA, NameCharacteristic namcha) throws NameSyntaxViolation {
        CompoundName result;
        Properties nameSyntax = new Properties(namePropertiesDefault);
        if (namcha != null) {
            if (namcha.getMyCompoundFlag()) {
                NameServerUtil.createCompoundNameProperties(namcha, nameSyntax);
            } else if (namcha.getMyIgnoreCase()) {
                nameSyntax.setProperty("jndi.syntax.ignorecase", "true");
            }
        }
        try {
            result = new CompoundName("", nameSyntax);
        }
        catch (InvalidNameException ine) {
            if (CIMTraceUtil.traceLevel >= 6) {
                myLogger.finest("Compound name syntax violation for empty name", (Throwable)ine);
            }
            throw new NameSyntaxViolation(ine);
        }
        CIMValueArray nameCompVA = nameCompPA.getValueArray();
        if (nameCompVA != null) {
            int i = 0;
            while (i < nameCompVA.size()) {
                CIMValue nextVal = nameCompVA.get(i);
                try {
                    result.add(nextVal.getStringvalue());
                }
                catch (InvalidNameException ine) {
                    if (CIMTraceUtil.traceLevel >= 6) {
                        myLogger.finest("Compound name syntax violation for name fragment " + result.toString() + ", next component " + nextVal.getStringvalue(), (Throwable)ine);
                    }
                    throw new NameSyntaxViolation(ine);
                }
                ++i;
            }
        }
        return result;
    }

    CIMValueNamedInstance createValueNamedInstanceForName(String nameCategory, CompoundName name, String userId, String caption, String description, boolean protectGrowth, NameCharacteristic namcha, AllocationState currNameState, CIMValueNamedInstance currVNI) throws CommunicationFailureException, NameSyntaxViolation {
        CIMValueNamedInstance result;
        CIMInstance nameInstance = null;
        CIMInstancename nameInstanceName = this.createNameInstanceName(namcha, nameCategory, name.toString());
        try {
            nameInstance = CIMFactory.instance((String)nameCategory);
            CIMProperty pk1 = CIMFactory.property((String)"CreationClassName", (String)"string", (String)nameCategory);
            nameInstance.addProperty(pk1);
            String cimName = this.createNameInCIMKey(name.toString(), namcha);
            CIMProperty pk2 = CIMFactory.property((String)"Name", (String)"string", (String)cimName);
            nameInstance.addProperty(pk2);
            String p1v = caption;
            if (caption.length() > 64) {
                p1v = caption.substring(0, 64);
            }
            CIMProperty p1 = CIMFactory.property((String)"Caption", (String)"string", (String)p1v);
            nameInstance.addProperty(p1);
            if (description != null) {
                CIMProperty p2 = CIMFactory.property((String)"Description", (String)"string", (String)description);
                nameInstance.addProperty(p2);
            }
            CIMProperty p3 = CIMFactory.property((String)"UserId", (String)"string", (String)userId);
            nameInstance.addProperty(p3);
            CIMValue p4Value = CIMFactory.value((boolean)protectGrowth);
            CIMProperty p4 = CIMFactory.property((String)"ProtectedGrowth", (String)"boolean", (CIMValue)p4Value);
            nameInstance.addProperty(p4);
            CIMProperty p5 = CIMFactory.property((String)"Key", (String)"string", (String)Integer.toString(myRandom.nextInt(100000000)));
            nameInstance.addProperty(p5);
            CIMProperty p6 = CIMFactory.property((String)"AllocationState", (String)"string", (String)"PRERES");
            nameInstance.addProperty(p6);
            CIMValueArray va1 = CIMFactory.valueArray();
            int i = 0;
            while (i < name.size()) {
                va1.addValue(CIMFactory.value((String)name.get(i)));
                ++i;
            }
            CIMPropertyArray pa1 = CIMFactory.propertyArray((String)"NameComponents", (String)"string");
            pa1.setValueArray(va1);
            nameInstance.addPropertyArray(pa1);
            if (currNameState.isOnNameServer()) {
                nameInstance.merge((ICIMItem)currVNI.getInstance());
                this.myCIMClient.modifyInstance(nameInstanceName, nameInstance);
            } else {
                String shortName = this.buildShortName(cimName);
                CIMProperty psn = CIMFactory.property((String)"ShortName", (String)"string", (String)shortName);
                nameInstance.addProperty(psn);
                nameInstanceName = this.myCIMClient.createInstance(nameInstance);
            }
            result = CIMFactory.valueNamedInstance((CIMInstancename)nameInstanceName, (CIMInstance)nameInstance);
        }
        catch (CIMClientException cce) {
            if (CIMTraceUtil.traceLevel >= 4) {
                myLogger.fine("Client exception in create name " + nameCategory + ":" + name.toString(), (Throwable)cce);
            }
            throw new CommunicationFailureException((Exception)((Object)cce));
        }
        catch (LcrException lce) {
            if (CIMTraceUtil.traceLevel >= 4) {
                myLogger.fine("LCR exception in create name " + nameCategory + ":" + name.toString(), (Throwable)lce);
            }
            throw new CommunicationFailureException((Exception)((Object)lce));
        }
        catch (ItemConstructionExcp ice) {
            throw new NameSyntaxViolation((Exception)((Object)ice));
        }
        return result;
    }

    AllocationState createAllocationState(NameCharacteristic aCharacteristic, String aFlatName, CIMInstance aDTName, CIMInstance aDTContext) throws NameSyntaxViolation {
        AllocationState resultState = new AllocationState();
        NameCharacteristic namcha = aCharacteristic;
        String nameKey = null;
        String nameOwner = null;
        boolean nameCompound = false;
        if (aCharacteristic != null) {
            nameCompound = aCharacteristic.getMyCompoundFlag();
            resultState.setIgnoreCase(aCharacteristic.getMyIgnoreCase());
            resultState.setNameCategory(aCharacteristic.getMyNameCategory());
        }
        if (aFlatName != null) {
            resultState.setFlatName(aFlatName);
        }
        if (aDTName != null) {
            CIMPropertyArray nameCompPA;
            Iterator propIter = aDTName.getPropertyIterator();
            while (propIter.hasNext()) {
                CIMValue nextValue;
                CIMProperty nextProperty = (CIMProperty)propIter.next();
                String propName = nextProperty.getName();
                if (propName.equalsIgnoreCase("CreationClassName")) {
                    resultState.setNameCategory(nextProperty.getValue());
                    continue;
                }
                if (propName.equalsIgnoreCase("Name")) {
                    resultState.setCimName(nextProperty.getValue());
                    continue;
                }
                if (propName.equalsIgnoreCase("Caption")) {
                    resultState.setCaption(nextProperty.getValue());
                    continue;
                }
                if (propName.equalsIgnoreCase("Description")) {
                    resultState.setDescription(nextProperty.getValue());
                    continue;
                }
                if (propName.equalsIgnoreCase("Separator") || propName.equalsIgnoreCase("Escape")) continue;
                if (propName.equalsIgnoreCase("Key")) {
                    nameKey = nextProperty.getValue();
                    continue;
                }
                if (propName.equalsIgnoreCase("AllocationState")) {
                    String stateValue = nextProperty.getValue();
                    if (stateValue == null) continue;
                    if (stateValue.equals("FINRES")) {
                        resultState.setReservedFinally();
                        continue;
                    }
                    if (stateValue.equals("PRERES")) {
                        resultState.setReservedPreliminary();
                        continue;
                    }
                    if (!stateValue.equals("UNRES")) continue;
                    resultState.setUnreserved();
                    continue;
                }
                if (propName.equalsIgnoreCase("UserId")) {
                    nameOwner = nextProperty.getValue();
                    resultState.setUserId(nameOwner);
                    continue;
                }
                if (propName.equalsIgnoreCase("UsageComment")) {
                    resultState.setUsageComment(nextProperty.getValue());
                    continue;
                }
                if (propName.equalsIgnoreCase("ProtectedGrowth")) {
                    nextValue = nextProperty.getCIMValue();
                    if (nextValue == null) continue;
                    resultState.setProtectedGrowth(nextValue.isTrue());
                    continue;
                }
                if (propName.equalsIgnoreCase("IgnoreCase")) {
                    nextValue = nextProperty.getCIMValue();
                    if (nextValue == null) continue;
                    resultState.setIgnoreCase(nextValue.isTrue());
                    continue;
                }
                if (propName.equalsIgnoreCase("CompoundName")) {
                    nextValue = nextProperty.getCIMValue();
                    if (nextValue == null) continue;
                    nameCompound = nextValue.isTrue();
                    continue;
                }
                if (propName.equalsIgnoreCase("WorkspaceLocation")) {
                    resultState.setWorkspaceLocation(nextProperty.getValue());
                    continue;
                }
                if (propName.equalsIgnoreCase("WorkspaceID")) {
                    resultState.setWorkspaceID(nextProperty.getValue());
                    continue;
                }
                if (!propName.equalsIgnoreCase("ShortName")) continue;
                resultState.setShortName(nextProperty.getValue());
            }
            if (nameOwner != null && this.myNameAllocator.getMyConnectUser().equalsIgnoreCase(nameOwner)) {
                resultState.setReservationKey(nameKey);
            }
            if (nameCompound) {
                resultState.setCompoundSyntax();
            }
            if (namcha == null) {
                namcha = new NameCharacteristic(resultState.getNameCategory());
            }
            if ((nameCompPA = aDTName.getPropertyArrayByName("NameComponents")) == null || nameCompPA.getValueArray() == null) {
                throw new NameSyntaxViolation("Original name missing for CIM name " + resultState.getNameCategory() + ":" + resultState.getCimName());
            }
            resultState.setCompoundName(this.createCompoundNameFromCIMPA(nameCompPA, namcha));
            resultState.setFlatName(resultState.getCompoundName().toString());
            if (!resultState.isOnNameServer()) {
                throw new NameSyntaxViolation("CIM name missing in instance with original name " + resultState.getNameCategory() + ":" + resultState.getFlatName());
            }
        }
        if (aDTContext != null) {
            CIMProperty propKey;
            CIMValue propOpenValue;
            CIMProperty propOpen;
            CIMProperty propName = aDTContext.getPropertyByName("Name");
            if (propName != null) {
                resultState.setContext(propName.getValue());
            }
            if ((propOpen = aDTContext.getPropertyByName("Open")) != null && (propOpenValue = propOpen.getCIMValue()) != null) {
                resultState.setContextIsOpen(propOpenValue.isTrue());
            }
            if (nameOwner != null && this.myNameAllocator.getMyConnectUser().equals(nameOwner) && (propKey = aDTContext.getPropertyByName("Key")) != null) {
                resultState.setContextKey(propKey.getValue());
            }
        }
        return resultState;
    }

    String getCaptionFromNameInstance(CIMInstance anInstance) {
        String val;
        if (anInstance == null) {
            return null;
        }
        CIMProperty prop = anInstance.getPropertyByName("Caption");
        if (prop != null && (val = prop.getValue()) != null) {
            return val;
        }
        return null;
    }

    String getDescriptionFromNameInstance(CIMInstance anInstance) {
        String val;
        if (anInstance == null) {
            return null;
        }
        CIMProperty prop = anInstance.getPropertyByName("Description");
        if (prop != null && (val = prop.getValue()) != null) {
            return val;
        }
        return null;
    }

    String getUserIdFromNameInstance(CIMInstance anInstance) {
        String val;
        if (anInstance == null) {
            return null;
        }
        CIMProperty prop = anInstance.getPropertyByName("UserId");
        if (prop != null && (val = prop.getValue()) != null) {
            return val;
        }
        return null;
    }

    String getKeyFromNameInstance(CIMInstance anInstance) {
        String keyValue;
        if (anInstance == null) {
            return null;
        }
        CIMProperty propKey = anInstance.getPropertyByName("Key");
        if (propKey != null && (keyValue = propKey.getValue()) != null) {
            return keyValue;
        }
        return null;
    }

    String getStateFromNameInstance(CIMInstance anInstance) {
        String stateValue;
        if (anInstance == null) {
            return null;
        }
        CIMProperty propState = anInstance.getPropertyByName("AllocationState");
        if (propState != null && (stateValue = propState.getValue()) != null) {
            return stateValue;
        }
        return "UNRES";
    }

    boolean getProtectedGrowthFlagFromNameInstance(CIMInstance anInstance) {
        CIMValue cimVal;
        if (anInstance == null) {
            return false;
        }
        CIMProperty prop = anInstance.getPropertyByName("ProtectedGrowth");
        if (prop != null && (cimVal = prop.getCIMValue()) != null && cimVal.isBoolean()) {
            return cimVal.isTrue();
        }
        return false;
    }

    String getKeyFromContextInstance(CIMInstance anInstance) {
        String val;
        if (anInstance == null) {
            return null;
        }
        CIMProperty prop = anInstance.getPropertyByName("Key");
        if (prop != null && (val = prop.getValue()) != null) {
            return val;
        }
        return null;
    }

    String getNameFromNameInstance(CIMInstance anInstance) throws NameSyntaxViolation {
        CIMValueArray valueArray;
        if (anInstance == null) {
            return null;
        }
        CIMPropertyArray propArray = anInstance.getPropertyArrayByName("NameComponents");
        if (propArray != null && (valueArray = propArray.getValueArray()) != null) {
            if (valueArray.size() <= 0) {
                return "";
            }
            if (valueArray.size() == 1) {
                return valueArray.get(0).getStringvalue();
            }
            String theCategory = null;
            CIMProperty categoryProperty = anInstance.getPropertyByName("CreationClassName");
            if (categoryProperty != null) {
                theCategory = categoryProperty.getValue();
            }
            NameCharacteristic namcha = this.myNameAllocator.getNameCharacteristic(theCategory);
            CompoundName theCompoundName = this.createCompoundNameFromCIMPA(propArray, namcha);
            return theCompoundName.toString();
        }
        return null;
    }

    String getCreationClassNameFromInstanceName(CIMInstancename anInstanceName) {
        if (anInstanceName == null) {
            return null;
        }
        CIMKeyValue keyValue1 = CIMUtil.getKeyValueByName((CIMInstancename)anInstanceName, (String)"CreationClassName");
        return keyValue1.getValue();
    }

    String getCimNameFromInstanceName(CIMInstancename anInstanceName) {
        if (anInstanceName == null) {
            return null;
        }
        CIMKeyValue keyValue2 = CIMUtil.getKeyValueByName((CIMInstancename)anInstanceName, (String)"Name");
        return keyValue2.getValue();
    }

    CIMValueNamedInstance getNameValueNamedInstance(String category, String name) throws CommunicationFailureException {
        CIMInstancename resultInstanceName;
        CIMInstance resultInstance;
        block5: {
            NameCharacteristic namcha = this.myNameAllocator.getNameCharacteristic(category);
            resultInstance = null;
            resultInstanceName = this.createNameInstanceName(namcha, category, name);
            try {
                resultInstance = this.myCIMClient.getInstance(resultInstanceName, false, false, false, null);
            }
            catch (CIMClientException cce) {
                if (CIMTraceUtil.traceLevel >= 4) {
                    myLogger.fine("Client exception in get instance of name " + category + ":" + name, (Throwable)cce);
                }
                throw new CommunicationFailureException((Exception)((Object)cce));
            }
            catch (LcrException lce) {
                if (lce.getStatusCode() == 6) break block5;
                if (CIMTraceUtil.traceLevel >= 4) {
                    myLogger.fine("LCR exception in get instance of name " + category + ":" + name, (Throwable)lce);
                }
                throw new CommunicationFailureException((Exception)((Object)lce));
            }
        }
        CIMValueNamedInstance result = CIMFactory.valueNamedInstance((CIMInstancename)resultInstanceName, (CIMInstance)resultInstance);
        return result;
    }

    CIMValueNamedInstance getContextValueNamedInstance(String context) throws CommunicationFailureException {
        CIMInstance contextInstance;
        CIMInstancename contextInstanceName;
        block5: {
            contextInstanceName = CIMFactory.instancename((String)"SAP_DesignTimeContext", (CIMKeybindingList)CIMFactory.keybindingList((String[])new String[]{"Name"}, (String[])new String[]{context}));
            contextInstance = null;
            try {
                contextInstance = this.myCIMClient.getInstance(contextInstanceName, false, false, false, null);
            }
            catch (CIMClientException cce) {
                if (CIMTraceUtil.traceLevel >= 4) {
                    myLogger.fine("Client exception in get instance of context " + context, (Throwable)cce);
                }
                throw new CommunicationFailureException((Exception)((Object)cce));
            }
            catch (LcrException lce) {
                if (lce.getStatusCode() == 6) break block5;
                if (CIMTraceUtil.traceLevel >= 4) {
                    myLogger.fine("LCR exception in get instance of context " + context, (Throwable)lce);
                }
                throw new CommunicationFailureException((Exception)((Object)lce));
            }
        }
        return CIMFactory.valueNamedInstance((CIMInstancename)contextInstanceName, (CIMInstance)contextInstance);
    }

    CIMValueNamedInstance[] getNamesOfCategory(String nameCategory) throws CommunicationFailureException {
        CIMValueNamedInstance[] allCategoryNames;
        String callCategory = nameCategory == null ? "SAP_DesignTimeName" : nameCategory;
        try {
            allCategoryNames = this.myCIMClient.enumerateInstances(callCategory, false, true, false, false, null);
        }
        catch (CIMClientException cce) {
            if (CIMTraceUtil.traceLevel >= 4) {
                myLogger.fine("Client exception in enumerate names of category " + nameCategory, (Throwable)cce);
            }
            throw new CommunicationFailureException((Exception)((Object)cce));
        }
        catch (LcrException lce) {
            if (lce.getStatusCode() == 5) {
                allCategoryNames = new CIMValueNamedInstance[]{};
            }
            if (CIMTraceUtil.traceLevel >= 4) {
                myLogger.fine("LCR exception in enumerate names of category " + nameCategory, (Throwable)lce);
            }
            throw new CommunicationFailureException((Exception)((Object)lce));
        }
        return allCategoryNames;
    }

    CIMValueObjectWithPath getAssociatedContextInstance(String category, String name) throws CommunicationFailureException {
        CIMValueObjectWithPath[] selectedInstances;
        NameCharacteristic namcha = this.myNameAllocator.getNameCharacteristic(category);
        String nameInCIMKey = this.createNameInCIMKey(name, namcha);
        CIMValueObjectWithPath resultInstance = null;
        String[] keyNames = new String[]{"CreationClassName", "Name"};
        String[] keyValues = new String[]{category, nameInCIMKey};
        CIMInstancename nameInstanceName = CIMFactory.instancename((String)category, (CIMKeybindingList)CIMFactory.keybindingList((String[])keyNames, (String[])keyValues));
        CIMClassname assocClass = CIMFactory.classname((String)"SAP_DTContextMember");
        CIMClassname targetClass = CIMFactory.classname((String)"SAP_DesignTimeContext");
        try {
            selectedInstances = this.myCIMClient.associators(nameInstanceName, assocClass, targetClass, "Member", "Collection", false, false, null);
        }
        catch (CIMClientException cce) {
            if (CIMTraceUtil.traceLevel >= 4) {
                myLogger.fine("Client exception in get associated context of name " + category + ":" + name, (Throwable)cce);
            }
            throw new CommunicationFailureException((Exception)((Object)cce));
        }
        catch (LcrException lce) {
            if (CIMTraceUtil.traceLevel >= 4) {
                myLogger.fine("LCR exception in get associated context of name " + category + ":" + name, (Throwable)lce);
            }
            throw new CommunicationFailureException((Exception)((Object)lce));
        }
        if (selectedInstances.length > 0) {
            if (selectedInstances.length > 1 && CIMTraceUtil.traceLevel >= 3) {
                myLogger.debug("More than one associated context detected for name " + category + ":" + name);
            }
            resultInstance = selectedInstances[0];
        }
        return resultInstance;
    }

    CIMValueObjectWithPath[] getAssociatedNameInstances(String context) throws CommunicationFailureException {
        CIMValueObjectWithPath[] selectedInstances = null;
        CIMInstancename contextInstanceName = CIMFactory.instancename((String)"SAP_DesignTimeContext", (CIMKeybindingList)CIMFactory.keybindingList((String[])new String[]{"Name"}, (String[])new String[]{context}));
        CIMClassname assocClass = CIMFactory.classname((String)"SAP_DTContextMember");
        CIMClassname targetClass = CIMFactory.classname((String)"SAP_DesignTimeName");
        try {
            selectedInstances = this.myCIMClient.associators(contextInstanceName, assocClass, targetClass, "Collection", "Member", false, false, null);
        }
        catch (CIMClientException cce) {
            if (CIMTraceUtil.traceLevel >= 4) {
                myLogger.fine("Client exception in get associated names of context " + context, (Throwable)cce);
            }
            throw new CommunicationFailureException((Exception)((Object)cce));
        }
        catch (LcrException lce) {
            if (CIMTraceUtil.traceLevel >= 4) {
                myLogger.fine("LCR exception in get associated names of context " + context, (Throwable)lce);
            }
            throw new CommunicationFailureException((Exception)((Object)lce));
        }
        return selectedInstances;
    }

    void checkForProtectedBranch(String nameCategory, CompoundName name, boolean openForOwner) throws NotOwnerException, ReservedBeforeException, NameSyntaxViolation, CommunicationFailureException {
        int i = name.size() - 1;
        while (i > 0) {
            CompoundName branch = (CompoundName)name.getPrefix(i);
            CIMValueNamedInstance branchValueNamedInstance = this.getNameValueNamedInstance(nameCategory, branch.toString());
            CIMInstance branchInstance = branchValueNamedInstance.getInstance();
            if (branchInstance != null && this.getProtectedGrowthFlagFromNameInstance(branchInstance)) {
                NameCharacteristic namcha = this.myNameAllocator.getNameCharacteristic(nameCategory);
                AllocationState branchState = this.createAllocationState(namcha, branch.toString(), branchInstance, null);
                String owner = this.getUserIdFromNameInstance(branchInstance);
                if (owner == null || !owner.equalsIgnoreCase(this.myNameAllocator.getMyConnectUser())) {
                    throw new NotOwnerException("Branch " + branch.toString() + " locked by user " + owner, branchState, true);
                }
                if (openForOwner) {
                    return;
                }
                throw new ReservedBeforeException("Branch " + branch.toString() + " locked by yourself", branchState, true);
            }
            --i;
        }
    }

    CIMValueNamedInstance checkNameBeforeModify(String nameCategory, String name, String reservationKey) throws CommunicationFailureException, NameNotFoundException, NotOwnerException {
        CIMValueNamedInstance currValueNamedInstance = null;
        if (name != null) {
            currValueNamedInstance = this.getNameValueNamedInstance(nameCategory, name);
            CIMInstance currInstance = currValueNamedInstance.getInstance();
            if (currInstance == null) {
                throw new NameNotFoundException("Name not found: " + nameCategory + ":" + name);
            }
            String currKey = this.getKeyFromNameInstance(currInstance);
            if (currKey == null || !currKey.equals(reservationKey)) {
                throw new NotOwnerException("Wrong key submitted for name " + nameCategory + ":" + name);
            }
        }
        if (currValueNamedInstance == null) {
            throw new NameNotFoundException("Name not defined: " + nameCategory + ":" + name);
        }
        return currValueNamedInstance;
    }

    CIMValueNamedInstance checkNameBeforeStateTransition(String nameCategory, CompoundName name, String reservationKey) throws CommunicationFailureException, NameNotFoundException, NotOwnerException {
        String flatName = name.toString();
        CIMValueNamedInstance currValueNamedInstance = this.checkNameBeforeModify(nameCategory, flatName, reservationKey);
        String currReservationState = this.getStateFromNameInstance(currValueNamedInstance.getInstance());
        if (!currReservationState.equals("PRERES")) {
            throw new NotOwnerException("Improper reservation state for state transition: " + (currReservationState.equals("FINRES") ? "finally reserved" : "unreserved"));
        }
        return currValueNamedInstance;
    }

    CIMValueNamedInstance checkContextBeforeModify(String context, String contextKey) throws CommunicationFailureException, ForeignContextException {
        String serverContextKey;
        CIMInstance serverContextInstance;
        CIMValueNamedInstance serverContextVNI = null;
        if (!(context == null || (serverContextInstance = (serverContextVNI = this.getContextValueNamedInstance(context)).getInstance()) == null || (serverContextKey = this.getKeyFromContextInstance(serverContextInstance)) != null && serverContextKey.equals(contextKey))) {
            throw new ForeignContextException("Wrong key submitted for context " + context);
        }
        return serverContextVNI;
    }

    boolean isNameToBeSelected(ICIMObjectContainer aNameObject, String specifiedCategory, String specifiedTextPattern, boolean suppressPrelim, boolean suppressFinal) {
        String nameName;
        CIMInstancename theInstanceName = aNameObject.getInstancename();
        CIMInstance theInstance = aNameObject.getInstance();
        String creationClassName = this.getCreationClassNameFromInstanceName(theInstanceName);
        try {
            nameName = this.getNameFromNameInstance(theInstance);
        }
        catch (NameSyntaxViolation nsve) {
            if (CIMTraceUtil.traceLevel >= 4) {
                myLogger.fine("Name syntax incorrect in CIM instance, using instance key.", (Throwable)((Object)nsve));
            }
            nameName = this.getCimNameFromInstanceName(theInstanceName);
        }
        if (specifiedCategory != null) {
            boolean ofCategory;
            Class<?> nameJavaClass;
            Class<?> categoryJavaClass;
            block14: {
                block13: {
                    categoryJavaClass = null;
                    nameJavaClass = null;
                    ofCategory = true;
                    try {
                        categoryJavaClass = Class.forName("com.sap.lcr.api.sapmodel." + specifiedCategory);
                    }
                    catch (ClassNotFoundException cnfe) {
                        if (CIMTraceUtil.traceLevel < 3) break block13;
                        myLogger.debug("Java class not found for category " + specifiedCategory, (Throwable)cnfe);
                    }
                }
                try {
                    nameJavaClass = Class.forName("com.sap.lcr.api.sapmodel." + creationClassName);
                }
                catch (ClassNotFoundException cnfe) {
                    if (CIMTraceUtil.traceLevel < 3) break block14;
                    myLogger.debug("Java class not found for class " + creationClassName, (Throwable)cnfe);
                }
            }
            if (categoryJavaClass != null && nameJavaClass != null) {
                ofCategory = categoryJavaClass.isAssignableFrom(nameJavaClass);
            }
            if (!ofCategory) {
                return false;
            }
        }
        if (specifiedTextPattern != null && !CIMUtil.matchesPattern((String)specifiedTextPattern, (String)nameName, (boolean)true)) {
            return false;
        }
        if (suppressPrelim || suppressFinal) {
            String nameState = this.getStateFromNameInstance(theInstance);
            if (suppressPrelim && nameState.equals("PRERES") || suppressFinal && nameState.equals("FINRES")) {
                return false;
            }
        }
        return true;
    }

    public static void checkNameSyntax(CompoundName name, NameCharacteristic namcha) throws NameSyntaxViolation {
        IExtendedSyntaxCheck theExtendedChecker = namcha.getMyExtendedSyntaxCheck();
        if (theExtendedChecker != null) {
            theExtendedChecker.checkSyntax(name);
        }
        if (name.toString().length() == 0) {
            throw new NameSyntaxViolation("Empty name cannot be reserved");
        }
        String[] theCharSet = namcha.getMyCharacterSet();
        if (theCharSet == null || theCharSet.length == 0) {
            throw new NameSyntaxViolation("No character set defined for category " + namcha.getMyNameCategory());
        }
        int i = 0;
        while (i < name.size()) {
            String nextComp = name.get(i);
            int j = 0;
            while (j < nextComp.length()) {
                char nextChar = nextComp.charAt(j);
                boolean valid = false;
                int k = 0;
                while (k < theCharSet.length) {
                    if (theCharSet[k].length() == 1) {
                        if (theCharSet[k].charAt(0) == nextChar) {
                            valid = true;
                            break;
                        }
                    } else {
                        int nuc;
                        if (theCharSet[k].equalsIgnoreCase("ALL")) {
                            return;
                        }
                        if (theCharSet[k].equalsIgnoreCase("ALPHANUM")) {
                            nuc = Character.getNumericValue(nextChar);
                            if (nuc >= NameAllocationConstants.ZERO_CHAR && nuc <= NameAllocationConstants.NINE_CHAR || nuc >= NameAllocationConstants.CAPITAL_A_CHAR && nuc <= NameAllocationConstants.CAPITAL_Z_CHAR || nuc >= NameAllocationConstants.LOWER_A_CHAR && nuc <= NameAllocationConstants.LOWER_Z_CHAR) {
                                valid = true;
                                break;
                            }
                        } else if (theCharSet[k].equalsIgnoreCase("ALPHA")) {
                            nuc = Character.getNumericValue(nextChar);
                            if (nuc >= NameAllocationConstants.CAPITAL_A_CHAR && nuc <= NameAllocationConstants.CAPITAL_Z_CHAR || nuc >= NameAllocationConstants.LOWER_A_CHAR && nuc <= NameAllocationConstants.LOWER_Z_CHAR) {
                                valid = true;
                                break;
                            }
                        } else if (theCharSet[k].equals("A-Z")) {
                            nuc = Character.getNumericValue(nextChar);
                            if (nuc >= NameAllocationConstants.CAPITAL_A_CHAR && nuc <= NameAllocationConstants.CAPITAL_Z_CHAR) {
                                valid = true;
                                break;
                            }
                        } else if (theCharSet[k].equals("a-z")) {
                            nuc = Character.getNumericValue(nextChar);
                            if (nuc >= NameAllocationConstants.LOWER_A_CHAR && nuc <= NameAllocationConstants.LOWER_Z_CHAR) {
                                valid = true;
                                break;
                            }
                        } else if (theCharSet[k].equals("0-9") && (nuc = Character.getNumericValue(nextChar)) >= NameAllocationConstants.ZERO_CHAR && nuc <= NameAllocationConstants.NINE_CHAR) {
                            valid = true;
                            break;
                        }
                    }
                    ++k;
                }
                if (!valid) {
                    throw new NameSyntaxViolation("Illegal character \"" + nextChar + "\" at position " + j + " in name component " + i + " of name \"" + name.toString() + "\"");
                }
                ++j;
            }
            ++i;
        }
    }

    void checkForTextualSyntax(CompoundName name, NameCharacteristic namcha) throws NameSyntaxViolation {
        NameServerUtil.checkNameSyntax(name, namcha);
    }

    void checkForAllowedNamePrefix(String nameCategory, CompoundName name) throws NameSyntaxViolation, CommunicationFailureException {
        CompoundName[] allowArray = this.myNameAllocator.getAllowedPrefixList(nameCategory);
        if (allowArray == null || allowArray.length == 0) {
            throw new NameSyntaxViolation("Invalid name; on this server no names of category " + nameCategory + " are allowed at all");
        }
        boolean prefixFound = false;
        int i = 0;
        while (i < allowArray.length) {
            CompoundName allowedPrefix = allowArray[i];
            int prefixSize = allowedPrefix.size();
            boolean deviationFound = false;
            int j = 0;
            while (j < prefixSize) {
                block13: {
                    boolean cmpFull;
                    String cmpComponent;
                    block14: {
                        String nextPrefixComponent;
                        cmpComponent = nextPrefixComponent = allowedPrefix.get(j);
                        cmpFull = true;
                        if (!nextPrefixComponent.endsWith("*")) break block14;
                        if (nextPrefixComponent.equals("*")) break block13;
                        cmpComponent = nextPrefixComponent.substring(0, nextPrefixComponent.length() - 1);
                        cmpFull = false;
                    }
                    try {
                        if (cmpFull) {
                            if (!name.get(j).equals(cmpComponent)) {
                                deviationFound = true;
                                break;
                            }
                        } else if (!name.get(j).startsWith(cmpComponent)) {
                            deviationFound = true;
                        }
                        break block13;
                    }
                    catch (ArrayIndexOutOfBoundsException aioobe) {
                        if (CIMTraceUtil.traceLevel >= 6) {
                            myLogger.finest("Compound name " + name + " shorter than allowed prefix " + allowedPrefix, (Throwable)aioobe);
                        }
                        deviationFound = true;
                    }
                    break;
                }
                ++j;
            }
            if (!deviationFound) {
                prefixFound = true;
                break;
            }
            ++i;
        }
        if (!prefixFound) {
            throw new NameSyntaxViolation("Invalid name: appropriate prefix not found; choose another name or another name server");
        }
    }

    CIMInstance modifyNameInstanceProperty(CIMInstance currInstance, CIMInstancename currInstanceName, String nameCategory, String name, String propName, String propType, String propValue) throws CommunicationFailureException {
        if (currInstance == null) {
            throw new CommunicationFailureException("Internal error: no instance submitted to modify");
        }
        CIMInstance modInstance = (CIMInstance)currInstance.clone();
        try {
            modInstance.addProperty(CIMFactory.property((String)propName, (String)propType, (String)propValue));
            this.myCIMClient.modifyInstance(currInstanceName, modInstance);
        }
        catch (CIMClientException cce) {
            if (CIMTraceUtil.traceLevel >= 4) {
                myLogger.fine("Client exception in modify name instance " + nameCategory + ":" + name, (Throwable)cce);
            }
            throw new CommunicationFailureException((Exception)((Object)cce));
        }
        catch (LcrException lce) {
            if (CIMTraceUtil.traceLevel >= 4) {
                myLogger.fine("LCR exception in modify name instance " + nameCategory + ":" + name, (Throwable)lce);
            }
            throw new CommunicationFailureException((Exception)((Object)lce));
        }
        catch (ItemConstructionExcp ice) {
            if (CIMTraceUtil.traceLevel >= 4) {
                myLogger.fine("Item construction exception in modify name instance " + nameCategory + ":" + name, (Throwable)ice);
            }
            throw new CommunicationFailureException((Exception)((Object)ice));
        }
        return modInstance;
    }

    CIMInstance modifyNameInstanceProperties(CIMInstance currInstance, CIMInstancename currInstanceName, String nameCategory, String name, String[] propNames, String[] propTypes, String[] propValues) throws CommunicationFailureException {
        if (currInstance == null) {
            throw new CommunicationFailureException("Internal error: no instance submitted to modify");
        }
        CIMInstance modInstance = (CIMInstance)currInstance.clone();
        int i = 0;
        while (i < propNames.length) {
            try {
                modInstance.addProperty(CIMFactory.property((String)propNames[i], (String)propTypes[i], (String)propValues[i]));
            }
            catch (ItemConstructionExcp ice) {
                if (CIMTraceUtil.traceLevel >= 4) {
                    myLogger.fine("Item construction exception in modify name instance " + nameCategory + ":" + name, (Throwable)ice);
                }
                throw new CommunicationFailureException((Exception)((Object)ice));
            }
            ++i;
        }
        try {
            this.myCIMClient.modifyInstance(currInstanceName, modInstance);
        }
        catch (CIMClientException cce) {
            if (CIMTraceUtil.traceLevel >= 4) {
                myLogger.fine("Client exception in modify name instance " + nameCategory + ":" + name, (Throwable)cce);
            }
            throw new CommunicationFailureException((Exception)((Object)cce));
        }
        catch (LcrException lce) {
            if (CIMTraceUtil.traceLevel >= 4) {
                myLogger.fine("LCR exception in modify name instance " + nameCategory + ":" + name, (Throwable)lce);
            }
            throw new CommunicationFailureException((Exception)((Object)lce));
        }
        return modInstance;
    }

    CIMInstance modifyContextInstanceProperty(CIMInstance currInstance, CIMInstancename currInstanceName, String context, String propName, String propType, String propValue) throws CommunicationFailureException {
        if (currInstance == null) {
            throw new CommunicationFailureException("Internal error: no context instance submitted to modify");
        }
        CIMInstance modInstance = (CIMInstance)currInstance.clone();
        try {
            modInstance.addProperty(CIMFactory.property((String)propName, (String)propType, (String)propValue));
            this.myCIMClient.modifyInstance(currInstanceName, modInstance);
        }
        catch (CIMClientException cce) {
            if (CIMTraceUtil.traceLevel >= 4) {
                myLogger.fine("Client exception in modify context instance " + context, (Throwable)cce);
            }
            throw new CommunicationFailureException((Exception)((Object)cce));
        }
        catch (LcrException lce) {
            if (CIMTraceUtil.traceLevel >= 4) {
                myLogger.fine("LCR exception in modify context instance " + context, (Throwable)lce);
            }
            throw new CommunicationFailureException((Exception)((Object)lce));
        }
        catch (ItemConstructionExcp ice) {
            if (CIMTraceUtil.traceLevel >= 4) {
                myLogger.fine("Item construction exception in modify context instance " + context, (Throwable)ice);
            }
            throw new CommunicationFailureException((Exception)((Object)ice));
        }
        return modInstance;
    }

    void removeNameInstance(String nameCategory, String name) throws CommunicationFailureException {
        NameCharacteristic namcha = this.myNameAllocator.getNameCharacteristic(nameCategory);
        CIMInstancename delInstanceName = this.createNameInstanceName(namcha, nameCategory, name);
        this.removeNameInstance(delInstanceName, nameCategory, name);
    }

    void removeNameInstance(CIMInstancename delInstanceName, String nameCategory, String name) throws CommunicationFailureException {
        try {
            this.myCIMClient.deleteInstance(delInstanceName, true);
        }
        catch (CIMClientException cce) {
            if (CIMTraceUtil.traceLevel >= 4) {
                myLogger.fine("Client exception in delete name instance " + nameCategory + ":" + name, (Throwable)cce);
            }
            throw new CommunicationFailureException((Exception)((Object)cce));
        }
        catch (LcrException lce) {
            if (CIMTraceUtil.traceLevel >= 4) {
                myLogger.fine("LCR exception in delete name instance " + nameCategory + ":" + name, (Throwable)lce);
            }
            throw new CommunicationFailureException((Exception)((Object)lce));
        }
    }

    void removeContextInstance(CIMInstancename delInstanceName, String context) throws CommunicationFailureException {
        try {
            this.myCIMClient.deleteInstance(delInstanceName, true);
        }
        catch (CIMClientException cce) {
            if (CIMTraceUtil.traceLevel >= 4) {
                myLogger.fine("Client exception in delete context instance " + context, (Throwable)cce);
            }
            throw new CommunicationFailureException((Exception)((Object)cce));
        }
        catch (LcrException lce) {
            if (CIMTraceUtil.traceLevel >= 4) {
                myLogger.fine("LCR exception in delete context instance " + context, (Throwable)lce);
            }
            throw new CommunicationFailureException((Exception)((Object)lce));
        }
    }

    void associateNameWithContext(String nameCategory, String name, String context, String contextKey) throws CommunicationFailureException, ForeignContextException {
        CIMValueNamedInstance nameVNI = this.getNameValueNamedInstance(nameCategory, name);
        CIMValueNamedInstance contextValueNamedInstance = this.getContextValueNamedInstance(context);
        CIMInstance contextInstance = contextValueNamedInstance.getInstance();
        CIMInstancename contextInstanceName = contextValueNamedInstance.getInstancename();
        if (contextInstance != null) {
            String currContextKey = this.getKeyFromContextInstance(contextInstance);
            if (currContextKey == null || !currContextKey.equals(contextKey)) {
                throw new ForeignContextException("Wrong key submitted for context to be associated");
            }
        } else {
            throw new ForeignContextException("Context " + context + " does not exist, create context first");
        }
        try {
            CIMValueReference memberValueReference = CIMFactory.valueReference((CIMInstancename)nameVNI.getInstancename());
            CIMPropertyReference memberPropertyReference = CIMFactory.propertyReference((String)"Member", (CIMValueReference)memberValueReference);
            CIMValueReference collectionValueReference = CIMFactory.valueReference((CIMInstancename)contextInstanceName);
            CIMPropertyReference collectionPropertyReference = CIMFactory.propertyReference((String)"Collection", (CIMValueReference)collectionValueReference);
            CIMInstance contextAssocInstance = CIMFactory.instance((String)"SAP_DTContextMember");
            contextAssocInstance.addPropertyReference(memberPropertyReference);
            contextAssocInstance.addPropertyReference(collectionPropertyReference);
            this.myCIMClient.createInstance(contextAssocInstance);
        }
        catch (CIMClientException cce) {
            if (CIMTraceUtil.traceLevel >= 4) {
                myLogger.fine("Client exception in associate context " + context + " with name " + nameCategory + ":" + name, (Throwable)cce);
            }
            throw new CommunicationFailureException((Exception)((Object)cce));
        }
        catch (LcrException lce) {
            if (CIMTraceUtil.traceLevel >= 4) {
                myLogger.fine("LCR exception in associate context " + context + " with name " + nameCategory + ":" + name, (Throwable)lce);
            }
            throw new CommunicationFailureException((Exception)((Object)lce));
        }
    }

    private String buildShortName(String cimName) throws CommunicationFailureException {
        long orgNameHashValue = cimName.hashCode();
        long randomValue = myRandom.nextInt();
        long longID = (Math.abs(randomValue) << 31) + Math.abs(orgNameHashValue);
        BigInteger bigID = BigInteger.valueOf(longID);
        String stringID = bigID.toString(36);
        StringBuffer shortNameBuffer = new StringBuffer(20);
        shortNameBuffer.append(stringID);
        shortNameBuffer.append(this.myNameAllocator.getMyObjectServerName(false));
        int i = shortNameBuffer.length();
        while (i < 20) {
            shortNameBuffer.insert(stringID.length(), ' ');
            ++i;
        }
        if (shortNameBuffer.length() > 20) {
            return shortNameBuffer.substring(0, 20);
        }
        return shortNameBuffer.toString();
    }

    public NamespacePrefix createNamespacePrefix(String category, String prefix, String nameServerHandle, String owner, String description, boolean forGenerator, boolean forOtherNameServer) throws NameSyntaxViolation {
        CIMValueNamedInstance existObj;
        NameCharacteristic namcha = this.myNameAllocator.getNameCharacteristic(category);
        CompoundName compoundPrefix = this.createCompoundNameFromString(prefix, namcha);
        NamespacePrefix result = new NamespacePrefix(namcha, compoundPrefix);
        try {
            existObj = this.myNameAllocator.getExistingNamePrefix(category, prefix);
        }
        catch (CommunicationFailureException cfe) {
            if (CIMTraceUtil.traceLevel >= 4) {
                myLogger.fine("Communication failure in create prefix " + category + ":" + prefix, (Throwable)((Object)cfe));
            }
            result.setMyCreationState(1);
            return result;
        }
        if (existObj != null) {
            if (CIMTraceUtil.traceLevel >= 4) {
                myLogger.fine("Found conflicting prefix in create prefix " + category + ":" + prefix);
            }
            result.setMyCreationState(3);
            return result;
        }
        CIMInstance prefixInst = this.createPrefixInstance(category, prefix, nameServerHandle, owner, description, forGenerator, forOtherNameServer);
        try {
            this.myCIMClient.createInstance(prefixInst);
            result.setMyCreationState(2);
        }
        catch (CIMClientException cce) {
            if (CIMTraceUtil.traceLevel >= 4) {
                myLogger.fine("Client exception in create prefix " + category + ":" + prefix, (Throwable)cce);
            }
            result.setMyCreationState(1);
        }
        catch (LcrException lce) {
            if (CIMTraceUtil.traceLevel >= 4) {
                myLogger.fine("LCR exception in create prefix " + category + ":" + prefix, (Throwable)lce);
            }
            if (lce.getStatusCode() == 11) {
                result.setMyCreationState(3);
            }
            result.setMyCreationState(1);
        }
        return result;
    }

    public NamespacePrefix updateNamespacePrefix(String category, String prefix, String nameServerHandle, String owner, String description, boolean forGenerator, boolean forOtherNameServer) throws NameSyntaxViolation {
        CIMValueNamedInstance existObj;
        NameCharacteristic namcha = this.myNameAllocator.getNameCharacteristic(category);
        CompoundName compoundPrefix = this.createCompoundNameFromString(prefix, namcha);
        NamespacePrefix result = new NamespacePrefix(namcha, compoundPrefix);
        try {
            existObj = this.myNameAllocator.getExistingNamePrefix(category, prefix);
        }
        catch (CommunicationFailureException cfe) {
            if (CIMTraceUtil.traceLevel >= 4) {
                myLogger.fine("Communication failure in update prefix " + category + ":" + prefix, (Throwable)((Object)cfe));
            }
            result.setMyCreationState(1);
            return result;
        }
        if (existObj == null) {
            if (CIMTraceUtil.traceLevel >= 4) {
                myLogger.fine("Found no prefix to be updated in update prefix " + category + ":" + prefix);
            }
            result.setMyCreationState(4);
            return result;
        }
        CIMInstance prefixInst = this.createPrefixInstance(category, prefix, nameServerHandle, owner, description, forGenerator, forOtherNameServer);
        try {
            if (CIMTraceUtil.traceLevel >= 4) {
                myLogger.fine("Found existing prefix to be updated for prefix " + category + ":" + prefix);
            }
            this.myCIMClient.renameInstance(existObj.getInstancename(), prefixInst);
            result.setMyCreationState(5);
        }
        catch (CIMClientException cce) {
            if (CIMTraceUtil.traceLevel >= 4) {
                myLogger.fine("Client exception in update prefix " + category + ":" + prefix, (Throwable)cce);
            }
            result.setMyCreationState(1);
        }
        catch (LcrException lce) {
            if (CIMTraceUtil.traceLevel >= 4) {
                myLogger.fine("LCR exception in update prefix " + category + ":" + prefix, (Throwable)lce);
            }
            result.setMyCreationState(1);
        }
        return result;
    }

    private CIMInstance createPrefixInstance(String category, String prefix, String nameServerHandle, String owner, String description, boolean forGenerator, boolean forOtherNameServer) throws NameSyntaxViolation {
        CIMInstance prefixInst = CIMFactory.instance((String)"SAP_AllowedNamespacePrefix");
        try {
            CIMProperty ps1 = CIMFactory.property((String)"Name", (String)"string", (String)prefix);
            prefixInst.addProperty(ps1);
            CIMProperty ps2 = CIMFactory.property((String)"NamespaceClassName", (String)"string", (String)category);
            prefixInst.addProperty(ps2);
            CIMProperty ps3 = CIMFactory.property((String)"NamespaceHandle", (String)"string", (String)nameServerHandle);
            prefixInst.addProperty(ps3);
            CIMProperty ps4 = CIMFactory.property((String)"Owner", (String)"string", (String)owner);
            prefixInst.addProperty(ps4);
            String ps5v = forGenerator ? "true" : "false";
            CIMProperty ps5 = CIMFactory.property((String)"UsedByGenerator", (String)"boolean", (String)ps5v);
            prefixInst.addProperty(ps5);
            String ps6v = forOtherNameServer ? "true" : "false";
            CIMProperty ps6 = CIMFactory.property((String)"ReservedForOthers", (String)"boolean", (String)ps6v);
            prefixInst.addProperty(ps6);
            String caption = prefix + " for " + category;
            if (caption.length() > 64) {
                caption = caption.substring(0, 64);
            }
            CIMProperty ps7 = CIMFactory.property((String)"Caption", (String)"string", (String)caption);
            prefixInst.addProperty(ps7);
            CIMProperty ps8 = CIMFactory.property((String)"Description", (String)"string", (String)description);
            prefixInst.addProperty(ps8);
        }
        catch (ItemConstructionExcp ice) {
            throw new NameSyntaxViolation((Exception)((Object)ice));
        }
        return prefixInst;
    }

    public NamespacePrefix[] generatePrefixesByConvention(String rootPrefix) throws NameSyntaxViolation {
        this.checkRootPrefix(rootPrefix);
        NamespacePrefix[] result = new NamespacePrefix[5];
        NameCharacteristic namcha = this.myNameAllocator.getNameCharacteristic("SAP_ApplicationContextRoot");
        CompoundName compoundPrefix = this.createCompoundNameFromString(rootPrefix.toLowerCase(), namcha);
        result[0] = new NamespacePrefix(namcha, compoundPrefix);
        namcha = this.myNameAllocator.getNameCharacteristic("SAP_DBFieldName");
        compoundPrefix = this.createCompoundNameFromString(rootPrefix.toUpperCase() + "_*", namcha);
        result[1] = new NamespacePrefix(namcha, compoundPrefix);
        namcha = this.myNameAllocator.getNameCharacteristic("SAP_DBObjectName");
        compoundPrefix = this.createCompoundNameFromString(rootPrefix.toUpperCase() + "_*", namcha);
        result[2] = new NamespacePrefix(namcha, compoundPrefix);
        namcha = this.myNameAllocator.getNameCharacteristic("SAP_DBPoolName");
        compoundPrefix = this.createCompoundNameFromString(rootPrefix.toUpperCase() + "/P_*", namcha);
        result[3] = new NamespacePrefix(namcha, compoundPrefix);
        namcha = this.myNameAllocator.getNameCharacteristic("SAP_InstallationUnitName");
        compoundPrefix = this.createCompoundNameFromString(rootPrefix.toUpperCase() + "_*", namcha);
        result[4] = new NamespacePrefix(namcha, compoundPrefix);
        return result;
    }

    public NamespacePrefix[] createPrefixesByConvention(String rootPrefix, String nameServerHandle, String owner, String description, boolean forGenerator, boolean forOtherNameServer) throws NameSyntaxViolation {
        NamespacePrefix[] prefixes = this.generatePrefixesByConvention(rootPrefix);
        NamespacePrefix[] result = new NamespacePrefix[prefixes.length];
        int i = 0;
        while (i < prefixes.length) {
            NamespacePrefix np = prefixes[i];
            result[i] = this.createNamespacePrefix(np.getMyCategory(), np.getMyStringName(), nameServerHandle, owner, description, forGenerator, forOtherNameServer);
            ++i;
        }
        return result;
    }

    private void checkRootPrefix(String rootPrefix) throws NameSyntaxViolation {
        int j = 0;
        while (j < rootPrefix.length()) {
            char nextChar = rootPrefix.charAt(j);
            int nuc = Character.getNumericValue(nextChar);
            if (!(nuc >= NameAllocationConstants.ZERO_CHAR && nuc <= NameAllocationConstants.NINE_CHAR || nuc >= NameAllocationConstants.CAPITAL_A_CHAR && nuc <= NameAllocationConstants.CAPITAL_Z_CHAR || nuc >= NameAllocationConstants.LOWER_A_CHAR && nuc <= NameAllocationConstants.LOWER_Z_CHAR)) {
                throw new NameSyntaxViolation("Illegal character (non alpha-numeric) at position " + j + " in root prefix " + rootPrefix + " (" + nextChar + ")");
            }
            ++j;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        namePropertiesDefault.setProperty("jndi.syntax.direction", "flat");
    }
}

