/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.namealloc;

import com.sap.lcr.namealloc.api.IExtendedSyntaxCheck;
import com.sap.lcr.namealloc.api.NameSyntaxViolation;
import javax.naming.CompoundName;

public class DevelopmentComponentSyntaxChecker
implements IExtendedSyntaxCheck {
    private static final int MAX_NAME_LENGTH = 60;
    private static final String[] devCompMixed1 = new String[]{"zgkb.com", "sap.com"};
    private static final String[] devCompMixed2 = new String[]{"sap.com", "bi", "sap.com", "caf", "sap.com", "ess", "zgkb.com", "local", "sap.com", "xapps", "sap.com", "scm", "sap.com", "local", "sap.com", "tc"};
    private static final String[] devCompMixed3 = new String[]{"sap.com", "bi", "mmr", "sap.com", "caf", "JavaCOOL", "sap.com", "caf", "CAFDataService", "sap.com", "caf", "RI", "sap.com", "caf", "proxyEJBs", "zgkb.com", "local", "prototypeVIII_Beta2", "zgkb.com", "local", "prototypeII", "sap.com", "caf", "BusinessObjectRuntimeServices", "zgkb.com", "local", "prototypeXV_Beta3", "sap.com", "caf", "CAFRuntime", "sap.com", "tc", "CBS", "sap.com", "local", "KS_EJB_1", "sap.com", "caf", "RIDDIC", "sap.com", "tc", "SL", "sap.com", "local", "KS_Ent_APP_4", "sap.com", "tc", "UIP", "sap.com", "tc", "bi", "sap.com", "tc", "TechSrv", "sap.com", "caf", "RIRuntime", "zgkb.com", "local", "prototypeXII_Beta2_Patch2", "zgkb.com", "local", "prototypeIII_Beta2", "sap.com", "caf", "BusinessObjectLayerDDIC", "sap.com", "caf", "RIServices", "zgkb.com", "local", "BusinessPartnerOne", "sap.com", "caf", "BusinessObjectLayerAssembly", "zgkb.com", "local", "prototypeXIV_Beta2_Patch2", "sap.com", "scm", "KS_Ent_App_1", "sap.com", "ess", "ESS_Homepage", "zgkb.com", "local", "prototypeIV_Beta2", "zgkb.com", "local", "printserverII", "zgkb.com", "local", "prototypeV_Beta2", "sap.com", "caf", "UI", "sap.com", "xapps", "fw", "sap.com", "tc", "samples", "sap.com", "scm", "ForTestDC", "sap.com", "caf", "BusinessObjectRuntime", "sap.com", "tc", "Tech", "zgkb.com", "local", "prototypeVI_Beta2", "sap.com", "caf", "BusinessObjectLayer", "sap.com", "caf", "DDIC", "sap.com", "tc", "sample", "sap.com", "caf", "BusinessObjectLayerServices", "sap.com", "caf", "Assembly", "sap.com", "scm", "WebViewManager"};
    private static final String[] devCompMixed4 = new String[]{"sap.com", "xapps", "fw", "ptnSearchbar", "sap.com", "tc", "bi", "webDynproGeneration", "sap.com", "tc", "bi", "dictionaryTypesDesigntime", "sap.com", "tc", "SL", "SDM", "sap.com", "tc", "UIP", "pilot2.1", "sap.com", "tc", "CBS", "WebUI", "sap.com", "tc", "sample", "wd", "sap.com", "bi", "mmr", "webApplicationProject", "sap.com", "bi", "mmr", "enterpriseApplicationProject", "sap.com", "tc", "bi", "dictionaryToolsGeneration", "sap.com", "tc", "TechSrv", "XML_DAS", "sap.com", "tc", "TechSrv", "XML_DAS_Schema", "sap.com", "tc", "Tech", "xlmversion", "sap.com", "xapps", "fw", "ui", "sap.com", "tc", "UIP", "services", "sap.com", "tc", "bi", "bp", "sap.com", "tc", "samples", "wd", "sap.com", "tc", "SL", "CMS", "sap.com", "tc", "bi", "metamodelDictionary", "sap.com", "tc", "bi", "metamodelCore", "sap.com", "tc", "UIP", "pilot", "sap.com", "bi", "mmr", "webProject", "sap.com", "tc", "bi", "dictionaryDatabase", "sap.com", "tc", "UIP", "docs", "sap.com", "tc", "bi", "generationFrameworkCore", "sap.com", "tc", "UIP", "config", "sap.com", "tc", "bi", "antTasks", "sap.com", "tc", "bi", "webDynproCheckLayer", "sap.com", "tc", "TechSrv", "XML_DAS_Init", "sap.com", "tc", "bi", "wdRun", "sap.com", "tc", "UIP", "eval", "sap.com", "tc", "bi", "metamodelWebDynpro"};
    private static final String[] devCompMixed5 = new String[]{"sap.com", "tc", "UIP", "eval", "d038055", "sap.com", "tc", "SL", "CMS", "IDEClient", "sap.com", "tc", "bi", "bp", "webDynpro", "sap.com", "tc", "UIP", "services", "slclient", "sap.com", "tc", "SL", "CMS", "DBO", "sap.com", "tc", "sample", "wd", "graphic", "sap.com", "tc", "sample", "wd", "tutorial", "sap.com", "tc", "SL", "CMS", "TCS", "sap.com", "tc", "UIP", "eval", "d030372", "sap.com", "tc", "UIP", "config", "oip", "sap.com", "tc", "samples", "wd", "demos", "sap.com", "tc", "SL", "CMS", "Util", "sap.com", "tc", "SL", "SDM", "SDM", "sap.com", "tc", "UIP", "pilot", "cfg", "sap.com", "tc", "SL", "CMS", "PCS", "sap.com", "xapps", "fw", "ui", "ptnObjectEditor", "sap.com", "tc", "bi", "bp", "javaLib", "sap.com", "tc", "UIP", "pilot2.1", "cfg", "sap.com", "tc", "SL", "CMS", "UI"};
    private static final String[] devCompMixed6 = new String[]{"sap.com", "tc", "UIP", "eval", "d030372", "Test1", "sap.com", "tc", "sample", "wd", "graphic", "Simple", "sap.com", "tc", "samples", "wd", "demos", "Book2Fly", "sap.com", "tc", "UIP", "eval", "d038055", "HelloWorldDC", "sap.com", "tc", "sample", "wd", "tutorial", "Hello_World", "sap.com", "tc", "UIP", "eval", "d030372", "WDComponentUser", "sap.com", "tc", "UIP", "eval", "d030372", "WDComponent", "sap.com", "tc", "UIP", "eval", "d030372", "Doc2", "sap.com", "tc", "UIP", "eval", "d030372", "WDModel", "sap.com", "tc", "UIP", "eval", "d030372", "Test2"};
    private static final String[][] devCompMixedList = new String[][]{devCompMixed1, devCompMixed2, devCompMixed3, devCompMixed4, devCompMixed5, devCompMixed6};
    private String correctPrefix = null;

    public void checkSyntax(CompoundName compoundName) throws NameSyntaxViolation {
        String secondComp;
        if (compoundName.size() < 1) {
            throw new NameSyntaxViolation("Empty development component name is not allowed");
        }
        int i = 1;
        while (i < compoundName.size()) {
            if (compoundName.get(i).length() < 1) {
                throw new NameSyntaxViolation("Empty name component (" + i + ") is not allowed, development component name = " + compoundName.toString());
            }
            ++i;
        }
        char firstChar = '\u0000';
        String firstComp = compoundName.get(0);
        if (firstComp.length() > 0) {
            firstChar = firstComp.charAt(0);
        } else if (compoundName.size() > 1 && (secondComp = compoundName.get(1)).length() > 0) {
            firstChar = secondComp.charAt(0);
        }
        if (Character.isDigit(firstChar)) {
            throw new NameSyntaxViolation("First character must not be a digit (" + firstChar + ") in development component name " + compoundName.toString());
        }
        String flatName = compoundName.toString();
        if (flatName.length() > 60) {
            throw new NameSyntaxViolation("DC name too long (max. of 60 characters): " + flatName);
        }
        this.checkLowerCaseWithExceptions(compoundName);
    }

    private void checkLowerCaseWithExceptions(CompoundName compoundName) throws NameSyntaxViolation {
        int foundLevel = this.scanExceptions(compoundName, 1);
        if (foundLevel > 0) {
            CompoundName restName;
            if (this.correctPrefix != null) {
                throw new NameSyntaxViolation("Wrong upper-/lowercase spelling, prefix must be " + this.correctPrefix);
            }
            if (compoundName.size() > foundLevel && !this.checkNameSpelledLowerCase(restName = (CompoundName)compoundName.getSuffix(foundLevel))) {
                throw new NameSyntaxViolation("Name suffix must be spelled lower case: " + restName.toString());
            }
        } else if (!this.checkNameSpelledLowerCase(compoundName)) {
            throw new NameSyntaxViolation("Name must be spelled lower case: " + compoundName.toString());
        }
    }

    private int scanExceptions(CompoundName compoundName, int ncomps) throws NameSyntaxViolation {
        if (ncomps <= 0) {
            return 0;
        }
        if (ncomps > compoundName.size()) {
            return ncomps - 1;
        }
        if (ncomps <= devCompMixedList.length) {
            if (this.foundMatchingException(devCompMixedList[ncomps - 1], ncomps, compoundName)) {
                return this.scanExceptions(compoundName, ncomps + 1);
            }
            return ncomps - 1;
        }
        return devCompMixedList.length;
    }

    private boolean foundMatchingException(String[] exceptions, int ncomps, CompoundName compoundName) throws NameSyntaxViolation {
        if (ncomps <= 0) {
            return false;
        }
        if (compoundName.size() < ncomps) {
            return false;
        }
        boolean foundHere = false;
        int i = 0;
        while (i < exceptions.length) {
            if (this.checkPrefixEqualsIgnoreCase(exceptions, i, ncomps, compoundName)) {
                if (this.checkPrefixEquals(exceptions, i, ncomps, compoundName)) {
                    this.correctPrefix = null;
                } else {
                    this.correctPrefix = "";
                    int j = 0;
                    while (j < ncomps) {
                        this.correctPrefix = this.correctPrefix + exceptions[i + j] + "/";
                        ++j;
                    }
                }
                foundHere = true;
            }
            i += ncomps;
        }
        return foundHere;
    }

    private boolean checkPrefixEqualsIgnoreCase(String[] exceptions, int index, int ncomps, CompoundName compoundName) {
        if (compoundName.size() < ncomps) {
            return false;
        }
        int i = 0;
        while (i < ncomps) {
            if (!exceptions[index + i].equalsIgnoreCase(compoundName.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean checkPrefixEquals(String[] exceptions, int index, int ncomps, CompoundName compoundName) {
        if (compoundName.size() < ncomps) {
            return false;
        }
        int i = 0;
        while (i < ncomps) {
            if (!exceptions[index + i].equals(compoundName.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean checkNameSpelledLowerCase(CompoundName compoundName) {
        int i = 0;
        while (i < compoundName.size()) {
            String comp = compoundName.get(i);
            if (!comp.equals(comp.toLowerCase())) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

