/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.namealloc;

import com.sap.lcr.namealloc.api.IExtendedSyntaxCheck;
import com.sap.lcr.namealloc.api.NameSyntaxViolation;
import javax.naming.CompoundName;

public class DesignTimePackageSyntaxChecker
implements IExtendedSyntaxCheck {
    public void checkSyntax(CompoundName compoundName) throws NameSyntaxViolation {
        String secondComp;
        if (compoundName.size() < 1) {
            throw new NameSyntaxViolation("Empty package name is not allowed");
        }
        int i = 0;
        while (i < compoundName.size()) {
            if (compoundName.get(i).length() < 1) {
                throw new NameSyntaxViolation("Empty name component (" + i + ") is not allowed, package name = " + compoundName.toString());
            }
            ++i;
        }
        char firstChar = '\u0000';
        String firstComp = compoundName.get(0);
        if (firstComp.length() > 0) {
            firstChar = firstComp.charAt(0);
        } else if (compoundName.size() > 1 && (secondComp = compoundName.get(1)).length() > 0) {
            firstChar = secondComp.charAt(0);
        }
        if (Character.isDigit(firstChar)) {
            throw new NameSyntaxViolation("First character must not be a digit (" + firstChar + ") in package name " + compoundName.toString());
        }
    }
}

