/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.namealloc;

import com.sap.lcr.namealloc.api.IExtendedSyntaxCheck;
import com.sap.lcr.namealloc.api.NameSyntaxViolation;
import javax.naming.CompoundName;

public class DBTableSyntaxChecker
implements IExtendedSyntaxCheck {
    private static final int MAX_NAME_LENGTH = 18;

    public void checkSyntax(CompoundName compoundName) throws NameSyntaxViolation {
        if (compoundName.size() < 1) {
            throw new NameSyntaxViolation("Empty table/index name is not allowed");
        }
        String flatName = compoundName.get(0);
        if (flatName.length() > 0) {
            char firstChar = flatName.charAt(0);
            if (Character.isDigit(firstChar)) {
                throw new NameSyntaxViolation("First character must not be a digit: " + firstChar);
            }
            if (flatName.length() > 18) {
                throw new NameSyntaxViolation("Table/Index name too long (max. of 18 characters): " + flatName);
            }
        } else {
            throw new NameSyntaxViolation("Empty Table/Index name not allowed");
        }
    }
}

