/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.namealloc;

import com.sap.lcr.namealloc.api.IExtendedSyntaxCheck;
import com.sap.lcr.namealloc.api.NameSyntaxViolation;
import javax.naming.CompoundName;

public class DBPoolSyntaxChecker
implements IExtendedSyntaxCheck {
    private static final int MAX_NAME_LENGTH = 32;

    public void checkSyntax(CompoundName compoundName) throws NameSyntaxViolation {
        if (compoundName.size() < 1) {
            throw new NameSyntaxViolation("Empty DB pool name is not allowed");
        }
        String flatName = compoundName.get(0);
        if (flatName.length() > 0) {
            char firstChar = flatName.charAt(0);
            if (Character.isDigit(firstChar)) {
                throw new NameSyntaxViolation("First character must not be a digit: " + firstChar);
            }
            if (flatName.length() > 32) {
                throw new NameSyntaxViolation("DB pool name too long (max. of 32 characters): " + flatName);
            }
        } else {
            throw new NameSyntaxViolation("Empty DB pool name not allowed");
        }
    }
}

