/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.designtime;

import com.sap.sql.types.CommonTypes;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class DtTypeInfo {
    private static HashSet builtInTypes = new HashSet();
    private static HashSet builtInTypesNumeric = new HashSet();
    private static HashMap jdbcTypesViaName = new HashMap();
    private static HashSet jdbcTypes = new HashSet();

    public static HashSet getBuiltInTypes() {
        return builtInTypes;
    }

    public static HashSet getBuiltInTypesNumeric() {
        return builtInTypesNumeric;
    }

    public static Set getSupportedJdbcTypes() {
        return jdbcTypesViaName.keySet();
    }

    public static HashMap getJdbcTypesViaName() {
        return jdbcTypesViaName;
    }

    public static ArrayList getJdbcTypesWithoutDefault() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("CLOB");
        list.add("BLOB");
        list.add("VARBINARY");
        list.add("BINARY");
        list.add("LONGVARCHAR");
        list.add("LONGVARBINARY");
        return list;
    }

    public static String getDefaultDefault(String jdbcTypeName) {
        if (jdbcTypeName.equalsIgnoreCase("SMALLINT")) {
            return "0";
        }
        if (jdbcTypeName.equalsIgnoreCase("INTEGER")) {
            return "0";
        }
        if (jdbcTypeName.equalsIgnoreCase("BIGINT")) {
            return "0";
        }
        if (jdbcTypeName.equalsIgnoreCase("DECIMAL")) {
            return "0";
        }
        if (jdbcTypeName.equalsIgnoreCase("REAL")) {
            return "0";
        }
        if (jdbcTypeName.equalsIgnoreCase("DOUBLE")) {
            return "0";
        }
        if (jdbcTypeName.equalsIgnoreCase("VARCHAR")) {
            return " ";
        }
        return "";
    }

    static {
        builtInTypes.add("string");
        builtInTypes.add("short");
        builtInTypes.add("integer");
        builtInTypes.add("long");
        builtInTypes.add("decimal");
        builtInTypes.add("float");
        builtInTypes.add("double");
        builtInTypes.add("boolean");
        builtInTypes.add("binary");
        builtInTypes.add("date");
        builtInTypes.add("time");
        builtInTypes.add("timestamp");
        builtInTypesNumeric.add("short");
        builtInTypesNumeric.add("integer");
        builtInTypesNumeric.add("long");
        builtInTypesNumeric.add("decimal");
        builtInTypesNumeric.add("float");
        builtInTypesNumeric.add("double");
        builtInTypesNumeric.add("binary");
        try {
            Class<?> types = Class.forName("java.sql.Types");
            Field[] fields = types.getFields();
            int i = 0;
            while (i < fields.length) {
                String name = fields[i].getName();
                int value = fields[i].getInt(types);
                if (CommonTypes.isFullySupported((int)value)) {
                    jdbcTypesViaName.put(name, new Integer(value));
                }
                ++i;
            }
        }
        catch (Exception ex) {
            jdbcTypes.add(CommonTypes.getJdbcTypeName((int)12));
            jdbcTypes.add(CommonTypes.getJdbcTypeName((int)-3));
            jdbcTypes.add(CommonTypes.getJdbcTypeName((int)-2));
            jdbcTypes.add(CommonTypes.getJdbcTypeName((int)5));
            jdbcTypes.add(CommonTypes.getJdbcTypeName((int)4));
            jdbcTypes.add(CommonTypes.getJdbcTypeName((int)-5));
            jdbcTypes.add(CommonTypes.getJdbcTypeName((int)8));
            jdbcTypes.add(CommonTypes.getJdbcTypeName((int)3));
            jdbcTypes.add(CommonTypes.getJdbcTypeName((int)91));
            jdbcTypes.add(CommonTypes.getJdbcTypeName((int)92));
            jdbcTypes.add(CommonTypes.getJdbcTypeName((int)93));
            jdbcTypes.add(CommonTypes.getJdbcTypeName((int)2005));
            jdbcTypes.add(CommonTypes.getJdbcTypeName((int)2004));
        }
    }
}

