/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.designtime;

import com.sap.dictionary.database.dbs.XmlMap;
import com.sap.dictionary.designtime.DtHelper;
import com.sap.dictionary.designtime.DtSimpleTypeExpanded;
import com.sap.dictionary.designtime.DtStructureColumnChecker;
import com.sap.dictionary.designtime.ErrTexts;
import com.sap.dictionary.designtime.ExpandException;
import com.sap.ide.metamodel.dictionary.datatype.DtField;
import com.sap.ide.metamodel.dictionary.datatype.DtGeneralStructure;
import com.sap.ide.metamodel.dictionary.datatype.DtSimpleType;
import java.io.PrintWriter;
import java.util.HashMap;

public class DtStructureColumnExpanded {
    DtSimpleTypeExpanded gSimpleType = null;
    String name = "";
    String backendName = "";
    String typeName = "";
    String backendTypeName = "";
    int position = 0;
    String builtInType = "";
    int length = 0;
    int decimals = 0;
    boolean referenceFieldExists = false;
    String referenceStructurePrefix = "";
    String referenceStructureName = "";
    String referenceFieldName = "";

    public DtStructureColumnExpanded(DtField dtField, int position) throws ExpandException {
        this.name = dtField.getName();
        this.backendName = dtField.getBackendName();
        this.position = position;
        this.builtInType = dtField.getBuiltInType();
        if (this.builtInType == null) {
            throw new ExpandException(ErrTexts.get("047"));
        }
        if (this.builtInType.equalsIgnoreCase("decimal")) {
            this.length = dtField.getTotalDigits();
            this.decimals = dtField.getFractionDigits();
        } else {
            this.length = dtField.getLength();
        }
        this.getReferencedFieldInfo(dtField);
    }

    public DtStructureColumnExpanded(DtField dtField, int position, DtSimpleType dtSimpleType) throws ExpandException {
        this.name = dtField.getName();
        this.backendName = dtField.getBackendName();
        this.position = position;
        this.gSimpleType = new DtSimpleTypeExpanded(dtSimpleType);
        if (!this.gSimpleType.isExpanded()) {
            throw new ExpandException(DtHelper.concat(ErrTexts.get("042"), this.gSimpleType.getName()));
        }
        String prefix = this.gSimpleType.getPrefix();
        this.typeName = this.gSimpleType.getName();
        if (prefix != "" && prefix != null) {
            this.typeName = prefix + "." + this.typeName;
        }
        this.backendTypeName = this.gSimpleType.getBackendName();
        this.builtInType = this.gSimpleType.getBuiltInType();
        if (this.builtInType.equalsIgnoreCase("string") || this.builtInType.equalsIgnoreCase("binary")) {
            if (this.gSimpleType.getLength() != 0) {
                this.length = this.gSimpleType.getLength();
            } else if (this.gSimpleType.getMaxLength() != 0) {
                this.length = this.gSimpleType.getMaxLength();
            }
        } else if (this.builtInType.equalsIgnoreCase("decimal")) {
            this.length = this.gSimpleType.getTotalDigits();
            this.decimals = this.gSimpleType.getFractionDigits();
        }
        this.getReferencedFieldInfo(dtField);
    }

    void getReferencedFieldInfo(DtField dtField) {
        DtField referenceField = dtField.getRefField();
        if (referenceField != null) {
            this.referenceStructureName = ((DtGeneralStructure)referenceField.getStructure()).getPackage() + "." + referenceField.getStructure().getName();
            this.referenceFieldName = referenceField.getName();
            this.referenceFieldExists = true;
        }
    }

    public String getName() {
        return this.name;
    }

    public String getBackendName() {
        return this.backendName;
    }

    public void setPosition(int pos) {
        this.position = pos;
    }

    public int getPosition() {
        return this.position;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getBackendTypeName() {
        return this.backendTypeName;
    }

    public String getBuiltInType() {
        return this.builtInType;
    }

    public boolean getEmbeddedTypeExists() {
        return false;
    }

    public DtSimpleTypeExpanded getEmbeddedSimpleType() {
        return new DtSimpleTypeExpanded();
    }

    public int getLength() {
        return this.length;
    }

    public int getDecimals() {
        return this.decimals;
    }

    public boolean getReferenceFieldExists() {
        return this.referenceFieldExists;
    }

    public String getReferenceStructureName() {
        return this.referenceStructureName;
    }

    public String getReferenceFieldName() {
        return this.referenceFieldName;
    }

    void writeToXmlFile(PrintWriter file, String offset0) {
        file.println(offset0 + "<column name=" + "\"" + this.name + "\"" + ">");
        String offset = offset0 + DtHelper.tabulate();
        file.println(offset + "<position>" + this.position + "</position>");
        file.println(offset + "<builtIn-type>" + this.builtInType + "</builtIn-type>");
        file.println(offset + "<length>" + this.length + "</length>");
        file.println(offset + "<decimals>" + this.decimals + "</decimals>");
        file.println(offset0 + "</column>");
    }

    public XmlMap getXmlMap() {
        XmlMap column = new XmlMap();
        column.put("name", this.name);
        column.put("position", Integer.toString(this.position));
        column.put("builtInType", this.builtInType);
        column.put("length", Integer.toString(this.length));
        column.put("decimals", Integer.toString(this.decimals));
        return column;
    }

    public boolean columnIsOk(HashMap messages) {
        DtStructureColumnChecker checker = new DtStructureColumnChecker(this, messages);
        return checker.nameIsOk() & checker.typeIsOk() & checker.decimalIsOk();
    }

    public boolean referenceFieldIsOk(HashMap messages, DtStructureColumnExpanded refField) {
        DtStructureColumnChecker checker = new DtStructureColumnChecker(this, messages);
        return checker.referenceFieldIsOk(refField);
    }

    public String toString() {
        String s = "";
        s = s + "  Fieldname      " + this.name + "\n" + "  Position       " + this.position + "\n" + "  Typename      " + this.getTypeName() + "\n" + "  DdType         " + this.builtInType + "\n" + "  Length         " + this.length + " \n" + "  Decimals       " + this.decimals;
        return s + "\n";
    }
}

