/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.designtime;

import com.sap.dictionary.designtime.DtHelper;
import com.sap.dictionary.designtime.DtStructureColumnExpanded;
import com.sap.dictionary.designtime.DtStructureExpanded;
import com.sap.dictionary.designtime.ErrTexts;
import com.sap.ide.metamodel.dictionary.datatype.DtStructure;
import com.sap.ide.metamodel.dictionary.datatype.DtStructureElement;
import java.util.ArrayList;
import java.util.HashMap;

public class DtStructureChecker {
    DtStructure structure = null;
    DtStructureExpanded expStructure = null;
    String name = null;
    static final int MAX_NAME_LENGTH = 18;
    HashMap mess = new HashMap();

    public DtStructureChecker() {
    }

    public DtStructureChecker(DtStructure structure) {
        this.structure = structure;
        this.name = structure.getName();
    }

    protected DtStructureChecker(DtStructure structure, DtStructureExpanded expStructure) {
        this.structure = structure;
        this.expStructure = expStructure;
        this.name = structure.getName();
    }

    protected void setExpStructure(DtStructureExpanded expStructure) {
        this.expStructure = expStructure;
    }

    public boolean nameIsOk() {
        String allowedCharacters = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_";
        String allowedAtFirstPosition = "ABCDEFGHIJKLMNOPQRSTUVWXYZ_";
        HashMap<String, String> messages = new HashMap<String, String>();
        int ch = 32;
        int i = 0;
        while (i < this.name.length()) {
            ch = this.name.toUpperCase().charAt(i);
            if (allowedCharacters.indexOf(ch) == -1) {
                messages.put(ErrTexts.get("029"), "Error");
            }
            ++i;
        }
        ch = this.name.toUpperCase().charAt(0);
        if (allowedAtFirstPosition.indexOf(ch) == -1) {
            messages.put(ErrTexts.get("030"), "Error");
        }
        if (messages.isEmpty()) {
            return true;
        }
        this.mess.putAll(messages);
        return false;
    }

    public boolean nameIsOk(String tableName) {
        this.name = tableName;
        return this.nameIsOk();
    }

    public boolean noDuplicateFields() {
        HashMap<String, String> messages = new HashMap<String, String>();
        if (this.expStructure == null) {
            this.expStructure = new DtStructureExpanded(this.structure, false);
        }
        ArrayList columns = this.expStructure.getColumnsAsList();
        HashMap checkFields = new HashMap();
        String fieldname = null;
        int i = 0;
        while (i < columns.size()) {
            fieldname = ((DtStructureColumnExpanded)columns.get(i)).getName();
            if (checkFields.put(fieldname, columns.get(i)) != null) {
                messages.put(DtHelper.concat(ErrTexts.get("104"), fieldname), "Error");
            }
            ++i;
        }
        if (messages.isEmpty()) {
            return true;
        }
        this.mess.putAll(messages);
        return false;
    }

    public boolean fieldsExist() {
        DtStructureElement[] columns = this.structure.getStructureElements();
        if (columns.length <= 0) {
            this.mess.put(ErrTexts.get("100"), "Error");
            return false;
        }
        return true;
    }

    public boolean fieldsAreOk() {
        HashMap messages = new HashMap();
        boolean totalErr = true;
        if (this.expStructure == null) {
            this.expStructure = new DtStructureExpanded(this.structure, false);
        }
        ArrayList columns = this.expStructure.getColumnsAsList();
        int i = 0;
        while (i < columns.size()) {
            boolean isOk = ((DtStructureColumnExpanded)columns.get(i)).columnIsOk(messages);
            if (!isOk) {
                totalErr = false;
            }
            ++i;
        }
        this.mess.putAll(messages);
        return totalErr;
    }

    public boolean referenceFieldsAreOk() {
        HashMap<String, String> messages = new HashMap<String, String>();
        boolean totalErr = true;
        if (this.expStructure == null) {
            this.expStructure = new DtStructureExpanded(this.structure, false);
        }
        ArrayList columns = this.expStructure.getColumnsAsList();
        HashMap columnsAsHash = this.expStructure.getColumns();
        int i = 0;
        while (i < columns.size()) {
            boolean isOk = true;
            DtStructureColumnExpanded column = (DtStructureColumnExpanded)columns.get(i);
            if (column.getReferenceFieldExists()) {
                String refFieldName = column.getReferenceFieldName();
                DtStructureColumnExpanded refColumn = (DtStructureColumnExpanded)columnsAsHash.get(refFieldName);
                isOk = column.referenceFieldIsOk(messages, refColumn);
                isOk = columnsAsHash.containsKey(column.getName());
                if (!isOk) {
                    messages.put(DtHelper.concat(ErrTexts.get("117"), column.getName(), refFieldName), "Error");
                }
            }
            if (!isOk) {
                totalErr = false;
            }
            ++i;
        }
        this.mess.putAll(messages);
        return totalErr;
    }

    public HashMap getMessages() {
        return this.mess;
    }
}

