/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.designtime;

import com.sap.dictionary.designtime.DdMapping;
import com.sap.dictionary.designtime.DtEnumerationValueExpanded;
import com.sap.dictionary.designtime.DtHelper;
import com.sap.dictionary.designtime.DtSimpleTypeChecker;
import com.sap.dictionary.designtime.DtTypeAttribute;
import com.sap.dictionary.designtime.DtTypeInfo;
import com.sap.dictionary.designtime.DtTypeInfoForDatabase;
import com.sap.dictionary.designtime.ErrTexts;
import com.sap.ide.metamodel.dictionary.datatype.BooleanEnum;
import com.sap.ide.metamodel.dictionary.datatype.DtDbProperty;
import com.sap.ide.metamodel.dictionary.datatype.DtDbTypeInfo;
import com.sap.ide.metamodel.dictionary.datatype.DtEnumerationValue;
import com.sap.ide.metamodel.dictionary.datatype.DtExternalRepresentation;
import com.sap.ide.metamodel.dictionary.datatype.DtHint;
import com.sap.ide.metamodel.dictionary.datatype.DtSchemaType;
import com.sap.ide.metamodel.dictionary.datatype.DtSimpleType;
import com.sap.ide.metamodel.dictionary.datatype.DtTechnicalInfo;
import com.sap.ide.metamodel.dictionary.datatype.DtTextObject;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.i18n.TextPool;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class DtSimpleTypeExpanded {
    private DtSimpleType currentType = null;
    private DtSimpleType baseType = null;
    private String typeKind = "SimpleType";
    private String typeName = "";
    private String typePrefix = "";
    private String backendTypeName = "";
    private String baseTypeName = "";
    private String baseTypePrefix = "";
    private DtTypeAttribute builtInType = new DtTypeAttribute("builtInType", "", false, "");
    private DtTypeAttribute length = new DtTypeAttribute("length", 0, false, "");
    private DtTypeAttribute minLength = new DtTypeAttribute("minLength", 0, false, "");
    private DtTypeAttribute maxLength = new DtTypeAttribute("maxLength", 0, false, "");
    private DtTypeAttribute minInclusive = new DtTypeAttribute("minInclusive", "", false, "");
    private DtTypeAttribute maxInclusive = new DtTypeAttribute("maxInclusive", "", false, "");
    private DtTypeAttribute minExclusive = new DtTypeAttribute("minExclusive", "", false, "");
    private DtTypeAttribute maxExclusive = new DtTypeAttribute("maxExclusive", "", false, "");
    private DtTypeAttribute totalDigits = new DtTypeAttribute("totalDigits", 0, false, "");
    private DtTypeAttribute fractionDigits = new DtTypeAttribute("fractionDigits", 0, false, "");
    private DtTypeAttribute pattern = new DtTypeAttribute("pattern", "", false, "");
    private ArrayList enumValues = new ArrayList();
    private HashMap enumValueTexts = new HashMap();
    private DtTypeAttribute enumeration = new DtTypeAttribute("enumeration", this.enumValues, false, "");
    private DtTypeAttribute format = new DtTypeAttribute("format", "", false, "");
    private DtTypeAttribute uppercase = new DtTypeAttribute("uppercase", false, false, "");
    private DtTypeAttribute readOnly = new DtTypeAttribute("readOnly", false, false, "");
    private DtTypeAttribute maxExternalLength = new DtTypeAttribute("maxExternalLength", 0, false, "");
    private DtTypeAttribute defaultValue = new DtTypeAttribute("defaultValue", "", false, "");
    private DtTypeAttribute translateFlag = new DtTypeAttribute("translateFlag", false, false, "");
    private DtTypeAttribute jdbcTypeName = new DtTypeAttribute("jdbcTypeName", "", false, "");
    private DtTypeAttribute notNull = new DtTypeAttribute("notNull", false, false, "");
    private DtTypeAttribute dbDefault = new DtTypeAttribute("dbDefault", "", false, "");
    HashMap typeInfoValues = new HashMap();
    private DtTypeAttribute typeInfo = new DtTypeAttribute("typeInfo", this.typeInfoValues, false, "");
    private HashMap descriptionValues = new HashMap();
    private DtTypeAttribute description = new DtTypeAttribute("description", this.descriptionValues, false, "");
    private HashMap fieldLabelValues = new HashMap();
    private DtTypeAttribute fieldLabel = new DtTypeAttribute("fieldLabel", this.fieldLabelValues, false, "");
    private HashMap columnLabelValues = new HashMap();
    private DtTypeAttribute columnLabel = new DtTypeAttribute("columnLabel", this.columnLabelValues, false, "");
    private HashMap quickInfoValues = new HashMap();
    private DtTypeAttribute quickInfo = new DtTypeAttribute("quickInfo", this.quickInfoValues, false, "");
    private DtTypeAttribute locale = new DtTypeAttribute("locale", "", false, "");
    private DtTypeAttribute mdoTexts = new DtTypeAttribute("mdoTexts", "", false, "");
    private DtTypeAttribute softwareLanguage = new DtTypeAttribute("softwareLanguage", "", false, "");
    private DtTypeAttribute languageDataType = new DtTypeAttribute("languageDataType", "", false, "");
    private ArrayList stack = new ArrayList();
    private HashMap allAttributes = new HashMap();
    private HashMap errorAttributes = new HashMap();
    private HashMap warningAttributes = new HashMap();
    private boolean expanded = false;
    private boolean check = true;
    private boolean externalRepresentationExists = false;
    private boolean dbPropertyExists = false;
    private boolean typeInfoExists = false;
    private boolean hintsExist = false;
    private boolean classRepresentationExists = false;
    private String rootName = "";
    private TextPool txtPool = null;
    private String className = "";

    public DtSimpleTypeExpanded() {
    }

    public DtSimpleTypeExpanded(DtSimpleType simpleType) {
        this.check = true;
        this.expand(simpleType);
    }

    public DtSimpleTypeExpanded(DtSimpleType simpleType, boolean check) {
        this.check = check;
        this.expand(simpleType);
    }

    private void expand(DtSimpleType simpleType) {
        this.typeName = simpleType.getName();
        this.typePrefix = simpleType.getPackage();
        this.backendTypeName = simpleType.getBackendName();
        this.builtInType.setValue(simpleType.getBuiltInType());
        this.allAttributes.put("builtInType", this.builtInType);
        this.allAttributes.put("length", this.length);
        this.allAttributes.put("minLength", this.minLength);
        this.allAttributes.put("maxLength", this.maxLength);
        this.allAttributes.put("minInclusive", this.minInclusive);
        this.allAttributes.put("maxInclusive", this.maxInclusive);
        this.allAttributes.put("minExclusive", this.minExclusive);
        this.allAttributes.put("maxExclusive", this.maxExclusive);
        this.allAttributes.put("totalDigits", this.totalDigits);
        this.allAttributes.put("fractionDigits", this.fractionDigits);
        this.allAttributes.put("pattern", this.pattern);
        this.allAttributes.put("format", this.format);
        this.allAttributes.put("uppercase", this.uppercase);
        this.allAttributes.put("translateFlag", this.translateFlag);
        this.allAttributes.put("readOnly", this.readOnly);
        this.allAttributes.put("maxExternalLength", this.maxExternalLength);
        this.allAttributes.put("defaultValue", this.defaultValue);
        this.allAttributes.put("jdbcTypeName", this.jdbcTypeName);
        this.allAttributes.put("notNull", this.notNull);
        this.allAttributes.put("dbDefault", this.dbDefault);
        this.allAttributes.put("description", this.description);
        this.allAttributes.put("fieldLabel", this.fieldLabel);
        this.allAttributes.put("columnLabel", this.columnLabel);
        this.allAttributes.put("quickInfo", this.quickInfo);
        this.allAttributes.put("locale", this.locale);
        this.allAttributes.put("softwareLanguage", this.softwareLanguage);
        this.allAttributes.put("languageDataType", this.languageDataType);
        this.currentType = simpleType;
        while (this.currentType != null) {
            this.baseType = this.currentType.getBaseType();
            this.stack.add(0, this.currentType);
            this.currentType = this.baseType;
        }
        while (!this.stack.isEmpty()) {
            this.currentType = (DtSimpleType)this.stack.remove(0);
            if (this.rootName.equalsIgnoreCase("")) {
                this.rootName = this.currentType.getName();
            }
            if (this.currentType == simpleType) {
                this.add(this.currentType);
            } else {
                this.add(this.currentType, false);
            }
            if (!this.expanded) break;
        }
        if (this.expanded) {
            this.setNoInheritedProperties(simpleType, this.builtInType.getStringValue());
        }
    }

    private boolean localCheck(DtSimpleType currentType) {
        DtDbProperty dbProperty;
        DtExternalRepresentation representation;
        Object errText = null;
        String simpleTypeName = currentType.getName();
        String builtInTypeName = currentType.getBuiltInType();
        if (builtInTypeName == null && currentType.getBaseTypeName() == null) {
            this.builtInType.setHasError(simpleTypeName);
            this.builtInType.setErrorText(ErrTexts.get("028"));
            this.errorAttributes.put("builtInType", this.builtInType);
            return false;
        }
        if (builtInTypeName == null) {
            builtInTypeName = this.builtInType.getStringValue();
        }
        if (!DtTypeInfo.getBuiltInTypes().contains(builtInTypeName)) {
            this.builtInType.setHasError(simpleTypeName);
            this.builtInType.setErrorText(DtHelper.concat(ErrTexts.get("008"), builtInTypeName));
            this.errorAttributes.put("builtInType", this.builtInType);
            return false;
        }
        int total = 0;
        int fraction = 0;
        int len = 0;
        int minLen = 0;
        int maxLen = 0;
        DtSchemaType schema = currentType.getSchemaType();
        if (schema != null) {
            total = schema.getTotalDigits();
            fraction = schema.getFractionDigits();
            String minIncl = schema.getMinInclusive();
            String maxIncl = schema.getMaxInclusive();
            String minExcl = schema.getMinExclusive();
            String maxExcl = schema.getMaxExclusive();
            DtSimpleTypeChecker.checkValidConstraintsPerType(this.length, builtInTypeName, schema.getLength(), simpleTypeName);
            DtSimpleTypeChecker.checkValidConstraintsPerType(this.minLength, builtInTypeName, schema.getMinLength(), simpleTypeName);
            DtSimpleTypeChecker.checkValidConstraintsPerType(this.maxLength, builtInTypeName, schema.getMaxLength(), simpleTypeName);
            DtSimpleTypeChecker.checkValidConstraintsPerType(this.minInclusive, builtInTypeName, schema.getMinInclusive(), simpleTypeName);
            DtSimpleTypeChecker.checkValidConstraintsPerType(this.maxInclusive, builtInTypeName, schema.getMaxInclusive(), simpleTypeName);
            DtSimpleTypeChecker.checkValidConstraintsPerType(this.minExclusive, builtInTypeName, schema.getMinExclusive(), simpleTypeName);
            DtSimpleTypeChecker.checkValidConstraintsPerType(this.maxExclusive, builtInTypeName, schema.getMaxExclusive(), simpleTypeName);
            DtSimpleTypeChecker.checkValidConstraintsPerType(this.totalDigits, builtInTypeName, schema.getTotalDigits(), simpleTypeName);
            DtSimpleTypeChecker.checkValidConstraintsPerType(this.fractionDigits, builtInTypeName, schema.getFractionDigits(), simpleTypeName);
            DtSimpleTypeChecker.checkValidConstraintsPerType(this.pattern, builtInTypeName, schema.getPattern(), simpleTypeName);
            DtEnumerationValue[] dtEnumerationValueArray = currentType.getSchemaType().getEnumerationValues();
            if (dtEnumerationValueArray.length > 0) {
                DtSimpleTypeChecker.checkValidConstraintsPerType(this.enumeration, builtInTypeName, schema.getEnumerationValues()[0].getValue(), simpleTypeName);
            }
            DtTypeAttribute min = null;
            String minValue = null;
            DtTypeAttribute max = null;
            String maxValue = null;
            if (DtSimpleTypeChecker.checkForDuplicateBorders(this.minInclusive, minIncl, this.minExclusive, minExcl, simpleTypeName) && DtSimpleTypeChecker.checkForDuplicateBorders(this.maxInclusive, maxIncl, this.maxExclusive, maxExcl, simpleTypeName)) {
                min = this.minInclusive;
                minValue = minIncl;
                if (minIncl == null || minIncl.equalsIgnoreCase("")) {
                    min = this.minExclusive;
                    minValue = minExcl;
                }
                max = this.maxInclusive;
                maxValue = maxIncl;
                if (maxIncl == null || maxIncl.equalsIgnoreCase("")) {
                    max = this.maxExclusive;
                    maxValue = maxExcl;
                }
                DtSimpleTypeChecker.checkMinMaxBorder(min, minValue, max, maxValue, simpleTypeName, builtInTypeName);
            }
            DtSimpleTypeChecker.checkStringFieldContent(this.minInclusive, builtInTypeName, schema.getMinInclusive(), simpleTypeName);
            DtSimpleTypeChecker.checkDecimalFormat(this.minInclusive, minIncl, total, fraction, builtInTypeName, simpleTypeName);
            DtSimpleTypeChecker.checkStringFieldContent(this.maxInclusive, builtInTypeName, schema.getMaxInclusive(), simpleTypeName);
            DtSimpleTypeChecker.checkDecimalFormat(this.maxInclusive, maxIncl, total, fraction, builtInTypeName, simpleTypeName);
            DtSimpleTypeChecker.checkStringFieldContent(this.minExclusive, builtInTypeName, schema.getMinExclusive(), simpleTypeName);
            DtSimpleTypeChecker.checkDecimalFormat(this.minExclusive, minExcl, total, fraction, builtInTypeName, simpleTypeName);
            DtSimpleTypeChecker.checkStringFieldContent(this.maxExclusive, builtInTypeName, schema.getMaxExclusive(), simpleTypeName);
            DtSimpleTypeChecker.checkDecimalFormat(this.maxExclusive, maxExcl, total, fraction, builtInTypeName, simpleTypeName);
            len = schema.getLength();
            minLen = schema.getMinLength();
            maxLen = schema.getMaxLength();
            DtSimpleTypeChecker.checkLengthAttributes(this.length, this.minLength, this.maxLength, len, minLen, maxLen, builtInTypeName, simpleTypeName);
            DtSimpleTypeChecker.checkDecimalAttributes(this.totalDigits, this.fractionDigits, total, fraction, builtInTypeName, simpleTypeName, this.rootName);
            DtSimpleTypeChecker.checkPattern(this.pattern);
            if (len <= 0) {
                len = this.length.getIntValue();
            }
            if (minLen <= 0) {
                minLen = this.minLength.getIntValue();
            }
            if (maxLen <= 0) {
                maxLen = this.maxLength.getIntValue();
            }
            DtEnumerationValue[] enumValues = schema.getEnumerationValues();
            String enumValue = null;
            if (enumValues.length > 0) {
                int i = 0;
                while (i < enumValues.length) {
                    enumValue = enumValues[i].getValue();
                    DtSimpleTypeChecker.checkStringFieldContent(this.enumeration, builtInTypeName, enumValue, simpleTypeName);
                    DtSimpleTypeChecker.checkDecimalFormat(this.enumeration, enumValue, total, fraction, builtInTypeName, simpleTypeName);
                    DtSimpleTypeChecker.checkStringValueLength(this.enumeration, builtInTypeName, enumValues[i].getValue(), len, minLen, maxLen, simpleTypeName);
                    ++i;
                }
            }
        }
        if ((representation = currentType.getExternalRepresentation()) != null) {
            DtSimpleTypeChecker.checkValidExtRepresentationsPerType(this.maxExternalLength, builtInTypeName, representation.getMaxExternalLength(), simpleTypeName);
            DtSimpleTypeChecker.checkValidExtRepresentationsPerType(this.uppercase, builtInTypeName, representation.getUppercase(), simpleTypeName);
            DtSimpleTypeChecker.checkValidExtRepresentationsPerType(this.readOnly, builtInTypeName, representation.getReadOnly(), simpleTypeName);
            DtSimpleTypeChecker.checkValidExtRepresentationsPerType(this.translateFlag, builtInTypeName, representation.getTranslateFlag(), simpleTypeName);
            DtSimpleTypeChecker.checkValidExtRepresentationsPerType(this.format, builtInTypeName, representation.getFormat(), simpleTypeName);
            DtSimpleTypeChecker.checkValidExtRepresentationsPerType(this.defaultValue, builtInTypeName, representation.getDefaultValue(), simpleTypeName);
            DtSimpleTypeChecker.checkStringFieldContent(this.defaultValue, builtInTypeName, representation.getDefaultValue(), simpleTypeName);
            DtSimpleTypeChecker.checkFormat(this.format, builtInTypeName, representation.getFormat(), simpleTypeName);
        }
        if ((dbProperty = currentType.getDbProperty()) != null) {
            String jdbcTypeNameString = dbProperty.getJdbcTypeName();
            if (dbProperty.getJdbcTypeName() != null) {
                if (!DtTypeInfo.getSupportedJdbcTypes().contains(jdbcTypeNameString) && !jdbcTypeNameString.equalsIgnoreCase("")) {
                    this.jdbcTypeName.setHasError(simpleTypeName);
                    this.jdbcTypeName.setErrorText(DtHelper.concat(ErrTexts.get("009"), jdbcTypeNameString));
                }
                if (DtTypeInfo.getJdbcTypesWithoutDefault().contains(jdbcTypeNameString) && dbProperty.getNotNull() == BooleanEnum.TRUE) {
                    this.notNull.setHasError(simpleTypeName);
                    this.notNull.setErrorText(DtHelper.concat(ErrTexts.get("041"), jdbcTypeNameString));
                }
            }
            if (dbProperty.getDbDefault() != null && !dbProperty.getDbDefault().equalsIgnoreCase("")) {
                String dbDefaultString;
                if (DtTypeInfo.getJdbcTypesWithoutDefault().contains(jdbcTypeNameString)) {
                    this.dbDefault.setErrorText(DtHelper.concat(ErrTexts.get("046"), jdbcTypeNameString));
                    this.dbDefault.setHasError(simpleTypeName);
                }
                if (!DtSimpleTypeChecker.checkDbDefaultContent(this.dbDefault, builtInTypeName, dbDefaultString = dbProperty.getDbDefault(), simpleTypeName)) {
                    this.dbDefault.setHasError(simpleTypeName);
                }
                DtSimpleTypeChecker.checkDecimalFormat(this.dbDefault, dbDefaultString, total, fraction, builtInTypeName, simpleTypeName);
                DtSimpleTypeChecker.checkStringValueLength(this.dbDefault, builtInTypeName, dbDefaultString, len, minLen, maxLen, simpleTypeName);
            }
        }
        DtHint[] hints = currentType.getHints();
        String stringValue = null;
        HashMap javaHints = null;
        if (hints != null) {
            int i = 0;
            while (i < hints.length) {
                stringValue = hints[i].getSoftwareLanguage();
                if (stringValue != null && stringValue.equalsIgnoreCase("java")) {
                    javaHints = DdMapping.getHints("java");
                    stringValue = hints[i].getLanguageDataType();
                    if (!((HashSet)javaHints.get(builtInTypeName)).contains(stringValue)) {
                        this.languageDataType.setHasError(simpleTypeName);
                        this.languageDataType.setErrorText(DtHelper.concat(ErrTexts.get("014"), stringValue, builtInTypeName));
                    }
                    this.hintsExist = true;
                }
                ++i;
            }
        }
        DtHelper.check((DevelopmentObject)currentType, this.mdoTexts);
        if (this.length.hasError()) {
            this.errorAttributes.put("length", this.length);
        }
        if (this.minLength.hasError()) {
            this.errorAttributes.put("minLength", this.minLength);
        }
        if (this.maxLength.hasError()) {
            this.errorAttributes.put("maxLength", this.maxLength);
        }
        if (this.totalDigits.hasError()) {
            this.errorAttributes.put("totalDigits", this.totalDigits);
        }
        if (this.fractionDigits.hasError()) {
            this.errorAttributes.put("fractionDigits", this.fractionDigits);
        }
        if (this.minInclusive.hasError()) {
            this.errorAttributes.put("minInclusive", this.minInclusive);
        }
        if (this.maxInclusive.hasError()) {
            this.errorAttributes.put("maxInclusive", this.maxInclusive);
        }
        if (this.minExclusive.hasError()) {
            this.errorAttributes.put("minExclusive", this.minExclusive);
        }
        if (this.maxExclusive.hasError()) {
            this.errorAttributes.put("maxExclusive", this.maxExclusive);
        }
        if (this.pattern.hasError()) {
            this.errorAttributes.put("pattern", this.pattern);
        }
        if (this.enumeration.hasError()) {
            this.errorAttributes.put("enumeration", this.enumeration);
        }
        if (this.maxExternalLength.hasError()) {
            this.errorAttributes.put("maxExternalLength", this.maxExternalLength);
        }
        if (this.format.hasError()) {
            this.errorAttributes.put("format", this.format);
        }
        if (this.uppercase.hasError()) {
            this.errorAttributes.put("uppercase", this.uppercase);
        }
        if (this.readOnly.hasError()) {
            this.errorAttributes.put("readOnly", this.readOnly);
        }
        if (this.translateFlag.hasError()) {
            this.errorAttributes.put("translateFlag", this.translateFlag);
        }
        if (this.defaultValue.hasError()) {
            this.errorAttributes.put("defaultValue", this.defaultValue);
        }
        if (this.jdbcTypeName.hasError()) {
            this.errorAttributes.put("jdbcTypeName", this.jdbcTypeName);
        }
        if (this.dbDefault.hasError()) {
            this.errorAttributes.put("dbDefault", this.dbDefault);
        }
        if (this.mdoTexts.hasError()) {
            this.errorAttributes.put("mdoTexts", this.mdoTexts);
        }
        if (this.mdoTexts.hasWarning()) {
            this.warningAttributes.put("mdoTexts", this.mdoTexts);
        }
        return this.errorAttributes.isEmpty();
    }

    private boolean globalCheck(DtSimpleType currentType) {
        DtExternalRepresentation representation;
        DtSchemaType schema;
        String simpleTypeName = currentType.getName();
        String builtInTypeName = currentType.getBuiltInType();
        String baseTypeName = currentType.getBaseTypeName();
        if (builtInTypeName == null && baseTypeName != null && (builtInTypeName = this.builtInType.getStringValue()) == null) {
            this.builtInType.setHasError(simpleTypeName);
            this.builtInType.setErrorText(ErrTexts.get("028"));
            this.errorAttributes.put("builtInType", this.builtInType);
            return false;
        }
        if (builtInTypeName != this.builtInType.getStringValue()) {
            this.builtInType.setHasError(simpleTypeName);
            this.builtInType.setErrorText(DtHelper.concat(ErrTexts.get("018"), this.builtInType.getStringValue()));
        }
        if ((schema = currentType.getSchemaType()) != null) {
            if (builtInTypeName.equalsIgnoreCase("string") || builtInTypeName.equalsIgnoreCase("binary")) {
                int len = schema.getLength();
                int minLen = schema.getMinLength();
                int maxLen = schema.getMaxLength();
                if (this.length.getIntValue() > 0 && (len <= 0 || len != this.length.getIntValue()) && len != 0) {
                    this.length.setHasError(simpleTypeName);
                    this.length.setErrorText(DtHelper.concat(ErrTexts.get("017"), "length"));
                }
                if (this.minLength.getIntValue() > 0 && (minLen <= 0 || minLen < this.minLength.getIntValue()) && minLen != 0) {
                    this.minLength.setHasError(simpleTypeName);
                    this.minLength.setErrorText(ErrTexts.get("037"));
                }
                if (this.maxLength.getIntValue() > 0 && (maxLen <= 0 || maxLen > this.maxLength.getIntValue()) && maxLen != 0) {
                    this.maxLength.setHasError(simpleTypeName);
                    this.maxLength.setErrorText(ErrTexts.get("038"));
                }
                if (minLen > 0 && this.length.getIntValue() > 0) {
                    this.minLength.setHasError(simpleTypeName);
                    this.minLength.setErrorText(DtHelper.concat(ErrTexts.get("039"), "minLength"));
                }
                if (maxLen > 0 && this.length.getIntValue() > 0) {
                    this.maxLength.setHasError(simpleTypeName);
                    this.maxLength.setErrorText(DtHelper.concat(ErrTexts.get("039"), "maxLength"));
                }
                if (len > 0 && (this.minLength.getIntValue() > 0 || this.minLength.getIntValue() > 0)) {
                    this.length.setHasError(simpleTypeName);
                    this.length.setErrorText(ErrTexts.get("040"));
                }
            }
            String minIncl = schema.getMinInclusive();
            String maxIncl = schema.getMaxInclusive();
            String minExcl = schema.getMinExclusive();
            String maxExcl = schema.getMaxExclusive();
            if (builtInTypeName.equalsIgnoreCase("decimal")) {
                if (this.totalDigits.getIntValue() > 0 && schema.getTotalDigits() != this.totalDigits.getIntValue() & schema.getTotalDigits() != 0) {
                    this.totalDigits.setHasError(simpleTypeName);
                    this.totalDigits.setErrorText(ErrTexts.get("021"));
                }
                if (this.totalDigits.getIntValue() > 0 && schema.getFractionDigits() != this.fractionDigits.getIntValue() & schema.getFractionDigits() != 0) {
                    this.fractionDigits.setHasError(simpleTypeName);
                    this.fractionDigits.setErrorText(ErrTexts.get("022"));
                }
                DtSimpleTypeChecker.checkDecimalFormat(this.minInclusive, minIncl, this.totalDigits.getIntValue(), this.fractionDigits.getIntValue(), builtInTypeName, simpleTypeName);
                DtSimpleTypeChecker.checkDecimalFormat(this.maxInclusive, maxIncl, this.totalDigits.getIntValue(), this.fractionDigits.getIntValue(), builtInTypeName, simpleTypeName);
                DtSimpleTypeChecker.checkDecimalFormat(this.minExclusive, minExcl, this.totalDigits.getIntValue(), this.fractionDigits.getIntValue(), builtInTypeName, simpleTypeName);
                DtSimpleTypeChecker.checkDecimalFormat(this.maxExclusive, maxExcl, this.totalDigits.getIntValue(), this.fractionDigits.getIntValue(), builtInTypeName, simpleTypeName);
            }
            if (schema.getMinInclusive() != null && schema.getMinInclusive().trim() != "") {
                DtSimpleTypeChecker.checkMinInExclusive(schema.getMinInclusive(), this.minInclusive.getStringValue(), this.minInclusive, simpleTypeName, builtInTypeName);
            }
            if (schema.getMinExclusive() != null && schema.getMinExclusive().trim() != "") {
                DtSimpleTypeChecker.checkMinInExclusive(schema.getMinExclusive(), this.minExclusive.getStringValue(), this.minExclusive, simpleTypeName, builtInTypeName);
            }
            if (schema.getMaxInclusive() != null && schema.getMaxInclusive().trim() != "") {
                DtSimpleTypeChecker.checkMaxInExclusive(schema.getMaxInclusive(), this.maxInclusive.getStringValue(), this.maxInclusive, simpleTypeName, builtInTypeName);
            }
            if (schema.getMaxExclusive() != null && schema.getMaxExclusive().trim() != "") {
                DtSimpleTypeChecker.checkMaxInExclusive(schema.getMaxExclusive(), this.maxExclusive.getStringValue(), this.maxExclusive, simpleTypeName, builtInTypeName);
            }
        }
        if ((representation = currentType.getExternalRepresentation()) != null && representation.getMaxExternalLength() != 0 && representation.getMaxExternalLength() != -1 && this.maxExternalLength.getIntValue() != 0 && representation.getMaxExternalLength() > this.maxExternalLength.getIntValue()) {
            this.maxExternalLength.setHasError(simpleTypeName);
            this.maxExternalLength.setErrorText(ErrTexts.get("023"));
        }
        if (schema != null) {
            DtEnumerationValue[] currentEnumValues = schema.getEnumerationValues();
            HashMap enumValues = this.enumeration.getEnumerationValues();
            if (currentEnumValues != null && enumValues != null && !enumValues.isEmpty()) {
                Object textValue = null;
                int i = 0;
                while (i < currentEnumValues.length) {
                    if (!enumValues.containsKey(currentEnumValues[i].getValue())) {
                        this.enumeration.setHasError(simpleTypeName);
                        this.enumeration.setErrorText(DtHelper.concat(ErrTexts.get("025"), currentEnumValues[i].getValue()));
                        break;
                    }
                    ++i;
                }
            }
        }
        if (this.length.hasError()) {
            this.errorAttributes.put("length", this.length);
        }
        if (this.minLength.hasError()) {
            this.errorAttributes.put("minLength", this.minLength);
        }
        if (this.maxLength.hasError()) {
            this.errorAttributes.put("maxLength", this.maxLength);
        }
        if (this.totalDigits.hasError()) {
            this.errorAttributes.put("totalDigits", this.totalDigits);
        }
        if (this.fractionDigits.hasError()) {
            this.errorAttributes.put("fractionDigits", this.fractionDigits);
        }
        if (this.minInclusive.hasError()) {
            this.errorAttributes.put("minInclusive", this.minInclusive);
        }
        if (this.maxInclusive.hasError()) {
            this.errorAttributes.put("maxInclusive", this.maxInclusive);
        }
        if (this.minExclusive.hasError()) {
            this.errorAttributes.put("minExclusive", this.minExclusive);
        }
        if (this.maxExclusive.hasError()) {
            this.errorAttributes.put("maxExclusive", this.maxExclusive);
        }
        if (this.pattern.hasError()) {
            this.errorAttributes.put("pattern", this.pattern);
        }
        if (this.enumeration.hasError()) {
            this.errorAttributes.put("enumeration", this.enumeration);
        }
        if (this.maxExternalLength.hasError()) {
            this.errorAttributes.put("maxExternalLength", this.maxExternalLength);
        }
        if (this.format.hasError()) {
            this.errorAttributes.put("format", this.format);
        }
        if (this.uppercase.hasError()) {
            this.errorAttributes.put("uppercase", this.uppercase);
        }
        if (this.readOnly.hasError()) {
            this.errorAttributes.put("readOnly", this.readOnly);
        }
        if (this.translateFlag.hasError()) {
            this.errorAttributes.put("translateFlag", this.translateFlag);
        }
        if (this.defaultValue.hasError()) {
            this.errorAttributes.put("defaultValue", this.defaultValue);
        }
        if (this.jdbcTypeName.hasError()) {
            this.errorAttributes.put("jdbcTypeName", this.jdbcTypeName);
        }
        if (this.dbDefault.hasError()) {
            this.errorAttributes.put("dbDefault", this.dbDefault);
        }
        return this.errorAttributes.isEmpty();
    }

    private void add(DtSimpleType currentType) {
        this.add(currentType, true);
    }

    private void add(DtSimpleType currentType, boolean localCheck) {
        DtHint[] hints;
        DtTextObject textObject;
        DtDbProperty dbProperty;
        DtExternalRepresentation extRepresentation;
        if (this.check) {
            boolean localCheckResult = true;
            if (localCheck) {
                localCheckResult = this.localCheck(currentType);
            }
            boolean globalCheckResult = this.globalCheck(currentType);
            this.expanded = localCheckResult && globalCheckResult;
        }
        this.baseTypePrefix = currentType.getBaseTypePrefix();
        this.baseTypeName = currentType.getBaseTypeName();
        String builtInTypeName = currentType.getBuiltInType();
        if (currentType.getBuiltInType() != null) {
            this.builtInType.setValue(currentType.getBuiltInType());
        }
        this.txtPool = currentType.getTextPool();
        String[] languages = this.txtPool.getAvailableLanguages();
        String stringValue = null;
        int numValue = 0;
        BooleanEnum boolValue = null;
        DtSchemaType schemaType = currentType.getSchemaType();
        if (schemaType != null) {
            DtEnumerationValue[] currentEnumValues;
            numValue = currentType.getSchemaType().getLength();
            if (numValue == -1) {
                this.length.setValue(0);
            } else if (numValue != 0) {
                this.length.setValue(numValue);
            }
            numValue = currentType.getSchemaType().getMinLength();
            if (numValue == -1) {
                this.minLength.setValue(0);
            } else if (numValue != 0) {
                this.minLength.setValue(numValue);
            }
            numValue = currentType.getSchemaType().getMaxLength();
            if (numValue == -1) {
                this.maxLength.setValue(0);
            } else if (numValue != 0) {
                this.maxLength.setValue(numValue);
            }
            stringValue = currentType.getSchemaType().getMinInclusive();
            if (stringValue != null) {
                this.minInclusive.setValue(stringValue);
            }
            if ((stringValue = currentType.getSchemaType().getMaxInclusive()) != null) {
                this.maxInclusive.setValue(stringValue);
            }
            if ((stringValue = currentType.getSchemaType().getMinExclusive()) != null) {
                this.minExclusive.setValue(stringValue);
            }
            if ((stringValue = currentType.getSchemaType().getMaxExclusive()) != null) {
                this.maxExclusive.setValue(stringValue);
            }
            if ((numValue = currentType.getSchemaType().getTotalDigits()) == -1) {
                this.totalDigits.setValue(0);
            } else if (numValue != 0) {
                this.totalDigits.setValue(numValue);
            }
            numValue = currentType.getSchemaType().getFractionDigits();
            if (numValue == -1) {
                this.fractionDigits.setValue(0);
            } else if (numValue != 0) {
                this.fractionDigits.setValue(numValue);
            }
            stringValue = currentType.getSchemaType().getPattern();
            if (stringValue != null) {
                this.pattern.setValue(stringValue);
            }
            if ((currentEnumValues = currentType.getSchemaType().getEnumerationValues()) != null && currentEnumValues.length > 0) {
                this.enumValues = new ArrayList();
                String textValue = null;
                int i = 0;
                while (i < currentEnumValues.length) {
                    stringValue = currentEnumValues[i].getValue();
                    if (stringValue != null) {
                        this.enumValueTexts = new HashMap();
                        textValue = currentEnumValues[i].getDescription();
                        if (textValue == null) {
                            textValue = "";
                        }
                        this.enumValueTexts.put("", textValue);
                        int j = 0;
                        while (j < languages.length) {
                            textValue = currentEnumValues[i].getDescription(languages[j]);
                            if (textValue == null) {
                                textValue = "";
                            }
                            this.enumValueTexts.put(languages[j], textValue);
                            ++j;
                        }
                        this.enumValues.add(new DtEnumerationValueExpanded(stringValue, this.enumValueTexts));
                    }
                    ++i;
                }
                this.enumeration.setEnumerationValuesAsList(this.enumValues);
            }
        }
        if ((extRepresentation = currentType.getExternalRepresentation()) != null) {
            stringValue = extRepresentation.getFormat();
            if (stringValue != null) {
                this.format.setValue(stringValue);
            }
            if ((boolValue = extRepresentation.getUppercase()) == BooleanEnum.TRUE) {
                this.uppercase.setValue(true);
            } else if (boolValue == BooleanEnum.FALSE) {
                this.uppercase.setValue(false);
            }
            boolValue = extRepresentation.getReadOnly();
            if (boolValue == BooleanEnum.TRUE) {
                this.readOnly.setValue(true);
            } else if (boolValue == BooleanEnum.FALSE) {
                this.readOnly.setValue(false);
            }
            numValue = extRepresentation.getMaxExternalLength();
            if (numValue == -1) {
                this.maxExternalLength.setValue(0);
            } else if (numValue != 0) {
                this.maxExternalLength.setValue(numValue);
            }
            stringValue = extRepresentation.getDefaultValue();
            if (stringValue != null) {
                this.defaultValue.setValue(stringValue);
            }
            if ((boolValue = extRepresentation.getTranslateFlag()) == BooleanEnum.TRUE) {
                this.translateFlag.setValue(true);
            } else if (boolValue == BooleanEnum.FALSE) {
                this.translateFlag.setValue(false);
            }
            this.externalRepresentationExists = true;
        }
        if ((dbProperty = currentType.getDbProperty()) != null) {
            stringValue = dbProperty.getJdbcTypeName();
            if (stringValue != null) {
                this.jdbcTypeName.setValue(stringValue);
            }
            if ((boolValue = dbProperty.getNotNull()) == BooleanEnum.TRUE) {
                this.notNull.setValue(true);
            } else if (boolValue == BooleanEnum.FALSE) {
                this.notNull.setValue(false);
            }
            if (stringValue != null && (stringValue.equalsIgnoreCase("CLOB") || stringValue.equalsIgnoreCase("BLOB"))) {
                this.notNull.setValue(false);
            }
            if ((stringValue = dbProperty.getDbDefault()) != null) {
                this.dbDefault.setValue(stringValue);
            }
            this.dbPropertyExists = true;
            DtDbTypeInfo[] currentTypeInfos = dbProperty.getTypeInfos();
            if (currentTypeInfos != null) {
                int i = 0;
                while (i < currentTypeInfos.length) {
                    stringValue = currentTypeInfos[i].getDatabase().toString();
                    DtTypeInfoForDatabase typeInfoForDb = null;
                    if (stringValue != null) {
                        typeInfoForDb = new DtTypeInfoForDatabase(stringValue, currentTypeInfos[i].getJdbcTypeName(), currentTypeInfos[i].getDatabaseTypeName());
                        this.typeInfoValues.put(stringValue, typeInfoForDb);
                    }
                    ++i;
                }
                this.typeInfoExists = true;
                this.typeInfo.setEnumerationValues(this.typeInfoValues);
            }
        }
        if ((textObject = currentType.getTexts()) != null) {
            stringValue = textObject.getDescription();
            if (stringValue != null) {
                this.descriptionValues.put("", stringValue);
            }
            if ((stringValue = textObject.getFieldLabel()) != null) {
                this.fieldLabelValues.put("", stringValue);
            }
            if ((stringValue = textObject.getColumnLabel()) != null) {
                this.columnLabelValues.put("", stringValue);
            }
            if ((stringValue = textObject.getQuickInfo()) != null) {
                this.quickInfoValues.put("", stringValue);
            }
            if ((stringValue = textObject.getLocale()) != null) {
                this.locale.setValue(stringValue);
            }
            String language = null;
            int i = 0;
            while (i <= languages.length - 1) {
                language = languages[i];
                stringValue = textObject.getDescription(language);
                if (stringValue != null) {
                    this.descriptionValues.put(language, stringValue);
                }
                if ((stringValue = textObject.getFieldLabel(language)) != null) {
                    this.fieldLabelValues.put(language, stringValue);
                }
                if ((stringValue = textObject.getColumnLabel(language)) != null) {
                    this.columnLabelValues.put(language, stringValue);
                }
                if ((stringValue = textObject.getQuickInfo(language)) != null) {
                    this.quickInfoValues.put(language, stringValue);
                }
                ++i;
            }
            this.description.setEnumerationValues(this.descriptionValues);
            this.fieldLabel.setEnumerationValues(this.fieldLabelValues);
            this.columnLabel.setEnumerationValues(this.columnLabelValues);
            this.quickInfo.setEnumerationValues(this.quickInfoValues);
        }
        if ((hints = currentType.getHints()) != null) {
            int i = 0;
            while (i < hints.length) {
                stringValue = hints[i].getSoftwareLanguage();
                if (stringValue != null && stringValue.equalsIgnoreCase("java")) {
                    this.softwareLanguage.setValue(stringValue);
                    stringValue = hints[i].getLanguageDataType();
                    this.languageDataType.setValue(stringValue);
                }
                this.hintsExist = true;
                ++i;
            }
        }
        if (!this.check) {
            this.expanded = true;
        }
    }

    public String getRawLanguage() {
        return "";
    }

    public String getTypeKind() {
        return this.typeKind;
    }

    public String getPrefix() {
        return this.typePrefix;
    }

    public String getName() {
        return this.typeName;
    }

    public String getBackendName() {
        return this.backendTypeName;
    }

    public String getBuiltInType() {
        return this.builtInType.getStringValue();
    }

    public int getLength() {
        return this.length.getIntValue();
    }

    public int getMinLength() {
        return this.minLength.getIntValue();
    }

    public int getMaxLength() {
        return this.maxLength.getIntValue();
    }

    public String getMinInclusive() {
        return this.minInclusive.getStringValue();
    }

    public String getMaxInclusive() {
        return this.maxInclusive.getStringValue();
    }

    public String getMinExclusive() {
        return this.minExclusive.getStringValue();
    }

    public String getMaxExclusive() {
        return this.maxExclusive.getStringValue();
    }

    public int getTotalDigits() {
        return this.totalDigits.getIntValue();
    }

    public int getFractionDigits() {
        return this.fractionDigits.getIntValue();
    }

    public String getPattern() {
        return this.pattern.getStringValue();
    }

    public String getFormat() {
        return this.format.getStringValue();
    }

    public boolean getReadOnly() {
        return this.readOnly.getBooleanValue();
    }

    public boolean getTranslateFlag() {
        return this.translateFlag.getBooleanValue();
    }

    public boolean getUppercase() {
        return this.uppercase.getBooleanValue();
    }

    public int getMaxExternalLength() {
        return this.maxExternalLength.getIntValue();
    }

    public String getDefaultValue() {
        if (this.builtInType.getStringValue().equalsIgnoreCase("string")) {
            return DtHelper.removeTrailingSpaces(this.defaultValue.getStringValue());
        }
        return this.defaultValue.getStringValue();
    }

    public String getJdbcTypeName() {
        return this.jdbcTypeName.getStringValue();
    }

    public boolean getNotNull() {
        return this.notNull.getBooleanValue();
    }

    public String getDbDefault() {
        return this.dbDefault.getStringValue();
    }

    public HashMap getTypeInfos() {
        return this.typeInfo.getEnumerationValues();
    }

    public String getMasterLanguage() {
        return this.txtPool.getMasterLanguage();
    }

    public String getDescription(String language) {
        String descr = (String)this.description.getEnumerationValues().get(language);
        if (descr == null) {
            return "";
        }
        return DtHelper.escapeXML(descr);
    }

    public String getDescription() {
        return this.getDescription("");
    }

    public String getDescriptionForResource(String language) {
        String descr = (String)this.description.getEnumerationValues().get(language);
        if (descr == null) {
            return "";
        }
        return DtHelper.escapePropertyFileChar(descr);
    }

    public String getColumnLabel(String language) {
        String label = (String)this.columnLabel.getEnumerationValues().get(language);
        if (label == null) {
            return "";
        }
        return DtHelper.escapeXML(label);
    }

    public String getColumnLabel() {
        return this.getColumnLabel("");
    }

    public String getColumnLabelForResource(String language) {
        String label = (String)this.columnLabel.getEnumerationValues().get(language);
        if (label == null) {
            return "";
        }
        return DtHelper.escapePropertyFileChar(label);
    }

    public String getQuickInfo(String language) {
        String info = (String)this.quickInfo.getEnumerationValues().get(language);
        if (info == null) {
            return "";
        }
        return DtHelper.escapeXML(info);
    }

    public String getQuickInfo() {
        return this.getQuickInfo("");
    }

    public String getQuickInfoForResource(String language) {
        String info = (String)this.quickInfo.getEnumerationValues().get(language);
        if (info == null) {
            return "";
        }
        return DtHelper.escapePropertyFileChar(info);
    }

    public String getFieldLabel(String language) {
        String label = (String)this.fieldLabel.getEnumerationValues().get(language);
        if (label == null) {
            return "";
        }
        return DtHelper.escapeXML(label);
    }

    public String getFieldLabel() {
        return this.getFieldLabel("");
    }

    public String getFieldLabelForResource(String language) {
        String label = (String)this.fieldLabel.getEnumerationValues().get(language);
        if (label == null) {
            return "";
        }
        return DtHelper.escapePropertyFileChar(label);
    }

    public String getLocale() {
        return this.locale.getStringValue();
    }

    public String getSoftwareLanguage() {
        return this.softwareLanguage.getStringValue();
    }

    public String getLanguageDataType() {
        return this.languageDataType.getStringValue();
    }

    public ArrayList getEnumerationValues(String language) {
        ArrayList arrayList = this.enumeration.getEnumerationValuesAsList();
        ArrayList<DtEnumerationValueExpanded> enumValuesPerLanguage = new ArrayList<DtEnumerationValueExpanded>();
        String type = this.builtInType.getStringValue();
        Object enumValue = null;
        String enumValueString = null;
        int i = 0;
        DtEnumerationValueExpanded currEntry = null;
        while (i < arrayList.size()) {
            currEntry = (DtEnumerationValueExpanded)arrayList.get(i);
            enumValueString = currEntry.getValue();
            if (type.equalsIgnoreCase("string")) {
                enumValueString = DtHelper.escapeXML(enumValueString);
            } else if (type.equalsIgnoreCase("short")) {
                enumValue = new Short(enumValueString);
            } else if (type.equalsIgnoreCase("integer")) {
                enumValue = new Integer(enumValueString);
            } else if (type.equalsIgnoreCase("long")) {
                enumValue = new Long(enumValueString);
            } else if (type.equalsIgnoreCase("float")) {
                enumValue = new Float(enumValueString);
            } else if (type.equalsIgnoreCase("double")) {
                enumValue = new Double(enumValueString);
            } else if (type.equalsIgnoreCase("decimal")) {
                enumValue = new BigDecimal(enumValueString);
            } else if (type.equalsIgnoreCase("date")) {
                try {
                    enumValue = DtHelper.getDateFormatter().parse(enumValueString);
                }
                catch (ParseException ex) {
                    enumValue = enumValueString;
                }
            } else if (type.equalsIgnoreCase("time")) {
                try {
                    enumValue = DtHelper.getTimeFormatter().parse(enumValueString);
                }
                catch (ParseException ex) {
                    enumValue = enumValueString;
                }
            } else if (type.equalsIgnoreCase("timestamp")) {
                try {
                    enumValue = DtHelper.getTimestampFormatter().parse(enumValueString);
                }
                catch (ParseException ex) {
                    enumValue = enumValueString;
                }
            } else {
                enumValue = enumValueString;
            }
            String text = (String)currEntry.getTexts().get(language);
            if (text == null) {
                text = "";
            }
            enumValuesPerLanguage.add(new DtEnumerationValueExpanded(enumValueString, DtHelper.escapeXML(text.trim())));
            ++i;
        }
        return enumValuesPerLanguage;
    }

    public ArrayList getEnumerationValues() {
        return this.getEnumerationValues("");
    }

    public TreeMap getEnumerationValuesForResource(String language) {
        ArrayList arrayList = this.enumeration.getEnumerationValuesAsList();
        TreeMap<String, String> enumValuesPerLanguage = new TreeMap<String, String>();
        String type = this.builtInType.getStringValue();
        Object enumValue = null;
        String enumValueString = null;
        DtEnumerationValueExpanded currEntry = null;
        int i = 0;
        while (i < arrayList.size()) {
            currEntry = (DtEnumerationValueExpanded)arrayList.get(i);
            enumValueString = currEntry.getValue();
            if (type.equalsIgnoreCase("string")) {
                enumValueString = DtHelper.escapePropertyFileChar(enumValueString);
            } else if (type.equalsIgnoreCase("short")) {
                enumValue = new Short(enumValueString);
            } else if (type.equalsIgnoreCase("integer")) {
                enumValue = new Integer(enumValueString);
            } else if (type.equalsIgnoreCase("long")) {
                enumValue = new Long(enumValueString);
            } else if (type.equalsIgnoreCase("float")) {
                enumValue = new Float(enumValueString);
            } else if (type.equalsIgnoreCase("double")) {
                enumValue = new Double(enumValueString);
            } else if (type.equalsIgnoreCase("decimal")) {
                enumValue = new BigDecimal(enumValueString);
            } else if (type.equalsIgnoreCase("date")) {
                try {
                    enumValue = DtHelper.getDateFormatter().parse(enumValueString);
                }
                catch (ParseException ex) {
                    enumValue = enumValueString;
                }
            } else if (type.equalsIgnoreCase("time")) {
                try {
                    enumValue = DtHelper.getTimeFormatter().parse(enumValueString);
                }
                catch (ParseException ex) {
                    enumValue = enumValueString;
                }
            } else if (type.equalsIgnoreCase("timestamp")) {
                try {
                    enumValue = DtHelper.getTimestampFormatter().parse(enumValueString);
                }
                catch (ParseException ex) {
                    enumValue = enumValueString;
                }
            } else {
                enumValue = enumValueString;
            }
            String text = (String)currEntry.getTexts().get(language);
            if (text == null) {
                text = "";
            }
            enumValuesPerLanguage.put(enumValueString, DtHelper.escapePropertyFileChar(text.trim()));
            ++i;
        }
        return enumValuesPerLanguage;
    }

    protected void printlnStack() {
        Iterator iter = ((AbstractList)this.stack).iterator();
        while (iter.hasNext()) {
            System.out.println(((DtSimpleType)iter.next()).getName());
        }
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public ArrayList getErrorMessages() {
        ArrayList<String> errMess = new ArrayList<String>();
        if (this.expanded) {
            return errMess;
        }
        errMess.add("Simple type " + this.typePrefix + "." + this.typeName + "  is not generated \n");
        String ttext = "";
        Set errs = this.errorAttributes.entrySet();
        Iterator it = errs.iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            DtTypeAttribute attr = (DtTypeAttribute)entry.getValue();
            HashSet et = (HashSet)attr.getErrorTexts();
            Iterator iet = et.iterator();
            ttext = "";
            while (iet.hasNext()) {
                ttext = ttext + iet.next() + " ";
            }
            errMess.add(entry.getKey() + ": " + ttext + "; ");
        }
        return errMess;
    }

    public ArrayList getWarningMessages() {
        ArrayList<String> warningMess = new ArrayList<String>();
        Set warnings = this.warningAttributes.entrySet();
        if (warnings.isEmpty()) {
            return warningMess;
        }
        warningMess.add("Simple type " + this.typePrefix + "." + this.typeName + "  is generated with warnings \n");
        String ttext = "";
        Iterator it = warnings.iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            DtTypeAttribute attr = (DtTypeAttribute)entry.getValue();
            HashSet et = (HashSet)attr.getWarningTexts();
            Iterator iet = et.iterator();
            ttext = "";
            while (iet.hasNext()) {
                ttext = ttext + iet.next() + " ";
            }
            warningMess.add(entry.getKey() + ": " + ttext + "; ");
        }
        return warningMess;
    }

    public ArrayList getInfoMessages() {
        return new ArrayList();
    }

    public String toString() {
        String s = this.typeKind + ": " + this.typePrefix + "." + this.typeName + "\n" + "\n";
        if (this.baseTypePrefix != null && this.baseTypeName != null) {
            s = s + "baseType:" + this.baseTypePrefix + "." + this.baseTypeName + "\n";
        }
        s = s + "Schema-Information: " + "\n" + "   builtInType    : " + this.builtInType.getStringValue() + "\n" + "   length         : " + this.length.getIntValue() + "\n" + "   minLength      : " + this.minLength.getIntValue() + "\n" + "   maxLength      : " + this.maxLength.getIntValue() + "\n" + "   minInclusive   : " + this.minInclusive.getStringValue() + "\n" + "   maxInclusive   : " + this.maxInclusive.getStringValue() + "\n" + "   minExclusive   : " + this.minExclusive.getStringValue() + "\n" + "   maxExclusive   : " + this.maxExclusive.getStringValue() + "\n" + "   totalDigits    : " + this.totalDigits.getIntValue() + "\n" + "   fractionDigits : " + this.fractionDigits.getIntValue() + "\n" + "   pattern        : " + this.pattern.getStringValue() + "\n" + "ExternalRepresentation:" + "\n" + "   format           :" + this.format.getStringValue() + "\n" + "   uppercase        :" + this.uppercase.getBooleanValue() + "\n" + "   translateFlag    :" + this.translateFlag.getBooleanValue() + "\n" + "   readOnly         :" + this.readOnly.getBooleanValue() + "\n" + "   maxExternalLength:" + this.maxExternalLength.getIntValue() + "\n" + "   defaultValue     :" + this.defaultValue.getStringValue() + "\n" + "DbProperty:" + "\n" + "   jdbcType :" + this.jdbcTypeName.getStringValue() + "\n" + "   notNull  :" + this.notNull.getBooleanValue() + "\n" + "   dbDefault:" + this.dbDefault.getStringValue() + "\n" + "Texts:" + "\n" + "   description:" + this.description.getStringValue() + "\n" + "   fieldLabel :" + this.fieldLabel.getStringValue() + "\n" + "   columnLabel:" + this.columnLabel.getStringValue() + "\n" + "   quickInfo  :" + this.quickInfo.getStringValue() + "\n" + "   locale     :" + this.locale.getStringValue() + "\n" + "Hints:" + "\n" + "   softwareLanguage:" + this.softwareLanguage.getStringValue() + "\n" + "   languageDatatype:" + this.languageDataType.getStringValue() + "\n" + "Enumeration:" + "\n";
        ArrayList enumValues = this.enumeration.getEnumerationValuesAsList();
        String key = "";
        String value = "";
        if (!enumValues.isEmpty()) {
            int i = 0;
            while (i < enumValues.size()) {
                DtEnumerationValueExpanded enumEntry = (DtEnumerationValueExpanded)enumValues.get(i);
                key = enumEntry.getValue();
                value = value + key + " " + enumEntry.getTexts().get("") + "\n";
                ++i;
            }
        }
        return s + value;
    }

    public boolean getEnumerationExists() {
        return this.enumeration.getEnumerationValuesAsList() != null && !this.enumeration.getEnumerationValuesAsList().isEmpty();
    }

    public boolean getSchemaTypeExists() {
        if (this.length.getIntValue() > 0) {
            return true;
        }
        if (this.minLength.getIntValue() > 0) {
            return true;
        }
        if (this.maxLength.getIntValue() > 0) {
            return true;
        }
        String stringValue = this.minInclusive.getStringValue();
        if (stringValue != null && !stringValue.trim().equalsIgnoreCase("")) {
            return true;
        }
        stringValue = this.maxInclusive.getStringValue();
        if (stringValue != null && !stringValue.trim().equalsIgnoreCase("")) {
            return true;
        }
        stringValue = this.minExclusive.getStringValue();
        if (stringValue != null && !stringValue.trim().equalsIgnoreCase("")) {
            return true;
        }
        stringValue = this.maxExclusive.getStringValue();
        if (stringValue != null && !stringValue.trim().equalsIgnoreCase("")) {
            return true;
        }
        if (this.totalDigits.getIntValue() > 0) {
            return true;
        }
        if (this.fractionDigits.getIntValue() > 0) {
            return true;
        }
        stringValue = this.pattern.getStringValue();
        return stringValue != null && !stringValue.trim().equalsIgnoreCase("");
    }

    public boolean getDbPropertyExists() {
        return this.dbPropertyExists;
    }

    public boolean getTypeInfoExists() {
        return this.typeInfoExists;
    }

    public boolean getExternalRepresentationExists() {
        return this.externalRepresentationExists;
    }

    public boolean getHintsExist() {
        return this.hintsExist;
    }

    public boolean getTextsExist() {
        HashMap textValues = null;
        textValues = this.description.getEnumerationValues();
        if (textValues != null && !textValues.isEmpty()) {
            return true;
        }
        textValues = this.fieldLabel.getEnumerationValues();
        if (textValues != null && !textValues.isEmpty()) {
            return true;
        }
        textValues = this.columnLabel.getEnumerationValues();
        if (textValues != null && !textValues.isEmpty()) {
            return true;
        }
        textValues = this.quickInfo.getEnumerationValues();
        return textValues != null && !textValues.isEmpty();
    }

    public boolean getTextsExist(String language) {
        String stringValue = null;
        stringValue = (String)this.description.getEnumerationValues().get(language);
        return stringValue != null && !stringValue.equalsIgnoreCase("");
    }

    private void setNoInheritedProperties(DtSimpleType simpleType, String builtInType) {
        if (builtInType == null || !builtInType.equalsIgnoreCase("string")) {
            return;
        }
        DtTechnicalInfo info = simpleType.getTechnicalInfo();
        if (info != null && info.getWithClass()) {
            this.softwareLanguage.setValue("java");
            String name = simpleType.getName();
            String packageName = simpleType.getPackage();
            packageName = packageName == null || packageName.equals("") ? "" : packageName + ".";
            this.className = packageName + name.substring(0, 1).toUpperCase() + name.substring(1, name.length());
            this.languageDataType.setValue(this.className);
            this.hintsExist = true;
            this.classRepresentationExists = true;
        }
    }

    public static HashMap getHintInfo(DtSimpleType simpleType) {
        DtTechnicalInfo info = simpleType.getTechnicalInfo();
        if (info != null) {
            HashMap<String, String> hints = new HashMap<String, String>();
            String name = simpleType.getName();
            String packageName = simpleType.getPackage();
            packageName = packageName == null || packageName.equals("") ? "" : packageName + ".";
            String className = packageName + name.substring(0, 1).toUpperCase() + name.substring(1, name.length());
            hints.put("java", className);
            return hints;
        }
        return null;
    }

    public String getClassName() {
        return this.className;
    }

    public boolean getClassRepresentationExists() {
        return this.classRepresentationExists;
    }
}

