/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.designtime;

import com.sap.dictionary.designtime.DtHelper;
import com.sap.dictionary.designtime.DtTypeAttribute;
import com.sap.dictionary.designtime.DtTypeInfo;
import com.sap.dictionary.designtime.ErrTexts;
import com.sap.ide.metamodel.dictionary.datatype.BooleanEnum;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class DtSimpleTypeChecker {
    private static final HashMap constraintsPerTypes = new HashMap();
    private static final HashSet numericConstraints = new HashSet<String>(Arrays.asList("minInclusive", "maxInclusive", "minExclusive", "maxExclusive", "pattern", "enumeration"));
    private static final HashSet nonNumericConstraints = new HashSet<String>(Arrays.asList("length", "minLength", "maxLength", "pattern", "enumeration"));
    private static final HashSet constraints = new HashSet();
    private static final HashMap typesPerConstraints = new HashMap();
    private static final HashSet typeSet1 = new HashSet<String>(Arrays.asList("string", "binary"));
    private static final HashSet typeSet2 = new HashSet<String>(Arrays.asList("string", "byte", "short", "integer", "long", "decimal", "float", "double", "binary", "date", "time", "timestamp"));
    private static final HashSet typeSet3 = new HashSet<String>(Arrays.asList("byte", "short", "integer", "long", "decimal", "float", "double", "date", "time", "timestamp"));
    private static final HashSet typeSet4 = new HashSet<String>(Arrays.asList("decimal"));
    private static final HashMap representationsPerTypes = new HashMap();
    private static final HashSet representationSet1 = new HashSet<String>(Arrays.asList("maxExternalLength", "uppercase", "readOnly", "format", "translateFlag"));
    private static final HashSet representationSet2 = new HashSet<String>(Arrays.asList("maxExternalLength", "format", "readOnly"));
    private static final HashSet representationSet3 = new HashSet<String>(Arrays.asList("format", "readOnly"));
    private static final HashMap typesPerRepresentations = new HashMap();
    private static final HashSet typeSet5 = new HashSet<String>(Arrays.asList("string"));
    private static final HashSet typeSet6 = new HashSet<String>(Arrays.asList("string", "byte", "short", "integer", "long", "decimal", "binary"));
    private static final HashSet typeSet7 = new HashSet<String>(Arrays.asList("string", "short", "integer", "long", "decimal", "float", "double", "binary", "boolean", "date", "time", "timestamp"));

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean checkStringFieldContent(DtTypeAttribute attribute, String builtInTypeName, String value, String typeName) {
        if (value == null || value.equalsIgnoreCase("")) return true;
        if (DtTypeInfo.getBuiltInTypesNumeric().contains(builtInTypeName)) {
            try {
                if (builtInTypeName.equalsIgnoreCase("short")) {
                    Short shortObject = new Short(value);
                }
                if (builtInTypeName.equalsIgnoreCase("integer")) {
                    Integer integerObject = new Integer(value);
                }
                if (builtInTypeName.equalsIgnoreCase("long")) {
                    Long longObject = new Long(value);
                }
                if (builtInTypeName.equalsIgnoreCase("decimal")) {
                    BigDecimal decimalObject = new BigDecimal(value);
                }
                if (!builtInTypeName.equalsIgnoreCase("float") && !builtInTypeName.equalsIgnoreCase("double")) return true;
                Double doubleObject = new Double(value);
                return true;
            }
            catch (NumberFormatException ex) {
                attribute.setHasError(typeName);
                attribute.setErrorText(ErrTexts.get("005"));
                return false;
            }
        }
        if (builtInTypeName.equalsIgnoreCase("date")) {
            try {
                DtHelper.getDateFormatter().parse(value);
                return true;
            }
            catch (ParseException ex) {
                attribute.setHasError(typeName);
                attribute.setErrorText(ErrTexts.get("006"));
                return false;
            }
        }
        if (builtInTypeName.equalsIgnoreCase("time")) {
            try {
                DtHelper.getTimeFormatter().parse(value);
                return true;
            }
            catch (ParseException ex) {
                attribute.setHasError(typeName);
                attribute.setErrorText(ErrTexts.get("007"));
                return false;
            }
        }
        if (!builtInTypeName.equalsIgnoreCase("timestamp")) return true;
        try {
            DtHelper.getTimestampFormatter().parse(value);
            return true;
        }
        catch (ParseException ex) {
            attribute.setHasError(typeName);
            attribute.setErrorText(DtHelper.concat(ErrTexts.get("052"), value));
            return false;
        }
    }

    public static String checkStringFieldContent(String attribute, String builtInTypeName, String value, String typeName) {
        DtTypeAttribute stringAttr = new DtTypeAttribute("stringAttr", "", false, "");
        boolean isOk = DtSimpleTypeChecker.checkStringFieldContent(stringAttr, builtInTypeName, value, typeName);
        if (!isOk) {
            Iterator iter = stringAttr.getErrorTexts().iterator();
            return (String)iter.next();
        }
        return "";
    }

    public static boolean checkStringValueLength(DtTypeAttribute attribute, String builtInTypeName, String value, int length, int minlength, int maxlength, String typeName) {
        if (value == null || value.equalsIgnoreCase("")) {
            return true;
        }
        if (!builtInTypeName.equalsIgnoreCase("string")) {
            return true;
        }
        if (length > 0 & length != value.length()) {
            attribute.setHasError(typeName);
            attribute.setErrorText(DtHelper.concat(ErrTexts.get("043"), value, String.valueOf(length)));
            return false;
        }
        if (minlength > 0 & minlength > value.length()) {
            attribute.setHasError(typeName);
            attribute.setErrorText(DtHelper.concat(ErrTexts.get("044"), value, String.valueOf(minlength)));
            return false;
        }
        if (maxlength > 0 & maxlength < value.length()) {
            attribute.setHasError(typeName);
            attribute.setErrorText(DtHelper.concat(ErrTexts.get("045"), value, String.valueOf(maxlength)));
            return false;
        }
        return true;
    }

    public static String checkStringValueLength(String builtInTypeName, String value, int length, int minlength, int maxlength, String typeName) {
        DtTypeAttribute stringAttr = new DtTypeAttribute("stringAttr", "", false, "");
        boolean isOk = DtSimpleTypeChecker.checkStringValueLength(stringAttr, builtInTypeName, value, length, minlength, maxlength, typeName);
        if (!isOk) {
            Iterator iter = stringAttr.getErrorTexts().iterator();
            return (String)iter.next();
        }
        return "";
    }

    public static boolean checkDbDefaultContent(DtTypeAttribute attribute, String builtInTypeName, String dbDefault, String typeName) {
        return dbDefault == null || dbDefault.equalsIgnoreCase("") || DtSimpleTypeChecker.checkStringFieldContent(attribute, builtInTypeName, dbDefault, typeName);
    }

    public static String checkDbDefaultContent(String dbDefault, String builtInTypeName, String typeName) {
        DtTypeAttribute attribute = new DtTypeAttribute("dbDefault", dbDefault, false, "");
        boolean isOk = DtSimpleTypeChecker.checkDbDefaultContent(attribute, builtInTypeName, dbDefault, typeName);
        if (!isOk) {
            Iterator iter = attribute.getErrorTexts().iterator();
            return (String)iter.next();
        }
        return "";
    }

    public static boolean checkFormat(DtTypeAttribute format, String builtInTypeName, String formatString, String simpleTypeName) {
        if (formatString != null && !formatString.equalsIgnoreCase("")) {
            if (DtTypeInfo.getBuiltInTypesNumeric().contains(builtInTypeName)) {
                try {
                    DecimalFormat decFormat = new DecimalFormat(formatString.trim());
                }
                catch (IllegalArgumentException ex) {
                    format.setHasError(simpleTypeName);
                    format.setErrorText(DtHelper.concat(ErrTexts.get("010"), formatString));
                    return false;
                }
            }
            if (builtInTypeName.equalsIgnoreCase("TIMESTAMP") && (formatString.equalsIgnoreCase("SHORT") || formatString.equalsIgnoreCase("MEDIUM") || formatString.equalsIgnoreCase("LONG") || formatString.equalsIgnoreCase("FULL"))) {
                format.setHasError(simpleTypeName);
                format.setErrorText(ErrTexts.get("050"));
                return false;
            }
        }
        return true;
    }

    public static String checkFormat(String format, String builtInTypeName, String simpleTypeName) {
        DtTypeAttribute attribute = new DtTypeAttribute("format", format, false, "");
        boolean isOk = DtSimpleTypeChecker.checkFormat(attribute, builtInTypeName, format, simpleTypeName);
        if (!isOk && !isOk) {
            Iterator iter = attribute.getErrorTexts().iterator();
            return (String)iter.next();
        }
        return "";
    }

    protected static boolean checkValidConstraintsPerType(DtTypeAttribute attribute, String builtInTypeName, String stringValue, String simpleTypeName) {
        if (stringValue != null && !((HashSet)typesPerConstraints.get(attribute.getAttributeName())).contains(builtInTypeName)) {
            attribute.setHasError(simpleTypeName);
            attribute.setErrorText(DtHelper.concat(ErrTexts.get("012"), attribute.getAttributeName()));
            return false;
        }
        return true;
    }

    protected static boolean checkValidConstraintsPerType(DtTypeAttribute attribute, String builtInTypeName, int intValue, String simpleTypeName) {
        if (intValue > 0 && !((HashSet)typesPerConstraints.get(attribute.getAttributeName())).contains(builtInTypeName)) {
            attribute.setHasError(simpleTypeName);
            attribute.setErrorText(DtHelper.concat(ErrTexts.get("012"), attribute.getAttributeName()));
            return false;
        }
        return true;
    }

    protected static boolean checkValidConstraintsPerType(DtTypeAttribute attribute, String builtInTypeName, BooleanEnum booleanValue, String simpleTypeName) {
        if (!(booleanValue != BooleanEnum.TRUE && booleanValue != BooleanEnum.FALSE || ((HashSet)typesPerConstraints.get(attribute.getAttributeName())).contains(builtInTypeName))) {
            attribute.setHasError(simpleTypeName);
            attribute.setErrorText(DtHelper.concat(ErrTexts.get("012"), attribute.getAttributeName()));
            return false;
        }
        return true;
    }

    protected static boolean checkValidExtRepresentationsPerType(DtTypeAttribute attribute, String builtInTypeName, String stringValue, String simpleTypeName) {
        if (stringValue != null && !((HashSet)typesPerRepresentations.get(attribute.getAttributeName())).contains(builtInTypeName)) {
            attribute.setHasError(simpleTypeName);
            attribute.setErrorText(DtHelper.concat(ErrTexts.get("013"), attribute.getAttributeName()));
            return false;
        }
        return true;
    }

    protected static boolean checkValidExtRepresentationsPerType(DtTypeAttribute attribute, String builtInTypeName, int intValue, String simpleTypeName) {
        if (intValue > 0 && !((HashSet)typesPerRepresentations.get(attribute.getAttributeName())).contains(builtInTypeName)) {
            attribute.setHasError(simpleTypeName);
            attribute.setErrorText(DtHelper.concat(ErrTexts.get("013"), attribute.getAttributeName()));
            return false;
        }
        return true;
    }

    protected static boolean checkValidExtRepresentationsPerType(DtTypeAttribute attribute, String builtInTypeName, BooleanEnum booleanValue, String simpleTypeName) {
        if (!(booleanValue != BooleanEnum.TRUE && booleanValue != BooleanEnum.FALSE || ((HashSet)typesPerRepresentations.get(attribute.getAttributeName())).contains(builtInTypeName))) {
            attribute.setHasError(simpleTypeName);
            attribute.setErrorText(DtHelper.concat(ErrTexts.get("013"), attribute.getAttributeName()));
            return false;
        }
        return true;
    }

    protected static boolean checkPattern(DtTypeAttribute pattern) {
        return true;
    }

    public static HashSet getValidConstraints(String builtInType) {
        return (HashSet)constraintsPerTypes.get(builtInType);
    }

    protected static HashSet getValidTypesForConstraint(String constraint) {
        return (HashSet)typesPerConstraints.get(constraint);
    }

    public static HashSet getValidRepresentations(String builtInType) {
        return (HashSet)representationsPerTypes.get(builtInType);
    }

    protected static HashSet getValidTypesForRepresentations(String representation) {
        return (HashSet)typesPerRepresentations.get(representation);
    }

    public static boolean checkName(String name) {
        return DtSimpleTypeChecker.checkNameWithMessage(name).equalsIgnoreCase("");
    }

    public static String checkNameWithMessage(String name) {
        String allowedCharacters = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_";
        String allowedAtFirstPosition = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        int ch = 32;
        int i = 0;
        while (i < name.length()) {
            ch = name.toUpperCase().charAt(i);
            if (allowedCharacters.indexOf(ch) == -1) {
                return ErrTexts.get("029");
            }
            ++i;
        }
        ch = name.toUpperCase().charAt(0);
        if (allowedAtFirstPosition.indexOf(ch) == -1) {
            return ErrTexts.get("030");
        }
        return "";
    }

    public static boolean checkLengthAttributes(DtTypeAttribute length, DtTypeAttribute minLength, DtTypeAttribute maxLength, int len, int minLen, int maxLen, String builtInTypeName, String simpleTypeName) {
        int sum = len + minLen + maxLen;
        if (builtInTypeName.equalsIgnoreCase("string") || builtInTypeName.equalsIgnoreCase("binary")) {
            if (!(len <= 0 || minLen == 0 && maxLen == 0 || minLen == -1 && maxLen == -1)) {
                length.setHasError(simpleTypeName);
                length.setErrorText(ErrTexts.get("015"));
                minLength.setHasError(simpleTypeName);
                minLength.setErrorText(ErrTexts.get("015"));
                maxLength.setHasError(simpleTypeName);
                maxLength.setErrorText(ErrTexts.get("015"));
                return false;
            }
            if ((len == 0 || len == -1) && (minLen < -1 || maxLen < -1 || minLen > maxLen && maxLen != 0 && maxLen != -1)) {
                length.setHasError(simpleTypeName);
                length.setErrorText(ErrTexts.get("016"));
                minLength.setHasError(simpleTypeName);
                minLength.setErrorText(ErrTexts.get("016"));
                maxLength.setHasError(simpleTypeName);
                maxLength.setErrorText(ErrTexts.get("016"));
                return false;
            }
        } else if (sum != 0) {
            String[] params = new String[]{"length", builtInTypeName};
            length.setHasError(simpleTypeName);
            length.setErrorText(DtHelper.concat(ErrTexts.get("027"), params));
            params[0] = "minLength";
            minLength.setHasError(simpleTypeName);
            minLength.setErrorText(DtHelper.concat(ErrTexts.get("027"), params));
            params[0] = "maxLength";
            maxLength.setHasError(simpleTypeName);
            maxLength.setErrorText(DtHelper.concat(ErrTexts.get("027"), params));
            return false;
        }
        return true;
    }

    public static String checkLengthAttributes(int length, int minLength, int maxLength, String builtInTypeName, String simpleTypeName) {
        DtTypeAttribute lengthAttr = new DtTypeAttribute("length", 0, false, "");
        DtTypeAttribute minAttr = new DtTypeAttribute("minLength", 0, false, "");
        DtTypeAttribute maxAttr = new DtTypeAttribute("maxLength", 0, false, "");
        boolean isOk = DtSimpleTypeChecker.checkLengthAttributes(lengthAttr, minAttr, maxAttr, length, minLength, maxLength, builtInTypeName, simpleTypeName);
        if (!isOk) {
            Set errorMessages = lengthAttr.getErrorTexts();
            errorMessages.addAll(minAttr.getErrorTexts());
            errorMessages.addAll(minAttr.getErrorTexts());
            Iterator iter = errorMessages.iterator();
            return (String)iter.next();
        }
        return "";
    }

    public static boolean checkDecimalAttributes(DtTypeAttribute totalDigits, DtTypeAttribute fractionDigits, int total, int fraction, String builtInTypeName, String simpleTypeName, String rootName) {
        if (!builtInTypeName.equalsIgnoreCase("decimal")) {
            return true;
        }
        if (total == -1 || fraction == -1) {
            totalDigits.setHasError(simpleTypeName);
            totalDigits.setErrorText(ErrTexts.get("019"));
            fractionDigits.setHasError(simpleTypeName);
            fractionDigits.setErrorText(ErrTexts.get("019"));
            return false;
        }
        if (total == 0 & simpleTypeName.equalsIgnoreCase(rootName)) {
            totalDigits.setHasError(simpleTypeName);
            totalDigits.setErrorText(ErrTexts.get("020"));
            return false;
        }
        if (total <= fraction & total != 0 & fraction != 0) {
            totalDigits.setHasError(simpleTypeName);
            totalDigits.setErrorText(DtHelper.concat(ErrTexts.get("032"), Integer.toString(total), Integer.toString(fraction)));
            return false;
        }
        return true;
    }

    public static boolean checkDecimalFormat(DtTypeAttribute attribute, String attributeValue, int total, int fraction, String builtInTypeName, String simpleTypeName) {
        boolean ok = true;
        if (!builtInTypeName.equalsIgnoreCase("decimal")) {
            return ok;
        }
        if (total == 0 && fraction == 0) {
            return ok;
        }
        if (attributeValue == null || attributeValue.equalsIgnoreCase("")) {
            return ok;
        }
        String formattedValue = null;
        try {
            NumberFormat formatter = DtHelper.getNumberFormatter(total, fraction);
            formattedValue = formatter.format(formatter.parse(attributeValue));
        }
        catch (ParseException ex) {
            attribute.setHasError(simpleTypeName);
            attribute.setErrorText(ErrTexts.get("005"));
            return !ok;
        }
        if (formattedValue.length() < attributeValue.length() & formattedValue.indexOf(46) != -1) {
            attribute.setHasError(simpleTypeName);
            attribute.setErrorText(DtHelper.concat(ErrTexts.get("048"), attribute.getName(), Integer.toString(fraction)));
            ok = false;
        }
        int i = 0;
        if (attributeValue.indexOf(46) != -1) {
            ++i;
        }
        if (attributeValue.indexOf(44) != -1) {
            ++i;
        }
        if (attributeValue.length() - i > total) {
            attribute.setHasError(simpleTypeName);
            attribute.setErrorText(DtHelper.concat(ErrTexts.get("049"), Integer.toString(total)));
            ok = false;
        }
        return ok;
    }

    public static String checkDecimalFormat(String value, int total, int fraction, String builtInTypeName, String simpleTypeName) {
        DtTypeAttribute attribute = new DtTypeAttribute("", value, false, "");
        boolean isOk = DtSimpleTypeChecker.checkDecimalFormat(attribute, value, total, fraction, builtInTypeName, simpleTypeName);
        if (!isOk) {
            Iterator iter = attribute.getErrorTexts().iterator();
            return (String)iter.next();
        }
        return "";
    }

    public static String checkDecimalAttributes(int totalDigits, int fractionDigits, String builtInTypeName, String simpleTypeName) {
        DtTypeAttribute total = new DtTypeAttribute("totalDigits", 0, false, "");
        DtTypeAttribute fraction = new DtTypeAttribute("fractionDigits", 0, false, "");
        String rootName = " ";
        boolean isOk = DtSimpleTypeChecker.checkDecimalAttributes(total, fraction, totalDigits, fractionDigits, builtInTypeName, simpleTypeName, rootName);
        if (!isOk) {
            Set errorMessages = total.getErrorTexts();
            errorMessages.addAll(fraction.getErrorTexts());
            Iterator iter = errorMessages.iterator();
            return (String)iter.next();
        }
        return "";
    }

    public static String checkTotalDigitsAreZero(int totalDigits, String builtInTypeName, String simpleTypeName) {
        if (totalDigits == 0) {
            return ErrTexts.get("020");
        }
        return "";
    }

    protected static boolean checkForDuplicateBorders(DtTypeAttribute minMaxIncl, String inclValue, DtTypeAttribute minMaxExcl, String exclValue, String simpleTypeName) {
        if (inclValue != null && !inclValue.equalsIgnoreCase("") && exclValue != null && !exclValue.equalsIgnoreCase("")) {
            minMaxIncl.setHasError(simpleTypeName);
            minMaxIncl.setErrorText(ErrTexts.get("036"));
            minMaxExcl.setHasError(simpleTypeName);
            minMaxExcl.setErrorText(ErrTexts.get("036"));
            return false;
        }
        return true;
    }

    protected static boolean checkMinMaxBorder(DtTypeAttribute minAttribute, String minValue, DtTypeAttribute maxAttribute, String maxValue, String simpleTypeName, String builtInTypeName) {
        Object[] objects = new Object[]{};
        if (minValue == null || maxValue == null) {
            return true;
        }
        if (minValue.trim().equalsIgnoreCase("") || maxValue.trim().equalsIgnoreCase("")) {
            return true;
        }
        if (builtInTypeName.equalsIgnoreCase("short") && ((Short)(objects = DtHelper.makeObject("java.lang.Short", minValue, maxValue))[0]).compareTo((Short)objects[1]) > 0) {
            minAttribute.setHasError(simpleTypeName);
            minAttribute.setErrorText(DtHelper.concat(ErrTexts.get("033"), minValue, maxValue));
            maxAttribute.setHasError(simpleTypeName);
            maxAttribute.setErrorText(DtHelper.concat(ErrTexts.get("033"), minValue, maxValue));
            return false;
        }
        if (builtInTypeName.equalsIgnoreCase("integer") && ((Integer)(objects = DtHelper.makeObject("java.lang.Integer", minValue, maxValue))[0]).compareTo((Integer)objects[1]) > 0) {
            minAttribute.setHasError(simpleTypeName);
            minAttribute.setErrorText(DtHelper.concat(ErrTexts.get("033"), minValue, maxValue));
            maxAttribute.setHasError(simpleTypeName);
            maxAttribute.setErrorText(DtHelper.concat(ErrTexts.get("033"), minValue, maxValue));
            return false;
        }
        if (builtInTypeName.equalsIgnoreCase("long") && ((Long)(objects = DtHelper.makeObject("java.lang.Long", minValue, maxValue))[0]).compareTo((Long)objects[1]) > 0) {
            minAttribute.setHasError(simpleTypeName);
            minAttribute.setErrorText(DtHelper.concat(ErrTexts.get("033"), minValue, maxValue));
            maxAttribute.setHasError(simpleTypeName);
            maxAttribute.setErrorText(DtHelper.concat(ErrTexts.get("033"), minValue, maxValue));
            return false;
        }
        if (builtInTypeName.equalsIgnoreCase("decimal") && ((BigDecimal)(objects = DtHelper.makeObject("java.math.BigDecimal", minValue, maxValue))[0]).compareTo((BigDecimal)objects[1]) > 0) {
            minAttribute.setHasError(simpleTypeName);
            minAttribute.setErrorText(DtHelper.concat(ErrTexts.get("033"), minValue, maxValue));
            maxAttribute.setHasError(simpleTypeName);
            maxAttribute.setErrorText(DtHelper.concat(ErrTexts.get("033"), minValue, maxValue));
            return false;
        }
        if (builtInTypeName.equalsIgnoreCase("float") && ((Float)(objects = DtHelper.makeObject("java.lang.Float", minValue, maxValue))[0]).compareTo((Float)objects[1]) > 0) {
            minAttribute.setHasError(simpleTypeName);
            minAttribute.setErrorText(DtHelper.concat(ErrTexts.get("033"), minValue, maxValue));
            maxAttribute.setHasError(simpleTypeName);
            maxAttribute.setErrorText(DtHelper.concat(ErrTexts.get("033"), minValue, maxValue));
            return false;
        }
        if (builtInTypeName.equalsIgnoreCase("double") && ((Double)(objects = DtHelper.makeObject("java.lang.Double", minValue, maxValue))[0]).compareTo((Double)objects[1]) > 0) {
            minAttribute.setHasError(simpleTypeName);
            minAttribute.setErrorText(DtHelper.concat(ErrTexts.get("033"), minValue, maxValue));
            maxAttribute.setHasError(simpleTypeName);
            maxAttribute.setErrorText(DtHelper.concat(ErrTexts.get("033"), minValue, maxValue));
            return false;
        }
        if (builtInTypeName.equalsIgnoreCase("date")) {
            try {
                Date date1 = new Date(DtHelper.getDateFormatter().parse(minValue).getTime());
                Date date2 = new Date(DtHelper.getDateFormatter().parse(maxValue).getTime());
                if (date1.compareTo(date2) > 0) {
                    minAttribute.setHasError(simpleTypeName);
                    minAttribute.setErrorText(DtHelper.concat(ErrTexts.get("033"), minValue, maxValue));
                    maxAttribute.setHasError(simpleTypeName);
                    maxAttribute.setErrorText(DtHelper.concat(ErrTexts.get("033"), minValue, maxValue));
                    return false;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                minAttribute.setHasError(simpleTypeName);
                minAttribute.setErrorText(DtHelper.concat(ErrTexts.get("033"), minValue, maxValue));
                maxAttribute.setHasError(simpleTypeName);
                maxAttribute.setErrorText(DtHelper.concat(ErrTexts.get("033"), minValue, maxValue));
                return false;
            }
        }
        if (builtInTypeName.equalsIgnoreCase("time")) {
            try {
                Time time1 = new Time(DtHelper.getTimeFormatter().parse(minValue).getTime());
                Time time2 = new Time(DtHelper.getTimeFormatter().parse(maxValue).getTime());
                if (time1.compareTo(time2) > 0) {
                    minAttribute.setHasError(simpleTypeName);
                    minAttribute.setErrorText(DtHelper.concat(ErrTexts.get("033"), minValue, maxValue));
                    maxAttribute.setHasError(simpleTypeName);
                    maxAttribute.setErrorText(DtHelper.concat(ErrTexts.get("033"), minValue, maxValue));
                    return false;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                minAttribute.setHasError(simpleTypeName);
                minAttribute.setErrorText(DtHelper.concat(ErrTexts.get("033"), minValue, maxValue));
                maxAttribute.setHasError(simpleTypeName);
                maxAttribute.setErrorText(DtHelper.concat(ErrTexts.get("033"), minValue, maxValue));
                return false;
            }
        }
        if (builtInTypeName.equalsIgnoreCase("timestamp")) {
            try {
                Timestamp timestamp1 = new Timestamp(DtHelper.getTimestampFormatter().parse(minValue).getTime());
                Timestamp timestamp2 = new Timestamp(DtHelper.getTimestampFormatter().parse(minValue).getTime());
                if (((java.util.Date)timestamp1).compareTo(timestamp2) > 0) {
                    minAttribute.setHasError(simpleTypeName);
                    minAttribute.setErrorText(DtHelper.concat(ErrTexts.get("033"), minValue, maxValue));
                    maxAttribute.setHasError(simpleTypeName);
                    maxAttribute.setErrorText(DtHelper.concat(ErrTexts.get("033"), minValue, maxValue));
                    return false;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                minAttribute.setHasError(simpleTypeName);
                minAttribute.setErrorText(DtHelper.concat(ErrTexts.get("033"), minValue, maxValue));
                maxAttribute.setHasError(simpleTypeName);
                maxAttribute.setErrorText(DtHelper.concat(ErrTexts.get("033"), minValue, maxValue));
                return false;
            }
        }
        return true;
    }

    protected static String checkMinMaxBorder(String minValue, String maxValue, String simpleTypeName, String builtInTypeName) {
        DtTypeAttribute minAttribute = new DtTypeAttribute("minAttribute", "", false, "");
        DtTypeAttribute maxAttribute = new DtTypeAttribute("maxAttribute", "", false, "");
        boolean isOk = DtSimpleTypeChecker.checkMinMaxBorder(minAttribute, minValue, maxAttribute, maxValue, simpleTypeName, builtInTypeName);
        if (!isOk) {
            Set errorMessages = minAttribute.getErrorTexts();
            errorMessages.addAll(maxAttribute.getErrorTexts());
            Iterator iter = errorMessages.iterator();
            return (String)iter.next();
        }
        return "";
    }

    protected static boolean checkMinInExclusive(String currentValue, String predecessorValue, DtTypeAttribute attribute, String simpleTypeName, String builtInTypeName) {
        java.util.Date timePre;
        java.util.Date timeCurr;
        Object[] objects = new Object[]{};
        if (predecessorValue.trim().equalsIgnoreCase("")) {
            return true;
        }
        if (builtInTypeName.equalsIgnoreCase("short") && ((Short)(objects = DtHelper.makeObject("java.lang.Short", currentValue, predecessorValue))[0]).compareTo((Short)objects[1]) < 0) {
            attribute.setHasError(simpleTypeName);
            attribute.setErrorText(ErrTexts.get("024"));
            return false;
        }
        if (builtInTypeName.equalsIgnoreCase("integer") && ((Integer)(objects = DtHelper.makeObject("java.lang.Integer", currentValue, predecessorValue))[0]).compareTo((Integer)objects[1]) < 0) {
            attribute.setHasError(simpleTypeName);
            attribute.setErrorText(ErrTexts.get("024"));
            return false;
        }
        if (builtInTypeName.equalsIgnoreCase("long") && ((Long)(objects = DtHelper.makeObject("java.lang.Long", currentValue, predecessorValue))[0]).compareTo((Long)objects[1]) < 0) {
            attribute.setHasError(simpleTypeName);
            attribute.setErrorText(ErrTexts.get("024"));
            return false;
        }
        if (builtInTypeName.equalsIgnoreCase("decimal") && ((BigDecimal)(objects = DtHelper.makeObject("java.math.BigDecimal", currentValue, predecessorValue))[0]).compareTo((BigDecimal)objects[1]) < 0) {
            attribute.setHasError(simpleTypeName);
            attribute.setErrorText(ErrTexts.get("024"));
            return false;
        }
        if (builtInTypeName.equalsIgnoreCase("float") && ((Float)(objects = DtHelper.makeObject("java.lang.Float", currentValue, predecessorValue))[0]).compareTo((Float)objects[1]) < 0) {
            attribute.setHasError(simpleTypeName);
            attribute.setErrorText(ErrTexts.get("024"));
            return false;
        }
        if (builtInTypeName.equalsIgnoreCase("double") && ((Double)(objects = DtHelper.makeObject("java.lang.Double", currentValue, predecessorValue))[0]).compareTo((Double)objects[1]) < 0) {
            attribute.setHasError(simpleTypeName);
            attribute.setErrorText(ErrTexts.get("024"));
            return false;
        }
        if (builtInTypeName.equalsIgnoreCase("Date")) {
            java.util.Date dateCurr = null;
            java.util.Date datePre = null;
            try {
                dateCurr = DtHelper.getDateFormatter().parse(currentValue);
                datePre = DtHelper.getDateFormatter().parse(predecessorValue);
            }
            catch (ParseException ex) {
                return false;
            }
            if (dateCurr.compareTo(datePre) < 0) {
                attribute.setHasError(simpleTypeName);
                attribute.setErrorText(ErrTexts.get("024"));
                return false;
            }
        }
        if (builtInTypeName.equalsIgnoreCase("Time")) {
            timeCurr = null;
            timePre = null;
            try {
                timeCurr = new Time(DtHelper.getTimeFormatter().parse(currentValue).getTime());
                timePre = new Time(DtHelper.getTimeFormatter().parse(predecessorValue).getTime());
            }
            catch (ParseException ex) {
                return false;
            }
            if (timeCurr.compareTo(timePre) < 0) {
                attribute.setHasError(simpleTypeName);
                attribute.setErrorText(ErrTexts.get("024"));
                return false;
            }
        }
        if (builtInTypeName.equalsIgnoreCase("Timestamp")) {
            timeCurr = null;
            timePre = null;
            try {
                timeCurr = new Timestamp(DtHelper.getTimeFormatter().parse(currentValue).getTime());
                timePre = new Timestamp(DtHelper.getTimeFormatter().parse(predecessorValue).getTime());
            }
            catch (ParseException ex) {
                return false;
            }
            if (timeCurr.compareTo(timePre) < 0) {
                attribute.setHasError(simpleTypeName);
                attribute.setErrorText(ErrTexts.get("024"));
                return false;
            }
        }
        return true;
    }

    protected static boolean checkMaxInExclusive(String currentValue, String predecessorValue, DtTypeAttribute attribute, String simpleTypeName, String builtInTypeName) {
        java.util.Date timePre;
        java.util.Date timeCurr;
        Object[] objects = new Object[]{};
        if (predecessorValue.trim().equalsIgnoreCase("")) {
            return true;
        }
        if (builtInTypeName.equalsIgnoreCase("short") && ((Short)(objects = DtHelper.makeObject("java.lang.Short", currentValue, predecessorValue))[0]).compareTo((Short)objects[1]) > 0) {
            attribute.setHasError(simpleTypeName);
            attribute.setErrorText(ErrTexts.get("026"));
            return false;
        }
        if (builtInTypeName.equalsIgnoreCase("integer") && ((Integer)(objects = DtHelper.makeObject("java.lang.Integer", currentValue, predecessorValue))[0]).compareTo((Integer)objects[1]) > 0) {
            attribute.setHasError(simpleTypeName);
            attribute.setErrorText(ErrTexts.get("026"));
            return false;
        }
        if (builtInTypeName.equalsIgnoreCase("long") && ((Long)(objects = DtHelper.makeObject("java.lang.Long", currentValue, predecessorValue))[0]).compareTo((Long)objects[1]) > 0) {
            attribute.setHasError(simpleTypeName);
            attribute.setErrorText(ErrTexts.get("026"));
            return false;
        }
        if (builtInTypeName.equalsIgnoreCase("decimal") && ((BigDecimal)(objects = DtHelper.makeObject("java.math.BigDecimal", currentValue, predecessorValue))[0]).compareTo((BigDecimal)objects[1]) > 0) {
            attribute.setHasError(simpleTypeName);
            attribute.setErrorText(ErrTexts.get("026"));
            return false;
        }
        if (builtInTypeName.equalsIgnoreCase("float") && ((Float)(objects = DtHelper.makeObject("java.lang.Float", currentValue, predecessorValue))[0]).compareTo((Float)objects[1]) > 0) {
            attribute.setHasError(simpleTypeName);
            attribute.setErrorText(ErrTexts.get("026"));
            return false;
        }
        if (builtInTypeName.equalsIgnoreCase("double") && ((Double)(objects = DtHelper.makeObject("java.lang.Double", currentValue, predecessorValue))[0]).compareTo((Double)objects[1]) > 0) {
            attribute.setHasError(simpleTypeName);
            attribute.setErrorText(ErrTexts.get("026"));
            return false;
        }
        if (builtInTypeName.equalsIgnoreCase("Date")) {
            java.util.Date dateCurr = null;
            java.util.Date datePre = null;
            try {
                dateCurr = DtHelper.getDateFormatter().parse(currentValue);
                datePre = DtHelper.getDateFormatter().parse(predecessorValue);
            }
            catch (ParseException ex) {
                return false;
            }
            if (dateCurr.compareTo(datePre) > 0) {
                attribute.setHasError(simpleTypeName);
                attribute.setErrorText(ErrTexts.get("026"));
                return false;
            }
        }
        if (builtInTypeName.equalsIgnoreCase("Time")) {
            timeCurr = null;
            timePre = null;
            try {
                timeCurr = new Time(DtHelper.getTimeFormatter().parse(currentValue).getTime());
                timePre = new Time(DtHelper.getTimeFormatter().parse(predecessorValue).getTime());
            }
            catch (ParseException ex) {
                return false;
            }
            if (timeCurr.compareTo(timePre) > 0) {
                attribute.setHasError(simpleTypeName);
                attribute.setErrorText(ErrTexts.get("026"));
                return false;
            }
        }
        if (builtInTypeName.equalsIgnoreCase("Timestamp")) {
            timeCurr = null;
            timePre = null;
            try {
                timeCurr = new Timestamp(DtHelper.getTimeFormatter().parse(currentValue).getTime());
                timePre = new Timestamp(DtHelper.getTimeFormatter().parse(predecessorValue).getTime());
            }
            catch (ParseException ex) {
                return false;
            }
            if (timeCurr.compareTo(timePre) > 0) {
                attribute.setHasError(simpleTypeName);
                attribute.setErrorText(ErrTexts.get("026"));
                return false;
            }
        }
        return true;
    }

    static {
        constraintsPerTypes.put("string", nonNumericConstraints);
        constraintsPerTypes.put("binary", nonNumericConstraints);
        constraintsPerTypes.put("byte", numericConstraints);
        constraintsPerTypes.put("short", numericConstraints);
        constraintsPerTypes.put("integer", numericConstraints);
        constraintsPerTypes.put("long", numericConstraints);
        constraintsPerTypes.put("float", numericConstraints);
        constraintsPerTypes.put("double", numericConstraints);
        constraintsPerTypes.put("date", numericConstraints);
        constraintsPerTypes.put("time", numericConstraints);
        constraintsPerTypes.put("timestamp", numericConstraints);
        constraints.add("totalDigits");
        constraints.add("fractionDigits");
        constraints.add("minInclusive");
        constraints.add("maxInclusive");
        constraints.add("minExclusive");
        constraints.add("maxExclusive");
        constraints.add("pattern");
        constraints.add("enumeration");
        constraintsPerTypes.put("decimal", constraints);
        constraintsPerTypes.put("boolean", null);
        typesPerConstraints.put("length", typeSet1);
        typesPerConstraints.put("minLength", typeSet1);
        typesPerConstraints.put("maxLength", typeSet1);
        typesPerConstraints.put("minInclusive", typeSet3);
        typesPerConstraints.put("maxInclusive", typeSet3);
        typesPerConstraints.put("minExclusive", typeSet3);
        typesPerConstraints.put("maxExclusive", typeSet3);
        typesPerConstraints.put("totalDigits", typeSet4);
        typesPerConstraints.put("fractionDigits", typeSet4);
        typesPerConstraints.put("pattern", typeSet2);
        typesPerConstraints.put("enumeration", typeSet2);
        representationsPerTypes.put("string", representationSet1);
        representationsPerTypes.put("byte", representationSet2);
        representationsPerTypes.put("short", representationSet2);
        representationsPerTypes.put("integer", representationSet2);
        representationsPerTypes.put("long", representationSet2);
        representationsPerTypes.put("decimal", representationSet2);
        representationsPerTypes.put("float", representationSet3);
        representationsPerTypes.put("double", representationSet3);
        representationsPerTypes.put("boolean", null);
        representationsPerTypes.put("binary", representationSet2);
        representationsPerTypes.put("date", representationSet3);
        representationsPerTypes.put("time", representationSet3);
        representationsPerTypes.put("timestamp", representationSet3);
        typesPerRepresentations.put("maxExternalLength", typeSet6);
        typesPerRepresentations.put("uppercase", typeSet5);
        typesPerRepresentations.put("readOnly", typeSet7);
        typesPerRepresentations.put("defaultValue", typeSet7);
        typesPerRepresentations.put("format", typeSet2);
        typesPerRepresentations.put("translateFlag", typeSet5);
    }
}

