/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.designtime;

import com.sap.dictionary.designtime.DtTypeAttribute;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.general.SeverityEnum;
import com.sap.ide.metamodel.general.i18n.I18NProblem;
import com.sap.ide.metamodel.general.i18n.I18NTextProblem;
import com.sap.ide.metamodel.general.i18n.TextPool;
import com.sap.ide.metamodel.util.RawLanguageConverter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Locale;

public class DtHelper {
    static final String tabulator = "      ";
    public static final String xmlTitle = "<?xml version=\"1.0\"?>";
    protected static final String ERROR = "Error";
    protected static final String WARNING = "Warning";
    protected static final String INFO = "Info";
    private static final ArrayList dbList = new ArrayList();
    protected static final SimpleDateFormat FDATE = new SimpleDateFormat("yyyy-MM-dd");
    protected static final SimpleDateFormat FTIME = new SimpleDateFormat("H:mm:ss");
    protected static final SimpleDateFormat FTIMESTAMP = new SimpleDateFormat("yyyy-MM-dd'T'H:mm:ss.SSS");
    NumberFormat formatter = null;
    private static final String[] CH_TO_ENC;
    static /* synthetic */ Class class$java$lang$String;

    protected static String concat(String text, String replaceString) {
        int position = text.indexOf(38);
        return text.substring(0, position) + replaceString + text.substring(position + 1, text.length());
    }

    protected static String concat(String text, String replaceString1, String replaceString2) {
        String[] replaceStrings = new String[]{replaceString1, replaceString2};
        return DtHelper.concat(text, replaceStrings);
    }

    public static String concat(String text, String[] replaceString) {
        int position = 0;
        String before = text;
        String after = "";
        int i = 0;
        while (i < replaceString.length) {
            position = before.indexOf(38);
            after = after + before.substring(0, position) + replaceString[i];
            before = before.substring(position + 1, before.length());
            ++i;
        }
        return after + " " + before;
    }

    protected static Object[] makeObject(String className, String value1, String value2) {
        Object[] objects = new Object[]{null, null};
        try {
            Class[] argsClass = new Class[]{class$java$lang$String == null ? (class$java$lang$String = DtHelper.class$("java.lang.String")) : class$java$lang$String};
            Constructor<?> constructor = Class.forName(className).getConstructor(argsClass);
            Object[] args1 = new Object[]{value1};
            Object[] args2 = new Object[]{value2};
            System.out.println(constructor.getName());
            objects[0] = constructor.newInstance(args1);
            objects[1] = constructor.newInstance(args2);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        System.out.println(objects);
        return objects;
    }

    public static String tabulate() {
        return tabulator;
    }

    /*
     * Unable to fully structure code
     */
    public static String escapeWhitespaces(String s) {
        t = "";
        i = 0;
        i = s.indexOf(" ", 0);
        if (i != -1) ** GOTO lbl9
        return s;
lbl-1000:
        // 1 sources

        {
            t = i == 0 ? t + "\\ " : t + s.substring(0, i) + "\\ ";
            s = s.substring(i + 1, s.length());
            i = s.indexOf(" ", 0);
lbl9:
            // 2 sources

            ** while (i > -1)
        }
lbl10:
        // 1 sources

        return t + s;
    }

    public static String escapePropertyFileChar(String s) {
        if (s == null) {
            return "";
        }
        StringBuffer b = new StringBuffer();
        int ls = s.length();
        int i = 0;
        while (i < ls) {
            char ch = s.charAt(i);
            if (ch == ':' || ch == '=' || ch == ' ') {
                b.append('\\').append(ch);
            } else {
                b.append(ch);
            }
            ++i;
        }
        return b.toString();
    }

    protected static String escapeXML(String s) {
        if (s == null) {
            return "";
        }
        StringBuffer b = new StringBuffer();
        int ls = s.length();
        int i = 0;
        while (i < ls) {
            char ch = s.charAt(i);
            if (ch < '\u0100') {
                String enc = CH_TO_ENC[ch];
                if (enc == null) {
                    b.append(ch);
                } else {
                    b.append('&').append(enc).append(';');
                }
            } else {
                b.append(ch);
            }
            ++i;
        }
        return b.toString();
    }

    public static String removeTrailingSpaces(String s) {
        if (s == null) {
            return "";
        }
        int count = s.length();
        int len = s.length();
        boolean st = false;
        char[] val = new char[len];
        if (len == 0) {
            return "";
        }
        int i = count;
        while (i > 0) {
            if (s.charAt(i - 1) > ' ') break;
            --len;
            --i;
        }
        if (len > 0) {
            return s.substring(0, len);
        }
        return " ";
    }

    public static ArrayList getSupportedDatabases() {
        return dbList;
    }

    protected static SimpleDateFormat getDateFormatter() {
        return FDATE;
    }

    public static String getDateTemplate() {
        return FDATE.toPattern();
    }

    protected static SimpleDateFormat getTimeFormatter() {
        return FTIME;
    }

    public static String getTimeTemplate() {
        return FTIME.toPattern();
    }

    protected static SimpleDateFormat getTimestampFormatter() {
        return FTIMESTAMP;
    }

    public static String getTimestampTemplate() {
        return FTIMESTAMP.toPattern();
    }

    protected static NumberFormat getNumberFormatter(int total, int fraction) {
        NumberFormat formatter = NumberFormat.getInstance(Locale.US);
        String format = "#,##0.";
        String s = "";
        int i = 1;
        while (i <= fraction) {
            s = s + "#";
            ++i;
        }
        format = format + s;
        Object formattedValue = null;
        ((DecimalFormat)formatter).applyPattern(format);
        return formatter;
    }

    public static String getNumberTemplate(int total, int fraction) {
        return ((DecimalFormat)DtHelper.getNumberFormatter(total, fraction)).toPattern();
    }

    public static void check(DevelopmentObject developmentObject, DtTypeAttribute attr) {
        if (!(developmentObject instanceof MainDevelopmentObject)) {
            return;
        }
        MainDevelopmentObject lMDO = (MainDevelopmentObject)developmentObject;
        TextPool lTextPool = lMDO.getTextPool();
        if (lTextPool.isEmpty()) {
            return;
        }
        String lOriginalLanguage = "";
        I18NProblem[] lI18NProblems = lTextPool.validateLanguages();
        int i = 0;
        while (i < lI18NProblems.length) {
            I18NProblem lI18NProblem = lI18NProblems[i];
            if (lI18NProblem.getSeverity() == SeverityEnum.WARNING) {
                attr.setHasWarning(lMDO.getName());
                attr.setWarningText(lI18NProblem.getMessage());
            } else if (lI18NProblem.getSeverity() == SeverityEnum.ERROR || lI18NProblem.getSeverity() == SeverityEnum.FATAL) {
                attr.setHasError(lMDO.getName());
                attr.setErrorText(lI18NProblem.getMessage());
            }
            ++i;
        }
        if (RawLanguageConverter.isRawLanguageMissing((MainDevelopmentObject)lMDO)) {
            attr.setHasWarning(lMDO.getName());
            attr.setWarningText("Raw language version is missingActivate raw language support for project " + lMDO.getRoot().getMetamodel().getName());
            lOriginalLanguage = lMDO.getMasterLanguage();
        }
        I18NTextProblem[] lI18NTextProblems = lTextPool.validateTexts(lOriginalLanguage);
        int i2 = 0;
        while (i2 < lI18NTextProblems.length) {
            I18NTextProblem lI18NProblem = lI18NTextProblems[i2];
            if (lI18NProblem.getSeverity() == SeverityEnum.WARNING) {
                attr.setHasWarning(lMDO.getName());
                attr.setWarningText(lI18NProblem.getMessage());
            } else if (lI18NProblem.getSeverity() == SeverityEnum.ERROR || lI18NProblem.getSeverity() == SeverityEnum.FATAL) {
                attr.setHasError(lMDO.getName());
                attr.setErrorText(lI18NProblem.getMessage());
            }
            ++i2;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            Class<?> cl = Class.forName("com.sap.dictionary.database.dbs.Database");
            Field[] fields = cl.getFields();
            String dbName = null;
            int i = 0;
            while (i < fields.length) {
                dbName = fields[i].getName();
                if (!dbName.equalsIgnoreCase("ARTIFICIAL") && !(dbName = fields[i].getName()).equalsIgnoreCase("INFORMIX")) {
                    dbList.add(dbName);
                }
                ++i;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        CH_TO_ENC = new String[256];
        DtHelper.CH_TO_ENC[38] = "amp";
        DtHelper.CH_TO_ENC[39] = "apos";
        DtHelper.CH_TO_ENC[34] = "quot";
        DtHelper.CH_TO_ENC[60] = "lt";
        DtHelper.CH_TO_ENC[62] = "gt";
    }
}

