/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.designtime;

import com.sap.dictionary.database.dbs.Database;
import com.sap.dictionary.database.dbs.DbFactory;
import com.sap.dictionary.database.dbs.DbObjectSqlStatements;
import com.sap.dictionary.database.dbs.DbTable;
import com.sap.dictionary.database.dbs.XmlMap;
import com.sap.dictionary.designtime.DtColumnExpanded;
import com.sap.dictionary.designtime.DtDatabaseInfoExpanded;
import com.sap.dictionary.designtime.DtDbTableChecker;
import com.sap.dictionary.designtime.DtHelper;
import com.sap.dictionary.designtime.DtIndexExpanded;
import com.sap.dictionary.designtime.DtStructureExpanded;
import com.sap.ide.metamodel.dictionary.datatype.DtDbIndex;
import com.sap.ide.metamodel.dictionary.datatype.DtDbTable;
import com.sap.ide.metamodel.dictionary.datatype.DtField;
import com.sap.ide.metamodel.dictionary.datatype.DtImportFromOtherStructure;
import com.sap.ide.metamodel.dictionary.datatype.DtNoCreateCondition;
import com.sap.ide.metamodel.dictionary.datatype.DtPrimaryKey;
import com.sap.ide.metamodel.dictionary.datatype.DtStructure;
import com.sap.ide.metamodel.dictionary.datatype.DtStructureElement;
import com.sap.ide.metamodel.dictionary.datatype.DtTechnicalSettings;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.ConsoleLog;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.Log;
import com.sap.tc.logging.LogRecord;
import com.sap.tc.logging.StreamLog;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;

public class DtDbTableExpanded
extends DtStructureExpanded {
    private String predefinedAction = "";
    private boolean positionIsRelevant = false;
    private String deploymentStatus = "";
    private ArrayList gIndexes = null;
    private ArrayList gPrimaryKey = null;
    private ArrayList gDatabaseInfo = new ArrayList();
    private DtTechnicalSettings dtTechnicalSettings = null;
    private int numberOfRecords = 0;
    private boolean isBuffered = false;
    private int genKeyCount = 0;
    private static final Location loc = Location.getLocation((String)"com.sap.dictionary.database");
    private static final Category cat = Category.getCategory((String)"/Jddic/Database");
    static /* synthetic */ Class class$com$sap$dictionary$database$dbs$DbTable;

    public DtDbTableExpanded(DtStructure dtTable) {
        this.structure = dtTable;
        this.checker = new DtDbTableChecker(dtTable);
        this.withCheck = true;
        this.expand(dtTable, 1, this.withCheck);
    }

    public DtDbTableExpanded(DtStructure dtTable, boolean withCheck) {
        this.structure = dtTable;
        this.checker = new DtDbTableChecker(dtTable);
        this.expand(dtTable, 1, withCheck);
    }

    protected DtDbTableExpanded(DtStructure dtTable, int position, boolean withCheck) {
        this.structure = dtTable;
        this.checker = new DtDbTableChecker(dtTable);
        this.withCheck = withCheck;
        this.expand(dtTable, position, withCheck);
    }

    protected void expandIndexes(DtStructure dtTable) {
        DtDbIndex[] dtDbIndexes;
        if (dtTable instanceof DtDbTable && (dtDbIndexes = ((DtDbTable)dtTable).getDbIndexes()) != null) {
            this.gIndexes = new ArrayList();
            DtIndexExpanded gIndex = null;
            int i = 0;
            while (i <= dtDbIndexes.length - 1) {
                gIndex = new DtIndexExpanded(dtDbIndexes[i]);
                this.gIndexes.add(gIndex);
                ++i;
            }
        }
    }

    protected void expandPrimaryKey(DtStructure dtTable) {
        DtPrimaryKey dtPrimaryKey;
        if (dtTable instanceof DtDbTable && (dtPrimaryKey = ((DtDbTable)dtTable).getPrimaryKey()) != null) {
            this.gPrimaryKey = new ArrayList();
            DtStructureElement[] dtKeyElements = dtPrimaryKey.getKeyElements();
            this.sortedFields = new TreeMap();
            int i = 0;
            while (i <= dtKeyElements.length - 1) {
                this.sortedFields.put(new Integer(dtKeyElements[i].getPosition()), dtKeyElements[i]);
                ++i;
            }
            Iterator fieldsIter = this.sortedFields.keySet().iterator();
            DtStructureElement keyElement = null;
            int i2 = 0;
            while (fieldsIter.hasNext()) {
                keyElement = (DtStructureElement)this.sortedFields.get(fieldsIter.next());
                if (keyElement instanceof DtField) {
                    this.gPrimaryKey.add(i2, ((DtField)keyElement).getName());
                    ++i2;
                    continue;
                }
                if (!(keyElement instanceof DtImportFromOtherStructure)) continue;
                DtStructure dtStructure = ((DtImportFromOtherStructure)keyElement).getUsedStructure();
                DtDbTableExpanded gStructure = new DtDbTableExpanded(dtStructure, false);
                HashMap appColumns = gStructure.getColumns();
                Iterator iter = appColumns.keySet().iterator();
                while (iter.hasNext()) {
                    this.gPrimaryKey.add(((DtColumnExpanded)appColumns.get(iter.next())).getName());
                }
            }
        }
    }

    protected void expandTechnicalSettings(DtStructure dtTable) {
        if (dtTable instanceof DtDbTable && ((DtDbTable)dtTable).hasTechnicalSettings()) {
            this.dtTechnicalSettings = ((DtDbTable)dtTable).getTechnicalSettings();
            if (this.dtTechnicalSettings != null) {
                this.numberOfRecords = this.dtTechnicalSettings.getNumberOfRecords();
                this.isBuffered = this.dtTechnicalSettings.getIsBuffered();
                this.genKeyCount = this.dtTechnicalSettings.getGenKeyCount();
            }
        }
    }

    protected void expandDatabaseInfo(DtStructure dtTable) {
        if (dtTable instanceof DtDbTable) {
            DtNoCreateCondition[] databases = ((DtDbTable)dtTable).getNoCreationOnDatabases();
            DtDatabaseInfoExpanded expDatabaseInfo = null;
            int i = 0;
            while (i < databases.length) {
                expDatabaseInfo = new DtDatabaseInfoExpanded(databases[i].getName().toString().toUpperCase(), databases[i].getDeleteIfExisting());
                this.gDatabaseInfo.add(expDatabaseInfo);
                ++i;
            }
        }
    }

    protected void expandTableHeader(DtStructure dtTable) {
        this.predefinedAction = ((DtDbTable)dtTable).getPredefinedAction();
        if (this.predefinedAction == null) {
            this.predefinedAction = "";
        }
    }

    protected boolean expand(DtStructure dtTable, int position, boolean withCheck) {
        boolean beforeExpand = true;
        boolean afterExpand = true;
        if (withCheck) {
            boolean nameIsOk = this.checker.nameIsOk();
            boolean fieldsExist = this.checker.fieldsExist();
            boolean bl = beforeExpand = nameIsOk && fieldsExist;
            if (!beforeExpand) {
                this.expanded = false;
                return this.expanded;
            }
        }
        this.expanded = super.expand(dtTable, position, false);
        if (!this.expanded) {
            return this.expanded;
        }
        this.expandTableHeader(dtTable);
        this.expandIndexes(dtTable);
        this.expandPrimaryKey(dtTable);
        this.expandTechnicalSettings(dtTable);
        this.expandDatabaseInfo(dtTable);
        Iterator columnsIter = ((AbstractList)this.gColumnsAsList).iterator();
        DtColumnExpanded column = null;
        while (columnsIter.hasNext()) {
            column = (DtColumnExpanded)columnsIter.next();
            if (this.gPrimaryKey == null || !this.gPrimaryKey.contains(column.getName())) continue;
            column.setIsNotNull(true);
        }
        if (withCheck) {
            this.expanded = beforeExpand & this.isTableOk();
        }
        return this.expanded;
    }

    public String getPredefinedAction() {
        return this.predefinedAction;
    }

    public boolean getPositionIsRelevant() {
        return this.positionIsRelevant;
    }

    public String getDeploymentStatus() {
        return this.deploymentStatus;
    }

    public ArrayList getIndexes() {
        return this.gIndexes;
    }

    public boolean getIndexesExist() {
        if (this.gIndexes == null) {
            return false;
        }
        return this.gIndexes.size() > 0;
    }

    public ArrayList getPrimaryKey() {
        return this.gPrimaryKey;
    }

    public boolean getPrimaryKeyExists() {
        if (this.gPrimaryKey == null) {
            return false;
        }
        return this.gPrimaryKey.size() > 0;
    }

    public ArrayList getDatabaseInfo() {
        return this.gDatabaseInfo;
    }

    public boolean getDatabaseInfoExists() {
        if (this.gDatabaseInfo.isEmpty()) {
            return false;
        }
        return this.gDatabaseInfo.size() > 0;
    }

    public int getSizeCategory() {
        return this.numberOfRecords;
    }

    public boolean getIsBuffered() {
        return this.isBuffered;
    }

    public int getGenKeyCount() {
        return this.genKeyCount;
    }

    public boolean getTechnicalInfoExists() {
        return this.numberOfRecords > 0 || this.isBuffered;
    }

    public boolean isTableOk() {
        final ArrayList dbMessages = new ArrayList();
        ArrayList<String> mess = new ArrayList<String>();
        MessageFormat format = null;
        boolean structureIsOk = this.isStructureOk();
        boolean nameIsOk = ((DtDbTableChecker)this.checker).reservedWordIsUsed();
        boolean primaryKeyIsOk = ((DtDbTableChecker)this.checker).primaryKeyIsOk() & ((DtDbTableChecker)this.checker).indexesAndPrimaryKeyAreDifferent();
        boolean indexesAreOk = ((DtDbTableChecker)this.checker).indexesAreOk();
        boolean indexColumnNamesAreOk = ((DtDbTableChecker)this.checker).indexColumnNamesAreOk() & ((DtDbTableChecker)this.checker).reservedWordIsUsed();
        boolean indexesAreAllDifferent = ((DtDbTableChecker)this.checker).indexesAreAllDifferent();
        boolean dbIndependentIsOk = structureIsOk & nameIsOk & primaryKeyIsOk & indexesAreOk & indexColumnNamesAreOk & indexesAreAllDifferent;
        loc.addLog((Log)new StreamLog(){

            protected String writeInt(LogRecord log) throws Exception {
                dbMessages.add(log.getMsgClear());
                dbMessages.add(log.getArgs());
                return super.writeInt(log);
            }
        });
        loc.addLog((Log)new ConsoleLog());
        loc.setEffectiveSeverity(500);
        cat.setEffectiveSeverity(500);
        loc.setResourceBundleName("com.sap.dictionary.database.dbs.messages.messages");
        cat.setResourceBundleName("com.sap.dictionary.database.dbs.messages.messages");
        loc.setClassLoader((class$com$sap$dictionary$database$dbs$DbTable == null ? (class$com$sap$dictionary$database$dbs$DbTable = DtDbTableExpanded.class$("com.sap.dictionary.database.dbs.DbTable")) : class$com$sap$dictionary$database$dbs$DbTable).getClassLoader());
        cat.setClassLoader((class$com$sap$dictionary$database$dbs$DbTable == null ? (class$com$sap$dictionary$database$dbs$DbTable = DtDbTableExpanded.class$("com.sap.dictionary.database.dbs.DbTable")) : class$com$sap$dictionary$database$dbs$DbTable).getClassLoader());
        XmlMap tableMap = this.getXmlMap();
        Iterator iter = ((AbstractList)DtHelper.getSupportedDatabases()).iterator();
        Iterator it = ((AbstractList)this.gDatabaseInfo).iterator();
        ArrayList<String> exclNames = new ArrayList<String>();
        while (it.hasNext()) {
            exclNames.add(((DtDatabaseInfoExpanded)it.next()).getDatabaseName());
        }
        boolean dbDependentIsOk = true;
        boolean dbDependent = false;
        DbTable table = null;
        int i = 0;
        int j = 0;
        while (iter.hasNext()) {
            String databaseName = (String)iter.next();
            if (exclNames.contains(databaseName.toUpperCase())) continue;
            try {
                DbFactory factory = new DbFactory(Database.getDatabase((String)databaseName));
                table = factory.makeTable();
                table.setCommonContentViaXml(tableMap);
                dbDependent = table.check();
                i = 0;
                while (i <= dbMessages.size() - 1) {
                    mess.add(databaseName + ":" + (String)dbMessages.get(i));
                    mess.add((String)dbMessages.get(++i));
                    ++i;
                }
                dbMessages.clear();
                if (dbDependent) continue;
                dbDependentIsOk = false;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        i = 0;
        List list = null;
        Iterator listIter = null;
        while (i < mess.size()) {
            format = new MessageFormat((String)mess.get(i));
            Object[] arguments = new Object[6];
            list = (List)mess.get(++i);
            listIter = list.iterator();
            j = 0;
            while (listIter.hasNext()) {
                arguments[j] = listIter.next();
                ++j;
            }
            this.errorMessages.add(format.format(arguments));
            ++i;
        }
        return dbDependentIsOk && dbIndependentIsOk;
    }

    public void getCreateStatements(String path) throws Exception {
        ArrayList dbList = DtHelper.getSupportedDatabases();
        Iterator iter = ((AbstractList)dbList).iterator();
        PrintWriter writer = null;
        String databaseName = "";
        while (iter.hasNext()) {
            databaseName = (String)iter.next();
            writer = new PrintWriter(new FileWriter(path + "\\" + this.name + "." + databaseName));
            this.getCreateStatement(databaseName, writer);
        }
    }

    public void getCreateStatement(String databaseName, PrintWriter file) throws Exception {
        XmlMap tableMap = this.getXmlMap();
        try {
            DbFactory factory = new DbFactory(Database.getDatabase((String)databaseName));
            DbTable table = factory.makeTable();
            table.setCommonContentViaXml(tableMap);
            DbObjectSqlStatements s = table.getDdlStatementsForCreate();
            file.println(s.toString().trim());
            file.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    public void writeToXmlFile(PrintWriter file, String offset0) {
        int i;
        file.println(offset0 + "<?xml version=\"1.0\"?>");
        file.println(offset0 + "<Dbtable name=" + "\"" + this.name + "\"" + ">");
        String offset1 = offset0 + DtHelper.tabulate();
        file.println(offset0 + "<columns>");
        Iterator iter = this.gColumns.keySet().iterator();
        while (iter.hasNext()) {
            ((DtColumnExpanded)this.gColumns.get(iter.next())).writeToXmlFile(file, offset1);
        }
        file.println(offset0 + "</columns>");
        String offset2 = offset1 + DtHelper.tabulate();
        String offset3 = offset1 + DtHelper.tabulate();
        if (this.gPrimaryKey != null) {
            file.println(offset0 + "<primary-key>");
            file.println(offset1 + "<columns>");
            i = 0;
            while (i < this.gPrimaryKey.size()) {
                file.println(offset2 + "<column>" + (String)this.gPrimaryKey.get(i) + "</column>");
                ++i;
            }
        }
        file.println(offset1 + "</columns>");
        file.println(offset0 + "</primary-key>");
        if (this.gIndexes != null) {
            file.println(offset0 + "<indexes>");
            i = 0;
            while (i < this.gIndexes.size()) {
                ((DtIndexExpanded)this.gIndexes.get(i)).writeToXmlFile(file, offset1);
                ++i;
            }
            file.println(offset1 + "</indexes>");
        }
        if (this.getTechnicalInfoExists()) {
            file.println(offset0 + "<technical-info>");
            file.println(offset1 + "<size-category>" + this.numberOfRecords + "</size-category>");
            file.println(offset1 + "<is-buffered>" + this.isBuffered + "</is-buffered>");
            file.println(offset1 + "<gen-key-count>" + this.genKeyCount + "</gen-key-count>");
            file.println(offset0 + "</technical-info>");
        }
        if (this.getDatabaseInfoExists()) {
            file.println(offset0 + "<database-exclusive-info>");
            i = 0;
            while (i < this.gDatabaseInfo.size()) {
                file.println(offset1 + "<database-exclusive>");
                ((DtDatabaseInfoExpanded)this.gDatabaseInfo.get(i)).writeToXmlFile(file, offset2);
                file.println(offset1 + "</database-exclusive>");
                ++i;
            }
            file.println(offset0 + "</database-exclusive-info>");
        }
        file.println(offset0 + "</Dbtable>");
        file.close();
    }

    public XmlMap getXmlMap() {
        XmlMap tableMap = new XmlMap();
        XmlMap body = new XmlMap();
        XmlMap columns = new XmlMap();
        XmlMap primaryKey = new XmlMap();
        XmlMap primaryKeyColumns = new XmlMap();
        XmlMap indexes = new XmlMap();
        XmlMap technicalInfo = new XmlMap();
        XmlMap databaseInfo = new XmlMap();
        body.put("name", this.name);
        Iterator iter = this.gColumns.keySet().iterator();
        int i = 0;
        while (iter.hasNext()) {
            columns.put("column" + (i == 0 ? "" : "" + i), ((DtColumnExpanded)this.gColumns.get(iter.next())).getXmlMap());
            ++i;
        }
        body.put("columns", columns);
        if (this.gPrimaryKey != null) {
            primaryKey.put("tabname", this.name);
            i = 0;
            while (i < this.gPrimaryKey.size()) {
                primaryKeyColumns.put("column" + (i == 0 ? "" : "" + i), (String)this.gPrimaryKey.get(i));
                ++i;
            }
            primaryKey.put("columns", primaryKeyColumns);
            body.put("primary-key", primaryKey);
        }
        if (this.gIndexes != null) {
            i = 0;
            while (i < this.gIndexes.size()) {
                indexes.put("index" + (i == 0 ? "" : "" + i), ((DtIndexExpanded)this.gIndexes.get(i)).getXmlMap());
                ++i;
            }
            body.put("indexes", indexes);
        }
        if (this.getTechnicalInfoExists()) {
            technicalInfo.put("size-category", Integer.toString(this.numberOfRecords));
            technicalInfo.put("is-buffered", new Boolean(this.isBuffered).toString());
            technicalInfo.put("gen-key-count", Integer.toString(this.genKeyCount));
            body.put("technical-info", technicalInfo);
        }
        if (this.getDatabaseInfoExists()) {
            i = 0;
            while (i < this.gDatabaseInfo.size()) {
                databaseInfo.put("databaseInfo" + (i == 0 ? "" : "" + i), ((DtDatabaseInfoExpanded)this.gDatabaseInfo.get(i)).getXmlMap());
                ++i;
            }
            body.put("database-exclusive-info", databaseInfo);
        }
        tableMap.put("Dbtable", body);
        return tableMap;
    }

    public String toString() {
        Iterator iter = null;
        String s = null;
        s = "Table: " + this.name + "\n" + "\n";
        iter = this.gColumns.keySet().iterator();
        while (iter.hasNext()) {
            s = s + (DtColumnExpanded)this.gColumns.get(iter.next());
        }
        if (this.gPrimaryKey != null) {
            Iterator pkIter = ((AbstractList)this.gPrimaryKey).iterator();
            s = s + "  Primary Key: " + "\n";
            s = s + "  Tablename    " + this.name + "\n" + "  Keyfields:   " + "\n";
            while (pkIter.hasNext()) {
                s = s + "   " + (String)pkIter.next() + "\n";
            }
        }
        if (this.gIndexes != null) {
            s = s + "  Indexes" + "\n";
            iter = ((AbstractList)this.gIndexes).listIterator();
            while (iter.hasNext()) {
                s = s + (DtIndexExpanded)iter.next();
            }
        }
        s = s + "  Technical Settings:" + "\n" + "  NumberOfRecords  " + this.numberOfRecords + "\n" + "  isBuffered        " + this.isBuffered + "\n" + "  genKeyCount      " + this.genKeyCount + "\n";
        if (this.gDatabaseInfo != null && !this.gDatabaseInfo.isEmpty()) {
            iter = ((AbstractList)this.gDatabaseInfo).listIterator();
            s = s + "  Additional Database Info:" + "\n";
            while (iter.hasNext()) {
                s = s + (DtDatabaseInfoExpanded)iter.next();
            }
        }
        return s;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

