/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.designtime;

import com.sap.dictionary.database.dbs.XmlMap;
import com.sap.dictionary.designtime.DtColumnChecker;
import com.sap.dictionary.designtime.DtHelper;
import com.sap.dictionary.designtime.DtStructureColumnExpanded;
import com.sap.dictionary.designtime.DtTypeInfoForDatabase;
import com.sap.dictionary.designtime.ExpandException;
import com.sap.ide.metamodel.dictionary.datatype.BooleanEnum;
import com.sap.ide.metamodel.dictionary.datatype.DtDbTypeInfo;
import com.sap.ide.metamodel.dictionary.datatype.DtField;
import com.sap.ide.metamodel.dictionary.datatype.DtSimpleType;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;

public class DtColumnExpanded
extends DtStructureColumnExpanded {
    private String javaSqlTypeName = "";
    private boolean isNotNull = false;
    private String defaultValue = "";
    private HashMap gTypeInfos = new HashMap();
    private String tabname = "";

    public DtColumnExpanded(DtField dtField, int position) throws ExpandException {
        super(dtField, position);
        DtDbTypeInfo[] typeInfos;
        this.javaSqlTypeName = dtField.getJdbcTypeName();
        this.isNotNull = true;
        if (dtField.getNotNull() == BooleanEnum.FALSE) {
            this.isNotNull = false;
        } else if (dtField.getNotNull() == BooleanEnum.TRUE) {
            this.isNotNull = true;
        }
        if (this.javaSqlTypeName != null && (this.javaSqlTypeName.equalsIgnoreCase("CLOB") || this.javaSqlTypeName.equalsIgnoreCase("BLOB"))) {
            this.isNotNull = false;
        }
        this.defaultValue = this.builtInType.equalsIgnoreCase("string") ? DtHelper.removeTrailingSpaces(dtField.getDbDefault()) : (this.builtInType.equalsIgnoreCase("time") || this.builtInType.equalsIgnoreCase("timestamp") || this.builtInType.equalsIgnoreCase("date") ? "" : dtField.getDbDefault());
        if ((this.builtInType.equalsIgnoreCase("string") || this.builtInType.equalsIgnoreCase("binary")) && (typeInfos = dtField.getTypeInfos()) != null) {
            String databaseName = null;
            int i = 0;
            while (i < typeInfos.length) {
                databaseName = typeInfos[i].getDatabase().toString();
                DtTypeInfoForDatabase typeInfoForDb = null;
                if (databaseName != null) {
                    typeInfoForDb = new DtTypeInfoForDatabase(databaseName, typeInfos[i].getJdbcTypeName(), typeInfos[i].getDatabaseTypeName());
                    this.gTypeInfos.put(databaseName, typeInfoForDb);
                }
                ++i;
            }
        }
    }

    public DtColumnExpanded(DtField dtField, int position, DtSimpleType dtSimpleType) throws ExpandException {
        super(dtField, position, dtSimpleType);
        this.javaSqlTypeName = this.gSimpleType.getJdbcTypeName();
        if ((this.builtInType.equalsIgnoreCase("string") || this.builtInType.equalsIgnoreCase("binary")) && this.gSimpleType.getTypeInfoExists()) {
            this.gTypeInfos = this.gSimpleType.getTypeInfos();
        }
        this.isNotNull = this.gSimpleType.getNotNull();
        this.defaultValue = this.builtInType.equalsIgnoreCase("string") ? DtHelper.removeTrailingSpaces(this.gSimpleType.getDbDefault()) : (this.builtInType.equalsIgnoreCase("time") || this.builtInType.equalsIgnoreCase("timestamp") || this.builtInType.equalsIgnoreCase("date") ? "" : this.gSimpleType.getDbDefault());
    }

    public void setTabname(String tabname) {
        this.tabname = tabname;
    }

    public String getTabname() {
        return this.tabname;
    }

    public String getJavaSqlTypeName() {
        return this.javaSqlTypeName;
    }

    public boolean getIsNotNull() {
        return this.isNotNull;
    }

    public void setIsNotNull(boolean isNotNull) {
        this.isNotNull = isNotNull;
    }

    public String getDefaultValue() {
        return DtHelper.escapeXML(this.defaultValue);
    }

    public boolean getTypeInfoExists() {
        return this.gTypeInfos != null && !this.gTypeInfos.isEmpty();
    }

    public HashMap getTypeInfo() {
        return this.gTypeInfos;
    }

    void writeToXmlFile(PrintWriter file, String offset0) {
        file.println(offset0 + "<column name=" + "\"" + this.name + "\"" + ">");
        String offset = offset0 + DtHelper.tabulate();
        file.println(offset + "<position>" + this.position + "</position>");
        file.println(offset + "<java-sql-type>" + this.javaSqlTypeName + "</java-sql-type>");
        file.println(offset + "<length>" + this.length + "</length>");
        file.println(offset + "<decimals>" + this.decimals + "</decimals>");
        file.println(offset + "<is-not-null>" + this.isNotNull + "</is-not-null>");
        if (this.defaultValue != null) {
            file.println(offset + "<default-value>" + this.defaultValue + "</default-value>");
        }
        file.println(offset0 + "</column>");
    }

    public XmlMap getXmlMap() {
        XmlMap column = new XmlMap();
        column.put("name", this.name);
        column.put("position", Integer.toString(this.position));
        column.put("java-sql-type", this.javaSqlTypeName);
        column.put("length", Integer.toString(this.length));
        column.put("decimals", Integer.toString(this.decimals));
        if (this.isNotNull) {
            column.put("is-not-null", "true");
        } else {
            column.put("is-not-null", "false");
        }
        if (this.defaultValue != null) {
            column.put("default-value", this.defaultValue);
        }
        if (this.gTypeInfos != null) {
            XmlMap typeInfos = new XmlMap();
            Iterator iter = this.gTypeInfos.keySet().iterator();
            int i = 0;
            while (iter.hasNext()) {
                typeInfos.put("type-info-additional" + (i == 0 ? "" : "" + i), ((DtTypeInfoForDatabase)this.gTypeInfos.get(iter.next())).getXmlMap());
                ++i;
            }
            column.put("types-info-additional", typeInfos);
        }
        return column;
    }

    public boolean columnIsOk(HashMap messages) {
        DtColumnChecker checker = new DtColumnChecker(this, messages);
        return checker.nameIsOk() & checker.typeIsOk() & checker.decimalIsOk() & checker.reservedWordIsUsed() & checker.dbDefaultIsOk();
    }

    public String toString() {
        String s = "";
        s = s + "  Fieldname     " + this.name + "\n" + "  Position      " + this.position + "\n" + "  Typename      " + this.getTypeName() + "\n" + "  JDBCType      " + this.javaSqlTypeName + "\n" + "  Length        " + this.length + " \n" + "  Decimals      " + this.decimals + " \n" + "  IsNotNull     " + this.isNotNull + "\n" + "  DefaultValue  " + this.defaultValue + "\n";
        if (this.getTypeInfoExists()) {
            s = s + "\n" + "   AdditionalTypeInfo" + "\n";
            Iterator iter = this.gTypeInfos.keySet().iterator();
            while (iter.hasNext()) {
                s = s + (DtTypeInfoForDatabase)this.gTypeInfos.get(iter.next());
            }
        }
        return s + "\n";
    }
}

