/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.designtime;

import com.sap.dictionary.designtime.DtColumnExpanded;
import com.sap.dictionary.designtime.DtHelper;
import com.sap.dictionary.designtime.DtStructureColumnChecker;
import com.sap.dictionary.designtime.DtTypeInfo;
import com.sap.dictionary.designtime.ErrTexts;
import com.sap.sql.sqlparser.SQLKeywords;
import java.util.HashMap;

public class DtColumnChecker
extends DtStructureColumnChecker {
    public DtColumnChecker() {
    }

    public DtColumnChecker(DtColumnExpanded expColumn, HashMap messages) {
        super(expColumn, messages);
    }

    public boolean nameIsOk() {
        String allowedCharacters = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_";
        String allowedAtFirstPosition = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        HashMap<String, String> messages = new HashMap<String, String>();
        int ch = 32;
        int i = 0;
        while (i < this.columnName.length()) {
            ch = this.columnName.toUpperCase().charAt(i);
            if (allowedCharacters.indexOf(ch) == -1) {
                messages.put(ErrTexts.get("029"), "Error");
            }
            ++i;
        }
        ch = this.columnName.toUpperCase().charAt(0);
        if (allowedAtFirstPosition.indexOf(ch) == -1) {
            messages.put(ErrTexts.get("030"), "Error");
        }
        if (this.columnName.length() > 18) {
            messages.put(DtHelper.concat(ErrTexts.get("109"), this.columnName), "Error");
        }
        if (messages.isEmpty()) {
            return true;
        }
        this.mess.putAll(messages);
        return false;
    }

    public boolean nameIsOk(String columnName) {
        this.columnName = columnName;
        return this.nameIsOk();
    }

    public boolean typeIsOk() {
        String fieldName = null;
        String javaSqlType = null;
        Object ddType = null;
        if (!super.typeIsOk()) {
            return false;
        }
        fieldName = this.expColumn.getName();
        javaSqlType = ((DtColumnExpanded)this.expColumn).getJavaSqlTypeName();
        if (!DtTypeInfo.getSupportedJdbcTypes().contains(javaSqlType)) {
            this.mess.put(DtHelper.concat(ErrTexts.get("105"), javaSqlType, fieldName), "Error");
            return false;
        }
        if (this.expColumn.getBuiltInType().equalsIgnoreCase("BOOLEAN")) {
            this.mess.put(DtHelper.concat(ErrTexts.get("116"), fieldName), "Error");
            return false;
        }
        return true;
    }

    public boolean decimalIsOk() {
        int length = 0;
        int decimals = 0;
        String fieldName = null;
        String builtInType = null;
        fieldName = this.expColumn.getName();
        builtInType = this.expColumn.getBuiltInType();
        if (builtInType.equalsIgnoreCase("decimals")) {
            length = this.expColumn.getLength();
            decimals = this.expColumn.getDecimals();
            if (length == 0 || decimals == 0) {
                this.mess.put(DtHelper.concat(ErrTexts.get("107"), fieldName), "Error");
                return false;
            }
            if (decimals >= length) {
                this.mess.put(ErrTexts.get("122"), "Error");
                return false;
            }
        }
        return true;
    }

    public boolean reservedWordIsUsed() {
        String fieldName = this.expColumn.getName();
        if (SQLKeywords.isKeyword((String)fieldName)) {
            this.mess.put(DtHelper.concat(ErrTexts.get("112"), fieldName), "Error");
            return false;
        }
        return true;
    }

    public boolean dbDefaultIsOk() {
        boolean isSet = true;
        boolean border = true;
        if (this.expColumn.getBuiltInType().equalsIgnoreCase("binary")) {
            return true;
        }
        if (this.expColumn.getBuiltInType().equalsIgnoreCase("date")) {
            return true;
        }
        if (this.expColumn.getBuiltInType().equalsIgnoreCase("time")) {
            return true;
        }
        if (this.expColumn.getBuiltInType().equalsIgnoreCase("timestamp")) {
            return true;
        }
        String fieldName = this.expColumn.getName();
        boolean isNotNull = ((DtColumnExpanded)this.expColumn).getIsNotNull();
        String dbDefault = ((DtColumnExpanded)this.expColumn).getDefaultValue();
        if (isNotNull && (dbDefault == null || dbDefault.equalsIgnoreCase(""))) {
            this.mess.put(DtHelper.concat(ErrTexts.get("115"), fieldName), "Warning");
            isSet = true;
        }
        if (dbDefault != null) {
            if (dbDefault.startsWith("'") || dbDefault.endsWith("'")) {
                this.mess.put(DtHelper.concat(ErrTexts.get("120"), fieldName), "Error");
                border = false;
            }
            if (dbDefault.startsWith("\"") || dbDefault.endsWith("\"")) {
                this.mess.put(DtHelper.concat(ErrTexts.get("121"), fieldName), "Warning");
                border = true;
            }
        }
        return isSet && border;
    }

    public HashMap getMessages() {
        return this.mess;
    }
}

