/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.col.servicemanager.core.calls;

import com.sap.tc.col.edo.IEdoTable;
import com.sap.tc.col.rpe.RpeParameter;
import com.sap.tc.col.servicemanager.api.ISrvMgrServiceModule;
import com.sap.tc.col.servicemanager.api.calls.ISrvMgrUpdateRow;
import com.sap.tc.col.servicemanager.core.AbstractServiceManager;
import com.sap.tc.col.servicemanager.core.CoolFeature;
import com.sap.tc.col.servicemanager.core.calls.AbstractAspectCall;
import java.util.ArrayList;

public class SrvMgrUpdateRow
extends AbstractAspectCall
implements ISrvMgrUpdateRow {
    IEdoTable mInRecords;

    public SrvMgrUpdateRow(ISrvMgrServiceModule serviceModule, String aspectName) {
        super(serviceModule, aspectName);
    }

    public void setInRecords(IEdoTable inRecords) {
        this.mInRecords = inRecords;
    }

    public IEdoTable getInRecords() {
        if (this.mInRecords == null) {
            this.mInRecords = this.createInRecordsTable();
        }
        return this.mInRecords;
    }

    public IEdoTable createInRecordsTable() {
        return this.createAspectInRecordsTable();
    }

    public void processCall() {
        this.validateStateForProcessing();
        AbstractServiceManager sm = (AbstractServiceManager)this.mServiceModule.getServiceManager();
        RpeParameter inRecords = this.getInRecordsParameter(sm, this.getInRecords());
        RpeParameter aspect = this.getAspectNameParameter(sm);
        RpeParameter serviceModule = this.getServiceModuleParameter(sm);
        ArrayList<RpeParameter> inp = new ArrayList<RpeParameter>();
        inp.add(inRecords);
        inp.add(aspect);
        inp.add(serviceModule);
        ArrayList<RpeParameter> out = new ArrayList<RpeParameter>();
        out.add(this.getOutRecordsParameter(sm));
        if (sm.isFeatureActive(CoolFeature.MESSAGES_OUT_OF_BAND_ONLY)) {
            out.add(this.getReturnCodeParameter(sm));
            out.add(this.getRejectedParameter(sm));
        } else {
            out.add(this.getMessageParameter(sm));
        }
        sm.callMethod("IF_COL_SERVICE_MANAGER~ASPECT_UPDATE", inp, out);
        sm.queueCall(this);
        sm.setToSave(true);
    }

    public void reset() {
        this.mInRecords = null;
        super.reset();
    }

    public void cleanupMessages() {
        this.removeAspectRowMessages(this.getAspectDescriptor(), this.getInRecords());
    }
}

