/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.col.servicemanager.core.calls;

import com.sap.tc.col.edo.IEdoTable;
import com.sap.tc.col.rpe.RpeParameter;
import com.sap.tc.col.servicemanager.api.ISrvMgrServiceModule;
import com.sap.tc.col.servicemanager.api.calls.ISrvMgrLock;
import com.sap.tc.col.servicemanager.core.AbstractServiceManager;
import com.sap.tc.col.servicemanager.core.CoolFeature;
import com.sap.tc.col.servicemanager.core.calls.AbstractAspectCall;
import java.util.ArrayList;

public class SrvMgrLock
extends AbstractAspectCall
implements ISrvMgrLock {
    private static String[] sLockMap = new String[]{" ", "X", "S", "SP"};
    private IEdoTable mInKeys;
    private int mLockMode;

    static String convertLockMode(int lockMode) {
        if (lockMode < 0 || lockMode >= sLockMap.length) {
            throw new IllegalArgumentException("Unsupported lock mode, see com.sap.tc.col.servicemanager.api.calls.ISrvMgrLock for valid values.");
        }
        return sLockMap[lockMode];
    }

    public SrvMgrLock(ISrvMgrServiceModule serviceModule, String aspectName) {
        super(serviceModule, aspectName);
    }

    public void setInKeys(IEdoTable inKeys) {
        this.mInKeys = inKeys;
    }

    public IEdoTable getInKeys() {
        if (this.mInKeys == null) {
            this.mInKeys = this.createInKeysTable();
        }
        return this.mInKeys;
    }

    public void processCall() {
        this.validateStateForProcessing();
        AbstractServiceManager sm = (AbstractServiceManager)this.mServiceModule.getServiceManager();
        RpeParameter inKeys = this.getInKeysParameter(sm, this.getInKeys());
        RpeParameter lockMode = this.getLockModeParameter(sm, this.mLockMode);
        RpeParameter aspect = this.getAspectNameParameter(sm);
        RpeParameter serviceModule = this.getServiceModuleParameter(sm);
        ArrayList<RpeParameter> inp = new ArrayList<RpeParameter>();
        inp.add(inKeys);
        inp.add(lockMode);
        inp.add(aspect);
        inp.add(serviceModule);
        ArrayList<RpeParameter> out = new ArrayList<RpeParameter>();
        if (sm.isFeatureActive(CoolFeature.MESSAGES_OUT_OF_BAND_ONLY)) {
            out.add(this.getReturnCodeParameter(sm));
            out.add(this.getRejectedParameter(sm));
        } else {
            out.add(this.getMessageParameter(sm));
        }
        sm.callMethod("IF_COL_SERVICE_MANAGER~ASPECT_LOCK", inp, out);
        sm.queueCall(this);
    }

    public void reset() {
        this.mInKeys = null;
        this.mLockMode = 2;
        super.reset();
    }

    public IEdoTable createInKeysTable() {
        return this.createAspectInKeysTable();
    }

    protected IEdoTable createOutRecordsTable() {
        return null;
    }

    public void setLockMode(int lockMode) {
        this.mLockMode = lockMode;
    }

    public int getLockMode() {
        return this.mLockMode;
    }

    public void cleanupMessages() {
    }
}

