/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.col.servicemanager.core.calls;

import com.sap.tc.col.client.metadata.api.IStructureDescriptor;
import com.sap.tc.col.client.metadata.core.RelationDescriptor;
import com.sap.tc.col.client.metadata.core.StructureDescriptor;
import com.sap.tc.col.edo.IEdoStructure;
import com.sap.tc.col.edo.IEdoTable;
import com.sap.tc.col.rpe.RpeParameter;
import com.sap.tc.col.servicemanager.api.ISrvMgrServiceModule;
import com.sap.tc.col.servicemanager.api.calls.ISrvMgrInsert;
import com.sap.tc.col.servicemanager.core.AbstractServiceManager;
import com.sap.tc.col.servicemanager.core.CoolFeature;
import com.sap.tc.col.servicemanager.core.calls.AbstractAspectCall;
import java.util.ArrayList;

public class SrvMgrInsert
extends AbstractAspectCall
implements ISrvMgrInsert {
    private IEdoTable mInRecords;
    private IEdoStructure mInRelationKey;
    private IEdoStructure mRelatedOutRecord;
    private RelationDescriptor mInsertRelationDescriptor = null;

    public SrvMgrInsert(ISrvMgrServiceModule serviceModule, String aspectName) {
        super(serviceModule, aspectName);
        String insertRelation = this.mAspectDescriptor.getAttributeInsertRelation();
        if (!"".equals(insertRelation)) {
            this.mInsertRelationDescriptor = (RelationDescriptor)this.mAspectDescriptor.getRelationDescriptor(insertRelation);
            if (this.mInsertRelationDescriptor == null) {
                throw new RuntimeException("Unknown insert relation: '" + insertRelation + "' on aspect '" + this.mAspectDescriptor.getName() + "'");
            }
        }
    }

    public void setInRecords(IEdoTable inRecords) {
        this.mInRecords = inRecords;
    }

    public IEdoTable getInRecords() {
        if (this.mInRecords == null) {
            this.mInRecords = this.createInRecordsTable();
        }
        return this.mInRecords;
    }

    public void processCall() {
        if (this.mInRelationKey == null && this.getAspectDescriptor().getAttributeInsertRelationRequired()) {
            throw new IllegalArgumentException("No insert relation key given. This is requiered for aspect '" + this.getAspectDescriptor().getName() + "'");
        }
        this.validateStateForProcessing();
        AbstractServiceManager sm = (AbstractServiceManager)this.mServiceModule.getServiceManager();
        RpeParameter outRecords = this.getOutRecordsParameter(sm);
        ArrayList<RpeParameter> inp = new ArrayList<RpeParameter>();
        inp.add(this.getInRecordsParameter(sm, this.getInRecords()));
        inp.add(this.getAspectNameParameter(sm));
        inp.add(this.getServiceModuleParameter(sm));
        ArrayList<RpeParameter> out = new ArrayList<RpeParameter>();
        out.add(outRecords);
        if (sm.isFeatureActive(CoolFeature.MESSAGES_OUT_OF_BAND_ONLY)) {
            out.add(this.getReturnCodeParameter(sm));
            out.add(this.getRejectedParameter(sm));
        } else {
            out.add(this.getMessageParameter(sm));
        }
        if (this.mInRelationKey != null) {
            inp.add(sm.createParameter("RELATION", "STRING", "I", "A", this.mInsertRelationDescriptor.getName()));
            inp.add(sm.createParameter("RELATION_INKEY", this.getRelationInKey().getDescriptor().getName(), "I", "S", this.getRelationInKey()));
            out.add(sm.createParameter("RELATION_OUTRECORD", this.getRelationOutRecord().getDescriptor().getName(), "E", "S", this.getRelationOutRecord()));
        }
        sm.callMethod("IF_COL_SERVICE_MANAGER~ASPECT_INSERT", inp, out);
        sm.queueCall(this);
        sm.setToSave(true);
    }

    public void reset() {
        this.mInRecords = null;
        this.mInRelationKey = null;
        this.mRelatedOutRecord = null;
        super.reset();
    }

    public IEdoTable createInRecordsTable() {
        return this.createAspectInRecordsTable();
    }

    public IEdoStructure createRelationInKey() {
        if (this.mInsertRelationDescriptor == null) {
            throw new UnsupportedOperationException("Insert by relation not supported by aspect '" + this.getAspectDescriptor().getName() + "'");
        }
        return this.mServiceModule.createStructure((IStructureDescriptor)((StructureDescriptor)this.mInsertRelationDescriptor.getTargetAspectDescriptor().getKeyDescriptor().getStructure()));
    }

    public IEdoStructure getRelationInKey() {
        if (this.mInRelationKey == null) {
            this.mInRelationKey = this.createRelationInKey();
        }
        return this.mInRelationKey;
    }

    public void setRelationInKey(IEdoStructure inKey) {
        if (this.mInsertRelationDescriptor == null) {
            throw new UnsupportedOperationException("Insert by relation not supported by aspect '" + this.getAspectDescriptor().getName() + "'");
        }
        this.mInRelationKey = inKey;
    }

    private IEdoStructure createRelatedOutRecordStructure() {
        if (this.mInsertRelationDescriptor == null) {
            return null;
        }
        return this.mServiceModule.createStructure((IStructureDescriptor)((StructureDescriptor)this.mInsertRelationDescriptor.getTargetAspectDescriptor().getStructure()));
    }

    public IEdoStructure getRelationOutRecord() {
        if (this.mInsertRelationDescriptor == null) {
            throw new UnsupportedOperationException("Insert by relation not supported by aspect '" + this.getAspectDescriptor().getName() + "'");
        }
        if (this.mRelatedOutRecord == null) {
            this.mRelatedOutRecord = this.createRelatedOutRecordStructure();
        }
        return this.mRelatedOutRecord;
    }

    public void cleanupMessages() {
        this.removeAspectRowMessages(this.getAspectDescriptor(), this.getInRecords());
    }
}

