/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.col.servicemanager.core.calls;

import com.sap.tc.col.client.metadata.api.IStructureDescriptor;
import com.sap.tc.col.client.metadata.core.AspectDescriptor;
import com.sap.tc.col.client.metadata.core.ServiceModuleDescriptor;
import com.sap.tc.col.edo.IEdoTable;
import com.sap.tc.col.servicemanager.api.ISrvMgrServiceModule;
import com.sap.tc.col.servicemanager.api.calls.ISrvMgrCopyCorresponding;
import com.sap.tc.col.servicemanager.core.AbstractServiceManager;
import com.sap.tc.col.servicemanager.core.calls.AbstractCall;
import com.sap.tc.col.servicemanager.core.typeinfo.AspectType;

public class SrvMgrCopyCorresponding
extends AbstractCall
implements ISrvMgrCopyCorresponding {
    private AspectDescriptor mInputAspectDescriptor;
    private AspectType mInputAspectTypeInfo;
    private AspectDescriptor mOutputAspectDescriptor;
    private AspectType mOutputAspectTypeInfo;
    private IEdoTable mInRecords;

    public SrvMgrCopyCorresponding(ISrvMgrServiceModule serviceModule, String inputAspectName, String outputAspectName) {
        super(serviceModule);
        this.mInputAspectDescriptor = (AspectDescriptor)serviceModule.getDescriptor().getAspectDescriptor(inputAspectName);
        this.mInputAspectTypeInfo = new AspectType(this.mInputAspectDescriptor, (ServiceModuleDescriptor)serviceModule.getDescriptor());
        this.mOutputAspectDescriptor = (AspectDescriptor)serviceModule.getDescriptor().getAspectDescriptor(outputAspectName);
        this.mOutputAspectTypeInfo = new AspectType(this.mOutputAspectDescriptor, (ServiceModuleDescriptor)serviceModule.getDescriptor());
    }

    protected IEdoTable createOutRecordsTable() {
        return this.mServiceModule.createTable((IStructureDescriptor)this.mOutputAspectTypeInfo.type_outrecords);
    }

    public IEdoTable createInRecordsTable() {
        return this.mServiceModule.createTable((IStructureDescriptor)this.mInputAspectTypeInfo.type_outrecords);
    }

    public void setInRecords(IEdoTable inRecords) {
        this.mInRecords = inRecords;
    }

    public IEdoTable getInRecords() {
        if (this.mInRecords == null) {
            this.mInRecords = this.createInRecordsTable();
        }
        return this.mInRecords;
    }

    public void processCall() {
        this.validateStateForProcessing();
        if (this.mInRecords == null) {
            throw new RuntimeException("Input records can not be null for ISrvMgrCopyCorresponding calls");
        }
        AbstractServiceManager sm = (AbstractServiceManager)this.mServiceModule.getServiceManager();
        sm.copyCorresponding(this.getInRecords(), this.getOutRecords());
        sm.queueCall(this);
    }

    public void reset() {
        this.mInRecords = null;
        super.reset();
    }

    public void cleanupMessages() {
    }
}

