/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.col.servicemanager.core.calls;

import com.sap.tc.col.client.metadata.api.IAspectActionDescriptor;
import com.sap.tc.col.client.metadata.api.IAspectDescriptor;
import com.sap.tc.col.client.metadata.api.IStructureDescriptor;
import com.sap.tc.col.client.metadata.core.AspectActionDescriptor;
import com.sap.tc.col.client.metadata.core.RelationDescriptor;
import com.sap.tc.col.client.metadata.core.ServiceModuleDescriptor;
import com.sap.tc.col.client.metadata.core.StructureDescriptor;
import com.sap.tc.col.edo.IEdoStructure;
import com.sap.tc.col.edo.IEdoTable;
import com.sap.tc.col.rpe.RpeParameter;
import com.sap.tc.col.servicemanager.api.ISrvMgrServiceModule;
import com.sap.tc.col.servicemanager.api.calls.ISrvMgrAction;
import com.sap.tc.col.servicemanager.core.AbstractServiceManager;
import com.sap.tc.col.servicemanager.core.CoolFeature;
import com.sap.tc.col.servicemanager.core.calls.AbstractAspectCall;
import com.sap.tc.col.servicemanager.core.typeinfo.ActionType;
import java.util.ArrayList;

public class SrvMgrAction
extends AbstractAspectCall
implements ISrvMgrAction {
    private AspectActionDescriptor mAspectActionDescriptor;
    private IEdoTable mInKeys;
    private IEdoStructure mInParameters;
    private IEdoStructure mInRelationKey;
    private IEdoStructure mRelatedOutRecord;
    private RelationDescriptor mActionRelationDescriptor = null;
    private ActionType mActionTypeInfo;

    public SrvMgrAction(ISrvMgrServiceModule serviceModule, String aspectName, String actionName) {
        super(serviceModule, aspectName);
        this.mAspectActionDescriptor = (AspectActionDescriptor)this.mAspectDescriptor.getAspectActionDescriptor(actionName);
        if (this.mAspectActionDescriptor == null) {
            throw new RuntimeException("Unknown action requested " + actionName + " on aspect " + this.mAspectDescriptor.getName());
        }
        this.mActionTypeInfo = new ActionType(this.mAspectActionDescriptor, (ServiceModuleDescriptor)serviceModule.getDescriptor());
        String actionRelation = this.mAspectActionDescriptor.getAttributeRelation();
        if (!"".equals(actionRelation)) {
            this.mActionRelationDescriptor = (RelationDescriptor)this.getAspectDescriptor().getRelationDescriptor(actionRelation);
            if (this.mActionRelationDescriptor == null) {
                throw new RuntimeException("Unknown action relation: '" + actionRelation + "' on action '" + this.mAspectActionDescriptor.getName() + "' in aspect '" + this.getAspectDescriptor().getName() + "'");
            }
        }
    }

    public IEdoTable createInKeysTable() {
        return this.mServiceModule.createTable((IStructureDescriptor)this.mActionTypeInfo.type_input_keys);
    }

    public void setInKeys(IEdoTable inKeys) {
        this.mInKeys = inKeys;
    }

    public IEdoTable getInKeys() {
        if (this.mInKeys == null) {
            this.mInKeys = this.createInKeysTable();
        }
        return this.mInKeys;
    }

    public void setInParameters(IEdoStructure inParameters) {
        if (!this.getAspectActionDescriptor().hasInputParameters()) {
            throw new UnsupportedOperationException("This aspect action does not have input parameters!");
        }
        this.mInParameters = inParameters;
    }

    public IEdoStructure getInParameters() {
        if (this.getAspectActionDescriptor().hasInputParameters()) {
            if (this.mInParameters == null) {
                this.mInParameters = this.createInParameterList();
            }
            return this.mInParameters;
        }
        throw new UnsupportedOperationException("This aspect action does not have input parameters!");
    }

    public void addInParameter(String name, String value) {
        if (!this.getAspectActionDescriptor().hasInputParameters()) {
            throw new UnsupportedOperationException("This aspect action does not have input parameters!");
        }
        this.getInParameters().setStringValue(name, value);
    }

    public IAspectActionDescriptor getAspectActionDescriptor() {
        return this.mAspectActionDescriptor;
    }

    public void processCall() {
        this.validateStateForProcessing();
        AbstractServiceManager sm = (AbstractServiceManager)this.mServiceModule.getServiceManager();
        RpeParameter inKeys = sm.createParameter("INKEYS", this.mActionTypeInfo.type_input_keys.getName(), "I", "T", this.getInKeys());
        RpeParameter action = sm.createParameter("ACTION", "STRING", "I", "A", this.mActionTypeInfo.actionName);
        RpeParameter serviceModule = sm.createParameter("SERVICE_MODULE", "STRING", "I", "A", this.mActionTypeInfo.smName);
        RpeParameter aspect = sm.createParameter("ASPECT", "STRING", "I", "A", this.mActionTypeInfo.aspectName);
        RpeParameter outRecords = this.getOutRecordsParameter(sm);
        ArrayList<RpeParameter> inp = new ArrayList<RpeParameter>();
        inp.add(inKeys);
        inp.add(action);
        inp.add(serviceModule);
        inp.add(aspect);
        if (this.getAspectActionDescriptor().hasInputParameters()) {
            RpeParameter inParams = sm.createParameter("INPARAM", this.mActionTypeInfo.type_input_parameters.getName(), "I", "S", this.getInParameters());
            inp.add(inParams);
        }
        ArrayList<RpeParameter> out = new ArrayList<RpeParameter>();
        out.add(outRecords);
        if (this.mInRelationKey != null) {
            inp.add(sm.createParameter("RELATION", "STRING", "I", "A", this.mActionRelationDescriptor.getName()));
            inp.add(sm.createParameter("RELATION_INKEY", this.getRelationInKey().getDescriptor().getName(), "I", "S", this.getRelationInKey()));
            out.add(sm.createParameter("RELATION_OUTRECORD", this.getRelationOutRecord().getDescriptor().getName(), "E", "S", this.getRelationOutRecord()));
        }
        if (sm.isFeatureActive(CoolFeature.MESSAGES_OUT_OF_BAND_ONLY)) {
            out.add(this.getReturnCodeParameter(sm));
            out.add(this.getRejectedParameter(sm));
        } else {
            out.add(this.getMessageParameter(sm));
        }
        sm.callMethod("IF_COL_SERVICE_MANAGER~ACTION_EXECUTE", inp, out);
        sm.queueCall(this);
        sm.setToSave(true);
    }

    public void reset() {
        this.mInKeys = null;
        this.mInParameters = null;
        this.mInRelationKey = null;
        this.mRelatedOutRecord = null;
        super.reset();
    }

    public IEdoStructure createInParameterList() {
        if (this.getAspectActionDescriptor().hasInputParameters()) {
            return this.mServiceModule.createStructure((IStructureDescriptor)this.mActionTypeInfo.type_input_parameters);
        }
        throw new UnsupportedOperationException("This aspect action does not have input parameters!");
    }

    public IEdoStructure createRelationInKey() {
        if (this.mActionRelationDescriptor == null) {
            throw new UnsupportedOperationException("Action relation not supportes by action '" + this.getAspectActionDescriptor().getName() + "' in aspect '" + this.getAspectDescriptor().getName() + "'");
        }
        return this.mServiceModule.createStructure((IStructureDescriptor)((StructureDescriptor)this.mActionRelationDescriptor.getTargetAspectDescriptor().getKeyDescriptor().getStructure()));
    }

    public IEdoStructure getRelationInKey() {
        if (this.mInRelationKey == null) {
            this.mInRelationKey = this.createRelationInKey();
        }
        return this.mInRelationKey;
    }

    public IEdoStructure getRelationOutRecord() {
        if (this.mActionRelationDescriptor == null) {
            throw new UnsupportedOperationException("Action relation not supportes by action '" + this.getAspectActionDescriptor().getName() + "' in aspect '" + this.getAspectDescriptor().getName() + "'");
        }
        if (this.mRelatedOutRecord == null) {
            this.mRelatedOutRecord = this.createRelatedOutRecordStructure();
        }
        return this.mRelatedOutRecord;
    }

    private IEdoStructure createRelatedOutRecordStructure() {
        if (this.mActionRelationDescriptor == null) {
            return null;
        }
        return this.mServiceModule.createStructure((IStructureDescriptor)((StructureDescriptor)this.mActionRelationDescriptor.getTargetAspectDescriptor().getStructure()));
    }

    public void setRelationInKey(IEdoStructure inKey) {
        if (this.mActionRelationDescriptor == null) {
            throw new UnsupportedOperationException("Action relation not supportes by action '" + this.getAspectActionDescriptor().getName() + "' in aspect '" + this.getAspectDescriptor().getName() + "'");
        }
        this.mInRelationKey = inKey;
    }

    public void cleanupMessages() {
        this.removeAspectRowMessages((IAspectDescriptor)this.getAspectDescriptor().getKeyDescriptor(), this.getInKeys());
    }
}

