/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.col.servicemanager.core.calls;

import com.sap.tc.col.client.metadata.api.IAspectDescriptor;
import com.sap.tc.col.client.metadata.core.ServiceModuleDescriptor;
import com.sap.tc.col.edo.IEdoAtomicValue;
import com.sap.tc.col.edo.IEdoTable;
import com.sap.tc.col.edo.IEdoValue;
import com.sap.tc.col.rpe.RpeParameter;
import com.sap.tc.col.servicemanager.api.ISrvMgrMessage;
import com.sap.tc.col.servicemanager.api.ISrvMgrServiceManager;
import com.sap.tc.col.servicemanager.api.ISrvMgrServiceModule;
import com.sap.tc.col.servicemanager.api.calls.ISrvMgrCall;
import com.sap.tc.col.servicemanager.core.AbstractServiceManager;
import com.sap.tc.col.servicemanager.core.SrvMgrMessageHandler;

public abstract class AbstractCall
implements ISrvMgrCall {
    protected ISrvMgrServiceModule mServiceModule;
    private int mState;
    private IEdoTable mOutRecords;
    private IEdoTable mReturnCodes;
    private IEdoAtomicValue mRejected;
    private ISrvMgrMessage[] mMessages;
    private IEdoTable mMessageTable;

    public int getState() {
        return this.mState;
    }

    protected abstract IEdoTable createOutRecordsTable();

    public IEdoTable getOutRecords() {
        if (this.mOutRecords == null) {
            this.mOutRecords = this.createOutRecordsTable();
        }
        return this.mOutRecords;
    }

    protected void setOutRecords(IEdoTable outRecords) {
        this.mOutRecords = outRecords;
    }

    protected IEdoTable createReturnCodesTable() {
        return this.mServiceModule.createTable(((ServiceModuleDescriptor)this.mServiceModule.getDescriptor()).getReturnCodeStructure());
    }

    public IEdoTable getReturnCodes() {
        if (this.mReturnCodes == null) {
            this.mReturnCodes = this.createReturnCodesTable();
        }
        return this.mReturnCodes;
    }

    protected void setReturnCodes(IEdoTable returnCodes) {
        this.mReturnCodes = returnCodes;
    }

    private IEdoAtomicValue getRejected() {
        if (this.mRejected == null) {
            this.mRejected = ((AbstractServiceManager)this.mServiceModule.getServiceManager()).createValue("");
            this.mRejected.setBooleanValue(false);
        }
        return this.mRejected;
    }

    public boolean isRejected() {
        return this.getRejected().getBooleanValue();
    }

    private IEdoTable getMessageTable() {
        if (this.mMessageTable == null) {
            this.mMessageTable = this.createMessageTable();
        }
        return this.mMessageTable;
    }

    protected IEdoTable createMessageTable() {
        return this.mServiceModule.createTable(((ServiceModuleDescriptor)this.mServiceModule.getDescriptor()).getMessageStructure());
    }

    protected RpeParameter getMessageParameter(AbstractServiceManager sm) {
        return sm.createParameter("MESSAGES", ((ServiceModuleDescriptor)this.mServiceModule.getDescriptor()).getMessageStructure().getName(), "E", "T", this.getMessageTable());
    }

    protected RpeParameter getReturnCodeParameter(AbstractServiceManager sm) {
        return sm.createParameter("RETURN_CODES", ((ServiceModuleDescriptor)this.mServiceModule.getDescriptor()).getReturnCodeStructure().getName(), "E", "T", this.getReturnCodes());
    }

    protected RpeParameter getRejectedParameter(AbstractServiceManager sm) {
        return sm.createParameter("REJECTED", "BOOLEAN", "E", "A", (IEdoValue)this.getRejected());
    }

    public void setState(int state) {
        this.mState = state;
    }

    protected AbstractCall(ISrvMgrServiceModule serviceModule) {
        this.mServiceModule = serviceModule;
        this.reset();
    }

    private void convertMessages() {
        this.mMessages = SrvMgrMessageHandler.getMessages(this.mMessageTable);
        if (this.mMessageTable != null) {
            this.mMessageTable.clear();
            this.mMessageTable = null;
        }
    }

    public ISrvMgrMessage[] getMessages() {
        if (this.getState() != 2) {
            throw new IllegalStateException("Operation not permitted: call is not completed.");
        }
        if (this.mMessages == null) {
            this.convertMessages();
        }
        return this.mMessages;
    }

    public abstract void cleanupMessages();

    public void reset() {
        this.mOutRecords = null;
        this.mMessages = null;
        this.mMessageTable = null;
        this.mRejected = null;
        this.mReturnCodes = null;
        this.mState = 0;
    }

    protected void validateStateForProcessing() {
        if (this.mState != 0) {
            throw new IllegalStateException("Operation not permitted: call has already been used.");
        }
    }

    protected void removeAspectRowMessages(IAspectDescriptor aspectDesc, IEdoTable table) {
        if (aspectDesc != null && table != null) {
            ISrvMgrServiceManager srvMgr = this.mServiceModule.getServiceManager();
            int i = 0;
            while (i < table.getRecordCount()) {
                String urlKey = srvMgr.getRelativeAspectRowKey(aspectDesc, table, i);
                srvMgr.removeMessages(srvMgr.getAspectRowMessages(urlKey));
                ++i;
            }
        }
    }

    public abstract void processCall();
}

