/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.col.servicemanager.core.calls;

import com.sap.tc.col.client.metadata.api.IAspectDescriptor;
import com.sap.tc.col.client.metadata.api.IStructureDescriptor;
import com.sap.tc.col.client.metadata.core.AspectDescriptor;
import com.sap.tc.col.client.metadata.core.ServiceModuleDescriptor;
import com.sap.tc.col.edo.IEdoTable;
import com.sap.tc.col.rpe.RpeParameter;
import com.sap.tc.col.servicemanager.api.ISrvMgrServiceModule;
import com.sap.tc.col.servicemanager.api.calls.ISrvMgrAspectCall;
import com.sap.tc.col.servicemanager.core.AbstractServiceManager;
import com.sap.tc.col.servicemanager.core.calls.AbstractCall;
import com.sap.tc.col.servicemanager.core.calls.SrvMgrLock;
import com.sap.tc.col.servicemanager.core.typeinfo.AspectType;

abstract class AbstractAspectCall
extends AbstractCall
implements ISrvMgrAspectCall {
    protected AspectDescriptor mAspectDescriptor;
    protected AspectType mAspectTypeInfo;

    protected AbstractAspectCall(ISrvMgrServiceModule serviceModule, String aspectName) {
        super(serviceModule);
        this.mAspectDescriptor = (AspectDescriptor)serviceModule.getDescriptor().getAspectDescriptor(aspectName);
        this.mAspectTypeInfo = new AspectType(this.mAspectDescriptor, (ServiceModuleDescriptor)serviceModule.getDescriptor());
    }

    public IAspectDescriptor getAspectDescriptor() {
        return this.mAspectDescriptor;
    }

    public void setAspectDescriptor(AspectDescriptor aspectDescriptor) {
        this.mAspectDescriptor = aspectDescriptor;
    }

    protected IEdoTable createAspectInKeysTable() {
        return this.mServiceModule.createTable((IStructureDescriptor)this.mAspectTypeInfo.type_inkeys);
    }

    protected IEdoTable createAspectInRecordsTable() {
        return this.mServiceModule.createTable((IStructureDescriptor)this.mAspectTypeInfo.type_inrecords);
    }

    protected IEdoTable createAscpectInFieldsTable() {
        return this.mServiceModule.createTable(((ServiceModuleDescriptor)this.mServiceModule.getDescriptor()).getInputFieldsStructure());
    }

    protected IEdoTable createOutRecordsTable() {
        return this.mServiceModule.createTable((IStructureDescriptor)this.mAspectTypeInfo.type_outrecords);
    }

    protected RpeParameter getOutRecordsParameter(AbstractServiceManager sm) {
        return sm.createParameter("OUTRECORDS", this.mAspectTypeInfo.type_outrecords.getName(), "E", "T", this.getOutRecords());
    }

    protected RpeParameter getInRecordsParameter(AbstractServiceManager sm, IEdoTable inRecords) {
        return sm.createParameter("INRECORDS", this.mAspectTypeInfo.type_inrecords.getName(), "I", "T", inRecords);
    }

    protected RpeParameter getInKeysParameter(AbstractServiceManager sm, IEdoTable inKeys) {
        return sm.createParameter("INKEYS", this.mAspectTypeInfo.type_inkeys.getName(), "I", "T", inKeys);
    }

    protected RpeParameter getInFieldsParameter(AbstractServiceManager sm, IEdoTable inFields) {
        return sm.createParameter("INFIELDS", ((ServiceModuleDescriptor)this.mServiceModule.getDescriptor()).getInputFieldsStructure().getName(), "I", "T", inFields);
    }

    protected RpeParameter getLockModeParameter(AbstractServiceManager sm, int lockMode) {
        return sm.createParameter("LOCKMODE", "STRING", "I", "", SrvMgrLock.convertLockMode(lockMode));
    }

    protected RpeParameter getAspectNameParameter(AbstractServiceManager sm) {
        return sm.createParameter("ASPECT", "STRING", "I", "", this.mAspectTypeInfo.aspectName);
    }

    protected RpeParameter getServiceModuleParameter(AbstractServiceManager sm) {
        return sm.createParameter("SERVICE_MODULE", "STRING", "I", "", this.mAspectTypeInfo.smName);
    }
}

