/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.col.servicemanager.core;

import com.sap.tc.col.client.metadata.api.IStructureDescriptor;
import com.sap.tc.col.edo.IEdoTable;
import com.sap.tc.col.servicemanager.api.ISrvMgrMessage;
import com.sap.tc.col.servicemanager.api.ISrvMgrMessageProvider;
import com.sap.tc.col.servicemanager.api.ISrvMgrServiceModule;
import com.sap.tc.col.servicemanager.api.calls.ISrvMgrQuery;
import com.sap.tc.col.servicemanager.core.ServiceManager;
import com.sap.tc.col.servicemanager.core.SrvMgrMessage;
import com.sap.tc.col.servicemanager.core.SrvMgrServiceModule;
import com.sap.tc.logging.Location;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;

public class SrvMgrMessageHandler
implements ISrvMgrMessageProvider {
    private static final Location _logger = Location.getLocation((Class)(class$com$sap$tc$col$servicemanager$core$SrvMgrMessageHandler == null ? (class$com$sap$tc$col$servicemanager$core$SrvMgrMessageHandler = SrvMgrMessageHandler.class$("com.sap.tc.col.servicemanager.core.SrvMgrMessageHandler")) : class$com$sap$tc$col$servicemanager$core$SrvMgrMessageHandler));
    private static final String sServiceModuleName = "COL_MESSAGES";
    private ServiceManager mServiceManager;
    private ArrayList mMessages = null;
    private ArrayList mSystemMessages = null;
    private HashMap mAspectMessages = null;
    private HashMap mAspectOnlyMessages = null;
    private HashMap mAspectRowMessages = null;
    static /* synthetic */ Class class$com$sap$tc$col$servicemanager$core$SrvMgrMessageHandler;

    SrvMgrMessageHandler(ServiceManager serviceManager) {
        this.mServiceManager = serviceManager;
        this.mServiceManager.useServiceModule(sServiceModuleName, "");
        this.resetMessages();
    }

    private void resetMessages() {
        this.mMessages = new ArrayList();
        this.mSystemMessages = new ArrayList();
        this.mAspectMessages = new HashMap();
        this.mAspectOnlyMessages = new HashMap();
        this.mAspectRowMessages = new HashMap();
    }

    public ISrvMgrMessage[] getMessages() {
        ISrvMgrMessage[] messages = new SrvMgrMessage[this.mMessages.size()];
        this.mMessages.toArray(messages);
        return messages;
    }

    public static SrvMgrMessage[] getMessages(IEdoTable resultTable) {
        String _methodName = "getMessages(ISrvMgrTable resultTable)";
        _logger.pathT("getMessages(ISrvMgrTable resultTable)");
        if (resultTable == null) {
            return new SrvMgrMessage[0];
        }
        int size = resultTable.getRecordCount();
        _logger.debugT("getMessages(ISrvMgrTable resultTable)", "Number of messages: " + size);
        SrvMgrMessage[] msgArray = new SrvMgrMessage[size];
        int i = 0;
        while (i < size) {
            msgArray[i] = SrvMgrMessageHandler.getMessageFromTable(resultTable, i, false);
            ++i;
        }
        return msgArray;
    }

    public int getMessageNum() {
        return this.mMessages.size();
    }

    public IEdoTable addMessageQueryCall(ServiceManager srvMgr) {
        String _methodName = "addMessageQueryCall(ServiceManager)";
        _logger.pathT("addMessageQueryCall(ServiceManager)");
        ISrvMgrServiceModule serviceModule = srvMgr.getServiceModule(sServiceModuleName);
        ISrvMgrQuery query = serviceModule.createQuery("COL_MESSAGES_QUERY_MESSAGES");
        query.processCall();
        return query.getOutRecords();
    }

    private static SrvMgrMessage getMessageFromTable(IEdoTable table, int index, boolean isOutbound) {
        int type;
        String str = table.getStringValue(index, "MESSAGE_TYPE");
        if ("I".equals(str)) {
            type = 0;
        } else if ("W".equals(str)) {
            type = 1;
        } else if ("E".equals(str)) {
            type = 2;
        } else {
            throw new IllegalArgumentException("Messagetype " + str + " not allowed!");
        }
        SrvMgrMessage newMessage = new SrvMgrMessage(type, table.getIntValue(index, "MESSAGE_CATEGORY"), table.getStringValue(index, "MESSAGE_CODE"), table.getStringValue(index, "MESSAGE_TEXT"), table.getBooleanValue(index, "FAILED"), table.getIntValue(index, "INRECORD"), table.getStringValue(index, "MESSAGE_VARS"), table.getStringValue(index, "ASPECT_NAME"), table.getStringValue(index, "ASPECT_FIELD"), table.getStringValue(index, "ASPECT_KEY"), table.getStringValue(index, "EXTENSION"));
        return newMessage;
    }

    public void getMessagesFromBackend(IEdoTable resultTable) {
        String _methodName = "getMessagesFromBackend";
        _logger.pathT("getMessagesFromBackend");
        _logger.debugT("getMessagesFromBackend", "Number of messages: " + resultTable.getRecordCount());
        int i = 0;
        while (i < resultTable.getRecordCount()) {
            SrvMgrMessage newMessage = SrvMgrMessageHandler.getMessageFromTable(resultTable, i, true);
            this.addMessage(newMessage);
            ++i;
        }
    }

    private void addMessage(SrvMgrMessage message) {
        if (!this.mMessages.contains(message)) {
            this.mMessages.add(message);
            String aspectName = message.getAspectName();
            this.addToNestedList(this.mAspectMessages, aspectName, message);
            String aspectKey = message.getCoolObjectKey().getUrl();
            switch (message.getCategory()) {
                case 1: {
                    this.addToNestedList(this.mAspectRowMessages, aspectKey, message);
                    break;
                }
                case 2: 
                case 3: {
                    if (aspectKey != null && !aspectKey.equals("")) break;
                    this.mSystemMessages.add(message);
                    this.addToNestedList(this.mAspectOnlyMessages, aspectName, message);
                    break;
                }
            }
        }
    }

    private void addToNestedList(HashMap map, String key, Object obj) {
        if (key != null && !key.equals("")) {
            ArrayList<Object> nestedList = (ArrayList<Object>)map.get(key);
            if (nestedList == null) {
                nestedList = new ArrayList<Object>();
                map.put(key, nestedList);
            }
            nestedList.add(obj);
        }
    }

    private ArrayList getNestedList(HashMap map, String key) {
        ArrayList nestedList = null;
        if (key != null && !key.equals("")) {
            nestedList = (ArrayList)map.get(key);
        }
        if (nestedList == null) {
            nestedList = new ArrayList();
        }
        return nestedList;
    }

    private void removeFromNestedList(HashMap map, String key, Object obj) {
        if (key != null && !key.equals("")) {
            ArrayList nestedList = (ArrayList)map.get(key);
            if (nestedList != null) {
                ((AbstractCollection)nestedList).remove(obj);
            }
            if (nestedList.isEmpty()) {
                map.remove(key);
            }
        }
    }

    public void clearMessages() {
        if (this.mMessages != null) {
            this.mMessages.clear();
            this.mSystemMessages.clear();
            this.mAspectMessages.clear();
            this.mAspectOnlyMessages.clear();
            this.mAspectRowMessages.clear();
        }
    }

    public void clearAspectRowMessages() {
    }

    public SrvMgrMessage removeMessage(int index) {
        SrvMgrMessage msg = (SrvMgrMessage)this.mMessages.get(index);
        this.removeMessage(msg);
        return msg;
    }

    public ISrvMgrMessage[] getAndRemoveAllMessages() {
        ISrvMgrMessage[] msg = this.getMessages();
        this.clearMessages();
        return msg;
    }

    public int sizeMessages() {
        return this.mMessages.size();
    }

    public ISrvMgrMessage[] getAspectMessages(String aspectName, boolean includeRowMessages) {
        ArrayList list = includeRowMessages ? this.getNestedList(this.mAspectMessages, aspectName) : this.getNestedList(this.mAspectOnlyMessages, aspectName);
        ISrvMgrMessage[] messages = new SrvMgrMessage[list.size()];
        list.toArray(messages);
        return messages;
    }

    public ISrvMgrMessage[] getAspectRowMessages(String urlKey) {
        ArrayList list = this.getNestedList(this.mAspectRowMessages, urlKey);
        ISrvMgrMessage[] messages = new SrvMgrMessage[list.size()];
        list.toArray(messages);
        return messages;
    }

    public ISrvMgrMessage[] getAspectRowMessages() {
        Collection messageLists = this.mAspectRowMessages.values();
        Iterator listIterator = messageLists.iterator();
        ArrayList messages = new ArrayList();
        while (listIterator.hasNext()) {
            messages.addAll((ArrayList)listIterator.next());
        }
        ISrvMgrMessage[] messageArray = new SrvMgrMessage[messages.size()];
        messages.toArray(messageArray);
        return messageArray;
    }

    public ISrvMgrMessage[] getSystemMessages() {
        return this.getAndClearSystemMessages();
    }

    public ISrvMgrMessage[] getAndClearSystemMessages() {
        ISrvMgrMessage[] messages = new SrvMgrMessage[this.mSystemMessages.size()];
        this.mSystemMessages.toArray(messages);
        this.removeMessages(messages);
        return messages;
    }

    public void removeMessage(ISrvMgrMessage message) {
        ((AbstractCollection)this.mMessages).remove(message);
        String aspectName = message.getAspectName();
        this.removeFromNestedList(this.mAspectMessages, aspectName, message);
        String aspectKey = message.getCoolObjectKey().getUrl();
        this.removeFromNestedList(this.mAspectRowMessages, aspectKey, message);
        if (aspectKey == null || aspectKey.equals("")) {
            ((AbstractCollection)this.mSystemMessages).remove(message);
            this.removeFromNestedList(this.mAspectOnlyMessages, aspectName, message);
        }
    }

    public void removeMessages(ISrvMgrMessage[] messages) {
        int i = 0;
        while (i < messages.length) {
            this.removeMessage(messages[i]);
            ++i;
        }
    }

    public IStructureDescriptor getMessageStructure() {
        SrvMgrServiceModule myServiceModule = (SrvMgrServiceModule)this.mServiceManager.getServiceModule(sServiceModuleName);
        return myServiceModule.getDescriptor().getAspectDescriptor("COL_MESSAGES_ASPECT_MESSAGES").getStructure();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Location.getLocation((String)"ID.com.sap.tc.cool.servicemanager").infoT("$Id: //tc/Cool/630_VAL_REL/src/_col_servicemanager/java/com/sap/tc/col/servicemanager/core/SrvMgrMessageHandler.java#1 $");
    }
}

