/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.col.servicemanager.core;

import com.sap.tc.col.client.metadata.core.AspectDescriptor;
import com.sap.tc.col.client.metadata.core.RelationDescriptor;
import com.sap.tc.col.edo.IEdoTable;
import com.sap.tc.col.servicemanager.api.ISrvMgrServiceModule;
import com.sap.tc.col.servicemanager.api.calls.ISrvMgrQuery;
import com.sap.tc.col.servicemanager.core.CoolObjectKey;
import com.sap.tc.col.servicemanager.core.ServiceManager;
import com.sap.tc.logging.Location;

public class SrvMgrAttributeHandler {
    private static final Location _logger = Location.getLocation((Class)(class$com$sap$tc$col$servicemanager$core$SrvMgrAttributeHandler == null ? (class$com$sap$tc$col$servicemanager$core$SrvMgrAttributeHandler = SrvMgrAttributeHandler.class$("com.sap.tc.col.servicemanager.core.SrvMgrAttributeHandler")) : class$com$sap$tc$col$servicemanager$core$SrvMgrAttributeHandler));
    private static final String sServiceModuleName = "COL_ATTRIBUTES";
    private ServiceManager mServiceManager;
    private IEdoTable mAttributeTable;
    static /* synthetic */ Class class$com$sap$tc$col$servicemanager$core$SrvMgrAttributeHandler;

    SrvMgrAttributeHandler(ServiceManager serviceManager) {
        this.mServiceManager = serviceManager;
        this.mAttributeTable = null;
        this.mServiceManager.useServiceModule(sServiceModuleName, "");
    }

    void addAttributeQueryCall() {
        String _methodName = "addAttributeQueryCall()";
        _logger.entering("addAttributeQueryCall()");
        ISrvMgrServiceModule serviceModule = this.mServiceManager.getServiceModule(sServiceModuleName);
        ISrvMgrQuery query = serviceModule.createQuery("CHANGED_ATTRIBUTES");
        query.processCall();
        this.mAttributeTable = query.getOutRecords();
        _logger.exiting();
    }

    void updateChangedAttributes() {
        String _methodName = "updateChangedAttributes()";
        _logger.entering("updateChangedAttributes()");
        if (this.mAttributeTable != null) {
            int i = 0;
            while (i < this.mAttributeTable.getRecordCount()) {
                int elementType = this.mAttributeTable.getIntValue(i, "ELEMENT_TYPE");
                switch (elementType) {
                    case 2: {
                        String aspectName = this.mAttributeTable.getStringValue(i, "ELEMENT_NAME");
                        AspectDescriptor aspectDesc = this.mServiceManager.getRepositoryManager().getAspectDescriptor(aspectName);
                        if (aspectDesc != null) {
                            String aspectKey = new CoolObjectKey(this.mAttributeTable.getStringValue(i, "ASPECT_KEY")).getUrl();
                            String propertyName = this.mAttributeTable.getStringValue(i, "PROPERTY_NAME");
                            String propertyValue = this.getPropertyValue(this.mAttributeTable, i);
                            int subType = this.mAttributeTable.getIntValue(i, "SUB_ELEM_TYPE");
                            String subElem = this.mAttributeTable.getStringValue(i, "SUB_ELEM_NAME");
                            switch (subType) {
                                case 13: {
                                    aspectDesc.addFieldAttribute(aspectKey, subElem, propertyName, propertyValue);
                                    break;
                                }
                                case 3: {
                                    RelationDescriptor relDesc = (RelationDescriptor)aspectDesc.getRelationDescriptor(subElem);
                                    if (relDesc != null) {
                                        relDesc.addAttribute(aspectKey, propertyName, propertyValue);
                                        break;
                                    }
                                    _logger.warningT("Relation '" + subElem + "' in aspect '" + aspectName + "' not found in repository, skipping property");
                                    break;
                                }
                                case 11: {
                                    aspectDesc.addActionAttribute(aspectKey, subElem, propertyName, propertyValue);
                                }
                            }
                            break;
                        }
                        _logger.warningT("Aspect '" + aspectName + "' not found in repository, skipping property");
                    }
                }
                ++i;
            }
            this.mAttributeTable = null;
        }
        _logger.exiting();
    }

    private String getPropertyValue(IEdoTable table, int index) {
        String value = "";
        String baseType = table.getStringValue(index, "PROPERTY_BASE_TYPE");
        if ("B".equalsIgnoreCase(baseType)) {
            value = table.getBooleanValue(index, "PROPERTY_VALUE_BOOL") ? "X" : " ";
        } else if ("S".equalsIgnoreCase(baseType)) {
            value = table.getStringValue(index, "PROPERTY_VALUE_STRING");
        } else if ("I".equalsIgnoreCase(baseType)) {
            value = new Integer(table.getIntValue(index, "PROPERTY_VALUE_STRING")).toString();
        }
        return value;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Location.getLocation((String)"ID.com.sap.tc.cool.servicemanager").infoT("$Id: //tc/Cool/630_VAL_REL/src/_col_servicemanager/java/com/sap/tc/col/servicemanager/core/SrvMgrAttributeHandler.java#1 $");
    }
}

