/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.col.servicemanager.core;

import com.sap.tc.col.cds.ConnectionData;
import com.sap.tc.col.cds.ConnectionDataServiceFactory;
import com.sap.tc.col.client.metadata.api.IAspectDescriptor;
import com.sap.tc.col.client.metadata.api.IFieldDescriptor;
import com.sap.tc.col.client.metadata.api.IServiceModuleDescriptor;
import com.sap.tc.col.client.metadata.api.IStructureDescriptor;
import com.sap.tc.col.edo.IEdoAtomicValue;
import com.sap.tc.col.edo.IEdoTable;
import com.sap.tc.col.edo.IEdoValue;
import com.sap.tc.col.rpe.RpeMethod;
import com.sap.tc.col.rpe.RpeParameter;
import com.sap.tc.col.servicemanager.api.ISrvMgrCallbackOnFlush;
import com.sap.tc.col.servicemanager.api.ISrvMgrMessage;
import com.sap.tc.col.servicemanager.api.ISrvMgrServiceManager;
import com.sap.tc.col.servicemanager.api.ISrvMgrServiceModule;
import com.sap.tc.col.servicemanager.api.calls.ISrvMgrCall;
import com.sap.tc.col.servicemanager.core.AbstractServiceManager;
import com.sap.tc.col.servicemanager.core.CoolObjectKey;
import com.sap.tc.col.servicemanager.core.CoolVersion;
import com.sap.tc.col.servicemanager.core.RepositoryManager;
import com.sap.tc.col.servicemanager.core.SrvMgrAttributeHandler;
import com.sap.tc.col.servicemanager.core.SrvMgrMessageHandler;
import com.sap.tc.col.servicemanager.core.SrvMgrServiceModule;
import com.sap.tc.col.servicemanager.core.calls.AbstractCall;
import com.sap.tc.logging.Location;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Locale;

public class ServiceManager
extends AbstractServiceManager
implements ISrvMgrServiceManager {
    private static final Location _logger = Location.getLocation((Class)(class$com$sap$tc$col$servicemanager$core$ServiceManager == null ? (class$com$sap$tc$col$servicemanager$core$ServiceManager = ServiceManager.class$("com.sap.tc.col.servicemanager.core.ServiceManager")) : class$com$sap$tc$col$servicemanager$core$ServiceManager));
    private CoolVersion mBackendVersion = null;
    private CoolVersion mActiveVersion;
    private Hashtable smList;
    private RepositoryManager smRepository;
    private SrvMgrMessageHandler msgHandler;
    private SrvMgrAttributeHandler mAttributeHandler;
    private String mTransactionID;
    static /* synthetic */ Class class$com$sap$tc$col$servicemanager$core$ServiceManager;

    public RepositoryManager getRepositoryManager() {
        String _methodName = "getRepositoryManager";
        _logger.entering("getRepositoryManager");
        if (this.smRepository == null) {
            this.smRepository = new RepositoryManager(this);
        }
        _logger.exiting();
        return this.smRepository;
    }

    public ServiceManager(ConnectionData connectionData, Locale locale) {
        super(locale);
        String _methodName = "ServiceManager(ConnectionData)";
        _logger.entering("ServiceManager(ConnectionData)", new Object[]{connectionData});
        this.init(connectionData);
        _logger.exiting();
    }

    public ServiceManager(String client, String user, String pword, String lang, Locale locale, String appServer, String systemNumber, boolean debug, boolean sync) {
        super(locale);
        String _methodName = "ServiceManager(String, String, String, String Locale, String, String, boolean, boolean)";
        _logger.entering("ServiceManager(String, String, String, String Locale, String, String, boolean, boolean)", new Object[]{client, user, pword, lang, locale, appServer, systemNumber, new Boolean(debug), new Boolean(sync)});
        ConnectionData cds = ConnectionDataServiceFactory.getConnectionDataService().getConnectionData("JCO", "0");
        cds.setProperty("client", client);
        cds.setProperty("user", user);
        cds.setProperty("passwd", pword);
        if (lang != null) {
            cds.setProperty("lang", lang);
        }
        cds.setProperty("ashost", appServer);
        cds.setProperty("sysnr", systemNumber);
        if (debug) {
            cds.setProperty("debug", "true");
        }
        if (sync) {
            cds.setProperty("sm.sync", "true");
        }
        this.init(cds);
        _logger.exiting();
    }

    public ISrvMgrCallbackOnFlush registerCallbackOnFlush(ISrvMgrCallbackOnFlush callbackObject) {
        ISrvMgrCallbackOnFlush oldCallback = this.mCallbackOnFlush;
        this.mCallbackOnFlush = callbackObject;
        return oldCallback;
    }

    public boolean save() {
        String _methodName = "save";
        _logger.entering("save");
        this.msgHandler.removeMessages(this.msgHandler.getAspectRowMessages());
        IEdoAtomicValue rejectValue = this.rpeContext.createValue("");
        IEdoAtomicValue transIDValue = this.rpeContext.createValue("");
        RpeParameter reject = this.createParameter("NOT_SAVED", "I", "E", "", (IEdoValue)rejectValue);
        RpeParameter transID = this.createParameter("TRANSACTION_ID", "STRING", "E", "", (IEdoValue)transIDValue);
        ArrayList<RpeParameter> out = new ArrayList<RpeParameter>();
        out.add(reject);
        out.add(transID);
        this.callMethod("IF_COL_SERVICE_MANAGER~SAVE", null, out);
        this.flush("SMP", "ISrvMgrServiceManager.save()");
        String taID = transIDValue.getStringValue().trim();
        this.setTransactionID(taID);
        if (!((IEdoAtomicValue)reject.getValue()).getBooleanValue()) {
            this.setToSave(false);
        }
        _logger.exiting();
        return rejectValue.getStringValue().trim().equals("0");
    }

    public boolean check() {
        String _methodName = "check";
        _logger.entering("check");
        this.msgHandler.removeMessages(this.msgHandler.getAspectRowMessages());
        IEdoAtomicValue rejectValue = this.rpeContext.createValue("");
        RpeParameter reject = this.createParameter("REJECTED", "I", "E", "", (IEdoValue)rejectValue);
        ArrayList<RpeParameter> out = new ArrayList<RpeParameter>();
        out.add(reject);
        this.callMethod("IF_COL_SERVICE_MANAGER~CHECK", null, out);
        this.flush("SMP", "ISrvMgrServiceManager.check()");
        _logger.exiting();
        return rejectValue.getStringValue().trim().equals("0");
    }

    public void cleanup() {
        String _methodName = "cleanup";
        _logger.entering("cleanup");
        this.msgHandler.removeMessages(this.msgHandler.getAspectRowMessages());
        IEdoAtomicValue transIDValue = this.rpeContext.createValue("");
        RpeParameter transID = this.createParameter("TRANSACTION_ID", "STRING", "E", "", (IEdoValue)transIDValue);
        ArrayList<RpeParameter> out = new ArrayList<RpeParameter>();
        out.add(transID);
        this.callMethod("IF_COL_SERVICE_MANAGER~CLEANUP", null, out);
        this.flush("SMP", "ISrvMgrServiceManager.cleanup()");
        String taID = transIDValue.getStringValue().trim();
        this.setTransactionID(taID);
        this.setToSave(false);
        _logger.exiting();
    }

    public ISrvMgrServiceModule getServiceModule(String serviceModuleName) {
        return this.getServiceModule(serviceModuleName, "");
    }

    public ISrvMgrServiceModule getServiceModule(String serviceModuleName, String serviceModuleConfigurationName) {
        String _methodName = "getServiceModule(String)";
        _logger.entering("getServiceModule(String)", new Object[]{serviceModuleName});
        SrvMgrServiceModule ism = (SrvMgrServiceModule)this.smList.get(serviceModuleName);
        if (ism == null) {
            ism = new SrvMgrServiceModule(serviceModuleName, serviceModuleConfigurationName, this);
            this.smList.put(serviceModuleName, ism);
        }
        _logger.exiting();
        return ism;
    }

    public void callMethod(String name, ArrayList input, ArrayList output) {
        String _methodName = "callMethod(String, ArrayList, ArrayList)";
        _logger.entering("callMethod(String, ArrayList, ArrayList)", new Object[]{name});
        RpeMethod method = this.rpeContext.createMethod(name);
        if (input != null) {
            int i = 0;
            while (i < input.size()) {
                method.addParameter((RpeParameter)input.get(i));
                ++i;
            }
        }
        if (output != null) {
            int i = 0;
            while (i < output.size()) {
                method.addParameter((RpeParameter)output.get(i));
                ++i;
            }
        }
        _logger.exiting();
        if (this.rpeServiceManagerObject == null) {
            return;
        }
        this.rpeContext.callMethod(this.rpeServiceManagerObject, method, false);
    }

    private void init(ConnectionData connectionData) {
        String _methodName = "init(ConnectionData)";
        _logger.entering("init(ConnectionData)");
        this.smList = new Hashtable();
        this.addContext(connectionData);
        this.getRepositoryManager();
        this.msgHandler = new SrvMgrMessageHandler(this);
        this.mAttributeHandler = new SrvMgrAttributeHandler(this);
        _logger.exiting();
    }

    public void flush(String callingLayer, String callingMethod) {
        String _methodName = "flush";
        _logger.entering("flush");
        if (this.mCallbackOnFlush != null && !this.mCallbackOnFlush.beforeFlush(callingLayer, callingMethod)) {
            throw new RuntimeException("Flush operation aborted by beforeFlush() callback");
        }
        boolean checkForMessages = this.rpeContext.getInstructionQueueSize() > 0;
        IEdoTable result = null;
        if (checkForMessages) {
            this.mAttributeHandler.addAttributeQueryCall();
            result = this.msgHandler.addMessageQueryCall(this);
        }
        int len = this.mCallList.size();
        ISrvMgrCall[] callArray = new AbstractCall[len];
        int i = 0;
        while (i < len) {
            callArray[i] = (ISrvMgrCall)this.mCallList.get(i);
            ++i;
        }
        super.flush();
        int i2 = 0;
        while (i2 < callArray.length) {
            callArray[i2].cleanupMessages();
            ++i2;
        }
        if (checkForMessages) {
            this.msgHandler.getMessagesFromBackend(result);
            this.mAttributeHandler.updateChangedAttributes();
        }
        if (this.mCallbackOnFlush != null) {
            this.mCallbackOnFlush.afterFlush(callArray);
        }
        _logger.exiting();
    }

    public IStructureDescriptor getMessageStructure() {
        return this.msgHandler.getMessageStructure();
    }

    public ISrvMgrMessage[] getMessages() {
        return this.msgHandler.getMessages();
    }

    public void clearMessages() {
        this.msgHandler.clearMessages();
    }

    public ISrvMgrMessage removeMessage(int index) {
        return this.msgHandler.removeMessage(index);
    }

    public int sizeMessages() {
        return this.msgHandler.sizeMessages();
    }

    public ISrvMgrMessage[] getAspectMessages(String aspectName, boolean includeRowMessages) {
        return this.msgHandler.getAspectMessages(aspectName, includeRowMessages);
    }

    public ISrvMgrMessage[] getAspectRowMessages(String urlKey) {
        return this.msgHandler.getAspectRowMessages(urlKey);
    }

    public ISrvMgrMessage[] getSystemMessages() {
        return this.msgHandler.getSystemMessages();
    }

    public ISrvMgrMessage[] getAndClearSystemMessages() {
        return this.msgHandler.getAndClearSystemMessages();
    }

    public void removeMessage(ISrvMgrMessage message) {
        this.msgHandler.removeMessage(message);
    }

    public void removeMessages(ISrvMgrMessage[] messages) {
        this.msgHandler.removeMessages(messages);
    }

    public IServiceModuleDescriptor getServiceModuleDescriptor(String serviceModuleName) {
        return this.getRepositoryManager().getServiceModuleDescriptor(serviceModuleName);
    }

    public IServiceModuleDescriptor getServiceModuleDescriptor(String serviceModuleName, String serviceModuleConfigurationName) {
        return this.getRepositoryManager().getServiceModuleDescriptor(serviceModuleName, serviceModuleConfigurationName);
    }

    public String[] getServiceModuleNames() {
        return this.getRepositoryManager().getServiceModuleNames();
    }

    public String[] getServiceModuleConfigurationNames(String serviceModuleName) {
        return this.getRepositoryManager().getConfigurationNames(serviceModuleName);
    }

    public void invalidateModuleCache() {
        this.getRepositoryManager().invalidate();
    }

    public boolean isServiceModule(String serviceModuleName) {
        return this.getRepositoryManager().isServiceModule(serviceModuleName);
    }

    public String getTransactionID() {
        return this.mTransactionID;
    }

    private void setTransactionID(String mTransactionID) {
        this.mTransactionID = mTransactionID;
    }

    public String getRelativeAspectRowKey(IAspectDescriptor aspect, IEdoTable table, int index) {
        if (index < 0 || index >= table.getRecordCount()) {
            throw new ArrayIndexOutOfBoundsException("Index " + index + " out of bounds for given table (record count: " + table.getRecordCount() + ")");
        }
        if (aspect.getStructure() != table.getDescriptor()) {
            throw new IllegalArgumentException("Aspect structure ('" + aspect.getStructure().getName() + "') does not match table strucure ('" + table.getDescriptor().getName() + "')");
        }
        IStructureDescriptor keyStructure = aspect.getKeyDescriptor().getStructure();
        String[] values = new String[keyStructure.size()];
        int i = 0;
        while (i < keyStructure.size()) {
            IFieldDescriptor fieldDesc = keyStructure.getFieldDescriptor(i);
            values[i] = table.getStringValue(index, fieldDesc.getName());
            if (values[i] != null) {
                if (fieldDesc.getType().equals("STRING")) {
                    values[i] = table.getStringValue(index, fieldDesc.getName()).trim();
                    if ("".equals(values[i])) {
                        values[i] = " ";
                    }
                } else {
                    values[i] = fieldDesc.getType().equals("INTEGER") ? String.valueOf(table.getIntValue(index, fieldDesc.getName())) : (fieldDesc.getType().equals("DATE") ? table.getStringValue(index, fieldDesc.getName()) : (fieldDesc.getType().equals("TIME") ? table.getStringValue(index, fieldDesc.getName()) : (fieldDesc.getType().equals("TIMESTAMP") ? table.getStringValue(index, fieldDesc.getName()) : (fieldDesc.getType().equals("BINARY") ? table.getStringValue(index, fieldDesc.getName()) : table.getStringValue(index, fieldDesc.getName())))));
                }
            }
            ++i;
        }
        return CoolObjectKey.buildRelativeAspectRowKey(aspect.getKeyDescriptor().getName(), values);
    }

    public String getBackendVersion() {
        if (this.mBackendVersion == null) {
            this.getRepositoryManager();
        }
        return this.mBackendVersion.getVersionNumber();
    }

    public String getFrontendVersion() {
        return CoolVersion.getCurrentCoolVersion().getVersionNumber();
    }

    public String getActiveVersion() {
        return this.mActiveVersion.getVersionNumber();
    }

    void setBackendVersion(CoolVersion version) {
        this.mBackendVersion = version;
    }

    void setActiveVersion(CoolVersion version) {
        this.mActiveVersion = version;
    }

    public String[] getActiveFeatures() {
        return this.mActiveVersion.getSupportedFeatureNames();
    }

    public boolean isFeatureActive(String feature) {
        return this.mActiveVersion.isFeatureSupported(feature);
    }

    public String[] getSupportedFeatures() {
        return CoolVersion.getCurrentCoolVersion().getSupportedFeatureNames();
    }

    public boolean isFeatureSupported(String feature) {
        return CoolVersion.getCurrentCoolVersion().isFeatureSupported(feature);
    }

    public void useServiceModule(String serviceModuleName, String serviceModuleConfigurationName) {
        this.getRepositoryManager().useServiceModule(serviceModuleName, serviceModuleConfigurationName);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Location.getLocation((String)"ID.com.sap.tc.cool.servicemanager").infoT("$Id: //tc/Cool/630_VAL_REL/src/_col_servicemanager/java/com/sap/tc/col/servicemanager/core/ServiceManager.java#1 $");
    }
}

