/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.col.servicemanager.core;

import com.sap.tc.col.client.metadata.api.IAspectDescriptor;
import com.sap.tc.col.client.metadata.api.IServiceModuleDescriptor;
import com.sap.tc.col.client.metadata.api.IStructureDescriptor;
import com.sap.tc.col.client.metadata.core.AspectDescriptor;
import com.sap.tc.col.client.metadata.core.FieldDescriptor;
import com.sap.tc.col.client.metadata.core.ServiceModuleDescriptor;
import com.sap.tc.col.client.metadata.core.StructureDescriptor;
import com.sap.tc.col.edo.IEdoIndexTable;
import com.sap.tc.col.edo.IEdoTable;
import com.sap.tc.col.rpe.RpeParameter;
import com.sap.tc.col.servicemanager.api.ISrvMgrCallbackOnFlush;
import com.sap.tc.col.servicemanager.api.ISrvMgrMessage;
import com.sap.tc.col.servicemanager.api.ISrvMgrServiceModule;
import com.sap.tc.col.servicemanager.api.calls.ISrvMgrQuery;
import com.sap.tc.col.servicemanager.api.calls.ISrvMgrSelectByRelation;
import com.sap.tc.col.servicemanager.core.AbstractServiceManager;
import com.sap.tc.col.servicemanager.core.CoolVersion;
import com.sap.tc.col.servicemanager.core.ServiceManager;
import com.sap.tc.col.servicemanager.core.SrvMgrRepositoryServiceModule;
import com.sap.tc.col.servicemanager.core.SrvMgrServiceModule;
import com.sap.tc.logging.Location;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import java.util.Vector;

public class RepositoryManager
extends AbstractServiceManager {
    private static final Location _logger = Location.getLocation((Class)(class$com$sap$tc$col$servicemanager$core$RepositoryManager == null ? (class$com$sap$tc$col$servicemanager$core$RepositoryManager = RepositoryManager.class$("com.sap.tc.col.servicemanager.core.RepositoryManager")) : class$com$sap$tc$col$servicemanager$core$RepositoryManager));
    private static String VERSION_NUMBER_TAG;
    private static String SYSTEM_KEY_TAG;
    private static String LOGON_CLIENT_TAG;
    private static String LOGON_LANGUAGE_TAG;
    private static StructureDescriptor DATA_EXCHANGE_STRUCT;
    private ISrvMgrServiceModule mRepositoryServiceModule = null;
    private HashMap mCachedServiceModules;
    private HashMap mServiceModuleConfigurations;
    private HashMap mStructureMap;
    private HashMap mAspectMap;
    private HashMap mUsedServiceModules;
    private HashMap mBootstrapData;
    private ServiceManager serviceManager;
    static /* synthetic */ Class class$com$sap$tc$col$servicemanager$core$RepositoryManager;

    protected RepositoryManager(ServiceManager aServiceManager) {
        super(Locale.US);
        this.serviceManager = aServiceManager;
        this.mCachedServiceModules = new HashMap();
        this.mUsedServiceModules = new HashMap();
        this.addContext(aServiceManager);
        if (this.serviceManager.m_Debug_Rpe) {
            this.setDebug(true, this.serviceManager.m_Debuginfo_Module, this.serviceManager.m_Debuginfo_GuiHost);
        } else if (!this.serviceManager.m_Debuginfo_Flushed && this.serviceManager.m_Debuginfo_Mode) {
            this.setDebug(this.serviceManager.m_Debuginfo_Mode, this.serviceManager.m_Debuginfo_Module, this.serviceManager.m_Debuginfo_GuiHost);
        }
        this.performBootstrap();
        this.getRepositoryServiceModule();
    }

    private void performBootstrap() {
        String _method = "performBootstrap()";
        _logger.pathT("performBootstrap()");
        this.mBootstrapData = new HashMap();
        ArrayList<RpeParameter> inp = new ArrayList<RpeParameter>();
        ArrayList<RpeParameter> out = new ArrayList<RpeParameter>();
        String feVersion = CoolVersion.getCurrentCoolVersion().getVersionNumber();
        if (_logger.beInfo()) {
            _logger.infoT("performBootstrap()", "Frontend version is " + feVersion);
        }
        RpeParameter versionFE = this.createParameter("DATA_IN", "STRING", "I", "", feVersion);
        IEdoTable dataIn = this.createTable((IStructureDescriptor)DATA_EXCHANGE_STRUCT);
        int index = dataIn.append(1);
        dataIn.setStringValue(index, "NAME", VERSION_NUMBER_TAG);
        dataIn.setStringValue(index, "VALUE", feVersion);
        RpeParameter dataInParam = this.createParameter("DATA_IN", DATA_EXCHANGE_STRUCT.getName(), "I", "T", dataIn);
        inp.add(dataInParam);
        IEdoTable dataOut = this.createTable((IStructureDescriptor)DATA_EXCHANGE_STRUCT);
        RpeParameter dataOutParam = this.createParameter("DATA_OUT", DATA_EXCHANGE_STRUCT.getName(), "E", "T", dataOut);
        out.add(dataOutParam);
        this.callMethod("BOOTSTRAP", inp, out);
        this.flush();
        int i = 0;
        while (i < dataOut.getRecordCount()) {
            String name = dataOut.getStringValue(i, "NAME");
            String value = dataOut.getStringValue(i, "VALUE");
            this.mBootstrapData.put(name, value);
            if (_logger.beInfo()) {
                _logger.infoT("performBootstrap()", "Bootstrap data: Key: '" + name + "', Value: '" + value + "'");
            }
            ++i;
        }
        String beVersion = (String)this.mBootstrapData.get(VERSION_NUMBER_TAG);
        if (_logger.beInfo()) {
            _logger.infoT("performBootstrap()", "Backend  version is " + beVersion);
            _logger.infoT("performBootstrap()", "Backend  system key is " + (String)this.mBootstrapData.get(SYSTEM_KEY_TAG));
        }
        CoolVersion backendVersion = new CoolVersion(beVersion);
        this.serviceManager.setBackendVersion(backendVersion);
        if (CoolVersion.getCurrentCoolVersion().compareTo(backendVersion) > 0) {
            IllegalStateException ex = new IllegalStateException("Version mismatch: cient version (" + CoolVersion.getCurrentCoolVersion().getVersionNumber() + ") does not work with backend version (" + backendVersion.getVersionNumber() + ")");
            _logger.throwing((Throwable)ex);
            throw ex;
        }
        this.serviceManager.setActiveVersion(CoolVersion.getCurrentCoolVersion());
        if (_logger.beInfo()) {
            _logger.infoT("Active   version is " + this.serviceManager.getActiveVersion());
        }
    }

    public void invalidate() {
        this.mCachedServiceModules.clear();
        this.mServiceModuleConfigurations = null;
        this.mStructureMap = null;
        this.mAspectMap = null;
    }

    public boolean isServiceModule(String serviceModuleName) {
        this.cacheServiceModuleNames();
        return this.mServiceModuleConfigurations.containsKey(serviceModuleName);
    }

    public String[] getServiceModuleNames() {
        this.cacheServiceModuleNames();
        String[] smNames = new String[this.mServiceModuleConfigurations.size()];
        this.mServiceModuleConfigurations.keySet().toArray(smNames);
        return smNames;
    }

    public String[] getConfigurationNames(String serviceModule) {
        if (this.mServiceModuleConfigurations == null) {
            this.cacheServiceModuleNames();
        }
        if (!this.isServiceModule(serviceModule)) {
            throw new IllegalArgumentException("No such service module: '" + serviceModule + "'");
        }
        Set configs = (Set)this.mServiceModuleConfigurations.get(serviceModule);
        String[] confNames = new String[configs.size()];
        configs.toArray(confNames);
        return confNames;
    }

    public IServiceModuleDescriptor getServiceModuleDescriptor(String serviceModuleName, String serviceModuleConfigurationName) {
        IServiceModuleDescriptor smDesc = (IServiceModuleDescriptor)this.mCachedServiceModules.get(serviceModuleName);
        if (smDesc != null) {
            if (smDesc.getConfigurationName().equalsIgnoreCase(serviceModuleConfigurationName)) {
                return smDesc;
            }
            throw new IllegalArgumentException("Service module '" + serviceModuleName + "' cannot be loaded for configuration '" + serviceModuleConfigurationName + "', it is already cached for configuration '" + smDesc.getConfigurationName() + "'");
        }
        this.cacheAServiceModule(serviceModuleName, serviceModuleConfigurationName);
        return (IServiceModuleDescriptor)this.mCachedServiceModules.get(serviceModuleName);
    }

    public IServiceModuleDescriptor getServiceModuleDescriptor(String serviceModuleName) {
        IServiceModuleDescriptor smDesc = (IServiceModuleDescriptor)this.mCachedServiceModules.get(serviceModuleName);
        if (smDesc != null) {
            return smDesc;
        }
        try {
            this.cacheAServiceModule(serviceModuleName, "");
            return (IServiceModuleDescriptor)this.mCachedServiceModules.get(serviceModuleName);
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("ServiceModuleDescriptor could not be cached: " + t.getMessage());
        }
    }

    AspectDescriptor getAspectDescriptor(String aspectName) {
        return (AspectDescriptor)this.mAspectMap.get(aspectName);
    }

    void putAspectDescriptor(String aspectName, AspectDescriptor aspectDesc) {
        this.mAspectMap.put(aspectName, aspectDesc);
    }

    StructureDescriptor getStructureDescriptor(String structName) {
        return (StructureDescriptor)this.mStructureMap.get(structName);
    }

    void putServiceModuleDescriptor(String serviceModuleName, ServiceModuleDescriptor serviceModuleDesc) {
        this.mCachedServiceModules.put(serviceModuleName, serviceModuleDesc);
    }

    private void cacheServiceModuleNames() {
        String _methodName = "cacheServiceModuleNames";
        if (this.mServiceModuleConfigurations != null) {
            return;
        }
        this.mServiceModuleConfigurations = new HashMap();
        SrvMgrRepositoryServiceModule repSvcMod = new SrvMgrRepositoryServiceModule(this);
        _logger.debugT("cacheServiceModuleNames", "Querying Service Modules: ");
        ISrvMgrQuery query = repSvcMod.createQuery("COL_SERVICE_MODULE_QUERY_RUNT");
        IEdoTable svcMods = query.getOutRecords();
        query.processCall();
        ISrvMgrSelectByRelation configRel = repSvcMod.createSelectByRelation("COL_SERVICE_MODULE_RUNT", "COL_SVC_MOD_CONFIG_RUNT");
        configRel.setInRecords(svcMods);
        configRel.processCall();
        this.flush();
        int count = svcMods.getRecordCount();
        _logger.debugT("cacheServiceModuleNames", "Number of Service Modules: " + count);
        int i = 0;
        while (i < count) {
            HashSet<String> confSet = new HashSet<String>();
            int[] confIdx = configRel.getRelations().getRelatedIndexes(i);
            int j = 0;
            while (j < confIdx.length) {
                confSet.add(configRel.getOutRecords().getStringValue(confIdx[j], "CONFIG_NAME"));
                ++j;
            }
            this.mServiceModuleConfigurations.put(svcMods.getStringValue(i, "SVC_MODULE_NAME"), confSet);
            ++i;
        }
    }

    ISrvMgrServiceModule getRepositoryServiceModule() {
        if (this.mRepositoryServiceModule == null) {
            this.mRepositoryServiceModule = new SrvMgrRepositoryServiceModule(this);
        }
        return this.mRepositoryServiceModule;
    }

    private void cacheAServiceModule(String aSMName, String configuration) {
        String _methodName = "cacheAServiceModule";
        _logger.entering("cacheAServiceModule");
        if (this.mCachedServiceModules.containsKey(aSMName)) {
            _logger.debugT("Service module already in cache.");
            _logger.exiting();
            return;
        }
        this.useServiceModule(aSMName, configuration);
        if (this.mAspectMap == null) {
            this.mAspectMap = new HashMap();
        }
        if (this.mStructureMap == null) {
            this.mStructureMap = new HashMap();
        }
        Iterator modNames = this.mUsedServiceModules.keySet().iterator();
        Vector<SrvMgrServiceModule> modules = new Vector<SrvMgrServiceModule>();
        while (modNames.hasNext()) {
            String smName = (String)modNames.next();
            if (this.mCachedServiceModules.containsKey(smName)) continue;
            SrvMgrServiceModule serviceModule = new SrvMgrServiceModule();
            serviceModule.queueRepositoryCalls(smName, (String)this.mUsedServiceModules.get(smName), this.serviceManager);
            modules.addElement(serviceModule);
        }
        this.flush();
        String errors = "";
        int i = 0;
        while (i < modules.size()) {
            SrvMgrServiceModule serviceModule = (SrvMgrServiceModule)modules.get(i);
            try {
                serviceModule.buildRepository();
            }
            catch (RuntimeException ex) {
                errors = errors + "\n" + ex;
            }
            ++i;
        }
        if (!"".equals(errors)) {
            throw new RuntimeException("Error loading repository:" + errors);
        }
    }

    void createStructureDesc(ServiceModuleDescriptor smDesc, ISrvMgrSelectByRelation structFieldRel) {
        IEdoTable structTable = structFieldRel.getInRecords();
        IEdoTable fieldTable = structFieldRel.getOutRecords();
        IEdoIndexTable structFieldIndex = structFieldRel.getRelations();
        int structCount = structTable.getRecordCount();
        int structIndex = 0;
        while (structIndex < structCount) {
            String structName = structTable.getStringValue(structIndex, "STRUCTURE_NAME");
            if (!this.mStructureMap.containsKey(structName)) {
                int[] fieldIndices = structFieldIndex.getRelatedIndexes(structIndex);
                FieldDescriptor[] fields = new FieldDescriptor[fieldIndices.length];
                int j = 0;
                while (j < fieldIndices.length) {
                    int fieldIndex = fieldIndices[j];
                    fields[j] = new FieldDescriptor(fieldTable.getStringValue(fieldIndex, "FIELD_NAME"), fieldTable.getStringValue(fieldIndex, "FIELD_TYPE"), fieldTable.getStringValue(fieldIndex, "MAXLENGTH"), fieldTable.getStringValue(fieldIndex, "DECIMALS"), fieldTable.getBooleanValue(fieldIndex, "EXTENSION_FIELD"));
                    fields[j].setTextInfo(fieldTable.getStringValue(fieldIndex, "FIELDTEXT"), fieldTable.getStringValue(fieldIndex, "SCRTEXT_S"), fieldTable.getStringValue(fieldIndex, "SCRTEXT_M"), fieldTable.getStringValue(fieldIndex, "SCRTEXT_L"));
                    ++j;
                }
                StructureDescriptor aStruct = new StructureDescriptor(smDesc, structName, fields);
                this.mStructureMap.put(structName, aStruct);
            }
            ++structIndex;
        }
    }

    public void cleanup() {
    }

    public ISrvMgrMessage[] getMessages() {
        return null;
    }

    public void clearMessages() {
    }

    public ISrvMgrMessage removeMessage(int index) {
        return null;
    }

    public int sizeMessages() {
        return 0;
    }

    public ISrvMgrServiceModule getServiceModule(String moduleName) {
        return null;
    }

    public ISrvMgrServiceModule getServiceModule(String moduleName, String configurationName) {
        return null;
    }

    public String[] getServiceModuleConfigurationNames(String serviceModuleName) {
        return null;
    }

    public void invalidateModuleCache() {
    }

    public boolean save() {
        return false;
    }

    public boolean check() {
        return false;
    }

    public String getTransactionID() {
        return null;
    }

    public ISrvMgrCallbackOnFlush registerCallbackOnFlush(ISrvMgrCallbackOnFlush callbackObject) {
        throw new UnsupportedOperationException("The repository manager doesn't support callbacks!");
    }

    public String getRelativeAspectRowKey(IAspectDescriptor aspect, IEdoTable table, int index) {
        return null;
    }

    public String getBackendVersion() {
        return null;
    }

    public String getActiveVersion() {
        return null;
    }

    public String getFrontendVersion() {
        return null;
    }

    public void useServiceModule(String serviceModuleName, String serviceModuleConfigurationName) {
        this.mUsedServiceModules.put(serviceModuleName, serviceModuleConfigurationName);
    }

    public void flush(String callingLayer, String callingMethod) {
        super.flush();
    }

    public String[] getActiveFeatures() {
        return this.serviceManager.getActiveFeatures();
    }

    public String[] getSupportedFeatures() {
        return this.serviceManager.getSupportedFeatures();
    }

    public boolean isFeatureActive(String feature) {
        return this.serviceManager.isFeatureActive(feature);
    }

    public boolean isFeatureSupported(String feature) {
        return this.serviceManager.isFeatureSupported(feature);
    }

    public ISrvMgrMessage[] getAspectMessages(String aspectName, boolean includeRowMessages) {
        return null;
    }

    public ISrvMgrMessage[] getAspectRowMessages(String urlKey) {
        return null;
    }

    public ISrvMgrMessage[] getSystemMessages() {
        return null;
    }

    public ISrvMgrMessage[] getAndClearSystemMessages() {
        return null;
    }

    public void removeMessage(ISrvMgrMessage message) {
    }

    public void removeMessages(ISrvMgrMessage[] messages) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Location.getLocation((String)"ID.com.sap.tc.cool.servicemanager").infoT("$Id: //tc/Cool/630_VAL_REL/src/_col_servicemanager/java/com/sap/tc/col/servicemanager/core/RepositoryManager.java#1 $");
        VERSION_NUMBER_TAG = "VersionNumber";
        SYSTEM_KEY_TAG = "SystemKey";
        LOGON_CLIENT_TAG = "Client";
        LOGON_LANGUAGE_TAG = "Language";
        DATA_EXCHANGE_STRUCT = new StructureDescriptor("SCOL_DATA_EX_LINE", new FieldDescriptor[]{new FieldDescriptor("NAME", "STRING"), new FieldDescriptor("VALUE", "STRING")});
    }
}

