/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.col.servicemanager.core;

import com.sap.tc.col.servicemanager.core.CoolVersion;
import java.util.AbstractCollection;
import java.util.HashMap;
import java.util.HashSet;

public class CoolFeature {
    public static final CoolFeature VALUE_HELP = new CoolFeature("VALUE_HELP", "Value help is provided.", new String[]{"0000000000.0000000002", "640."});
    public static final CoolFeature ASPECT_RELATIONS = new CoolFeature("ASPECT_RELATIONS", "Relations are aspect-local.", new String[]{"0000000000.0000000002", "640."});
    public static final CoolFeature QUERY_SELECTION_PARAM = new CoolFeature("QUERY_SELECTION_PARAM", "Queries have selection parameters.", new String[]{"0000000000.0000000002", "640."});
    public static final CoolFeature MESSAGES_OUT_OF_BAND_ONLY = new CoolFeature("MESSAGES_OUT_OF_BAND_ONLY", "Messages are only transported out of band; no messages parameters in call objects.", new String[]{"0000000000.0000000002", "640."});
    public static final CoolFeature CROSS_ASPECT_ACTIONS = new CoolFeature("CROSS_ASPECT_ACTIONS", "Cross Aspect Actions.", new String[]{"700.0000000001"});
    private static HashMap theFeatures = new HashMap();
    private String mName;
    private String mDescription;
    private HashSet mVersions;

    static CoolFeature[] getKnownFeatures() {
        CoolFeature[] knownFeatures = new CoolFeature[theFeatures.size()];
        theFeatures.values().toArray(knownFeatures);
        return knownFeatures;
    }

    public CoolFeature(String featureName, String description, String[] versions) {
        this.mName = featureName;
        this.mDescription = description;
        this.mVersions = new HashSet(versions.length);
        int i = 0;
        while (i < versions.length) {
            this.mVersions.add(versions[i]);
            ++i;
        }
    }

    public String getName() {
        return this.mName;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public String[] getVersions() {
        String[] versions = new String[this.mVersions.size()];
        ((AbstractCollection)this.mVersions).toArray(versions);
        return versions;
    }

    public boolean isSupported() {
        return this.mVersions.contains(CoolVersion.getCurrentCoolVersion().getVersionNumber());
    }

    public boolean isSupportedInVersion(String coolVersion) {
        return this.mVersions.contains(coolVersion);
    }

    public static boolean isSupportedInVersion(String featureName, String coolVersion) {
        CoolFeature feature = (CoolFeature)theFeatures.get(featureName);
        if (feature == null) {
            throw new IllegalArgumentException("Unknown Feature '" + featureName);
        }
        return feature.isSupportedInVersion(coolVersion);
    }

    static {
        theFeatures.put(VALUE_HELP.getName(), VALUE_HELP);
        theFeatures.put(ASPECT_RELATIONS.getName(), ASPECT_RELATIONS);
        theFeatures.put(QUERY_SELECTION_PARAM.getName(), QUERY_SELECTION_PARAM);
        theFeatures.put(CROSS_ASPECT_ACTIONS.getName(), CROSS_ASPECT_ACTIONS);
        theFeatures.put(MESSAGES_OUT_OF_BAND_ONLY.getName(), MESSAGES_OUT_OF_BAND_ONLY);
    }
}

