/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.col.servicemanager.core;

import com.sap.tc.col.cds.ConnectionData;
import com.sap.tc.col.client.metadata.api.IAspectDescriptor;
import com.sap.tc.col.client.metadata.api.IServiceModuleDescriptor;
import com.sap.tc.col.client.metadata.api.IStructureDescriptor;
import com.sap.tc.col.edo.IEdoAtomicValue;
import com.sap.tc.col.edo.IEdoIndexTable;
import com.sap.tc.col.edo.IEdoStructure;
import com.sap.tc.col.edo.IEdoTable;
import com.sap.tc.col.edo.IEdoValue;
import com.sap.tc.col.rpe.IRpeConnection;
import com.sap.tc.col.rpe.RpeContext;
import com.sap.tc.col.rpe.RpeError;
import com.sap.tc.col.rpe.RpeErrors;
import com.sap.tc.col.rpe.RpeMethod;
import com.sap.tc.col.rpe.RpeMethodOpCode;
import com.sap.tc.col.rpe.RpeObject;
import com.sap.tc.col.rpe.RpeParameter;
import com.sap.tc.col.rpe.RpeParameterKind;
import com.sap.tc.col.rpe.RpeParameterMeta;
import com.sap.tc.col.servicemanager.api.ISrvMgrCallbackOnFlush;
import com.sap.tc.col.servicemanager.api.ISrvMgrMessage;
import com.sap.tc.col.servicemanager.api.ISrvMgrServiceManager;
import com.sap.tc.col.servicemanager.api.ISrvMgrServiceModule;
import com.sap.tc.col.servicemanager.core.CoolFeature;
import com.sap.tc.col.servicemanager.core.calls.AbstractCall;
import com.sap.tc.logging.Location;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public abstract class AbstractServiceManager
implements ISrvMgrServiceManager {
    private static final Location _logger = Location.getLocation((Class)(class$com$sap$tc$col$servicemanager$core$AbstractServiceManager == null ? (class$com$sap$tc$col$servicemanager$core$AbstractServiceManager = AbstractServiceManager.class$("com.sap.tc.col.servicemanager.core.AbstractServiceManager")) : class$com$sap$tc$col$servicemanager$core$AbstractServiceManager));
    protected RpeContext rpeContext = null;
    protected RpeObject rpeServiceManagerObject;
    protected RpeObject rpePerformanceBooster;
    protected Locale mLocale = null;
    protected Vector mCallList = new Vector();
    protected ISrvMgrCallbackOnFlush mCallbackOnFlush = null;
    protected boolean m_Debuginfo_Flushed = true;
    protected boolean m_Debuginfo_Mode = false;
    protected String m_Debuginfo_Module = null;
    protected String m_Debuginfo_GuiHost = null;
    protected boolean m_Debug_Rpe = false;
    protected boolean mToSave;
    static /* synthetic */ Class class$com$sap$tc$col$servicemanager$core$AbstractServiceManager;

    protected AbstractServiceManager(Locale locale) {
        this.mLocale = locale;
    }

    public void closeConnection() {
        this.invalidateModuleCache();
        if (this.rpeContext != null) {
            this.rpeContext.release();
        }
        this.rpeContext = null;
    }

    protected void addContext(ConnectionData connectionData) {
        String _methodName = "addContext(ConnectionData)";
        _logger.entering("addContext(ConnectionData)", new Object[]{connectionData});
        boolean sync = false;
        String propName = null;
        String propValue = null;
        if (this.rpeContext != null) {
            throw new RuntimeException("Context / Connection already set !!!");
        }
        this.rpeContext = RpeContext.createContext();
        String channel = connectionData.getProperty("cds.channel");
        IRpeConnection connection = this.rpeContext.createConnection(channel, true);
        Set allProperties = connectionData.getEntrySet();
        Iterator iter = allProperties.iterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            propName = (String)entry.getKey();
            propValue = (String)entry.getValue();
            if (propName.startsWith("cds.")) continue;
            if (propName.equals("sm.sync")) {
                if (!propValue.equals("true")) continue;
                sync = true;
                continue;
            }
            if (propName.equals("debug") && propValue.equals("true")) {
                connection.setProperty(propName, propValue);
                continue;
            }
            connection.setProperty(propName, propValue);
        }
        String lang = connectionData.getProperty("lang");
        if (lang == null || "".equals(lang)) {
            if (this.mLocale == null) {
                _logger.warningT("No connection language specified, use US locale");
                this.mLocale = Locale.US;
            }
            lang = this.mLocale.getLanguage();
            connection.setProperty("lang", lang);
        }
        connection.connect(null, null, null, null, null);
        if (this.mLocale == null) {
            lang = connection.getConnectionInfo().getProperty("ISO_LANGUAGE");
            this.mLocale = lang != null ? new Locale(lang, "") : Locale.US;
            _logger.warningT("Locale " + this.mLocale + " created from connection language");
        }
        this.setSynchronous(sync);
        _logger.exiting();
    }

    protected void addContext(AbstractServiceManager existingSvrMgr) {
        if (this.rpeContext != null) {
            throw new RuntimeException("Context / Connection already set !!!");
        }
        this.rpeContext = existingSvrMgr.rpeContext.createSharedContext();
        this.startContext();
        existingSvrMgr.rpeServiceManagerObject = this.rpeServiceManagerObject;
        existingSvrMgr.rpePerformanceBooster = this.rpePerformanceBooster;
        this.setSynchronous(this.rpeContext.isSynchronous());
    }

    protected void startContext() {
        this.rpeServiceManagerObject = this.rpeContext.createObject("CL_COL_SERVICE_MANAGER");
        this.rpePerformanceBooster = this.rpeContext.createObject("CL_RSE_BOOSTER");
    }

    public void setSynchronous(boolean sync) {
        this.rpeContext.setSynchronous(sync);
    }

    public boolean isSynchronous() {
        return this.rpeContext.isSynchronous();
    }

    protected void flush() {
        this.rpeContext.flush();
        if (this.rpeContext.hasError()) {
            int i = 0;
            while (i < this.mCallList.size()) {
                AbstractCall call = (AbstractCall)this.mCallList.get(i);
                call.setState(3);
                ++i;
            }
            this.mCallList.clear();
            throw new IllegalStateException(this.buildErrorMessage(this.rpeContext));
        }
        this.m_Debuginfo_Flushed = true;
        int i = 0;
        while (i < this.mCallList.size()) {
            AbstractCall call = (AbstractCall)this.mCallList.get(i);
            if (this.isFeatureActive(CoolFeature.MESSAGES_OUT_OF_BAND_ONLY)) {
                if (call.isRejected()) {
                    call.setState(3);
                } else {
                    call.setState(2);
                }
            } else {
                call.setState(2);
            }
            ++i;
        }
        this.mCallList.clear();
    }

    public IEdoTable createTable(IStructureDescriptor tableType) {
        return this.rpeContext.createTable(tableType);
    }

    public IEdoIndexTable createIndexTable(IStructureDescriptor indexTableType, String inField, String outField) {
        return this.rpeContext.createIndexTable(indexTableType, inField, outField);
    }

    public IEdoStructure createStructure(IStructureDescriptor structType) {
        return this.rpeContext.createStructure(structType);
    }

    public IEdoAtomicValue createValue(String initialValue) {
        return this.rpeContext.createValue(initialValue);
    }

    public RpeParameter createParameter(String name, String type, String kind, String meta, IEdoStructure aStructure) {
        return this.createParameter(name, type, kind, meta, (IEdoValue)aStructure);
    }

    public RpeParameter createParameter(String name, String type, String kind, String meta, IEdoTable aTable) {
        return this.createParameter(name, type, kind, meta, (IEdoValue)aTable);
    }

    public RpeParameter createParameter(String name, String type, String kind, String meta, IEdoValue value) {
        RpeParameterKind rpeKind = null;
        if (kind.compareTo("I") == 0) {
            rpeKind = RpeParameterKind.Importing;
        } else if (kind.compareTo("E") == 0) {
            rpeKind = RpeParameterKind.Exporting;
        } else if (kind.compareTo("C") == 0) {
            rpeKind = RpeParameterKind.Changing;
        } else if (kind.compareTo("R") == 0) {
            rpeKind = RpeParameterKind.Return;
        } else {
            throw new RuntimeException("Invalid parameter kind for remote method invocation !!!");
        }
        RpeParameterMeta rpeMeta = null;
        rpeMeta = meta.compareTo("T") == 0 ? RpeParameterMeta.Table : (meta.compareTo("S") == 0 ? RpeParameterMeta.Structure : (meta.compareTo("O") == 0 ? RpeParameterMeta.Object : RpeParameterMeta.Atomic));
        return this.rpeContext.createParameter(name, type, rpeKind, rpeMeta, value);
    }

    public RpeParameter createParameter(String name, String type, String kind, String meta, String stringValue) {
        return this.createParameter(name, type, kind, meta, (IEdoValue)this.rpeContext.createValue(stringValue));
    }

    public void callMethod(String name, ArrayList input, ArrayList output) {
        RpeMethod method = new RpeMethod(name, RpeMethodOpCode.Method);
        int i = 0;
        while (i < input.size()) {
            method.addParameter((RpeParameter)input.get(i));
            ++i;
        }
        int i2 = 0;
        while (i2 < output.size()) {
            method.addParameter((RpeParameter)output.get(i2));
            ++i2;
        }
        this.rpeContext.callMethod(this.rpeServiceManagerObject, method, false);
    }

    public void setDebug(boolean mode, String serviceModuleName, String guiHost) {
        IEdoAtomicValue v1 = null;
        IEdoAtomicValue v2 = null;
        IEdoAtomicValue v3 = null;
        ArrayList<RpeParameter> inp = new ArrayList<RpeParameter>();
        ArrayList out = new ArrayList();
        v1 = mode ? this.rpeContext.createValue("X") : this.rpeContext.createValue("");
        RpeParameter p1 = this.createParameter("DEBUG_MODE", "C", "I", "A", (IEdoValue)v1);
        inp.add(p1);
        if (serviceModuleName != null) {
            v2 = this.rpeContext.createValue(serviceModuleName);
            RpeParameter p2 = this.createParameter("SERVICE_MODULE", "STRING", "I", "A", (IEdoValue)v2);
            inp.add(p2);
        }
        if (mode && guiHost != null) {
            v3 = this.rpeContext.createValue(guiHost);
            RpeParameter p3 = this.createParameter("SAPGUI_HOST", "STRING", "I", "A", (IEdoValue)v3);
            inp.add(p3);
        }
        this.callMethod("ENABLE_DEBUG_MODE", inp, out);
        this.m_Debuginfo_Flushed = false;
        this.m_Debuginfo_Mode = mode;
        this.m_Debuginfo_Module = serviceModuleName;
        this.m_Debuginfo_GuiHost = guiHost;
    }

    public void queueCall(AbstractCall call) {
        this.mCallList.add(call);
        call.setState(1);
        if (this.isSynchronous()) {
            this.flush("SMP", "ISrvMgrCall.processCall()");
        }
    }

    protected String buildErrorMessage(RpeContext rpeContext) {
        String errorMessage = null;
        RpeErrors errorList = rpeContext.getErrors();
        RpeError error = errorList.getError(0);
        errorMessage = "\n\n          Error Text     " + error.description + "\n          " + "Error Code     " + error.code + "\n          " + "Category       " + error.category + "\n          " + "Class Name     " + error.className + "\n          " + "Object         " + error.object + "\n          " + "Method         " + error.method + "\n          " + "Opcode         " + error.opcode + "\n          " + "Parameter      " + error.parameter + "\n          " + "Value          " + error.value + "\n          " + "State          " + error.state + "\n          " + "Location       " + error.location + "\n          " + "Backend Info   " + error.connection.toString() + "\n";
        rpeContext.release();
        rpeContext = null;
        return errorMessage;
    }

    public boolean isToSave() {
        return this.mToSave;
    }

    public void setToSave(boolean mToSave) {
        this.mToSave = mToSave;
    }

    public void copyCorresponding(IEdoTable srcTable, IEdoTable dstTable) {
        RpeMethod method = this.rpeContext.createMethod("MOVE_CORRESPONDING");
        RpeParameter srcParam = this.createParameter("SRC_TABLE", srcTable.getDescriptor().getName(), "I", "T", srcTable);
        RpeParameter dstParam = this.createParameter("DST_TABLE", dstTable.getDescriptor().getName(), "C", "T", dstTable);
        method.addParameter(srcParam);
        method.addParameter(dstParam);
        this.rpeContext.callMethod(this.rpePerformanceBooster, method, false);
    }

    private void setLocale(String language, String country) {
        String theCountry;
        String theLanguage = language == null ? "" : language.toLowerCase();
        String string = theCountry = country == null ? "" : country.toUpperCase();
        if ("".equals(theLanguage)) {
            theLanguage = Locale.getDefault().getLanguage();
        }
        this.mLocale = new Locale(theLanguage, theCountry);
    }

    public Locale getLocale() {
        return this.mLocale;
    }

    abstract IServiceModuleDescriptor getServiceModuleDescriptor(String var1, String var2);

    public boolean isFeatureActive(CoolFeature feature) {
        return this.isFeatureActive(feature.getName());
    }

    public abstract String getRelativeAspectRowKey(IAspectDescriptor var1, IEdoTable var2, int var3);

    public abstract String getTransactionID();

    public abstract boolean isFeatureActive(String var1);

    public abstract String[] getActiveFeatures();

    public abstract boolean isFeatureSupported(String var1);

    public abstract String[] getSupportedFeatures();

    public abstract ISrvMgrCallbackOnFlush registerCallbackOnFlush(ISrvMgrCallbackOnFlush var1);

    public abstract boolean check();

    public abstract boolean save();

    public abstract void cleanup();

    public abstract int sizeMessages();

    public abstract ISrvMgrMessage removeMessage(int var1);

    public abstract void flush(String var1, String var2);

    public abstract ISrvMgrServiceModule getServiceModule(String var1, String var2);

    public abstract ISrvMgrServiceModule getServiceModule(String var1);

    public abstract void useServiceModule(String var1, String var2);

    public abstract void invalidateModuleCache();

    public abstract boolean isServiceModule(String var1);

    public abstract String[] getServiceModuleConfigurationNames(String var1);

    public abstract String[] getServiceModuleNames();

    public abstract String getActiveVersion();

    public abstract String getBackendVersion();

    public abstract String getFrontendVersion();

    public abstract void removeMessages(ISrvMgrMessage[] var1);

    public abstract void removeMessage(ISrvMgrMessage var1);

    public abstract void clearMessages();

    public abstract ISrvMgrMessage[] getMessages();

    public abstract ISrvMgrMessage[] getAndClearSystemMessages();

    public abstract ISrvMgrMessage[] getSystemMessages();

    public abstract ISrvMgrMessage[] getAspectRowMessages(String var1);

    public abstract ISrvMgrMessage[] getAspectMessages(String var1, boolean var2);

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Location.getLocation((String)"ID.com.sap.tc.cool.servicemanager").infoT("$Id: //tc/Cool/630_VAL_REL/src/_col_servicemanager/java/com/sap/tc/col/servicemanager/core/AbstractServiceManager.java#1 $");
    }
}

