/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdo.sql.util;

import com.sap.dictionary.database.dbs.Database;
import com.sap.dictionary.database.dbs.DbColumn;
import com.sap.dictionary.database.dbs.DbColumns;
import com.sap.dictionary.database.dbs.DbFactory;
import com.sap.dictionary.database.dbs.DbIndexColumnInfo;
import com.sap.dictionary.database.dbs.DbPrimaryKey;
import com.sap.dictionary.database.dbs.DbSchema;
import com.sap.dictionary.database.dbs.DbTable;
import com.sap.dictionary.database.dbs.JddException;
import com.sap.dictionary.database.opentools.DbTableOpenTools;
import com.sap.jdo.sql.catalog.virtual.VirtualCatalogReader;
import com.sap.jdo.sql.catalog.virtual.VirtualColumn;
import com.sap.jdo.sql.catalog.virtual.VirtualTable;
import com.sap.jdo.sql.mapping.MappingClass;
import com.sap.jdo.sql.mapping.impl.MappingClassImpl;
import com.sap.jdo.sql.mapping.impl.MappingModelImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.jdo.JDOException;

public class JDO {
    public static final String HELP_ARG = "-h";
    public static final String VERBOSE_ARG = "-v";
    public static final String PROPERTY_ARG = "-p";
    public static final String DATASOURCE_ARG = "-d";
    public static final String MAPPING_ARG = "-m";
    public static final String CATALOG_ARG = "-c";
    public static final String RTO_ARG = "-rto";
    public static final String CLASSPATH_ARG = "-classpath";
    public static final String READ_TABLES_ARG = "read";
    public static final String CREATE_TABLES_ARG = "create";
    public static final String DROP_TABLES_ARG = "drop";
    public static final String CHECK_CLASSES_ARG = "check";
    public static final String FORWARD_ARG = "forward";
    public static final String GENERATE_ARG = "generate";
    public static final String TABLES_ARG = "tables";
    private Properties _properties = null;
    private Connection _connection = null;
    private Args a = new Args();
    private ClassLoader classLoader;
    private Class persistenceCapableClass;
    static /* synthetic */ Class class$com$sap$dictionary$database$dbs$DbPrimaryKey;
    static /* synthetic */ Class class$com$sap$jdo$sql$util$JDO;

    private JDO() {
    }

    private void readTables(String[] tables, String catalogPath) throws Exception {
        this.connect();
        DbFactory factory = new DbFactory(this._connection);
        int read = 0;
        if (tables != null) {
            File tablesDir = new File(catalogPath);
            tablesDir.mkdirs();
            int i = 0;
            while (i < tables.length) {
                DbTable table = factory.makeTable(null, tables[i]);
                table.setCommonContentViaDb(factory);
                if (table.getColumns() != null) {
                    String xmlFileName = catalogPath + System.getProperty("file.separator") + tables[i] + ".gdbtable";
                    PrintWriter pw = new PrintWriter(new FileWriter(xmlFileName));
                    table.writeCommonContentToXmlFile(pw, "");
                    pw.close();
                    System.out.println(tables[i] + ": table succesfully read");
                    ++read;
                } else {
                    System.out.println(tables[i] + ": table not found");
                }
                ++i;
            }
        }
        System.out.println("=> " + read + " table(s) read");
        this.disconnect();
    }

    private void createTables(String[] tables, String catalogPath) throws IOException, JddException, ClassNotFoundException, SQLException {
        this.connect();
        DbTableOpenTools openTools = new DbTableOpenTools(this._connection);
        int created = 0;
        int failed = 0;
        if (tables != null) {
            ClassLoader loader = this.getLoader(catalogPath);
            int i = 0;
            while (i < tables.length) {
                File file;
                URL url;
                String filename = tables[i] + ".gdbtable";
                if (loader != null && (url = loader.getResource(filename)) != null && (file = new File(url.getFile())) != null) {
                    if (openTools.createTable(tables[i], file)) {
                        ++created;
                    } else {
                        System.out.println("creation of table " + tables[i] + " failed.");
                        ++failed;
                    }
                }
                ++i;
            }
        }
        System.out.println("=> " + created + " table(s) created, " + failed + " table(s) FAILED");
        this.disconnect();
        if (failed > 0) {
            System.exit(1);
        }
    }

    private void dropTables(String[] tables, String catalogPath) throws JddException, ClassNotFoundException, SQLException {
        this.connect();
        int dropped = 0;
        int failed = 0;
        DbTableOpenTools openTools = new DbTableOpenTools(this._connection);
        if (tables != null) {
            int i = 0;
            while (i < tables.length) {
                if (openTools.dropTable(tables[i])) {
                    ++dropped;
                } else {
                    ++failed;
                }
                ++i;
            }
        }
        System.out.println("=> " + dropped + " table(s) dropped, " + failed + " table(s) FAILED");
        this.disconnect();
    }

    /*
     * Unable to fully structure code
     */
    private void checkClasses(String[] classes, String catalogPath) throws ClassNotFoundException {
        p = (Properties)this._properties.clone();
        p.setProperty("com.sap.jdo.sql.mapping.checkConsistency", Boolean.TRUE.toString());
        p.setProperty("com.sap.jdo.sql.mapping.checkConsistencyDeep", Boolean.TRUE.toString());
        p.setProperty("com.sap.jdo.sql.mapping.useCatalog", Boolean.TRUE.toString());
        p.setProperty("com.sap.jdo.sql.mapping.catalogPath", catalogPath);
        checked = 0;
        failed = 0;
        mappingModel = MappingModelImpl.getMappingModelFromPath(p);
        i = 0;
        while (i < classes.length) {
            block6: {
                pcClass = Class.forName(classes[i], true, this.classLoader);
                if (this.persistenceCapableClass.isAssignableFrom(pcClass)) {
                    block7: {
                        ++checked;
                        try {
                            mappingModel.getMappingClass(pcClass, true);
                            System.out.println(pcClass.getName() + ": check for PC class passed");
                            break block6;
                        }
                        catch (JDOException e) {
                            ++failed;
                            System.out.println("check failed:" + pcClass.getName() + " : " + e.getMessage());
                            ts = e.getNestedExceptions();
                            if (ts == null) break block7;
                            k = 0;
                            ** while (k < ts.length)
                        }
lbl-1000:
                        // 1 sources

                        {
                            t = ts[k];
                            System.out.println("nested Exception:" + t.getMessage());
                            ++k;
                            continue;
                        }
                    }
                    if (this.a.verbose) {
                        e.printStackTrace();
                    }
                }
            }
            ++i;
        }
        System.out.println("=> " + checked + " PC class(es) checked (" + failed + " failed), " + (classes.length - checked) + " non PC class(es) not checked");
    }

    private void forwardMapping(String[] classes, String catalogPath, String mappingFilesPath) throws Exception {
        Properties p = (Properties)((Hashtable)this._properties).clone();
        p.setProperty("com.sap.jdo.sql.mapping.useCatalog", Boolean.FALSE.toString());
        p.setProperty("com.sap.jdo.sql.mapping.checkConsistency", Boolean.FALSE.toString());
        p.setProperty("com.sap.jdo.sql.mapping.checkConsistencyDeep", Boolean.FALSE.toString());
        p.setProperty("com.sap.jdo.sql.mapping.forwardMapping", Boolean.TRUE.toString());
        this.forwardMapping0(p, classes, catalogPath, mappingFilesPath);
    }

    private void forwardMappingDictionaryOnly(String[] classes, String catalogPath) throws Exception {
        Properties p = (Properties)((Hashtable)this._properties).clone();
        p.setProperty("com.sap.jdo.sql.mapping.useCatalog", Boolean.FALSE.toString());
        p.setProperty("com.sap.jdo.sql.mapping.checkConsistency", Boolean.FALSE.toString());
        p.setProperty("com.sap.jdo.sql.mapping.checkConsistencyDeep", Boolean.FALSE.toString());
        p.setProperty("com.sap.jdo.sql.mapping.forwardMapping", Boolean.FALSE.toString());
        this.forwardMapping0(p, classes, catalogPath, null);
    }

    private void forwardMapping0(Properties p, String[] classes, String catalogPath, String mappingFilesPath) throws Exception {
        int mapped = 0;
        int created = 0;
        MappingModelImpl mappingModel = MappingModelImpl.getVirtualMappingModel(p);
        int i = 0;
        while (i < classes.length) {
            Class<?> pcClass = Class.forName(classes[i], true, this.classLoader);
            if (this.persistenceCapableClass.isAssignableFrom(pcClass)) {
                if (mappingFilesPath != null) {
                    mappingModel.getMappingClass(pcClass);
                } else {
                    mappingModel.getMappingClass(pcClass, true);
                }
                ++mapped;
            }
            ++i;
        }
        if (mappingFilesPath != null) {
            File mappingFilesDir = new File(mappingFilesPath);
            mappingFilesDir.mkdirs();
            MappingClass[] mappingClasses = mappingModel.getMappingClasses(this.classLoader);
            int count = mappingClasses == null ? 0 : mappingClasses.length;
            int i2 = 0;
            while (i2 < count) {
                MappingClass mappingClass = mappingClasses[i2];
                String fileName = null;
                if (!mappingClass.getPackageName().equals("")) {
                    fileName = mappingFilesPath + "/" + mappingClass.getName().replace('.', '/') + ".map";
                    String dirName = mappingFilesPath + "/" + mappingClass.getPackageName().replace('.', '/');
                    File dir = new File(dirName);
                    dir.mkdirs();
                }
                ((MappingClassImpl)mappingClass).render(fileName);
                System.out.println(classes[i2] + ": mapping file " + fileName + " for PC class created");
                ++i2;
            }
        }
        if (catalogPath != null) {
            VirtualCatalogReader catalogReader = (VirtualCatalogReader)mappingModel.getCatalogReader();
            String[] tableNames = catalogReader.getTables();
            DbFactory factory = new DbFactory(Database.ARTIFICIAL);
            File tablesDir = new File(catalogPath);
            tablesDir.mkdirs();
            created = tableNames.length;
            int i3 = 0;
            while (i3 < tableNames.length) {
                VirtualTable table = (VirtualTable)catalogReader.getTable(tableNames[i3]);
                DbSchema dbSchema = new DbSchema();
                DbTable dbTable = factory.makeTable(dbSchema, table.getName());
                ArrayList<DbIndexColumnInfo> pkColumns = new ArrayList<DbIndexColumnInfo>();
                DbColumns dbColumns = new DbColumns(factory);
                VirtualTable.VirtualColumnIterator columnIterator = (VirtualTable.VirtualColumnIterator)table.getColumns();
                int j = 0;
                while (columnIterator.hasNext()) {
                    VirtualColumn column = (VirtualColumn)columnIterator.next();
                    DbColumn dbColumn = factory.makeDbColumn(column.getName(), ++j, column.getJdbcType(), "", column.getSize(), column.getDecimals(), !column.isNullable(), "");
                    dbColumns.add(dbColumn);
                    if (!column.isPrimaryKey()) continue;
                    DbIndexColumnInfo dbIndexColumnInfo = new DbIndexColumnInfo(column.getName(), false);
                    pkColumns.add(dbIndexColumnInfo);
                }
                dbTable.setColumns(dbColumns);
                if (pkColumns.size() > 0) {
                    DbPrimaryKey dbPrimaryKey = factory.makePrimaryKey();
                    dbPrimaryKey.setColumnNames(pkColumns);
                    dbTable.setPrimaryKey(dbPrimaryKey);
                    dbPrimaryKey.setTable(dbTable);
                    Class clazz = class$com$sap$dictionary$database$dbs$DbPrimaryKey == null ? JDO.class$("com.sap.dictionary.database.dbs.DbPrimaryKey") : class$com$sap$dictionary$database$dbs$DbPrimaryKey;
                    Field field = clazz.getDeclaredField("tableName");
                    ((AccessibleObject)field).setAccessible(true);
                    field.set(dbPrimaryKey, dbTable.getName());
                }
                String xmlFileName = catalogPath + System.getProperty("file.separator") + dbTable.getName() + ".gdbtable";
                PrintWriter pw = new PrintWriter(new FileWriter(xmlFileName));
                dbTable.writeCommonContentToXmlFile(pw, "");
                pw.close();
                if (this.a.verbose) {
                    System.out.println(dbTable.getName() + ": xml file " + xmlFileName + " for table created");
                } else {
                    System.out.println(dbTable.getName() + ": xml file for table created");
                }
                ++i3;
            }
        }
        System.out.println("=> " + mapped + " class(es) mapped, " + created + " table(s)");
    }

    public static void main(String[] args) throws Exception {
        JDO instance = new JDO();
        instance.process(args);
    }

    private void process(String[] args) throws Exception {
        this._properties = new Properties();
        this.processArgs(args);
        try {
            if (READ_TABLES_ARG.equals(this.a.operation)) {
                this.readTables(this.a.tables, this.getCatalogPath(this._properties, true, true));
            } else if (CREATE_TABLES_ARG.equals(this.a.operation)) {
                this.createTables(this.a.tables, this.getCatalogPath(this._properties, true, false));
            } else if (DROP_TABLES_ARG.equals(this.a.operation)) {
                this.dropTables(this.a.tables, this.getCatalogPath(this._properties, true, false));
            } else if (CHECK_CLASSES_ARG.equals(this.a.operation)) {
                this.checkClasses(this.a.classes, this.getCatalogPath(this._properties, true, false));
            } else if (FORWARD_ARG.equals(this.a.operation)) {
                this.forwardMapping(this.a.classes, this.getCatalogPath(this._properties, false, true), this.getMappingFilesPath(this._properties, true, true));
            } else if (GENERATE_ARG.equals(this.a.operation)) {
                this.forwardMappingDictionaryOnly(this.a.classes, this.getCatalogPath(this._properties, false, true));
            }
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.disconnect();
            throw throwable;
        }
        this.disconnect();
    }

    private void getProperties() throws IOException {
        if (this.a.propertiesFileName != null) {
            FileInputStream fi = new FileInputStream(this.a.propertiesFileName);
            try {
                this._properties = new Properties();
                this._properties.load(fi);
                Object var3_2 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                fi.close();
                throw throwable;
            }
            fi.close();
            {
            }
        }
    }

    private void connect() throws ClassNotFoundException, SQLException {
        if (this.a.dataSourceName != null) {
            System.out.println("unsupported option -d");
            System.exit(1);
        } else {
            String jdbcDriverName = this._properties.getProperty("javax.jdo.option.ConnectionDriverName");
            if (jdbcDriverName == null || "".equals(jdbcDriverName)) {
                System.out.println("Property javax.jdo.option.ConnectionDriverName not set");
                System.exit(1);
            }
            Class.forName(jdbcDriverName);
            String URL2 = this._properties.getProperty("javax.jdo.option.ConnectionURL");
            if (URL2 == null || "".equals(URL2)) {
                System.out.println("Property javax.jdo.option.ConnectionURL not set");
                System.exit(1);
            }
            String userName = this._properties.getProperty("javax.jdo.option.ConnectionUserName");
            String password = this._properties.getProperty("javax.jdo.option.ConnectionPassword");
            System.out.println("... connect to database: " + URL2);
            this._connection = DriverManager.getConnection(URL2, userName, password);
        }
        if (this._connection == null) {
            System.out.println("... FAILED");
            System.exit(1);
        }
        System.out.println("... connected");
    }

    void disconnect() throws SQLException {
        if (this._connection != null) {
            this._connection.close();
            this._connection = null;
            System.out.println("... disconnected");
        }
    }

    ClassLoader getLoader(String path) throws MalformedURLException {
        if (path == null || path.equalsIgnoreCase("")) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(path, File.pathSeparator);
        ArrayList<URL> arrayList = new ArrayList<URL>();
        while (tokenizer.hasMoreTokens()) {
            String name = tokenizer.nextToken();
            File file = new File(name);
            if (!file.exists()) continue;
            arrayList.add(file.toURL());
        }
        if (arrayList.size() > 0) {
            URL[] urls = new URL[arrayList.size()];
            urls = arrayList.toArray(urls);
            return new URLClassLoader(urls, null);
        }
        return null;
    }

    private String getCatalogPath(Properties properties, boolean required, boolean single) {
        String catalogPath = this.a.catalogPath;
        if (catalogPath == null || "".equals(catalogPath)) {
            catalogPath = this._properties.getProperty("com.sap.jdo.sql.mapping.catalogPath");
        }
        if (required && (catalogPath == null || "".equals(catalogPath))) {
            System.out.println("Neither property com.sap.jdo.sql.mapping.catalogPath nor option -c set");
            System.exit(1);
        }
        if (catalogPath != null) {
            System.out.println("... catalog path: " + catalogPath);
        }
        if (single && catalogPath != null && !"".equals(catalogPath) && catalogPath.indexOf(File.pathSeparator) != -1) {
            System.out.println("Catalog path must not contain more than one path entry");
            System.exit(1);
        }
        return catalogPath;
    }

    private String getMappingFilesPath(Properties properties, boolean required, boolean single) {
        String mappingFilesPath = this.a.mappingFilesPath;
        if (mappingFilesPath == null || mappingFilesPath.equals("")) {
            mappingFilesPath = this._properties.getProperty("com.sap.jdo.sql.mapping.mappingFilesPath");
        }
        if (required && (mappingFilesPath == null || mappingFilesPath.equals(""))) {
            System.out.println("Neither property com.sap.jdo.sql.mapping.mappingFilesPath nor option -m set");
            System.exit(1);
        }
        if (mappingFilesPath != null) {
            System.out.println("... mapping files path: " + mappingFilesPath);
        }
        if (single && mappingFilesPath != null && !"".equals(mappingFilesPath) && mappingFilesPath.indexOf(File.pathSeparator) != -1) {
            System.out.println("Mapping Files path must not contain more than one path entry");
            System.exit(1);
        }
        return mappingFilesPath;
    }

    private Set processTables(int i, String[] args) throws ClassNotFoundException {
        Set<String> tables = new HashSet();
        if (i + 1 < args.length) {
            if (TABLES_ARG.equals(args[i + 1])) {
                int j = i + 2;
                while (j < args.length) {
                    tables.add(args[j].toUpperCase());
                    ++j;
                }
            } else {
                Set classes = this.processClasses(i, args);
                tables = this.tablesFromClasses(classes);
            }
        }
        return tables;
    }

    private Set tablesFromClasses(Set classes) throws ClassNotFoundException {
        Properties p = (Properties)((Hashtable)this._properties).clone();
        p.setProperty("com.sap.jdo.sql.mapping.useCatalog", Boolean.FALSE.toString());
        p.setProperty("com.sap.jdo.sql.mapping.checkConsistency", Boolean.FALSE.toString());
        p.setProperty("com.sap.jdo.sql.mapping.checkConsistencyDeep", Boolean.FALSE.toString());
        HashSet<String> tables = new HashSet<String>();
        MappingModelImpl mappingModel = MappingModelImpl.getVirtualMappingModel(p);
        Iterator i = classes.iterator();
        while (i.hasNext()) {
            String className = (String)i.next();
            Class<?> pcClass = Class.forName(className, true, this.classLoader);
            if (!this.persistenceCapableClass.isAssignableFrom(pcClass)) continue;
            mappingModel.getMappingClass(pcClass, true);
        }
        VirtualCatalogReader catalogReader = (VirtualCatalogReader)mappingModel.getCatalogReader();
        String[] tableNames = catalogReader.getTables();
        tables = new HashSet();
        int i2 = 0;
        while (i2 < tableNames.length) {
            tables.add(tableNames[i2]);
            ++i2;
        }
        return tables;
    }

    private Set processClasses(int i, String[] args) {
        HashSet<String> classes = new HashSet<String>();
        int j = i + 1;
        while (j < args.length) {
            if (JDO.isClassFileName(args[j])) {
                classes.add(JDO.createClassName(args[j]));
            } else {
                classes.add(args[j]);
            }
            ++j;
        }
        return classes;
    }

    private void processArgs(String[] args) throws ClassNotFoundException, IOException {
        Set tables = new HashSet();
        Set classes = new HashSet();
        this.classLoader = (class$com$sap$jdo$sql$util$JDO == null ? (class$com$sap$jdo$sql$util$JDO = JDO.class$("com.sap.jdo.sql.util.JDO")) : class$com$sap$jdo$sql$util$JDO).getClassLoader();
        this.persistenceCapableClass = Class.forName("javax.jdo.spi.PersistenceCapable", true, this.classLoader);
        int i = 0;
        while (i < args.length) {
            if (HELP_ARG.equals(args[i])) {
                this.usage();
            }
            if (PROPERTY_ARG.equals(args[i])) {
                if (i + 1 < args.length) {
                    this.a.propertiesFileName = args[++i];
                    this.getProperties();
                }
            } else if (DATASOURCE_ARG.equals(args[i])) {
                if (i + 1 < args.length) {
                    this.a.dataSourceName = args[++i];
                }
            } else if (CATALOG_ARG.equals(args[i])) {
                if (i + 1 < args.length) {
                    this.a.catalogPath = args[++i];
                }
            } else if (MAPPING_ARG.equals(args[i])) {
                if (i + 1 < args.length) {
                    this.a.mappingFilesPath = args[++i];
                }
            } else if (VERBOSE_ARG.equals(args[i])) {
                this.a.verbose = true;
            } else {
                if (READ_TABLES_ARG.equals(args[i])) {
                    this.a.operation = args[i];
                    tables = this.processTables(i, args);
                    break;
                }
                if (CREATE_TABLES_ARG.equals(args[i])) {
                    this.a.operation = args[i];
                    tables = this.processTables(i, args);
                    break;
                }
                if (DROP_TABLES_ARG.equals(args[i])) {
                    this.a.operation = args[i];
                    tables = this.processTables(i, args);
                    break;
                }
                if (CLASSPATH_ARG.equals(args[i])) {
                    String classpath = args[++i];
                    this.classLoader = this.getClassLoader(classpath);
                    this.persistenceCapableClass = Class.forName("javax.jdo.spi.PersistenceCapable", true, this.classLoader);
                } else {
                    if (CHECK_CLASSES_ARG.equals(args[i])) {
                        this.a.operation = args[i];
                        classes = this.processClasses(i, args);
                        break;
                    }
                    if (FORWARD_ARG.equals(args[i])) {
                        this.a.operation = args[i];
                        classes = this.processClasses(i, args);
                        break;
                    }
                    if (GENERATE_ARG.equals(args[i])) {
                        this.a.operation = args[i];
                        classes = this.processClasses(i, args);
                        break;
                    }
                    this.usage();
                }
            }
            ++i;
        }
        this.a.tables = tables.toArray(new String[0]);
        this.a.classes = classes.toArray(new String[0]);
    }

    private void usage() {
        System.out.println("Usage: JDO <options> <command> (<classfile>...|<class>...| tables <table>...)");
        System.out.println("Options:");
        System.out.println("  -h                       print usage message and exit gently");
        System.out.println("  -v                       print verbose messages");
        System.out.println("  -p                       properties file");
        System.out.println("  -d                       data source");
        System.out.println("  -c                       catalog path");
        System.out.println("  -m                       mapping metadata path");
        System.out.println("  -classpath               path of the classfiles");
        System.out.println();
        System.out.println("Commands:");
        System.out.println("  check                    check mapping");
        System.out.println("  forward                  forward mapping");
        System.out.println("  generate                 generate dictionary metadata");
        System.out.println("  read                     read dictionary metadata from database");
        System.out.println("  create                   create tables given by metadata dictionary");
        System.out.println("  drop                     drop tables given by metadata dictionary");
        System.out.println();
        System.out.println("Arguments:");
        System.out.println("  <classfile>              the name of a .class file");
        System.out.println("  <class>                  the fully qualified name of a Java class");
        System.out.println("  <table>                  the name of a database table");
        System.out.println();
        System.out.println("Returns a non-zero value in case of errors.");
        System.exit(1);
    }

    private static boolean isClassFileName(String filename) {
        return filename.endsWith(".class");
    }

    private static String createClassName(String filename) {
        String classname = filename.replace('/', '.');
        int i = classname.lastIndexOf(".class");
        classname = classname.substring(0, i);
        return classname;
    }

    private ClassLoader getClassLoader(String path) throws IOException {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        if (path != null) {
            StringTokenizer tokenizer = new StringTokenizer(path, File.pathSeparator);
            while (tokenizer.hasMoreTokens()) {
                String name = tokenizer.nextToken();
                File file = new File(name);
                file = file.getCanonicalFile();
                arrayList.add(file.toURL());
            }
        }
        URL[] urls = new URL[arrayList.size()];
        urls = arrayList.toArray(urls);
        return new URLClassLoader(urls, (class$com$sap$jdo$sql$util$JDO == null ? (class$com$sap$jdo$sql$util$JDO = JDO.class$("com.sap.jdo.sql.util.JDO")) : class$com$sap$jdo$sql$util$JDO).getClassLoader());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class Args {
        String propertiesFileName = null;
        boolean verbose = false;
        String[] tables = null;
        String[] classes = null;
        String operation = null;
        String dataSourceName = null;
        String catalogPath = null;
        String mappingFilesPath = null;

        private Args() {
        }
    }
}

