/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdo.sql.mapping.xml;

import com.sap.jdo.model.jdo.JDOModelException;
import com.sap.jdo.sql.catalog.Column;
import com.sap.jdo.sql.catalog.virtual.VirtualColumn;
import com.sap.jdo.sql.jdbc.JDBCHelper;
import com.sap.jdo.sql.mapping.MappingClass;
import com.sap.jdo.sql.mapping.MappingClassMember;
import com.sap.jdo.sql.mapping.MappingDiscriminator;
import com.sap.jdo.sql.mapping.MappingField;
import com.sap.jdo.sql.mapping.MappingForeignKey;
import com.sap.jdo.sql.mapping.MappingInterfaceKey;
import com.sap.jdo.sql.mapping.MappingModel;
import com.sap.jdo.sql.mapping.MappingRelationship;
import com.sap.jdo.sql.mapping.impl.MappingModelJDBCTypeSupplier;
import java.util.Stack;
import javax.jdo.JDOFatalUserException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class Handler_1_0 {
    private MappingModel model = null;
    private Stack context = null;
    private String lookupClassName = null;
    boolean lookupSingleClass = false;
    boolean ignoreClass = false;

    public Handler_1_0(MappingModel model) {
        this.model = model;
        this.context = new Stack();
    }

    public Handler_1_0(MappingModel model, String lookupClassName) {
        this.model = model;
        this.context = new Stack();
        this.lookupSingleClass = true;
        this.lookupClassName = lookupClassName;
    }

    public void start_map(Attributes meta) throws SAXException {
        String version = meta.getValue("", "version");
        if (!version.equals("1.0")) {
            throw new SAXException("Illegal XML mapping metadata document version " + version + ". Supported versions: 1.0");
        }
    }

    public void end_map() throws SAXException {
    }

    public void start_package(Attributes meta) throws SAXException {
        try {
            String packageName = meta.getValue("", "name");
            if (packageName == null || packageName.length() == 0) {
                throw new JDOModelException("Invalid empty package specification");
            }
            packageName = packageName.trim();
            this.context.push(packageName);
        }
        catch (JDOModelException e) {
            throw new SAXException("model exception", e);
        }
    }

    public void end_package() throws SAXException {
        this.context.pop();
    }

    public void start_class(Attributes meta) throws SAXException {
        try {
            String packageName = (String)this.context.peek();
            String className = meta.getValue("", "name");
            if (className == null || className.length() == 0) {
                throw new JDOModelException("Invalid empty class specification");
            }
            if (packageName != null) {
                className = packageName + '.' + className;
            }
            if (this.lookupSingleClass && !className.equals(this.lookupClassName)) {
                this.ignoreClass = true;
            } else {
                this.ignoreClass = false;
                MappingClass mappingClass = this.model.createMappingClass(className);
                this.context.push(mappingClass);
            }
        }
        catch (JDOModelException e) {
            throw new SAXException("model exception", e);
        }
    }

    public void end_class() throws SAXException {
        if (!this.ignoreClass) {
            MappingClass mappingClass = (MappingClass)this.context.pop();
            MappingModelJDBCTypeSupplier.process(mappingClass);
        }
    }

    public void start_field(Attributes meta) throws SAXException {
        MappingClass mappingClass = (MappingClass)this.context.peek();
        String fieldName = null;
        Boolean virtual = new Boolean(false);
        int i = 0;
        while (i < meta.getLength()) {
            String name = meta.getLocalName(i);
            String value = meta.getValue(i);
            if ("name".equals(name)) {
                fieldName = value;
            } else if ("virtual".equals(name)) {
                virtual = new Boolean(value);
            }
            ++i;
        }
        MappingField mappingField = null;
        mappingField = virtual == false ? mappingClass.createMappingField(fieldName) : mappingClass.createMappingVirtualField(fieldName);
        this.context.push(mappingField);
    }

    public void end_field() {
        this.context.pop();
    }

    public void start_column(Attributes meta) throws SAXException {
        Object contextPeek = this.context.peek();
        String columnName = null;
        String tableName = null;
        Column column = null;
        int i = 0;
        while (i < meta.getLength()) {
            String name = meta.getLocalName(i);
            String value = meta.getValue(i);
            if ("name".equals(name)) {
                columnName = value;
            } else if ("table".equals(name)) {
                tableName = value;
            }
            ++i;
        }
        if (contextPeek instanceof MappingClassMember) {
            MappingClassMember mappingClassMember = (MappingClassMember)contextPeek;
            column = mappingClassMember.addColumn(columnName, tableName);
        } else if (contextPeek instanceof MappingInterfaceDiscriminator) {
            MappingInterfaceDiscriminator mappingInterfaceDiscriminator = (MappingInterfaceDiscriminator)contextPeek;
            column = mappingInterfaceDiscriminator.getDeclaringMappingInterfaceKey().setDiscriminatorColumn(columnName, tableName);
        } else if (contextPeek instanceof MappingInterfaceReference) {
            MappingInterfaceReference mappingInterfaceReference = (MappingInterfaceReference)contextPeek;
            column = mappingInterfaceReference.getDeclaringMappingInterfaceKey().setReferenceColumn(columnName, tableName);
        } else if (contextPeek instanceof MappingCountColumn) {
            MappingCountColumn mappingCountColumn = (MappingCountColumn)contextPeek;
            column = mappingCountColumn.getDeclaringMappingRelationship().setCountColumn(columnName, tableName);
        } else if (contextPeek instanceof MappingSerializedDataColumn) {
            MappingSerializedDataColumn mappingSerializedDataColumn = (MappingSerializedDataColumn)contextPeek;
            mappingSerializedDataColumn.getDeclaringMappingInterfaceKey().setSerializedDataColumn(columnName, tableName);
        } else {
            throw new SAXException("ASSERTION: internal parser error");
        }
        this.context.push(column);
    }

    public void end_column() throws SAXException {
        this.context.pop();
    }

    public void start_relationshipField(Attributes meta) throws SAXException {
        MappingClass mappingClass = (MappingClass)this.context.peek();
        String fieldName = null;
        int multiplicity = 1;
        Boolean join = new Boolean(false);
        Boolean update = new Boolean(true);
        int i = 0;
        while (i < meta.getLength()) {
            String name = meta.getLocalName(i);
            String value = meta.getValue(i);
            if ("name".equals(name)) {
                fieldName = value;
            } else if ("multiplicity".equals(name)) {
                if ("one".equals(value)) {
                    multiplicity = 1;
                } else if ("many".equals(value)) {
                    multiplicity = 2;
                }
            } else if ("join-table".equals(name)) {
                join = new Boolean(value);
            } else if ("update".equals(name)) {
                update = new Boolean(value);
            }
            ++i;
        }
        MappingField mappingField = mappingClass.createMappingField(fieldName);
        MappingRelationship mappingRelationship = mappingField.createMappingRelationship(multiplicity, join, update);
        this.context.push(mappingRelationship);
    }

    public void end_relationshipField() throws SAXException {
        while (!(this.context.pop() instanceof MappingRelationship)) {
        }
    }

    public void start_foreignKey(Attributes meta) throws SAXException {
        MappingRelationship mappingRelationship = (MappingRelationship)this.context.peek();
        String foreignKeyName = null;
        String pkTableName = null;
        String fkTableName = null;
        int i = 0;
        while (i < meta.getLength()) {
            String name = meta.getLocalName(i);
            String value = meta.getValue(i);
            if ("name".equals(name)) {
                foreignKeyName = value;
            } else if ("primary-key-table".equals(name)) {
                pkTableName = value;
            } else if ("foreign-key-table".equals(name)) {
                fkTableName = value;
            }
            ++i;
        }
        MappingForeignKey mappingForeignKey = mappingRelationship.createMappingForeignKey();
        this.context.push(mappingForeignKey);
        mappingForeignKey.setForeignKey(foreignKeyName, fkTableName, pkTableName);
    }

    public void end_foreignKey() throws SAXException {
        this.context.pop();
    }

    public void start_columnPair(Attributes meta) throws SAXException {
        MappingForeignKey mappingForeignKey = (MappingForeignKey)this.context.peek();
        MappingRelationship mappingRelationship = mappingForeignKey.getDeclaringRelationship();
        String pkColumnName = null;
        String fkColumnName = null;
        int i = 0;
        while (i < meta.getLength()) {
            String name = meta.getLocalName(i);
            String value = meta.getValue(i);
            if ("foreign-key-column".equals(name)) {
                fkColumnName = value;
            } else if ("primary-key-column".equals(name)) {
                pkColumnName = value;
            }
            ++i;
        }
        mappingForeignKey.addColumnPair(fkColumnName, pkColumnName);
    }

    public void end_columnPair() throws SAXException {
    }

    public void start_discriminator(Attributes meta) throws SAXException {
        Object contextPeek = this.context.peek();
        if (contextPeek instanceof MappingClass) {
            MappingClass mappingClass = (MappingClass)contextPeek;
            MappingDiscriminator mappingDiscriminator = mappingClass.createMappingDiscriminator();
            this.context.push(mappingDiscriminator);
        } else if (contextPeek instanceof MappingRelationship) {
            MappingRelationship mappingRelationship = (MappingRelationship)contextPeek;
            MappingInterfaceKey mappingInterfaceKey = mappingRelationship.createMappingInterfaceKey();
            this.context.push(mappingInterfaceKey);
            MappingInterfaceDiscriminator mappingInterfaceDiscriminator = new MappingInterfaceDiscriminator(mappingInterfaceKey);
            this.context.push(mappingInterfaceDiscriminator);
        }
    }

    public void end_discriminator() throws SAXException {
        this.context.pop();
    }

    public void start_reference(Attributes meta) throws SAXException {
        MappingInterfaceKey mappingInterfaceKey = (MappingInterfaceKey)this.context.peek();
        MappingInterfaceReference mappingInterfaceReference = new MappingInterfaceReference(mappingInterfaceKey);
        this.context.push(mappingInterfaceReference);
    }

    public void end_reference() throws SAXException {
        this.context.pop();
    }

    public void start_count(Attributes meta) throws SAXException {
        MappingRelationship mappingRelationship = (MappingRelationship)this.context.peek();
        MappingCountColumn mappingCountColumn = new MappingCountColumn(mappingRelationship);
        this.context.push(mappingCountColumn);
    }

    public void end_count() throws SAXException {
        this.context.pop();
    }

    public void start_serializedData(Attributes meta) throws SAXException {
        MappingInterfaceKey mik = (MappingInterfaceKey)this.context.peek();
        MappingSerializedDataColumn mappingSerializedDataColumn = new MappingSerializedDataColumn(mik);
        this.context.push(mappingSerializedDataColumn);
    }

    public void end_serializedData() throws SAXException {
        this.context.pop();
    }

    public void start_jdbcType(Attributes meta) throws SAXException {
        Column column = (Column)this.context.peek();
        String jdbcTypeName = null;
        Long length = new Long(0L);
        Integer decimals = new Integer(0);
        Boolean isNotNull = new Boolean(false);
        Boolean isPrimaryKey = new Boolean(false);
        int i = 0;
        while (i < meta.getLength()) {
            String name = meta.getLocalName(i);
            String value = meta.getValue(i);
            if ("name".equals(name)) {
                jdbcTypeName = value;
            } else if ("length".equals(name)) {
                length = new Long(value);
            } else if ("decimals".equals(name)) {
                decimals = new Integer(value);
            } else if ("is-not-null".equals(name)) {
                isNotNull = new Boolean(value);
            } else if ("is-primary-key".equals(name)) {
                isPrimaryKey = new Boolean(value);
            }
            ++i;
        }
        if (column instanceof VirtualColumn) {
            VirtualColumn virtualColumn = (VirtualColumn)column;
            try {
                int jdbcType = JDBCHelper.parseJdbcType(jdbcTypeName);
                if (!JDBCHelper.isSupportedJdbcType(jdbcType)) {
                    throw new SAXException((Exception)((Object)new JDOFatalUserException("Unsupported JDBC Type " + jdbcTypeName)));
                }
                virtualColumn.setJdbcType(jdbcType);
                virtualColumn.setSize(length);
                virtualColumn.setDecimals(decimals);
                virtualColumn.setIsNullable(isNotNull == false);
                virtualColumn.setIsPrimaryKey(isPrimaryKey);
            }
            catch (JDBCHelper.InvalidJdbcType e) {
                throw new SAXException((Exception)((Object)new JDOFatalUserException("Invalid JDBC Type " + jdbcTypeName, (Throwable)e)));
            }
        }
    }

    public void end_jdbcType() throws SAXException {
    }

    static class MappingSerializedDataColumn {
        private MappingInterfaceKey _mappingInterfaceKey = null;

        public MappingSerializedDataColumn(MappingInterfaceKey mappingInterfaceKey) {
            this._mappingInterfaceKey = mappingInterfaceKey;
        }

        public MappingInterfaceKey getDeclaringMappingInterfaceKey() {
            return this._mappingInterfaceKey;
        }
    }

    static class MappingCountColumn {
        private MappingRelationship _mappingRelationship = null;

        public MappingCountColumn(MappingRelationship mappingRelationship) {
            this._mappingRelationship = mappingRelationship;
        }

        public MappingRelationship getDeclaringMappingRelationship() {
            return this._mappingRelationship;
        }
    }

    static class MappingInterfaceReference {
        private MappingInterfaceKey _mappingInterfaceKey = null;

        public MappingInterfaceReference(MappingInterfaceKey mappingInterfaceKey) {
            this._mappingInterfaceKey = mappingInterfaceKey;
        }

        public MappingInterfaceKey getDeclaringMappingInterfaceKey() {
            return this._mappingInterfaceKey;
        }
    }

    static class MappingInterfaceDiscriminator {
        private MappingInterfaceKey _mappingInterfaceKey = null;

        public MappingInterfaceDiscriminator(MappingInterfaceKey mappingInterfaceKey) {
            this._mappingInterfaceKey = mappingInterfaceKey;
        }

        public MappingInterfaceKey getDeclaringMappingInterfaceKey() {
            return this._mappingInterfaceKey;
        }
    }
}

