/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdo.sql.mapping.impl;

import com.sap.jdo.JDODefaultProperties;
import com.sap.jdo.common.model.jdo.RuntimeJDOModelFactoryImpl;
import com.sap.jdo.model.jdo.JDOModel;
import com.sap.jdo.model.jdo.JDOModelException;
import com.sap.jdo.model.jdo.JDOModelFactory;
import com.sap.jdo.sql.catalog.JDOCatalogReader;
import com.sap.jdo.sql.catalog.proxy.ConnectedCatalogReaderProxy;
import com.sap.jdo.sql.catalog.proxy.PathCatalogReaderProxy;
import com.sap.jdo.sql.catalog.virtual.VirtualCatalogReader;
import com.sap.jdo.sql.mapping.MappingClass;
import com.sap.jdo.sql.mapping.MappingModel;
import com.sap.jdo.sql.mapping.MappingVisitor;
import com.sap.jdo.sql.mapping.impl.MappingClassImpl;
import com.sap.jdo.sql.mapping.impl.MappingModelForwardMapper;
import com.sap.jdo.sql.mapping.impl.MappingModelJDBCTypeSupplier;
import com.sap.jdo.sql.mapping.xml.Handler_0_3;
import com.sap.jdo.sql.mapping.xml.Handler_1_0;
import com.sap.jdo.sql.mapping.xml.Parser_0_3;
import com.sap.jdo.sql.mapping.xml.Parser_1_0;
import com.sap.jdo.sql.mapping.xml.Renderer_0_3;
import com.sap.jdo.sql.mapping.xml.Renderer_1_0;
import com.sap.tc.logging.Location;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.jdo.JDODataStoreException;
import javax.jdo.JDOFatalDataStoreException;
import javax.jdo.JDOFatalInternalException;
import javax.jdo.JDOFatalUserException;
import javax.jdo.JDOUserException;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class MappingModelImpl
implements MappingModel {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$jdo$sql$mapping$impl$MappingModelImpl == null ? (class$com$sap$jdo$sql$mapping$impl$MappingModelImpl = MappingModelImpl.class$("com.sap.jdo.sql.mapping.impl.MappingModelImpl")) : class$com$sap$jdo$sql$mapping$impl$MappingModelImpl));
    private boolean _beInfo;
    Boolean _forwardMapping = JDODefaultProperties.FORWARDMAPPING_DEFAULT_VALUE;
    Boolean _createMappingFile = JDODefaultProperties.CREATE_MAPPINGFILE_DEFAULT_VALUE;
    String _mappingFileName = null;
    String _mappingFilesPath = null;
    Boolean _checkConsistency = JDODefaultProperties.CHECK_CONSISTENCY_DEFAULT_VALUE;
    Boolean _checkConsistencyDeep = JDODefaultProperties.CHECK_CONSISTENCY_DEEP_DEFAULT_VALUE;
    Boolean _useCatalog = JDODefaultProperties.USE_CATALOG_DEFAULT_VALUE;
    Boolean _lookupSingleClass = JDODefaultProperties.LOOKUP_SINGLE_CLASS_DEFAULT_VALUE;
    Boolean _trimBigDecimals = JDODefaultProperties.TRIM_BIG_DECIMALS_DEFAULT_VALUE;
    Boolean _storeCharacterAsNumber = JDODefaultProperties.STORE_CHARACTER_AS_NUMBER_DEFAULT_VALUE;
    Boolean _storeAllNumbersAsDecimals = JDODefaultProperties.STORE_ALL_NUMBERS_AS_DECIMALS_DEFAULT_VALUE;
    Boolean _storeFloatAsDouble = JDODefaultProperties.STORE_FLOAT_AS_DOUBLE_DEFAULT_VALUE;
    Boolean _storeDateAsLong = JDODefaultProperties.STORE_DATE_AS_LONG_DEFAULT_VALUE;
    String _version = "1.0";
    private static final Map _instances = new HashMap();
    private static final MappingClassImpl[] initialMappingClassArray = new MappingClassImpl[0];
    private Properties _properties;
    private JDOModelFactory _jdoModelFactory;
    private JDOCatalogReader _catalogReader;
    private Map _mappingClassesForClassLoaders;
    private long _CID;
    private ClassLoader _classLoader;
    private String _lookupClassName;
    static /* synthetic */ Class class$com$sap$jdo$sql$mapping$impl$MappingModelImpl;

    private MappingModelImpl(Properties properties, JDOCatalogReader catalogReader) {
        this.setProperties(properties);
        this._catalogReader = catalogReader;
        try {
            this._jdoModelFactory = RuntimeJDOModelFactoryImpl.getInstance();
        }
        catch (JDOModelException e) {
            throw new JDOFatalInternalException("Cannot get instance of JDOModelFactory", (Throwable)e);
        }
        this._mappingClassesForClassLoaders = new HashMap();
        this._CID = 0L;
    }

    public static synchronized MappingModelImpl getMappingModelFromPath(Properties properties) {
        MappingModelImpl instance = (MappingModelImpl)_instances.get(properties);
        if (instance == null) {
            String path = properties.getProperty("com.sap.jdo.sql.mapping.catalogPath");
            PathCatalogReaderProxy reader = new PathCatalogReaderProxy(path);
            instance = new MappingModelImpl(properties, reader);
            _instances.put(properties, instance);
        }
        return instance;
    }

    public static synchronized MappingModelImpl getVirtualMappingModel(Properties properties) {
        MappingModelImpl instance = (MappingModelImpl)_instances.get(properties);
        if (instance == null) {
            VirtualCatalogReader reader = new VirtualCatalogReader();
            instance = new MappingModelImpl(properties, reader);
            _instances.put(properties, instance);
        }
        return instance;
    }

    public static synchronized MappingModelImpl getRuntimeMappingModelImpl(Properties properties) {
        MappingModelImpl instance = (MappingModelImpl)_instances.get(properties);
        if (instance == null) {
            ConnectedCatalogReaderProxy catalogReader;
            String dataSourceName = properties.getProperty("javax.jdo.option.ConnectionFactoryName");
            if (dataSourceName != null) {
                catalogReader = ConnectedCatalogReaderProxy.getProxyFromDataSource(dataSourceName);
            } else {
                String driverName = properties.getProperty("javax.jdo.option.ConnectionDriverName");
                String url = properties.getProperty("javax.jdo.option.ConnectionURL");
                String userName = properties.getProperty("javax.jdo.option.ConnectionUserName");
                String password = properties.getProperty("javax.jdo.option.ConnectionPassword");
                catalogReader = ConnectedCatalogReaderProxy.getProxyFromUrl(driverName, url, userName, password);
            }
            instance = new MappingModelImpl(properties, catalogReader);
            _instances.put(properties, instance);
        }
        return instance;
    }

    private void setProperties(Properties properties) {
        this._forwardMapping = new Boolean(properties.getProperty("com.sap.jdo.sql.mapping.forwardMapping", JDODefaultProperties.FORWARDMAPPING_DEFAULT_VALUE.toString()));
        this._createMappingFile = new Boolean(properties.getProperty("com.sap.jdo.sql.mapping.createMappingFile", JDODefaultProperties.CREATE_MAPPINGFILE_DEFAULT_VALUE.toString()));
        if (this._createMappingFile.equals(Boolean.TRUE)) {
            this._forwardMapping = Boolean.TRUE;
        }
        this._mappingFileName = properties.getProperty("com.sap.jdo.sql.mapping.mappingFileName");
        this._mappingFilesPath = properties.getProperty("com.sap.jdo.sql.mapping.mappingFilesPath");
        this._lookupSingleClass = JDODefaultProperties.LOOKUP_SINGLE_CLASS_DEFAULT_VALUE;
        this._checkConsistency = new Boolean(properties.getProperty("com.sap.jdo.sql.mapping.checkConsistency", JDODefaultProperties.CHECK_CONSISTENCY_DEFAULT_VALUE.toString()));
        this._checkConsistencyDeep = new Boolean(properties.getProperty("com.sap.jdo.sql.mapping.checkConsistencyDeep", JDODefaultProperties.CHECK_CONSISTENCY_DEEP_DEFAULT_VALUE.toString()));
        if (this._checkConsistencyDeep.equals(Boolean.TRUE)) {
            this._checkConsistency = Boolean.TRUE;
        }
        this._useCatalog = new Boolean(properties.getProperty("com.sap.jdo.sql.mapping.useCatalog", JDODefaultProperties.USE_CATALOG_DEFAULT_VALUE.toString()));
        this._storeCharacterAsNumber = new Boolean(properties.getProperty("com.sap.jdo.sql.mapping.storeCharacterAsNumber", JDODefaultProperties.STORE_CHARACTER_AS_NUMBER_DEFAULT_VALUE.toString()));
        this._storeAllNumbersAsDecimals = new Boolean(properties.getProperty("com.sap.jdo.sql.mapping.storeAllNumbersAsDecimals", JDODefaultProperties.STORE_ALL_NUMBERS_AS_DECIMALS_DEFAULT_VALUE.toString()));
        this._storeFloatAsDouble = new Boolean(properties.getProperty("com.sap.jdo.sql.mapping.storeFloatAsDouble", JDODefaultProperties.STORE_FLOAT_AS_DOUBLE_DEFAULT_VALUE.toString()));
        this._storeDateAsLong = new Boolean(properties.getProperty("com.sap.jdo.sql.mapping.storeDateAsLong", JDODefaultProperties.STORE_DATE_AS_LONG_DEFAULT_VALUE.toString()));
        this._trimBigDecimals = new Boolean(properties.getProperty("com.sap.jdo.sql.mapping.trimBigDecimals", JDODefaultProperties.TRIM_BIG_DECIMALS_DEFAULT_VALUE.toString()));
        this._version = "1.0";
        this._properties = properties;
    }

    public JDOModelFactory getJDOModelFactory() {
        return this._jdoModelFactory;
    }

    public JDOModel getJDOModel() {
        return this.getJDOModel(this._classLoader);
    }

    public JDOModel getJDOModel(ClassLoader classLoader) {
        if (this._jdoModelFactory == null || classLoader == null) {
            return null;
        }
        try {
            return this._jdoModelFactory.getJDOModel(classLoader);
        }
        catch (JDOModelException e) {
            LOCATION.traceThrowableT(100, "getJDOModel", (Throwable)e);
            return null;
        }
    }

    public JDOCatalogReader getCatalogReader() {
        return this._catalogReader;
    }

    public synchronized MappingClass getMappingClass(Class pcClass) {
        this.assertIsNoInterface(pcClass);
        ClassLoader classLoader = pcClass.getClassLoader();
        String className = pcClass.getName();
        MappingClass mappingClass = (MappingClassImpl)this.getMappingClass(classLoader, className);
        if (mappingClass == null) {
            mappingClass = this._forwardMapping == false ? this.getMappingClass(pcClass, false) : this.createMappingClassFromJDOModel(pcClass);
        }
        return mappingClass;
    }

    public synchronized MappingClass getMappingClass(Class pcClass, boolean loadXMLMetadata) {
        MappingClassImpl mappingClass;
        this.assertIsNoInterface(pcClass);
        ClassLoader classLoader = pcClass.getClassLoader();
        String className = pcClass.getName();
        if (loadXMLMetadata) {
            mappingClass = (MappingClassImpl)this.getMappingClass(classLoader, className);
            if (mappingClass == null || mappingClass.isXMLRequired()) {
                ClassLoader classLoaderBackUp = this._classLoader;
                this._classLoader = classLoader;
                if (this._classLoader == null) {
                    throw new JDOFatalDataStoreException("Impossible to get a Mapping Class for bootstrap-class " + className);
                }
                mappingClass = (MappingClassImpl)this.lookupXMLMappingData(className);
                if (mappingClass == null) {
                    throw new JDOFatalInternalException("Mapping Class for " + className + "not found");
                }
                this._classLoader = classLoaderBackUp;
            }
            mappingClass.checkConsistency();
        } else {
            mappingClass = (MappingClassImpl)this.getMappingClass(classLoader, className);
            if (mappingClass == null) {
                mappingClass = (MappingClassImpl)this.createMappingClass(pcClass);
            }
        }
        return mappingClass;
    }

    public synchronized MappingClass getMappingClass(ClassLoader classLoader, String className) {
        MappingClass mappingClass = null;
        HashMap mappingClasses = (HashMap)this._mappingClassesForClassLoaders.get(classLoader);
        if (mappingClasses != null) {
            mappingClass = (MappingClass)mappingClasses.get(className);
        }
        return mappingClass;
    }

    private void putMappingClass(ClassLoader classLoader, String className, MappingClass mappingClass) {
        HashMap<String, MappingClass> mappingClasses = (HashMap<String, MappingClass>)this._mappingClassesForClassLoaders.get(classLoader);
        if (mappingClasses == null) {
            mappingClasses = new HashMap<String, MappingClass>();
            this._mappingClassesForClassLoaders.put(classLoader, mappingClasses);
        }
        mappingClasses.put(className, mappingClass);
    }

    public synchronized MappingClass[] getMappingClasses() {
        ArrayList result = new ArrayList();
        Iterator i = this._mappingClassesForClassLoaders.values().iterator();
        while (i.hasNext()) {
            result.addAll(((HashMap)i.next()).values());
        }
        return result.toArray(initialMappingClassArray);
    }

    public synchronized MappingClass[] getMappingClasses(ClassLoader classLoader) {
        MappingClass[] result = null;
        HashMap mappingClasses = (HashMap)this._mappingClassesForClassLoaders.get(classLoader);
        if (mappingClasses != null) {
            result = mappingClasses.values().toArray(initialMappingClassArray);
        }
        return result;
    }

    public synchronized MappingClass createMappingClass(Class pcClass) {
        String METHOD = "createMappingClass(Class pcClass)";
        this._beInfo = LOCATION.beInfo();
        this.assertIsNoInterface(pcClass);
        ClassLoader classLoader = pcClass.getClassLoader();
        String className = pcClass.getName();
        MappingClassImpl mappingClass = (MappingClassImpl)this.getMappingClass(classLoader, className);
        if (mappingClass == null) {
            if (classLoader == null) {
                throw new JDOFatalDataStoreException("Impossible to get a Mapping Class for bootstrap-class " + className);
            }
            JDOModel jdoModel = this.getJDOModel(classLoader);
            mappingClass = new MappingClassImpl(this, jdoModel, pcClass);
            this.invalidateModelCID();
            if (this._beInfo) {
                LOCATION.infoT("createMappingClass(Class pcClass)", "Mapping Class for class {0} created without loading XML metadata", new Object[]{className});
            }
            this.putMappingClass(classLoader, className, mappingClass);
            mappingClass.setXMLRequired(true);
        }
        return mappingClass;
    }

    public synchronized MappingClass createMappingClass(String className) {
        String METHOD = "createMappingClass(String className)";
        this._beInfo = LOCATION.beInfo();
        try {
            MappingClassImpl mappingClass = (MappingClassImpl)this.getMappingClass(this._classLoader, className);
            if (mappingClass == null) {
                JDOModel jdoModel = null;
                if (this._jdoModelFactory != null) {
                    jdoModel = this._jdoModelFactory.getJDOModel(this._classLoader);
                }
                mappingClass = new MappingClassImpl(this, jdoModel, className);
                this.invalidateModelCID();
                this.putMappingClass(this._classLoader, className, mappingClass);
            }
            mappingClass.setXMLRequired(false);
            if (this._beInfo) {
                LOCATION.infoT("createMappingClass(String className)", "Mapping Class for class {0} loaded from XML metadata", new Object[]{className});
            }
            return mappingClass;
        }
        catch (JDOModelException e) {
            throw new JDOFatalDataStoreException("model error");
        }
    }

    private void assertIsNoInterface(Class cls) {
        if (cls.isInterface()) {
            throw new JDOFatalInternalException("ASSERTION: There must not be any mapping metadata for interfaces");
        }
    }

    private MappingClass createMappingClassFromJDOModel(Class pcClass) {
        this.assertIsNoInterface(pcClass);
        ClassLoader classLoader = pcClass.getClassLoader();
        String className = pcClass.getName();
        MappingClassImpl mappingClass = (MappingClassImpl)this.getMappingClass(classLoader, className);
        if (mappingClass == null) {
            try {
                JDOModel jdoModel = null;
                if (this._jdoModelFactory != null) {
                    jdoModel = this._jdoModelFactory.getJDOModel(pcClass.getClassLoader());
                }
                mappingClass = new MappingClassImpl(this, jdoModel, className);
                this.putMappingClass(classLoader, className, mappingClass);
                mappingClass.setXMLRequired(false);
                MappingModelForwardMapper mappingModelForwardMapper = MappingModelForwardMapper.getInstance(this._properties);
                mappingModelForwardMapper.checkSupported(mappingClass);
                mappingModelForwardMapper.createPKMappingFieldsFromJDOModel(mappingClass);
                mappingModelForwardMapper.createNonPKMappingFieldsFromJDOModel(mappingClass);
                MappingModelJDBCTypeSupplier.process(mappingClass);
                MappingClass mappingRootClass = mappingClass.getMappingRootClass();
                if (mappingRootClass != null) {
                    MappingModelJDBCTypeSupplier.process(mappingRootClass);
                }
            }
            catch (JDOModelException e) {
                throw new JDOFatalDataStoreException("model error");
            }
        }
        return mappingClass;
    }

    private MappingClass lookupXMLMappingData(String className) {
        MappingClassImpl mappingClassImpl;
        InputStream is = this.getXMLMappingDataInputStream(className);
        if (is == null) {
            throw new JDOFatalUserException("no mapping metadata file found for class " + className);
        }
        try {
            if (this._lookupSingleClass.booleanValue()) {
                this._lookupClassName = className;
            }
            this.lookupXMLMappingData(is);
            MappingClassImpl mc = (MappingClassImpl)this.getMappingClass(this._classLoader, className);
            if (mc == null) {
                throw new JDOFatalUserException("no mapping metadata found in file for class " + className);
            }
            mappingClassImpl = mc;
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            try {
                is.close();
            }
            catch (IOException e) {
                LOCATION.catching("ignoring IOException during close()", (Throwable)e);
            }
            throw throwable;
        }
        try {
            is.close();
        }
        catch (IOException e) {
            LOCATION.catching("ignoring IOException during close()", (Throwable)e);
        }
        return mappingClassImpl;
    }

    private void lookupXMLMappingData(InputStream is) {
        block7: {
            try {
                if (this._version == null) {
                    throw new JDOFatalInternalException("mapping version not defined");
                }
                if (this._version.equals("0.3")) {
                    Handler_0_3 handler = this._lookupSingleClass == false ? new Handler_0_3(this) : new Handler_0_3(this, this._lookupClassName);
                    Parser_0_3 parser = new Parser_0_3(handler);
                    parser.parse(new InputSource(new InputStreamReader(is)));
                    break block7;
                }
                if (this._version.equals("1.0")) {
                    Handler_1_0 handler = this._lookupSingleClass == false ? new Handler_1_0(this) : new Handler_1_0(this, this._lookupClassName);
                    Parser_1_0 parser = new Parser_1_0(handler);
                    parser.parse(new InputSource(new InputStreamReader(is)));
                    break block7;
                }
                throw new JDOFatalUserException("mapping version " + this._version + " unknown");
            }
            catch (SAXException ex) {
                throw new JDOFatalUserException("XML mapping data parse error", (Throwable)ex);
            }
            catch (ParserConfigurationException ex) {
                throw new JDOFatalDataStoreException("XML mapping data parser configuration error", (Throwable)ex);
            }
            catch (IOException ex) {
                throw new JDODataStoreException("XML mapping data IO error", (Throwable)ex);
            }
        }
    }

    private InputStream getXMLMappingDataInputStream(String className) {
        String resourceName = className.replace('.', '/') + ".map";
        InputStream stream = this._classLoader.getResourceAsStream(resourceName);
        while (stream == null) {
            int index = resourceName.lastIndexOf(47);
            if (index == -1) {
                return null;
            }
            resourceName = resourceName.substring(0, index) + ".map";
            stream = this._classLoader.getResourceAsStream(resourceName);
        }
        return stream;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void parse(String fileName) {
        FileInputStream fis = null;
        try {
            try {
                fis = new FileInputStream(fileName);
                this.lookupXMLMappingData(fis);
            }
            catch (FileNotFoundException e) {
                throw new JDOUserException("file not found error", (Throwable)e);
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            try {
                if (fis == null) throw throwable;
                fis.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new JDOFatalDataStoreException("io error", (Throwable)e);
            }
        }
        try {}
        catch (IOException e) {
            throw new JDOFatalDataStoreException("io error", (Throwable)e);
        }
        if (fis == null) return;
        fis.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void render(String fileName) {
        if (fileName == null) return;
        OutputStreamWriter osw = null;
        try {
            try {
                if (this._version == null) {
                    throw new JDOFatalInternalException("version not defined");
                }
                FileOutputStream os = new FileOutputStream(fileName);
                osw = new OutputStreamWriter((OutputStream)os, "UTF-8");
                if (this._version.equals("0.3")) {
                    Renderer_0_3 renderer = new Renderer_0_3(osw);
                    renderer.render(this);
                } else {
                    if (!this._version.equals("1.0")) throw new JDOFatalUserException("version " + this._version + " unknown");
                    Renderer_1_0 renderer = new Renderer_1_0(osw);
                    renderer.render(this);
                }
                Object var6_8 = null;
            }
            catch (FileNotFoundException e) {
                throw new JDOUserException("file not found error", (Throwable)e);
            }
            catch (IOException e) {
                throw new JDOFatalDataStoreException("io error", (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            try {
                if (osw == null) throw throwable;
                osw.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new JDOFatalDataStoreException("io error", (Throwable)e);
            }
        }
        try {}
        catch (IOException e) {
            throw new JDOFatalDataStoreException("io error", (Throwable)e);
        }
        if (osw == null) return;
        osw.close();
    }

    public synchronized MappingClass getMappingClassFromUID(String UID, ClassLoader classLoader) {
        String pcClassName = UID;
        MappingClass mappingClass = this.getMappingClass(classLoader, pcClassName);
        if (mappingClass == null) {
            try {
                Class<?> pcClass = classLoader.loadClass(pcClassName);
                mappingClass = this.getMappingClass(pcClass);
            }
            catch (ClassNotFoundException e) {
                throw new JDOFatalUserException("class " + pcClassName + " not found", (Throwable)e);
            }
        }
        return mappingClass;
    }

    public synchronized MappingClass getMappingClassFromUID(char[] UID, ClassLoader classLoader) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public synchronized MappingClass getMappingClassFromUID(byte[] UID, ClassLoader classLoader) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public synchronized void accept(MappingVisitor mappingVisitor) throws Exception {
        mappingVisitor.visitMappingModelPre(this);
        MappingClassImpl[] mcs = (MappingClassImpl[])this.getMappingClasses();
        Arrays.sort(mcs, new MappingClassComparator());
        int i = 0;
        while (i < mcs.length) {
            mcs[i].accept(mappingVisitor);
            ++i;
        }
        mappingVisitor.visitMappingModelPost(this);
    }

    public synchronized void close() {
        if (this._createMappingFile.equals(Boolean.TRUE) && this._mappingFileName != null && !this._mappingFileName.equals("")) {
            this.render(this._mappingFileName);
        }
    }

    synchronized boolean isValidModelCID(long CID) {
        return this._CID == CID;
    }

    synchronized void invalidateModelCID() {
        ++this._CID;
    }

    synchronized long getActualModelCID() {
        return this._CID;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class MappingClassComparator
    implements Comparator {
        private MappingClassComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (o1 instanceof MappingClassImpl && o2 instanceof MappingClassImpl) {
                return ((MappingClassImpl)o1).getName().compareTo(((MappingClassImpl)o2).getName());
            }
            throw new JDOFatalDataStoreException("invalid instances in class MappingClassComparator");
        }
    }
}

