/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdo.sql.mapping.impl;

import com.sap.jdo.sql.catalog.Column;
import com.sap.jdo.sql.catalog.JDOCatalogReader;
import com.sap.jdo.sql.catalog.Table;
import com.sap.jdo.sql.mapping.MappingInterfaceKey;
import com.sap.jdo.sql.mapping.MappingRelationship;
import com.sap.jdo.sql.mapping.MappingVisitor;
import com.sap.jdo.sql.mapping.impl.MappingClassImpl;
import com.sap.jdo.sql.mapping.impl.MappingRelationshipImpl;
import java.sql.SQLException;
import javax.jdo.JDOFatalUserException;

public class MappingInterfaceKeyImpl
implements MappingInterfaceKey {
    private MappingRelationshipImpl _declaringRelationship;
    private int _type;
    private Column _discriminatorColumn;
    private Column _referenceColumn;
    private Column _serializedDataColumn;

    public MappingInterfaceKeyImpl(MappingRelationshipImpl mappingRelationship, int mappingInterfaceKeyType) {
        if (mappingRelationship == null) {
            throw new IllegalArgumentException("no mapping relationship given");
        }
        this._declaringRelationship = mappingRelationship;
        this._type = mappingInterfaceKeyType;
        this._discriminatorColumn = null;
        this._referenceColumn = null;
        this._serializedDataColumn = null;
    }

    public synchronized MappingRelationship getDeclaringRelationship() {
        return this._declaringRelationship;
    }

    public synchronized int getKeyType() {
        return this._type;
    }

    public synchronized Column setReferenceColumn(String columnName, String tableName) {
        this.invalidateCID();
        try {
            this._referenceColumn = this.getColumn(columnName, tableName);
            return this._referenceColumn;
        }
        catch (SQLException e) {
            throw new JDOFatalUserException("catalog error", (Throwable)e);
        }
    }

    public synchronized Column getReferenceColumn() {
        return this._referenceColumn;
    }

    public synchronized Column setDiscriminatorColumn(String columnName, String tableName) {
        this.invalidateCID();
        try {
            this._discriminatorColumn = this.getColumn(columnName, tableName);
            return this._discriminatorColumn;
        }
        catch (SQLException e) {
            throw new JDOFatalUserException("catalog error", (Throwable)e);
        }
    }

    public synchronized Column getDiscriminatorColumn() {
        return this._discriminatorColumn;
    }

    public synchronized void accept(MappingVisitor mappingVisitor) throws Exception {
        mappingVisitor.visitMappingInterfaceKeyPre(this);
        mappingVisitor.visitMappingInterfaceKeyPost(this);
    }

    private void invalidateCID() {
        this._declaringRelationship._declaringField._declaringClass.invalidateClassCID();
    }

    public synchronized String toString() {
        return "MappingInterfaceKey[declaringRelationship = " + this._declaringRelationship + "]";
    }

    public synchronized Column getSerializedDataColumn() {
        return this._serializedDataColumn;
    }

    public synchronized Column setSerializedDataColumn(String columnName, String tableName) {
        this.invalidateCID();
        try {
            this._serializedDataColumn = this.getColumn(columnName, tableName);
            return this._serializedDataColumn;
        }
        catch (SQLException e) {
            throw new JDOFatalUserException("catalog error", (Throwable)e);
        }
    }

    private Column getColumn(String columnName, String tableName) throws SQLException {
        MappingClassImpl mappingClass = (MappingClassImpl)this.getDeclaringRelationship().getDeclaringField().getDeclaringClass();
        JDOCatalogReader catalogReader = mappingClass.getDeclaringModel().getCatalogReader();
        Table table = catalogReader.getTable(tableName);
        if (table == null) {
            throw new JDOFatalUserException("table " + tableName + " not found in catalog");
        }
        Column column = table.getColumn(columnName);
        if (column == null) {
            throw new JDOFatalUserException("column " + columnName + " in table " + tableName + " not found in catalog");
        }
        return column;
    }
}

