/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdo.sql.mapping.impl;

import com.sap.jdo.sql.catalog.Column;
import com.sap.jdo.sql.catalog.ForeignKey;
import com.sap.jdo.sql.catalog.JDOCatalogReader;
import com.sap.jdo.sql.mapping.MappingForeignKey;
import com.sap.jdo.sql.mapping.MappingRelationship;
import com.sap.jdo.sql.mapping.MappingVisitor;
import com.sap.jdo.sql.mapping.impl.MappingRelationshipImpl;
import javax.jdo.JDOFatalUserException;

public class MappingForeignKeyImpl
implements MappingForeignKey {
    private MappingRelationshipImpl _declaringRelationship;
    private int _type;
    private ForeignKey _foreignKey;

    public MappingForeignKeyImpl(MappingRelationshipImpl mappingRelationship, int mappingForeignKeyType) {
        if (mappingRelationship == null) {
            throw new IllegalArgumentException("no mapping relationship given");
        }
        this._declaringRelationship = mappingRelationship;
        this._type = mappingForeignKeyType;
        this._foreignKey = null;
    }

    public synchronized void setForeignKey(String foreignKeyName, String fkTableName, String pkTableName) {
        this.invalidateCID();
        JDOCatalogReader catalogReader = this._declaringRelationship.getDeclaringField().getDeclaringClass().getDeclaringModel().getCatalogReader();
        this._foreignKey = catalogReader.getForeignKey(foreignKeyName);
        if (this._foreignKey == null) {
            throw new JDOFatalUserException("foreign key " + foreignKeyName + " not found");
        }
        this._foreignKey.setTableNames(fkTableName, pkTableName);
    }

    public synchronized void setForeignKey(String foreignKeyName, Column[] fkColumns, Column[] pkColumns) {
        this.invalidateCID();
        Object mappingForeignKey = null;
        if (fkColumns.length != pkColumns.length) {
            throw new JDOFatalUserException("Number of foreign and primary key columns must be equal in foreignkey " + foreignKeyName);
        }
        int i = 0;
        while (i < fkColumns.length) {
            Column fkColumn = fkColumns[i];
            Column pkColumn = pkColumns[i];
            if (i == 0) {
                this.setForeignKey(foreignKeyName, fkColumn.getTable().getName(), pkColumn.getTable().getName());
            }
            this._foreignKey.setColumnPair(fkColumn, pkColumn);
            ++i;
        }
    }

    public synchronized MappingRelationship getDeclaringRelationship() {
        return this._declaringRelationship;
    }

    public synchronized ForeignKey getForeignKey() {
        return this._foreignKey;
    }

    public synchronized int getKeyType() {
        return this._type;
    }

    public synchronized void addColumnPair(String fkColumnName, String pkColumnName) {
        this.invalidateCID();
        String pkTableName = this._foreignKey.getPrimaryKeyTable().getName();
        String fkTableName = this._foreignKey.getForeignKeyTable().getName();
        this._foreignKey.setColumnPair(fkColumnName, pkColumnName);
        if (this._type == 1) {
            this.getDeclaringRelationship().getDeclaringField().addColumn(fkColumnName, fkTableName);
        }
    }

    public synchronized void accept(MappingVisitor mappingVisitor) throws Exception {
        mappingVisitor.visitMappingForeignKeyPre(this);
        mappingVisitor.visitMappingForeignKeyPost(this);
    }

    private void invalidateCID() {
        this._declaringRelationship._declaringField._declaringClass.invalidateClassCID();
    }

    public synchronized String toString() {
        return "MappingForeignKey[declaringRelationship = " + this._declaringRelationship + "]";
    }
}

