/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdo.sql.mapping.impl;

import com.sap.jdo.sql.catalog.Column;
import com.sap.jdo.sql.catalog.JDOCatalogReader;
import com.sap.jdo.sql.catalog.Table;
import com.sap.jdo.sql.mapping.MappingClass;
import com.sap.jdo.sql.mapping.MappingDiscriminator;
import com.sap.jdo.sql.mapping.MappingVisitor;
import com.sap.jdo.sql.mapping.impl.MappingClassImpl;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jdo.JDOFatalUserException;

public class MappingDiscriminatorImpl
implements MappingDiscriminator {
    private static final Column[] initialColumnArray = new Column[0];
    private MappingClassImpl _declaringClass;
    private List _columns;

    public MappingDiscriminatorImpl(MappingClassImpl mappingClass) {
        if (mappingClass == null) {
            throw new IllegalArgumentException("no mapping class given");
        }
        this._declaringClass = mappingClass;
        this._columns = new ArrayList();
    }

    public synchronized MappingClass getDeclaringClass() {
        return this._declaringClass;
    }

    public synchronized Column addColumn(String columnName, String tableName) {
        this.invalidateCID();
        Column column = null;
        try {
            MappingClassImpl mappingClass = (MappingClassImpl)this.getDeclaringClass();
            JDOCatalogReader catalogReader = mappingClass.getDeclaringModel().getCatalogReader();
            Table table = catalogReader.getTable(tableName);
            if (table == null) {
                throw new JDOFatalUserException("table " + tableName + " not found in catalog");
            }
            column = table.getColumn(columnName);
            if (column == null) {
                throw new JDOFatalUserException("column " + columnName + " in table " + tableName + " not found in catalog");
            }
            boolean found = false;
            Iterator i = this._columns.iterator();
            while (i.hasNext()) {
                if (!i.next().equals(column)) continue;
                found = true;
            }
            if (!found) {
                this._columns.add(column);
            }
        }
        catch (SQLException e) {
            throw new JDOFatalUserException("catalog error", (Throwable)e);
        }
        return column;
    }

    public synchronized Column[] getColumns() {
        return this._columns.toArray(initialColumnArray);
    }

    public synchronized void accept(MappingVisitor mappingVisitor) throws Exception {
        mappingVisitor.visitMappingDiscriminatorPre(this);
        mappingVisitor.visitMappingDiscriminatorPost(this);
    }

    private void invalidateCID() {
        this._declaringClass.invalidateClassCID();
    }

    public synchronized String toString() {
        return "MappingDiscriminator[DeclaringClass = " + this._declaringClass + "]";
    }
}

